package nashid.verify.sdk.utils.helpers

import nashid.verify.sdk.model.VerificationResultResponse

sealed class ScanDocumentResult {
    data class FileKeyResult(val fileKey: String, val artifactType: String) : ScanDocumentResult()

    data class ScanDocumentResponse(val result: Boolean, val message: String, val verificationId: String) : ScanDocumentResult()

    data class GetScanResultResponse(val result: Boolean, val message: String, val verificationResult: VerificationResultResponse?) : ScanDocumentResult()

    data class Error(val message: String) : ScanDocumentResult()
}
