/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;

public final class ImageHeaderBox
extends JP2Box {
    long height;
    long width;
    int nc;
    short bpc;
    short c;
    boolean unk;
    boolean ipr;

    public ImageHeaderBox(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        super(randomAccessIO, n);
        this.readBox();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ImageHeaderBox ").append(eol).append("  ");
        stringBuffer.append("height= ").append(String.valueOf(this.height)).append(", ");
        stringBuffer.append("width= ").append(String.valueOf(this.width)).append(eol).append("  ");
        stringBuffer.append("nc= ").append(String.valueOf(this.nc)).append(", ");
        stringBuffer.append("bpc= ").append(String.valueOf(this.bpc)).append(", ");
        stringBuffer.append("c= ").append(String.valueOf(this.c)).append(eol).append("  ");
        stringBuffer.append("image colorspace is ").append(new String(this.unk ? "known" : "unknown"));
        stringBuffer.append(", the image ").append(new String(this.ipr ? "contains " : "does not contain ")).append("intellectual property").append("]");
        return stringBuffer.toString();
    }

    void readBox() throws IOException {
        byte[] byArray = new byte[14];
        this.in.seek(this.dataStart);
        this.in.readFully(byArray, 0, 14);
        this.height = ICCProfile.getInt(byArray, 0);
        this.width = ICCProfile.getInt(byArray, 4);
        this.nc = ICCProfile.getShort(byArray, 8);
        this.bpc = (short)(byArray[10] & 0xFF);
        this.c = (short)(byArray[11] & 0xFF);
        this.unk = byArray[12] == 0;
        this.ipr = byArray[13] == 1;
    }

    static {
        type = 69686472;
    }
}

