/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import icc.lut.LookUpTable;
import icc.lut.LookUpTable32Gamma;
import icc.lut.LookUpTable32Interp;
import icc.tags.ICCCurveType;

abstract class LookUpTable32
extends LookUpTable {
    protected final int dwMaxOutput;
    public final int[] lut;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[LookUpTable32 ");
        stringBuffer.append("max= " + this.dwMaxOutput);
        stringBuffer.append(", nentries= " + this.dwNumInput);
        return stringBuffer.append("]").toString();
    }

    public String toStringWholeLut() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("[LookUpTable32" + eol);
        stringBuffer.append("max output = " + this.dwMaxOutput + eol);
        for (n2 = 0; n2 < this.dwNumInput / 10; ++n2) {
            stringBuffer.append("lut[" + 10 * n2 + "] : ");
            for (n = 0; n < 10; ++n) {
                stringBuffer.append(this.lut[10 * n2 + n] + " ");
            }
            stringBuffer.append(eol);
        }
        stringBuffer.append("lut[" + 10 * n2 + "] : ");
        for (n = 0; n < this.dwNumInput % 10; ++n) {
            stringBuffer.append(this.lut[10 * n2 + n] + " ");
        }
        stringBuffer.append(eol + eol);
        return stringBuffer.toString();
    }

    public static LookUpTable32 createInstance(ICCCurveType iCCCurveType, int n, int n2) {
        if (iCCCurveType.count == 1) {
            return new LookUpTable32Gamma(iCCCurveType, n, n2);
        }
        return new LookUpTable32Interp(iCCCurveType, n, n2);
    }

    protected LookUpTable32(int n, int n2) {
        super(null, n);
        this.lut = new int[n];
        this.dwMaxOutput = n2;
    }

    protected LookUpTable32(ICCCurveType iCCCurveType, int n, int n2) {
        super(iCCCurveType, n);
        this.dwMaxOutput = n2;
        this.lut = new int[n];
    }

    public final int elementAt(int n) {
        return this.lut[n];
    }
}

