/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.data.repository;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.util.Base64;
import androidx.compose.runtime.internal.StabilityInferred;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.model.AdditionalDocumentDetails;
import nashid.verify.sdk.model.AdditionalPersonDetails;
import nashid.verify.sdk.model.DocumentType;
import nashid.verify.sdk.model.Passport;
import nashid.verify.sdk.model.PersonDetails;
import nashid.verify.sdk.utils.AdditionalDGFiles;
import nashid.verify.sdk.utils.DateUtil;
import nashid.verify.sdk.utils.EDocument;
import nashid.verify.sdk.utils.LivenessData;
import nashid.verify.sdk.utils.MRTDTrustStore;
import nashid.verify.sdk.utils.NFCDocumentTag;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.VerificationStatus;
import nashid.verify.sdk.utils.helpers.DocumentImages;
import nashid.verify.sdk.utils.id_card.jmrtd.BACKeySpec;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG2File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardService;
import nashid.verify.sdk.viewmodel.NfcLiveData;
import nashid.verify.sdkNew.R;
import net.sf.scuba.data.Gender;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jmrtd.CardServiceProtocolException;
import org.jmrtd.lds.icao.DG14File;
import org.jmrtd.lds.icao.MRZInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\nJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnashid/verify/sdk/data/repository/NfcRepository;", "", "nfcLiveData", "Lnashid/verify/sdk/viewmodel/NfcLiveData;", "context", "Landroid/content/Context;", "(Lnashid/verify/sdk/viewmodel/NfcLiveData;Landroid/content/Context;)V", "disposable", "Lio/reactivex/disposables/CompositeDisposable;", "eDocument", "Lnashid/verify/sdk/utils/EDocument;", "fetchDisposable", "fetchEDocument", "readOmanIdNFC", "Lnashid/verify/sdk/data/repository/NfcRepository$ReadResult;", "isoDep", "Landroid/nfc/tech/IsoDep;", "bacKey", "Lnashid/verify/sdk/utils/id_card/jmrtd/BACKeySpec;", "readPassportNfc", "", "tagFromIntent", "Landroid/nfc/Tag;", "ReadResult", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class NfcRepository {
    @NotNull
    private final NfcLiveData nfcLiveData;
    @NotNull
    private final Context context;
    @NotNull
    private EDocument eDocument;
    @NotNull
    private CompositeDisposable disposable;
    public static final int $stable = 8;

    public NfcRepository(@NotNull NfcLiveData nfcLiveData, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)nfcLiveData, (String)"nfcLiveData");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.nfcLiveData = nfcLiveData;
        this.context = context;
        this.eDocument = new EDocument();
        this.disposable = new CompositeDisposable();
    }

    public final void readPassportNfc(@Nullable Tag tagFromIntent) {
        MRTDTrustStore trustStore = new MRTDTrustStore(null, null, null, 7, null);
        MRZInfo mrzInfo = MRZInfo.createTD3MRZInfo((String)"P", (String)"ESP", (String)"DUMMY", (String)"DUMMY", (String)((String)this.nfcLiveData.getPassportNumber().getValue()), (String)"ESP", (String)((String)this.nfcLiveData.getDateOfBirth().getValue()), (Gender)Gender.MALE, (String)((String)this.nfcLiveData.getDateOfExpiration().getValue()), (String)"DUMMY");
        NFCDocumentTag nfcDocumentTag = new NFCDocumentTag();
        Tag tag = tagFromIntent;
        Intrinsics.checkNotNull((Object)tag);
        Intrinsics.checkNotNull((Object)mrzInfo);
        Disposable disposable12 = nfcDocumentTag.handleTag(this.context, tag, mrzInfo, trustStore, new NFCDocumentTag.PassportCallback(this, mrzInfo){
            final /* synthetic */ NfcRepository this$0;
            final /* synthetic */ MRZInfo $mrzInfo;
            {
                this.this$0 = $receiver;
                this.$mrzInfo = $mrzInfo;
            }

            public void onProgresUpdate(@Nullable Integer progress) {
                NfcLiveData nfcLiveData = NfcRepository.access$getNfcLiveData$p(this.this$0);
                Integer n = progress;
                Intrinsics.checkNotNull((Object)n);
                nfcLiveData.setMrtPercentage(n);
            }

            public void onPassportReadStart() {
            }

            public void onPassportReadFinish() {
            }

            public void onPassportRead(@Nullable Passport passport) {
                boolean match$iv$iv;
                char it;
                int index$iv$iv;
                String $this$trim$iv;
                DocumentType docType = DocumentType.OTHER;
                nashid.verify.sdk.utils.PersonDetails personDetails = new nashid.verify.sdk.utils.PersonDetails();
                AdditionalPersonDetails additionalPersonDetails = new AdditionalPersonDetails();
                AdditionalDGFiles additionalDGFiles = new AdditionalDGFiles();
                Passport passport2 = passport;
                Intrinsics.checkNotNull((Object)passport2);
                PersonDetails personDetails2 = passport2.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails2);
                String string2 = personDetails2.getSecondaryIdentifier();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = StringsKt.replace$default((String)string2, (String)"<", (String)" ", (boolean)false, (int)4, null);
                nashid.verify.sdk.utils.PersonDetails personDetails3 = personDetails;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                personDetails3.setName(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                PersonDetails personDetails4 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails4);
                String string4 = personDetails4.getPrimaryIdentifier();
                Intrinsics.checkNotNull((Object)string4);
                $this$trim$iv = StringsKt.replace$default((String)string4, (String)"<", (String)" ", (boolean)false, (int)4, null);
                personDetails3 = personDetails;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                personDetails3.setSurname(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                PersonDetails personDetails5 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails5);
                personDetails.setPersonalNumber(personDetails5.getOptionalData1());
                PersonDetails personDetails6 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails6);
                personDetails.setGender(String.valueOf(personDetails6.getGender()));
                PersonDetails personDetails7 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails7);
                personDetails.setBirthDate(DateUtil.convertFromMrzDate(personDetails7.getDateOfBirth()));
                PersonDetails personDetails8 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails8);
                personDetails.setExpiryDate(DateUtil.convertFromMrzDate(personDetails8.getDateOfExpiry()));
                PersonDetails personDetails9 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails9);
                personDetails.setSerialNumber(personDetails9.getDocumentNumber());
                PersonDetails personDetails10 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails10);
                personDetails.setNationality(personDetails10.getNationality());
                PersonDetails personDetails11 = passport.getPersonDetails();
                Intrinsics.checkNotNull((Object)personDetails11);
                personDetails.setIssuerAuthority(personDetails11.getIssuingState());
                VerificationStatus verificationStatus = passport.getVerificationStatus();
                Intrinsics.checkNotNull((Object)verificationStatus);
                personDetails.setDigitalSigVerification(verificationStatus.getCa() == VerificationStatus.Verdict.SUCCEEDED);
                if (Intrinsics.areEqual((Object)"I", (Object)this.$mrzInfo.getDocumentCode())) {
                    docType = DocumentType.OMAN_ID;
                } else if (Intrinsics.areEqual((Object)"P", (Object)this.$mrzInfo.getDocumentCode())) {
                    docType = DocumentType.Passport;
                }
                personDetails.setFaceImage(passport.getFace());
                personDetails.setSignature(passport.getSignature());
                if (passport.getAdditionalPersonDetails() != null) {
                    AdditionalPersonDetails additionalPersonDetails2 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails2);
                    additionalPersonDetails.setCustodyInformation(additionalPersonDetails2.getCustodyInformation());
                    AdditionalPersonDetails additionalPersonDetails3 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails3);
                    String string5 = additionalPersonDetails3.getNameOfHolder();
                    Intrinsics.checkNotNull((Object)string5);
                    additionalPersonDetails.setNameOfHolder(StringsKt.replace$default((String)string5, (String)"null ", (String)"", (boolean)false, (int)4, null));
                    AdditionalPersonDetails additionalPersonDetails4 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails4);
                    additionalPersonDetails.setFullDateOfBirth(DateUtil.convertFromMrzDateDG12(additionalPersonDetails4.getFullDateOfBirth()));
                    AdditionalPersonDetails additionalPersonDetails5 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails5);
                    additionalPersonDetails.setOtherNames(additionalPersonDetails5.getOtherNames());
                    AdditionalPersonDetails additionalPersonDetails6 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails6);
                    additionalPersonDetails.setOtherValidTDNumbers(additionalPersonDetails6.getOtherValidTDNumbers());
                    AdditionalPersonDetails additionalPersonDetails7 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails7);
                    additionalPersonDetails.setPermanentAddress(additionalPersonDetails7.getPermanentAddress());
                    AdditionalPersonDetails additionalPersonDetails8 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails8);
                    additionalPersonDetails.setPersonalNumber(additionalPersonDetails8.getPersonalNumber());
                    AdditionalPersonDetails additionalPersonDetails9 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails9);
                    additionalPersonDetails.setPersonalSummary(additionalPersonDetails9.getPersonalSummary());
                    AdditionalPersonDetails additionalPersonDetails10 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails10);
                    additionalPersonDetails.setPlaceOfBirth(additionalPersonDetails10.getPlaceOfBirth());
                    AdditionalPersonDetails additionalPersonDetails11 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails11);
                    additionalPersonDetails.setProfession(additionalPersonDetails11.getProfession());
                    AdditionalPersonDetails additionalPersonDetails12 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails12);
                    additionalPersonDetails.setProofOfCitizenship(additionalPersonDetails12.getProofOfCitizenship());
                    AdditionalPersonDetails additionalPersonDetails13 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails13);
                    additionalPersonDetails.setTag(additionalPersonDetails13.getTag());
                    AdditionalPersonDetails additionalPersonDetails14 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails14);
                    additionalPersonDetails.setTagPresenceList(additionalPersonDetails14.getTagPresenceList());
                    AdditionalPersonDetails additionalPersonDetails15 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails15);
                    additionalPersonDetails.setTelephone(additionalPersonDetails15.getTelephone());
                    AdditionalPersonDetails additionalPersonDetails16 = passport.getAdditionalPersonDetails();
                    Intrinsics.checkNotNull((Object)additionalPersonDetails16);
                    additionalPersonDetails.setTitle(additionalPersonDetails16.getTitle());
                    NfcRepository.access$getEDocument$p(this.this$0).setAdditionalPersonDetails(additionalPersonDetails);
                } else {
                    PersonDetails personDetails12 = passport.getPersonDetails();
                    Intrinsics.checkNotNull((Object)personDetails12);
                    String string6 = personDetails12.getPrimaryIdentifier();
                    PersonDetails personDetails13 = passport.getPersonDetails();
                    Intrinsics.checkNotNull((Object)personDetails13);
                    personDetails.setName(string6 + " " + personDetails13.getSecondaryIdentifier());
                }
                if (passport.getDg14File() != null) {
                    DG14File dG14File = passport.getDg14File();
                    Intrinsics.checkNotNull((Object)dG14File);
                    additionalDGFiles.setSecurityInfos(dG14File.getSecurityInfos().toString());
                }
                if (passport.getAdditionalDocumentDetails() != null) {
                    AdditionalDocumentDetails additionalDocumentDetails = passport.getAdditionalDocumentDetails();
                    Intrinsics.checkNotNull((Object)additionalDocumentDetails);
                    additionalDGFiles.setIssueingAuthority(additionalDocumentDetails.getIssuingAuthority());
                    AdditionalDocumentDetails additionalDocumentDetails2 = passport.getAdditionalDocumentDetails();
                    Intrinsics.checkNotNull((Object)additionalDocumentDetails2);
                    additionalDGFiles.setDateOfIssue(DateUtil.convertFromMrzDateDG12(additionalDocumentDetails2.getDateOfIssue()));
                    AdditionalDocumentDetails additionalDocumentDetails3 = passport.getAdditionalDocumentDetails();
                    Intrinsics.checkNotNull((Object)additionalDocumentDetails3);
                    additionalDGFiles.setPersonalizationDeviceSerialNumber(additionalDocumentDetails3.getPersonalizationSystemSerialNumber());
                    AdditionalDocumentDetails additionalDocumentDetails4 = passport.getAdditionalDocumentDetails();
                    Intrinsics.checkNotNull((Object)additionalDocumentDetails4);
                    additionalDGFiles.setPersonalizationTime(additionalDocumentDetails4.getDateAndTimeOfPersonalization());
                    NfcRepository.access$getEDocument$p(this.this$0).setAdditionalDGFiles(additionalDGFiles);
                }
                NfcRepository.access$getEDocument$p(this.this$0).setRSAPublicKey(passport.getRasPublicKey());
                NfcRepository.access$getEDocument$p(this.this$0).setECDSAPublicKey(passport.getEcdsaPublicKey());
                NfcRepository.access$getEDocument$p(this.this$0).setDocType(docType);
                NfcRepository.access$getEDocument$p(this.this$0).setPersonDetails(personDetails);
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowResult(true);
            }

            public void onAccessDeniedException(@NotNull CardServiceProtocolException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowError("");
            }

            public void onBACDeniedException(@NotNull CardServiceProtocolException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowError("");
            }

            public void onPACEException(@NotNull CardServiceProtocolException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowError("");
            }

            public void onCardException(@NotNull CardServiceException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowError("card");
            }

            public void onGeneralException(@Nullable Exception exception) {
                NfcRepository.access$getNfcLiveData$p(this.this$0).setShowError("");
            }
        });
        this.disposable.add(disposable12);
    }

    @Nullable
    public final ReadResult readOmanIdNFC(@NotNull IsoDep isoDep, @NotNull BACKeySpec bacKey) {
        ReadResult readResult;
        Intrinsics.checkNotNullParameter((Object)isoDep, (String)"isoDep");
        Intrinsics.checkNotNullParameter((Object)bacKey, (String)"bacKey");
        try {
            CardService cardService = CardService.getInstance((Object)isoDep);
            cardService.open();
            OmanCardService service = new OmanCardService(cardService, 256, 224, false, false);
            service.open();
            service.sendSelectApplet(false);
            service.doBAC(bacKey);
            this.nfcLiveData.setMrtPercentage(5);
            byte[] dgFile1 = service.readFile((short)1);
            if (dgFile1 == null) {
                String string2 = this.context.getResources().getString(R.string.error_dg1_is_null);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                this.nfcLiveData.setShowError(string2);
            }
            Utility.Companion.getInstance().setDgFile1(dgFile1);
            this.nfcLiveData.setMrtPercentage(20);
            byte[] dgFile2 = service.readFile((short)2);
            if (dgFile2 == null) {
                String string3 = this.context.getResources().getString(R.string.error_dg2_is_null);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                this.nfcLiveData.setShowError(string3);
            }
            Utility.Companion.getInstance().setDgFile2(dgFile2);
            OmanCardDG2File dgFile2Obj = new OmanCardDG2File(Utility.Companion.getInstance().getDgFile2());
            byte[] decodedString = Base64.decode((String)dgFile2Obj.getTagValue(25093), (int)0);
            LivenessData.getInstance().setNfcBitmap(BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length));
            DocumentImages.Companion.getInstance().setNfcPhoto(BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length));
            this.nfcLiveData.setMrtPercentage(35);
            byte[] dgFile4 = service.readFile((short)4);
            if (dgFile4 == null) {
                String string4 = this.context.getResources().getString(R.string.error_dg4_is_null);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                this.nfcLiveData.setShowError(string4);
            }
            Utility.Companion.getInstance().setDgFile4(dgFile4);
            this.nfcLiveData.setMrtPercentage(50);
            byte[] dgFile6 = service.readFile((short)6);
            if (dgFile6 == null) {
                String string5 = this.context.getResources().getString(R.string.error_dg6_is_null);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
                this.nfcLiveData.setShowError(string5);
            }
            Utility.Companion.getInstance().setDgFile6(dgFile6);
            this.nfcLiveData.setMrtPercentage(65);
            try {
                byte[] dgFile10 = service.readFile((short)10);
                if (dgFile10 == null) {
                    String string6 = this.context.getResources().getString(R.string.error_dg10_is_null);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
                    this.nfcLiveData.setShowError(string6);
                }
                Utility.Companion.getInstance().setDgFile10(dgFile10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.nfcLiveData.setMrtPercentage(75);
            try {
                byte[] dgFile11 = service.readFile((short)11);
                if (dgFile11 == null) {
                    String string7 = this.context.getResources().getString(R.string.error_dg11_is_null);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
                    this.nfcLiveData.setShowError(string7);
                }
                Utility.Companion.getInstance().setDgFile11(dgFile11);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.nfcLiveData.setMrtPercentage(85);
            try {
                byte[] dgFile13 = service.readFile((short)13);
                if (dgFile13 == null) {
                    String string8 = this.context.getResources().getString(R.string.error_dg13_is_null);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
                    this.nfcLiveData.setShowError(string8);
                }
                Utility.Companion.getInstance().setDgFile13(dgFile13);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            readResult = new ReadResult(100, null, 2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nfcLiveData.setShowError("An error occurred: " + e.getMessage());
            readResult = null;
        }
        return readResult;
    }

    @NotNull
    public final EDocument fetchEDocument() {
        return this.eDocument;
    }

    @NotNull
    public final CompositeDisposable fetchDisposable() {
        return this.disposable;
    }

    public static final /* synthetic */ NfcLiveData access$getNfcLiveData$p(NfcRepository $this) {
        return $this.nfcLiveData;
    }

    public static final /* synthetic */ EDocument access$getEDocument$p(NfcRepository $this) {
        return $this.eDocument;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lnashid/verify/sdk/data/repository/NfcRepository$ReadResult;", "", "percentage", "", "error", "", "(ILjava/lang/String;)V", "getError", "()Ljava/lang/String;", "getPercentage", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "VerifySDK_release"})
    @StabilityInferred(parameters=1)
    public static final class ReadResult {
        private final int percentage;
        @Nullable
        private final String error;
        public static final int $stable;

        public ReadResult(int percentage, @Nullable String error) {
            this.percentage = percentage;
            this.error = error;
        }

        public /* synthetic */ ReadResult(int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            this(n, string2);
        }

        public final int getPercentage() {
            return this.percentage;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final int component1() {
            return this.percentage;
        }

        @Nullable
        public final String component2() {
            return this.error;
        }

        @NotNull
        public final ReadResult copy(int percentage, @Nullable String error) {
            return new ReadResult(percentage, error);
        }

        public static /* synthetic */ ReadResult copy$default(ReadResult readResult, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = readResult.percentage;
            }
            if ((n2 & 2) != 0) {
                string2 = readResult.error;
            }
            return readResult.copy(n, string2);
        }

        @NotNull
        public String toString() {
            return "ReadResult(percentage=" + this.percentage + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.percentage);
            result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadResult)) {
                return false;
            }
            ReadResult readResult = (ReadResult)other;
            if (this.percentage != readResult.percentage) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)readResult.error);
        }
    }
}

