/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.ui;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.fragment.app.FragmentActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.utils.Loggers;
import nashid.verify.sdk.utils.OnInternetAvailabilityListener;
import nashid.verify.sdk.utils.helpers.ErrorUtility;
import nashid.verify.sdk.utils.helpers.LocaleUtil;
import nashid.verify.sdk.utils.helpers.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0012\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020\u001aH\u0014J\b\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020\u001aH\u0014J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lnashid/verify/sdk/ui/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lorg/koin/core/component/KoinComponent;", "Lnashid/verify/sdk/utils/OnInternetAvailabilityListener;", "()V", "isInternetAvailable", "", "()Z", "setInternetAvailable", "(Z)V", "logger", "Lnashid/verify/sdk/utils/Loggers$LoggerInstance;", "getLogger", "()Lnashid/verify/sdk/utils/Loggers$LoggerInstance;", "oldPrefLocaleCode", "", "storage", "Lnashid/verify/sdk/utils/helpers/Storage;", "getStorage", "()Lnashid/verify/sdk/utils/helpers/Storage;", "setStorage", "(Lnashid/verify/sdk/utils/helpers/Storage;)V", "tag", "getTag", "()Ljava/lang/String;", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "getPreferredLocale", "context", "onAvailable", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onLost", "onResume", "resetTitle", "updateLayoutDirection", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public class BaseActivity
extends AppCompatActivity
implements KoinComponent,
OnInternetAvailabilityListener {
    public Storage storage;
    private String oldPrefLocaleCode;
    private boolean isInternetAvailable = true;
    @NotNull
    private final String tag;
    @NotNull
    private final Loggers.LoggerInstance logger;
    public static final int $stable = 8;

    public BaseActivity() {
        this.tag = "BaseActivity";
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        this.logger = Loggers.INSTANCE.withTag(string2);
    }

    @NotNull
    public final Storage getStorage() {
        Storage storage = this.storage;
        if (storage != null) {
            return storage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storage");
        return null;
    }

    public final void setStorage(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.storage = storage;
    }

    public final boolean isInternetAvailable() {
        return this.isInternetAvailable;
    }

    public final void setInternetAvailable(boolean bl) {
        this.isInternetAvailable = bl;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final Loggers.LoggerInstance getLogger() {
        return this.logger;
    }

    private final String getPreferredLocale(Context context) {
        if (this.storage == null) {
            this.setStorage(new Storage(context));
        }
        return this.getStorage().getPreferredLocale();
    }

    @Override
    public void onAvailable() {
        this.logger.log("onAvailable: ");
        this.isInternetAvailable = true;
    }

    @Override
    public void onLost() {
        this.isInternetAvailable = false;
        ErrorUtility.Companion.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
    }

    protected void onDestroy() {
        super.onDestroy();
        ErrorUtility.Companion.getInstance().unregisterConnectivityManager((Activity)this);
    }

    private final void resetTitle() {
        try {
            int label = this.getPackageManager().getActivityInfo((ComponentName)this.getComponentName(), (int)128).labelRes;
            if (label != 0) {
                this.setTitle(label);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        this.getPreferredLocale(newBase);
        this.oldPrefLocaleCode = new Storage(newBase).getPreferredLocale();
        String string2 = this.oldPrefLocaleCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldPrefLocaleCode");
            string2 = null;
        }
        this.applyOverrideConfiguration(LocaleUtil.Companion.getLocalizedConfiguration(string2));
        super.attachBaseContext(newBase);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isInternetAvailable = ErrorUtility.Companion.getInstance().registerConnectivityManager((Activity)this, this);
        this.resetTitle();
        this.updateLayoutDirection();
    }

    private final void updateLayoutDirection() {
        Configuration config = this.getResources().getConfiguration();
        if (config.getLayoutDirection() == 1) {
            this.getWindow().getDecorView().setLayoutDirection(1);
        } else {
            this.getWindow().getDecorView().setLayoutDirection(0);
        }
    }

    protected void onResume() {
        String currentLocaleCode = new Storage((Context)this).getPreferredLocale();
        String string2 = this.oldPrefLocaleCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldPrefLocaleCode");
            string2 = null;
        }
        if (!Intrinsics.areEqual((Object)string2, (Object)currentLocaleCode)) {
            this.recreate();
            this.oldPrefLocaleCode = currentLocaleCode;
        }
        super.onResume();
        this.isInternetAvailable = ErrorUtility.Companion.getInstance().registerConnectivityManager((Activity)this, this);
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }
}

