/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.Image;
import android.os.Build;
import android.os.CountDownTimer;
import android.util.Size;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.CompoundButton;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.ui.CameraXLiveActivity;
import nashid.verify.sdk.utils.GlareDetector;
import nashid.verify.sdk.utils.Loggers;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.FocusRectDrawer;
import nashid.verify.sdk.utils.helpers.PermissionHelper;
import nashid.verify.sdk.utils.helpers.Storage;
import nashid.verify.sdk.utils.helpers.TextSizeConverter;
import nashid.verify.sdk.viewmodel.CameraXLiveData;
import nashid.verify.sdk.viewmodel.CameraXLiveViewModel;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.ActivityCameraXliveAcitivityBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020-H\u0002J\b\u00108\u001a\u000206H\u0002J\b\u00109\u001a\u000206H\u0007J\b\u0010:\u001a\u000206H\u0003J\b\u0010;\u001a\u000206H\u0002J\u0010\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002062\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010@\u001a\u000206H\u0002J\b\u0010A\u001a\u000206H\u0002J\b\u0010B\u001a\u000206H\u0002J\u000e\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020\u000eJ\u000e\u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020\u000eJ\u000e\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020\u000eJ\u000e\u0010I\u001a\u0002062\u0006\u0010J\u001a\u00020\u000eJ\b\u0010K\u001a\u000206H\u0002J\b\u0010L\u001a\u000206H\u0002J\u0018\u0010M\u001a\u0002062\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u000eH\u0016J\u0010\u0010Q\u001a\u0002062\u0006\u00107\u001a\u00020-H\u0003J\b\u0010R\u001a\u00020>H\u0002J\b\u0010S\u001a\u000206H\u0002J\b\u0010T\u001a\u000206H\u0002J\b\u0010U\u001a\u000206H\u0003J\b\u0010V\u001a\u000206H\u0002J\u0006\u0010W\u001a\u000206J\b\u0010X\u001a\u000206H\u0002J\b\u0010Y\u001a\u000206H\u0002J\b\u0010Z\u001a\u000206H\u0002J(\u0010[\u001a\u0002062\u0006\u0010&\u001a\u00020'2\u0006\u0010\\\u001a\u00020\u00172\u0006\u0010]\u001a\u00020\u00172\u0006\u0010^\u001a\u00020\u0017H\u0016J\u0010\u0010_\u001a\u0002062\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010`\u001a\u0002062\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010a\u001a\u0002062\u0006\u0010b\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lnashid/verify/sdk/utils/helpers/CameraOverlayManager;", "Landroid/view/SurfaceHolder$Callback;", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "activity", "Lnashid/verify/sdk/ui/CameraXLiveActivity;", "binding", "Lnashid/verify/sdkNew/databinding/ActivityCameraXliveAcitivityBinding;", "textSizeConverter", "Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "storage", "Lnashid/verify/sdk/utils/helpers/Storage;", "viewModel", "Lnashid/verify/sdk/viewmodel/CameraXLiveViewModel;", "isInternetAvailable", "", "logger", "Lnashid/verify/sdk/utils/Loggers$LoggerInstance;", "(Lnashid/verify/sdk/ui/CameraXLiveActivity;Lnashid/verify/sdkNew/databinding/ActivityCameraXliveAcitivityBinding;Lnashid/verify/sdk/utils/helpers/TextSizeConverter;Lnashid/verify/sdk/utils/helpers/Storage;Lnashid/verify/sdk/viewmodel/CameraXLiveViewModel;ZLnashid/verify/sdk/utils/Loggers$LoggerInstance;)V", "analysisUseCase", "Landroidx/camera/core/ImageAnalysis;", "bitmapImage", "Landroid/graphics/Bitmap;", "bottom", "", "boxHeight", "boxWidth", "cTimer", "Landroid/os/CountDownTimer;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "cameraSelector", "Landroidx/camera/core/CameraSelector;", "croppedBitmap", "delayMillisecond", "", "diameter", "executor", "Ljava/util/concurrent/Executor;", "holder", "Landroid/view/SurfaceHolder;", "imageCapture", "Landroidx/camera/core/ImageCapture;", "left", "lensFacing", "mPImage", "Landroidx/camera/core/ImageProxy;", "originalBitmapImage", "previewUseCase", "Landroidx/camera/core/Preview;", "right", "screenDivideValue", "", "top", "analyzeImage", "", "pImage", "bindAllCameraUseCases", "bindAnalysisUseCase", "bindPreviewUseCase", "captureAnImage", "captureBackViewIdCard", "stream", "Ljava/io/ByteArrayOutputStream;", "captureFrontViewIdCard", "capturePassportImage", "cropBitmapByPercentage", "filterScannedText", "handleAnalysisUseCase", "needToClearAnalyzer", "handleCTimer", "needToCloseTimer", "handleCaptureAnImage", "needToCallCapture", "handleCloseImageProxy", "needToClose", "initCameraViewModelProvider", "initClick", "onCheckedChanged", "buttonView", "Landroid/widget/CompoundButton;", "isChecked", "passImageToRead", "reCropDocBitmap", "requestPermissions", "setRescanningDocumentVisibility", "setUpAnalysisUseCase", "setupHeaderAndAnimation", "setupOverlayAndAnimation", "setupPaddingAndOverlay", "startCameraInit", "startTimer", "surfaceChanged", "format", "width", "height", "surfaceCreated", "surfaceDestroyed", "unBindCameraProvider", "isUnbind", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class CameraOverlayManager
implements SurfaceHolder.Callback,
CompoundButton.OnCheckedChangeListener {
    @NotNull
    private final CameraXLiveActivity activity;
    @NotNull
    private final ActivityCameraXliveAcitivityBinding binding;
    @NotNull
    private final TextSizeConverter textSizeConverter;
    @NotNull
    private final Storage storage;
    @NotNull
    private final CameraXLiveViewModel viewModel;
    private final boolean isInternetAvailable;
    @NotNull
    private final Loggers.LoggerInstance logger;
    private SurfaceHolder holder;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    @Nullable
    private ImageAnalysis analysisUseCase;
    @NotNull
    private final Executor executor;
    @Nullable
    private ImageCapture imageCapture;
    @Nullable
    private Bitmap bitmapImage;
    @Nullable
    private Bitmap originalBitmapImage;
    @Nullable
    private Bitmap croppedBitmap;
    @Nullable
    private ImageProxy mPImage;
    @Nullable
    private CountDownTimer cTimer;
    @Nullable
    private Preview previewUseCase;
    private final long delayMillisecond;
    private final double screenDivideValue;
    private int lensFacing;
    @Nullable
    private CameraSelector cameraSelector;
    private int boxWidth;
    private int boxHeight;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int diameter;
    public static final int $stable = 8;

    public CameraOverlayManager(@NotNull CameraXLiveActivity activity, @NotNull ActivityCameraXliveAcitivityBinding binding, @NotNull TextSizeConverter textSizeConverter, @NotNull Storage storage, @NotNull CameraXLiveViewModel viewModel, boolean isInternetAvailable, @NotNull Loggers.LoggerInstance logger) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)textSizeConverter, (String)"textSizeConverter");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.activity = activity;
        this.binding = binding;
        this.textSizeConverter = textSizeConverter;
        this.storage = storage;
        this.viewModel = viewModel;
        this.isInternetAvailable = isInternetAvailable;
        this.logger = logger;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executor = executorService;
        this.delayMillisecond = 15000L;
        this.screenDivideValue = 1.8;
        this.lensFacing = 1;
    }

    public final void setupOverlayAndAnimation() {
        this.setupPaddingAndOverlay();
        this.setupHeaderAndAnimation();
        this.requestPermissions();
    }

    private final void setupPaddingAndOverlay() {
        this.binding.txtBottom.setPadding(this.textSizeConverter.getPaddingOrMarginValue(6), 0, 0, 0);
        this.binding.overlay.setZOrderMediaOverlay(true);
        SurfaceHolder surfaceHolder = this.binding.overlay.getHolder();
        Intrinsics.checkNotNullExpressionValue((Object)surfaceHolder, (String)"getHolder(...)");
        this.holder = surfaceHolder;
        SurfaceHolder surfaceHolder2 = this.holder;
        if (surfaceHolder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"holder");
            surfaceHolder2 = null;
        }
        surfaceHolder2.setFormat(-2);
        SurfaceHolder surfaceHolder3 = this.holder;
        if (surfaceHolder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"holder");
            surfaceHolder3 = null;
        }
        surfaceHolder3.addCallback((SurfaceHolder.Callback)this);
        this.cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
    }

    private final void setupHeaderAndAnimation() {
        this.binding.layoutHeader.imgBack.setImageResource(R.drawable.back_white);
        this.binding.layoutHeader.lytHeaderMain.setBackgroundColor(0);
        if (StringsKt.equals((String)this.storage.getPreferredLocale(), (String)"ar", (boolean)true)) {
            this.binding.layoutHeader.imgBack.setRotation(180.0f);
        }
        this.binding.lottieAnimationView.setAnimation(R.raw.scan);
        this.binding.lottieAnimationView.playAnimation();
        this.binding.lottieAnimationView.setRepeatCount(-1);
    }

    private final void requestPermissions() {
        PermissionHelper.INSTANCE.requestsPermissions((FragmentActivity)this.activity, new PermissionHelper.PermissionCallback(this){
            final /* synthetic */ CameraOverlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResult(boolean allGranted, @NotNull List<String> grantedList, @NotNull List<String> deniedList) {
                Intrinsics.checkNotNullParameter(grantedList, (String)"grantedList");
                Intrinsics.checkNotNullParameter(deniedList, (String)"deniedList");
                if (allGranted) {
                    CameraOverlayManager.access$startCameraInit(this.this$0);
                }
            }
        });
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        new FocusRectDrawer((Context)this.activity, holder, this.binding, this.screenDivideValue).drawFocusRect(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.overlay_color));
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    private final void startCameraInit() {
        this.logger.log("start camera..");
        this.initCameraViewModelProvider();
        this.initClick();
        this.startTimer();
    }

    private final void initCameraViewModelProvider() {
        Function1 function1 = (Function1)new Function1<ProcessCameraProvider, Unit>(this){
            final /* synthetic */ CameraOverlayManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ProcessCameraProvider provider) {
                CameraOverlayManager.access$setCameraProvider$p(this.this$0, provider);
                CameraOverlayManager.access$bindAllCameraUseCases(this.this$0);
                this.this$0.bindAnalysisUseCase();
            }
        };
        this.viewModel.getProcessCameraProvider().observe((LifecycleOwner)this.activity, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final void initClick() {
        this.binding.layoutHeader.imgBack.setOnClickListener(arg_0 -> CameraOverlayManager.initClick$lambda$0(this, arg_0));
        this.binding.btnRescanningDocuments.setOnClickListener(arg_0 -> CameraOverlayManager.initClick$lambda$1(this, arg_0));
    }

    private final void bindAllCameraUseCases() {
        if (this.cameraProvider != null) {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            Intrinsics.checkNotNull((Object)processCameraProvider);
            processCameraProvider.unbindAll();
            this.bindPreviewUseCase();
        }
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    public final void bindAnalysisUseCase() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.CAMERA") == 0) {
            this.setUpAnalysisUseCase();
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private final void setUpAnalysisUseCase() {
        UseCase[] useCaseArray;
        this.activity.runOnUiThread(() -> CameraOverlayManager.setUpAnalysisUseCase$lambda$2(this));
        if (this.cameraProvider == null) {
            return;
        }
        if (this.analysisUseCase != null) {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            Intrinsics.checkNotNull((Object)processCameraProvider);
            useCaseArray = new UseCase[]{this.analysisUseCase};
            processCameraProvider.unbind(useCaseArray);
        }
        ImageAnalysis imageAnalysis = this.analysisUseCase = new ImageAnalysis.Builder().setDefaultResolution(new Size(1280, 720)).setBackpressureStrategy(0).build();
        Intrinsics.checkNotNull((Object)imageAnalysis);
        imageAnalysis.setAnalyzer(this.executor, arg_0 -> CameraOverlayManager.setUpAnalysisUseCase$lambda$3(this, arg_0));
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        Intrinsics.checkNotNull((Object)processCameraProvider);
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.activity;
        CameraSelector cameraSelector = this.cameraSelector;
        Intrinsics.checkNotNull((Object)cameraSelector);
        useCaseArray = new UseCase[]{this.imageCapture, this.analysisUseCase};
        processCameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, useCaseArray);
    }

    private final void analyzeImage(ImageProxy pImage) {
        Image mediaImage = pImage.getImage();
        if (mediaImage == null) {
            pImage.close();
            return;
        }
        this.logger.log("analyze:image ");
        InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)pImage.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(...)");
        InputImage image = inputImage;
        try {
            this.originalBitmapImage = this.bitmapImage = ImageConvertUtils.getInstance().convertToUpRightBitmap(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cropBitmapByPercentage();
        if (Intrinsics.areEqual((Object)true, (Object)this.viewModel.getCameraXLiveData().getFlag().getValue())) {
            this.passImageToRead(pImage);
        } else {
            boolean bl;
            boolean bl2 = bl = this.analysisUseCase != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ImageAnalysis imageAnalysis = this.analysisUseCase;
            Intrinsics.checkNotNull((Object)imageAnalysis);
            imageAnalysis.clearAnalyzer();
        }
    }

    private final void cropBitmapByPercentage() {
        Bitmap bitmap = this.bitmapImage;
        Intrinsics.checkNotNull((Object)bitmap);
        int height = bitmap.getHeight();
        Bitmap bitmap2 = this.bitmapImage;
        Intrinsics.checkNotNull((Object)bitmap2);
        int width = bitmap2.getWidth();
        this.diameter = Math.min(height, width);
        int offset = (int)(0.06 * (double)this.diameter);
        this.logger.log("analyzeImage: " + width + "   " + this.diameter);
        this.diameter -= offset;
        int value = 4;
        this.logger.log("analyzeImage:after removing offset " + width + "   " + this.diameter);
        this.left = width - this.diameter;
        this.top = (int)((double)height / this.screenDivideValue - (double)(this.diameter / value));
        this.right = this.diameter;
        this.bottom = (int)((double)height / this.screenDivideValue + (double)(this.diameter / value));
        this.boxHeight = this.bottom - this.top;
        this.boxWidth = this.right - this.left;
        int cutPercentage = 16;
        int cutAmount = (int)((double)width * ((double)cutPercentage / 100.0));
        this.left += cutAmount;
        this.right -= cutAmount;
        int newBoxWidth = this.right - this.left;
        if (Intrinsics.areEqual((Object)false, (Object)this.viewModel.getCameraXLiveData().getIsFrontView().getValue())) {
            Bitmap bitmap3 = this.bitmapImage;
            Intrinsics.checkNotNull((Object)bitmap3);
            this.croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)this.left, (int)this.top, (int)newBoxWidth, (int)this.boxHeight);
        } else {
            int cutPercentageTopBottom = 5;
            int cutAmountTopBottom = (int)((double)height * ((double)cutPercentageTopBottom / 100.0));
            this.top += cutAmountTopBottom;
            this.bottom -= cutAmountTopBottom;
            int newBoxHeight = this.bottom - this.top;
            Bitmap bitmap4 = this.bitmapImage;
            Intrinsics.checkNotNull((Object)bitmap4);
            this.croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap4, (int)this.left, (int)this.top, (int)newBoxWidth, (int)newBoxHeight);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Bitmap bitmap5 = this.croppedBitmap;
        Intrinsics.checkNotNull((Object)bitmap5);
        bitmap5.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void passImageToRead(ImageProxy pImage) {
        this.mPImage = pImage;
        if (StringsKt.equals((String)"release", (String)"debug", (boolean)true)) {
            this.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$4(this));
        }
        if (this.binding.lyoutScanFail.getVisibility() == 8) {
            String string2 = this.activity.getString(R.string.image_light_normal);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String imageLight = string2;
            if (StringsKt.equals((String)imageLight, (String)this.activity.getString(R.string.image_light_normal), (boolean)true)) {
                Bitmap bitmap = this.croppedBitmap;
                Intrinsics.checkNotNull((Object)bitmap);
                boolean hasGlare = GlareDetector.INSTANCE.isGlareDetected(bitmap);
                if (!hasGlare) {
                    this.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$5(this));
                    this.filterScannedText();
                } else {
                    this.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$7(this, pImage));
                }
            } else {
                this.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$9(this, imageLight, pImage));
            }
        }
    }

    private final void filterScannedText() {
        try {
            if (!StringsKt.equals((String)((String)Objects.requireNonNull(this.viewModel.getCameraXLiveData().getSelectedDoc().getValue())), (String)this.activity.getString(R.string.e_passport), (boolean)true)) {
                if (Intrinsics.areEqual((Object)false, (Object)this.viewModel.getCameraXLiveData().getAlgoHeaderDetect().getValue()) && Intrinsics.areEqual((Object)true, (Object)this.viewModel.getCameraXLiveData().getIsFrontView().getValue())) {
                    Bitmap bitmap = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap);
                    Bitmap bitmap2 = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap2);
                    int n = bitmap2.getWidth() / 2;
                    Bitmap bitmap3 = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap3);
                    this.croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)(bitmap3.getHeight() / 2));
                } else if (Intrinsics.areEqual((Object)true, (Object)this.viewModel.getCameraXLiveData().getIsFrontView().getValue())) {
                    Bitmap bitmap = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap);
                    Bitmap bitmap4 = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap4);
                    int n = bitmap4.getHeight() / 2;
                    Bitmap bitmap5 = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap5);
                    int n2 = bitmap5.getWidth();
                    Bitmap bitmap6 = this.croppedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap6);
                    this.croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n, (int)n2, (int)(bitmap6.getHeight() / 2));
                }
            }
            if (StringsKt.equals((String)"release", (String)"debug", (boolean)true)) {
                this.activity.runOnUiThread(() -> CameraOverlayManager.filterScannedText$lambda$10(this));
            }
            this.viewModel.processTextFromBitmap(this.croppedBitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void startTimer() {
        long l = this.delayMillisecond;
        this.cTimer = new CountDownTimer(this, l){
            final /* synthetic */ CameraOverlayManager this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, 1000L);
            }

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (CameraOverlayManager.access$isInternetAvailable$p(this.this$0)) {
                    if (Intrinsics.areEqual((Object)true, (Object)CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getIsFrontView().getValue())) {
                        CameraOverlayManager.access$setRescanningDocumentVisibility(this.this$0);
                    } else if (Utility.Companion.getInstance().getPassportNumber() == null && Utility.Companion.getInstance().getDateOfBirth() == null && Utility.Companion.getInstance().getExpiryDate() == null) {
                        CameraOverlayManager.access$setRescanningDocumentVisibility(this.this$0);
                    } else {
                        CountDownTimer countDownTimer = CameraOverlayManager.access$getCTimer$p(this.this$0);
                        Intrinsics.checkNotNull((Object)countDownTimer);
                        countDownTimer.start();
                    }
                } else {
                    CountDownTimer countDownTimer = CameraOverlayManager.access$getCTimer$p(this.this$0);
                    Intrinsics.checkNotNull((Object)countDownTimer);
                    countDownTimer.start();
                }
            }
        }.start();
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    private final void bindPreviewUseCase() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.CAMERA") == 0) {
            int n;
            if (this.cameraProvider == null) {
                return;
            }
            if (this.previewUseCase != null) {
                ProcessCameraProvider processCameraProvider = this.cameraProvider;
                Intrinsics.checkNotNull((Object)processCameraProvider);
                UseCase[] useCaseArray = new UseCase[]{this.previewUseCase};
                processCameraProvider.unbind(useCaseArray);
            }
            Preview.Builder builder = new Preview.Builder();
            Preview preview = this.previewUseCase = builder.build();
            Intrinsics.checkNotNull((Object)preview);
            preview.setSurfaceProvider(this.binding.previewView.getSurfaceProvider());
            if (Build.VERSION.SDK_INT >= 30) {
                Display display = this.activity.getDisplay();
                n = display != null ? display.getRotation() : 0;
            } else {
                n = this.activity.getWindowManager().getDefaultDisplay().getRotation();
            }
            int rotation = n;
            this.imageCapture = new ImageCapture.Builder().setTargetRotation(rotation).build();
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            Intrinsics.checkNotNull((Object)processCameraProvider);
            LifecycleOwner lifecycleOwner = (LifecycleOwner)this.activity;
            CameraSelector cameraSelector = this.cameraSelector;
            Intrinsics.checkNotNull((Object)cameraSelector);
            UseCase[] useCaseArray = new UseCase[]{this.imageCapture, this.previewUseCase};
            processCameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, useCaseArray);
        }
    }

    private final void setRescanningDocumentVisibility() {
        this.viewModel.getCameraXLiveData().setIsOverlayVisible(false);
        this.viewModel.getCameraXLiveData().setIsScanVisible(false);
        this.viewModel.getCameraXLiveData().setIsScanFailVisible(true);
        this.viewModel.getCameraXLiveData().setIsTransparentVisible(true);
        this.viewModel.getCameraXLiveData().setIsScanCompleteVisible(false);
    }

    public final void handleCloseImageProxy(boolean needToClose) {
        block1: {
            if (!needToClose || this.mPImage == null) break block1;
            ImageProxy imageProxy = this.mPImage;
            if (imageProxy != null) {
                imageProxy.close();
            }
        }
    }

    public final void handleCTimer(boolean needToCloseTimer) {
        block0: {
            block1: {
                if (this.cTimer == null) break block0;
                if (!needToCloseTimer) break block1;
                CountDownTimer countDownTimer = this.cTimer;
                if (countDownTimer == null) break block0;
                countDownTimer.cancel();
                break block0;
            }
            CountDownTimer countDownTimer = this.cTimer;
            if (countDownTimer == null) break block0;
            countDownTimer.start();
        }
    }

    public final void handleCaptureAnImage(boolean needToCallCapture) {
        if (needToCallCapture) {
            this.captureAnImage();
        }
    }

    public final void handleAnalysisUseCase(boolean needToClearAnalyzer) {
        block1: {
            if (!needToClearAnalyzer) break block1;
            ImageAnalysis imageAnalysis = this.analysisUseCase;
            if (imageAnalysis != null) {
                imageAnalysis.clearAnalyzer();
            }
        }
    }

    public final void unBindCameraProvider(boolean isUnbind) {
        block2: {
            boolean bl;
            if (!isUnbind) break block2;
            boolean bl2 = bl = this.cameraProvider != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider != null) {
                processCameraProvider.unbindAll();
            }
        }
    }

    private final void captureAnImage() {
        block0: {
            this.logger.log("capturing photo");
            ImageCapture imageCapture = this.imageCapture;
            if (imageCapture == null) break block0;
            imageCapture.takePicture(this.executor, new ImageCapture.OnImageCapturedCallback(this){
                final /* synthetic */ CameraOverlayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCaptureSuccess(@NotNull ImageProxy image) {
                    Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                    CameraOverlayManager.access$getBinding$p((CameraOverlayManager)this.this$0).imgScanComplete.setMaxFrame(80);
                    super.onCaptureSuccess(image);
                    if (StringsKt.equals((String)((String)Objects.requireNonNull(CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getSelectedDoc().getValue())), (String)CameraOverlayManager.access$getActivity$p(this.this$0).getString(R.string.e_passport), (boolean)true)) {
                        CameraOverlayManager.access$capturePassportImage(this.this$0);
                    } else {
                        ByteArrayOutputStream stream = CameraOverlayManager.access$reCropDocBitmap(this.this$0);
                        if (Intrinsics.areEqual((Object)true, (Object)CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getIsFrontView().getValue()) && Intrinsics.areEqual((Object)false, (Object)CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getIsFrontViewScanned().getValue())) {
                            CameraOverlayManager.access$captureFrontViewIdCard(this.this$0, stream);
                        } else {
                            CameraOverlayManager.access$captureBackViewIdCard(this.this$0, stream);
                        }
                    }
                }
            });
        }
    }

    private final void capturePassportImage() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Bitmap bitmap = this.croppedBitmap;
        if (bitmap != null) {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        }
        byte[] byteArray = stream.toByteArray();
        Utility.Companion.getInstance().setScannedImage(byteArray);
        this.activity.runOnUiThread(() -> CameraOverlayManager.capturePassportImage$lambda$11(this));
    }

    private final ByteArrayOutputStream reCropDocBitmap() {
        Bitmap bitmap = this.originalBitmapImage;
        Intrinsics.checkNotNull((Object)bitmap);
        int height = bitmap.getHeight();
        Bitmap bitmap2 = this.originalBitmapImage;
        Intrinsics.checkNotNull((Object)bitmap2);
        int width = bitmap2.getWidth();
        this.diameter = Math.min(height, width);
        int offset = (int)(0.06 * (double)this.diameter);
        this.logger.log("analyzeImage: " + width + "   " + this.diameter);
        this.diameter -= offset;
        int value = 4;
        this.logger.log("analyzeImage:after removing offset " + width + "   " + this.diameter);
        this.left = width - this.diameter;
        this.top = (int)((double)height / this.screenDivideValue - (double)(this.diameter / value));
        this.right = this.diameter;
        this.bottom = (int)((double)height / this.screenDivideValue + (double)(this.diameter / value));
        this.boxHeight = this.bottom - this.top;
        this.boxWidth = this.right - this.left;
        Bitmap bitmap3 = this.originalBitmapImage;
        Intrinsics.checkNotNull((Object)bitmap3);
        this.croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)this.left, (int)this.top, (int)this.boxWidth, (int)this.boxHeight);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Bitmap bitmap4 = this.croppedBitmap;
        Intrinsics.checkNotNull((Object)bitmap4);
        bitmap4.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        return stream;
    }

    private final void captureFrontViewIdCard(ByteArrayOutputStream stream) {
        byte[] byteArray = stream.toByteArray();
        Utility.Companion.getInstance().setScannedImage(byteArray);
        this.activity.runOnUiThread(() -> CameraOverlayManager.captureFrontViewIdCard$lambda$12(this, byteArray));
        this.activity.runOnUiThread(() -> CameraOverlayManager.captureFrontViewIdCard$lambda$13(this));
    }

    private final void captureBackViewIdCard(ByteArrayOutputStream stream) {
        this.activity.runOnUiThread(() -> CameraOverlayManager.captureBackViewIdCard$lambda$14(this));
        byte[] byteArray = stream.toByteArray();
        Utility.Companion.getInstance().setScannedIdFrontView(byteArray);
        this.activity.runOnUiThread(() -> CameraOverlayManager.captureBackViewIdCard$lambda$15(this));
    }

    public void onCheckedChanged(@NotNull CompoundButton buttonView, boolean isChecked) {
        Intrinsics.checkNotNullParameter((Object)buttonView, (String)"buttonView");
        if (ContextCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.CAMERA") == 0) {
            if (this.cameraProvider == null) {
                return;
            }
            int newLensFacing = this.lensFacing == 0 ? 1 : 0;
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(newLensFacing).build();
            Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"build(...)");
            CameraSelector newCameraSelector = cameraSelector;
            try {
                ProcessCameraProvider processCameraProvider = this.cameraProvider;
                Intrinsics.checkNotNull((Object)processCameraProvider);
                if (processCameraProvider.hasCamera(newCameraSelector)) {
                    this.lensFacing = newLensFacing;
                    this.cameraSelector = newCameraSelector;
                    this.bindAllCameraUseCases();
                }
            }
            catch (CameraInfoUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    private static final void initClick$lambda$0(CameraOverlayManager this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.activity.getOnBackPressedDispatcher().onBackPressed();
    }

    private static final void initClick$lambda$1(CameraOverlayManager this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setIsOverlayVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsScanVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsScanFailVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsTransparentVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsScanCompleteVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsBackCardScanVisible(false);
        CountDownTimer countDownTimer = this$0.cTimer;
        Intrinsics.checkNotNull((Object)countDownTimer);
        countDownTimer.start();
        if (this$0.mPImage != null) {
            ImageProxy imageProxy = this$0.mPImage;
            Intrinsics.checkNotNull((Object)imageProxy);
            imageProxy.close();
        }
    }

    private static final void setUpAnalysisUseCase$lambda$2(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setIsScanVisible(true);
    }

    private static final void setUpAnalysisUseCase$lambda$3(CameraOverlayManager this$0, ImageProxy pImage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)pImage, (String)"pImage");
        if (this$0.isInternetAvailable) {
            this$0.analyzeImage(pImage);
        } else {
            pImage.close();
        }
    }

    private static final void passImageToRead$lambda$4(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Loggers.LoggerInstance loggerInstance = this$0.logger;
        Bitmap bitmap = this$0.croppedBitmap;
        Intrinsics.checkNotNull((Object)bitmap);
        int n = bitmap.getHeight();
        Bitmap bitmap2 = this$0.croppedBitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        loggerInstance.log("run: " + n + " " + bitmap2.getWidth());
        this$0.binding.testimg1.setVisibility(0);
        this$0.binding.testimg1.setImageBitmap(this$0.croppedBitmap);
    }

    private static final void passImageToRead$lambda$5(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setGlareTextVisibility(false);
    }

    private static final void passImageToRead$lambda$7$lambda$6(ImageProxy $pImage) {
        Intrinsics.checkNotNullParameter((Object)$pImage, (String)"$pImage");
        $pImage.close();
    }

    private static final void passImageToRead$lambda$7(CameraOverlayManager this$0, ImageProxy $pImage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pImage, (String)"$pImage");
        this$0.viewModel.getCameraXLiveData().setGlareTextVisibility(true);
        CameraXLiveData cameraXLiveData = this$0.viewModel.getCameraXLiveData();
        String string2 = this$0.activity.getString(R.string.glare);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        cameraXLiveData.setGlareText(string2);
        this$0.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$7$lambda$6($pImage));
    }

    private static final void passImageToRead$lambda$9$lambda$8(ImageProxy $pImage) {
        Intrinsics.checkNotNullParameter((Object)$pImage, (String)"$pImage");
        $pImage.close();
    }

    private static final void passImageToRead$lambda$9(CameraOverlayManager this$0, String $imageLight, ImageProxy $pImage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$imageLight, (String)"$imageLight");
        Intrinsics.checkNotNullParameter((Object)$pImage, (String)"$pImage");
        this$0.viewModel.getCameraXLiveData().setGlareTextVisibility(true);
        this$0.viewModel.getCameraXLiveData().setGlareText(this$0.activity.getString(R.string.image_light) + $imageLight);
        this$0.activity.runOnUiThread(() -> CameraOverlayManager.passImageToRead$lambda$9$lambda$8($pImage));
    }

    private static final void filterScannedText$lambda$10(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.binding.testimg2.setVisibility(0);
        this$0.binding.testimg2.setImageBitmap(this$0.croppedBitmap);
    }

    private static final void capturePassportImage$lambda$11(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setStatusText("");
        this$0.viewModel.getCameraXLiveData().setIsOverlayVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsScanVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsTransparentVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsScanCompleteVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsLayoutBottomVisible(false);
        this$0.binding.imgScanComplete.playAnimation();
        this$0.binding.imgScanComplete.addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this$0){
            final /* synthetic */ CameraOverlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                CameraOverlayManager.access$getLogger$p(this.this$0).log("passport scan completed");
                CameraOverlayManager.access$getViewModel$p(this.this$0).handleAnimationCompleted();
            }
        });
    }

    private static final void captureFrontViewIdCard$lambda$12(CameraOverlayManager this$0, byte[] $byteArray) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setStatusText("");
        this$0.viewModel.getCameraXLiveData().setIsOverlayVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsScanVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsTransparentVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsScanCompleteVisible(true);
        this$0.binding.imgScanComplete.playAnimation();
        this$0.binding.imgScanComplete.addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this$0, $byteArray){
            final /* synthetic */ CameraOverlayManager this$0;
            final /* synthetic */ byte[] $byteArray;
            {
                this.this$0 = $receiver;
                this.$byteArray = $byteArray;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                if (CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getIdNo().getValue() == null && CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getDOB().getValue() == null && CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().getExpiryDate().getValue() == null) {
                    CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsScanCompleteVisible(false);
                    CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsBackCardScanVisible(true);
                    CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setStatusText("");
                    CameraXLiveViewModel cameraXLiveViewModel = CameraOverlayManager.access$getViewModel$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)this.$byteArray, (String)"$byteArray");
                    cameraXLiveViewModel.scannedIdFrontViewCompleted(this.$byteArray);
                    CameraOverlayManager.access$getLogger$p(this.this$0).log("loading card flip animation");
                    RequestBuilder requestBuilder2 = Glide.with((FragmentActivity)((FragmentActivity)CameraOverlayManager.access$getActivity$p(this.this$0))).asGif().load(Integer.valueOf(R.drawable.card_flip)).listener((RequestListener)new RequestListener<GifDrawable>(this.this$0){
                        final /* synthetic */ CameraOverlayManager this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public boolean onLoadFailed(@Nullable GlideException e, @Nullable Object model, @NotNull Target<GifDrawable> target, boolean isFirstResource) {
                            Intrinsics.checkNotNullParameter(target, (String)"target");
                            return false;
                        }

                        public boolean onResourceReady(@NotNull GifDrawable resource, @NotNull Object model, @NotNull Target<GifDrawable> target, @NotNull DataSource dataSource, boolean isFirstResource) {
                            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                            Intrinsics.checkNotNullParameter(target, (String)"target");
                            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                            CameraOverlayManager.access$getBinding$p((CameraOverlayManager)this.this$0).txtTurnDoc.setVisibility(0);
                            CameraOverlayManager.access$getBinding$p((CameraOverlayManager)this.this$0).txtTurnDoc.setText((CharSequence)CameraOverlayManager.access$getActivity$p(this.this$0).getString(R.string.turn_document));
                            CameraOverlayManager.access$getLogger$p(this.this$0).log("resource ready to load");
                            resource.setLoopCount(1);
                            resource.registerAnimationCallback(new Animatable2Compat.AnimationCallback(this.this$0){
                                final /* synthetic */ CameraOverlayManager this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public void onAnimationEnd(@NotNull Drawable drawable2) {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
                                        CameraOverlayManager.access$getLogger$p(this.this$0).log("animation end");
                                        CameraOverlayManager.access$getBinding$p((CameraOverlayManager)this.this$0).txtTurnDoc.setVisibility(8);
                                        CameraXLiveData cameraXLiveData = CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData();
                                        String string2 = CameraOverlayManager.access$getActivity$p(this.this$0).getString(R.string.scan_id_top_back_text);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                                        cameraXLiveData.setStatusText(string2);
                                        CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsOverlayVisible(true);
                                        CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsScanVisible(true);
                                        CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsTransparentVisible(false);
                                        CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsScanCompleteVisible(false);
                                        CameraOverlayManager.access$getViewModel$p(this.this$0).getCameraXLiveData().setIsBackCardScanVisible(false);
                                        CameraOverlayManager.access$getLogger$p(this.this$0).log("onAnimationEnd: start time " + CameraOverlayManager.access$getViewModel$p(this.this$0).printCurrentTimeInLogs());
                                        ImageProxy imageProxy = CameraOverlayManager.access$getMPImage$p(this.this$0);
                                        if (imageProxy == null) break block0;
                                        imageProxy.close();
                                    }
                                }
                            });
                            return false;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"listener(...)");
                    RequestBuilder requestBuilder3 = requestBuilder2;
                    requestBuilder3.into(CameraOverlayManager.access$getBinding$p((CameraOverlayManager)this.this$0).imgBackcrdScan);
                }
            }
        });
    }

    private static final void captureFrontViewIdCard$lambda$13(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setIdLine1(true);
        this$0.viewModel.getCameraXLiveData().setIdLine2(true);
        this$0.viewModel.getCameraXLiveData().setIdLine3(true);
        this$0.viewModel.getCameraXLiveData().setIsFrontViewScanned(true);
    }

    private static final void captureBackViewIdCard$lambda$14(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setStatusText("");
    }

    private static final void captureBackViewIdCard$lambda$15(CameraOverlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewModel.getCameraXLiveData().setIsOverlayVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsScanVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsTransparentVisible(true);
        this$0.viewModel.getCameraXLiveData().setIsBackCardScanVisible(false);
        this$0.viewModel.getCameraXLiveData().setIsScanCompleteVisible(true);
        this$0.binding.imgScanComplete.playAnimation();
        this$0.logger.log("onAnimationEnd: end time " + this$0.viewModel.printCurrentTimeInLogs());
        this$0.binding.imgScanComplete.addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this$0){
            final /* synthetic */ CameraOverlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                CameraOverlayManager.access$getViewModel$p(this.this$0).handleAnimationCompleted();
            }
        });
    }

    public static final /* synthetic */ void access$startCameraInit(CameraOverlayManager $this) {
        $this.startCameraInit();
    }

    public static final /* synthetic */ void access$setCameraProvider$p(CameraOverlayManager $this, ProcessCameraProvider processCameraProvider) {
        $this.cameraProvider = processCameraProvider;
    }

    public static final /* synthetic */ void access$bindAllCameraUseCases(CameraOverlayManager $this) {
        $this.bindAllCameraUseCases();
    }

    public static final /* synthetic */ boolean access$isInternetAvailable$p(CameraOverlayManager $this) {
        return $this.isInternetAvailable;
    }

    public static final /* synthetic */ CameraXLiveViewModel access$getViewModel$p(CameraOverlayManager $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ void access$setRescanningDocumentVisibility(CameraOverlayManager $this) {
        $this.setRescanningDocumentVisibility();
    }

    public static final /* synthetic */ CountDownTimer access$getCTimer$p(CameraOverlayManager $this) {
        return $this.cTimer;
    }

    public static final /* synthetic */ ActivityCameraXliveAcitivityBinding access$getBinding$p(CameraOverlayManager $this) {
        return $this.binding;
    }

    public static final /* synthetic */ CameraXLiveActivity access$getActivity$p(CameraOverlayManager $this) {
        return $this.activity;
    }

    public static final /* synthetic */ void access$capturePassportImage(CameraOverlayManager $this) {
        $this.capturePassportImage();
    }

    public static final /* synthetic */ ByteArrayOutputStream access$reCropDocBitmap(CameraOverlayManager $this) {
        return $this.reCropDocBitmap();
    }

    public static final /* synthetic */ void access$captureFrontViewIdCard(CameraOverlayManager $this, ByteArrayOutputStream stream) {
        $this.captureFrontViewIdCard(stream);
    }

    public static final /* synthetic */ void access$captureBackViewIdCard(CameraOverlayManager $this, ByteArrayOutputStream stream) {
        $this.captureBackViewIdCard(stream);
    }

    public static final /* synthetic */ Loggers.LoggerInstance access$getLogger$p(CameraOverlayManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ImageProxy access$getMPImage$p(CameraOverlayManager $this) {
        return $this.mPImage;
    }
}

