/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.SurfaceHolder;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.ActivityCameraXliveAcitivityBinding;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnashid/verify/sdk/utils/helpers/FocusRectDrawer;", "", "context", "Landroid/content/Context;", "holder", "Landroid/view/SurfaceHolder;", "binding", "Lnashid/verify/sdkNew/databinding/ActivityCameraXliveAcitivityBinding;", "screenDivideValue", "", "(Landroid/content/Context;Landroid/view/SurfaceHolder;Lnashid/verify/sdkNew/databinding/ActivityCameraXliveAcitivityBinding;D)V", "bottom", "", "boxHeight", "boxWidth", "canvas", "Landroid/graphics/Canvas;", "diameter", "left", "right", "top", "createCornersPath", "", "paint", "Landroid/graphics/Paint;", "drawFocusRect", "color", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class FocusRectDrawer {
    @NotNull
    private final Context context;
    @NotNull
    private final SurfaceHolder holder;
    @NotNull
    private final ActivityCameraXliveAcitivityBinding binding;
    private final double screenDivideValue;
    private int diameter;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int boxWidth;
    private int boxHeight;
    private Canvas canvas;
    public static final int $stable = 8;

    public FocusRectDrawer(@NotNull Context context, @NotNull SurfaceHolder holder, @NotNull ActivityCameraXliveAcitivityBinding binding, double screenDivideValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.context = context;
        this.holder = holder;
        this.binding = binding;
        this.screenDivideValue = screenDivideValue;
    }

    public final void drawFocusRect(int color2) {
        try {
            int width;
            int height = this.binding.previewView.getHeight();
            this.diameter = width = this.binding.previewView.getWidth();
            if (height < width) {
                this.diameter = height;
            }
            int offset = (int)(0.06 * (double)this.diameter);
            this.diameter -= offset;
            Canvas canvas = this.holder.lockCanvas();
            Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"lockCanvas(...)");
            this.canvas = canvas;
            Canvas canvas2 = this.canvas;
            if (canvas2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
                canvas2 = null;
            }
            canvas2.drawColor(ContextCompat.getColor((Context)this.context, (int)R.color.overlay_color), PorterDuff.Mode.ADD);
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(color2);
            paint.setStrokeWidth(3.0f);
            this.left = width - this.diameter;
            this.top = (int)((double)height / this.screenDivideValue - (double)(this.diameter / 3));
            this.right = this.diameter;
            this.bottom = (int)((double)height / this.screenDivideValue + (double)(this.diameter / 3));
            this.boxHeight = this.bottom - this.top;
            this.boxWidth = this.right - this.left;
            Paint paint1 = new Paint(4);
            paint1.setStyle(Paint.Style.FILL);
            paint1.setColor(-1);
            paint1.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            Paint paint2 = new Paint();
            paint2.setStyle(Paint.Style.STROKE);
            paint2.setColor(-1);
            paint2.setStrokeWidth(4.0f);
            int corner = 26;
            int cornerSpace = 18;
            paint.setStrokeJoin(Paint.Join.ROUND);
            this.createCornersPath(this.left - cornerSpace, this.top - cornerSpace, this.right + cornerSpace, this.bottom + cornerSpace, paint2);
            Canvas canvas3 = this.canvas;
            if (canvas3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
                canvas3 = null;
            }
            canvas3.drawRoundRect(new RectF((float)this.left, (float)this.top, (float)this.right, (float)this.bottom), (float)corner, (float)corner, paint1);
            Canvas canvas4 = this.canvas;
            if (canvas4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
                canvas4 = null;
            }
            canvas4.drawRoundRect(new RectF((float)this.left, (float)this.top, (float)this.right, (float)this.bottom), (float)corner, (float)corner, paint);
            Canvas canvas5 = this.canvas;
            if (canvas5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
                canvas5 = null;
            }
            this.holder.unlockCanvasAndPost(canvas5);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.boxWidth, this.boxHeight);
            params.topMargin = this.top;
            params.addRule(14, -1);
            this.binding.scan.setLayoutParams((ViewGroup.LayoutParams)params);
            this.binding.scan.invalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void createCornersPath(int left, int top, int right, int bottom, Paint paint) {
        float radius = 40.0f;
        float lengthF = 80.0f;
        Canvas canvas = this.canvas;
        if (canvas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas = null;
        }
        canvas.drawLine((float)left + radius, (float)top, (float)left + lengthF, (float)top, paint);
        Canvas canvas2 = this.canvas;
        if (canvas2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas2 = null;
        }
        canvas2.drawLine((float)left, (float)top + radius, (float)left, (float)top + lengthF, paint);
        RectF rectTL = new RectF((float)left, (float)top, (float)left + radius * (float)2, (float)top + radius * (float)2);
        Canvas canvas3 = this.canvas;
        if (canvas3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas3 = null;
        }
        canvas3.drawArc(rectTL, 180.0f, 90.0f, false, paint);
        Canvas canvas4 = this.canvas;
        if (canvas4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas4 = null;
        }
        canvas4.drawLine((float)right - radius, (float)top, (float)right - lengthF, (float)top, paint);
        Canvas canvas5 = this.canvas;
        if (canvas5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas5 = null;
        }
        canvas5.drawLine((float)right, (float)top + radius, (float)right, (float)top + lengthF, paint);
        RectF rectTR = new RectF((float)right - radius * (float)2, (float)top, (float)right, (float)top + radius * (float)2);
        Canvas canvas6 = this.canvas;
        if (canvas6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas6 = null;
        }
        canvas6.drawArc(rectTR, 270.0f, 90.0f, false, paint);
        Canvas canvas7 = this.canvas;
        if (canvas7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas7 = null;
        }
        canvas7.drawLine((float)left + radius, (float)bottom, (float)left + lengthF, (float)bottom, paint);
        Canvas canvas8 = this.canvas;
        if (canvas8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas8 = null;
        }
        canvas8.drawLine((float)left, (float)bottom - radius, (float)left, (float)bottom - lengthF, paint);
        RectF rectBL = new RectF((float)left, (float)bottom - radius * (float)2, (float)left + radius * (float)2, (float)bottom);
        Canvas canvas9 = this.canvas;
        if (canvas9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas9 = null;
        }
        canvas9.drawArc(rectBL, 90.0f, 90.0f, false, paint);
        Canvas canvas10 = this.canvas;
        if (canvas10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas10 = null;
        }
        canvas10.drawLine((float)right - radius, (float)bottom, (float)right - lengthF, (float)bottom, paint);
        Canvas canvas11 = this.canvas;
        if (canvas11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas11 = null;
        }
        canvas11.drawLine((float)right, (float)bottom - radius, (float)right, (float)bottom - lengthF, paint);
        RectF rectBR = new RectF((float)right - radius * (float)2, (float)bottom - radius * (float)2, (float)right, (float)bottom);
        Canvas canvas12 = this.canvas;
        if (canvas12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canvas");
            canvas12 = null;
        }
        canvas12.drawArc(rectBR, 0.0f, 90.0f, false, paint);
    }
}

