/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertStoreParameters;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.utils.helpers.JMRTDSecurityProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lnashid/verify/sdk/utils/helpers/KeyStoreCertStoreParameters;", "", "Ljava/security/cert/CertStoreParameters;", "uri", "Ljava/net/URI;", "password", "", "(Ljava/net/URI;[C)V", "algorithm", "", "(Ljava/net/URI;Ljava/lang/String;[C)V", "keyStore", "Ljava/security/KeyStore;", "(Ljava/security/KeyStore;)V", "getKeyStore", "()Ljava/security/KeyStore;", "clone", "", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class KeyStoreCertStoreParameters
implements Cloneable,
CertStoreParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyStore keyStore;
    public static final int $stable = 8;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    @NotNull
    private static final String DEFAULT_ALGORITHM = "JKS";
    @NotNull
    private static final char[] DEFAULT_PASSWORD;

    public KeyStoreCertStoreParameters(@NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.keyStore = keyStore;
    }

    @NotNull
    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStoreCertStoreParameters(@NotNull URI uri, @NotNull char[] password) throws KeyStoreException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(uri, DEFAULT_ALGORITHM, password);
    }

    @JvmOverloads
    public KeyStoreCertStoreParameters(@NotNull URI uri, @NotNull String algorithm, @NotNull char[] password) throws KeyStoreException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(KeyStoreCertStoreParameters.Companion.readKeyStore(uri, algorithm, password));
    }

    public /* synthetic */ KeyStoreCertStoreParameters(URI uRI, String string2, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) throws KeyStoreException {
        if ((n & 2) != 0) {
            string2 = DEFAULT_ALGORITHM;
        }
        if ((n & 4) != 0) {
            cArray = DEFAULT_PASSWORD;
        }
        this(uRI, string2, cArray);
    }

    @Override
    @NotNull
    public Object clone() {
        return new KeyStoreCertStoreParameters(this.keyStore);
    }

    @JvmOverloads
    public KeyStoreCertStoreParameters(@NotNull URI uri, @NotNull String algorithm) throws KeyStoreException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this(uri, algorithm, null, 4, null);
    }

    @JvmOverloads
    public KeyStoreCertStoreParameters(@NotNull URI uri) throws KeyStoreException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, null, null, 6, null);
    }

    static {
        char[] cArray = "".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        DEFAULT_PASSWORD = cArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnashid/verify/sdk/utils/helpers/KeyStoreCertStoreParameters$Companion;", "", "()V", "DEFAULT_ALGORITHM", "", "DEFAULT_PASSWORD", "", "LOGGER", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "readKeyStore", "Ljava/security/KeyStore;", "location", "Ljava/net/URI;", "keyStoreType", "password", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        private final KeyStore readKeyStore(URI location, String keyStoreType, char[] password) throws KeyStoreException {
            try {
                int n = JMRTDSecurityProvider.Companion.beginPreferBouncyCastleProvider();
                URLConnection uc = location.toURL().openConnection();
                InputStream inputStream = uc.getInputStream();
                KeyStore ks = null;
                ks = KeyStore.getInstance(keyStoreType);
                try {
                    Logger logger = LOGGER;
                    KeyStore keyStore = ks;
                    Intrinsics.checkNotNull((Object)keyStore);
                    String string2 = keyStore.getProvider().getClass().getCanonicalName();
                    Intrinsics.checkNotNull((Object)string2);
                    logger.info("KeystoreCertStore will use provider for KeyStore: " + string2);
                    ks.load(inputStream, password);
                }
                catch (IOException ioe) {
                    LOGGER.warning("Cannot read this file \"" + location + "\" as keystore");
                }
                inputStream.close();
                JMRTDSecurityProvider.Companion.endPreferBouncyCastleProvider(n);
                return ks;
            }
            catch (Exception e) {
                throw new KeyStoreException("Error getting keystore: " + e.getMessage());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

