/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.model.Liveness;
import nashid.verify.sdk.model.MainData;
import nashid.verify.sdk.model.NFC;
import nashid.verify.sdk.model.Scan;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lnashid/verify/sdk/utils/helpers/MainDataSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnashid/verify/sdk/model/MainData;", "()V", "isLivenessEmpty", "", "liveness", "Lnashid/verify/sdk/model/Liveness;", "isNfcEmpty", "nfc", "Lnashid/verify/sdk/model/NFC;", "isScanEmpty", "scan", "Lnashid/verify/sdk/model/Scan;", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "VerifySDK_release"})
@StabilityInferred(parameters=1)
public final class MainDataSerializer
implements JsonSerializer<MainData> {
    public static final int $stable;

    @NotNull
    public JsonElement serialize(@NotNull MainData src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject jsonObject = new JsonObject();
        if (src.getScan() != null && !this.isScanEmpty(src.getScan())) {
            jsonObject.add("scan", context.serialize((Object)src.getScan()));
        }
        if (src.getNfc() != null && !this.isNfcEmpty(src.getNfc())) {
            jsonObject.add("NFC", context.serialize((Object)src.getNfc()));
        }
        if (src.getLiveness() != null && !this.isLivenessEmpty(src.getLiveness())) {
            jsonObject.add("liveness", context.serialize((Object)src.getLiveness()));
        }
        return (JsonElement)jsonObject;
    }

    private final boolean isScanEmpty(Scan scan) {
        return Intrinsics.areEqual((Object)scan, (Object)new Scan(null, null, null, null, null, null, null, null, null, 511, null));
    }

    private final boolean isNfcEmpty(NFC nfc) {
        return Intrinsics.areEqual((Object)nfc, (Object)new NFC(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFFFF, null));
    }

    private final boolean isLivenessEmpty(Liveness liveness) {
        return Intrinsics.areEqual((Object)liveness, (Object)new Liveness(false, false, null, 7, null));
    }
}

