/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class FragmentBuffer
implements Serializable {
    private static final long serialVersionUID = -3510872461790499721L;
    private static final int DEFAULT_SIZE = 2000;
    private byte[] buffer;
    private final Collection<Fragment> fragments;

    public FragmentBuffer() {
        this(2000);
    }

    public FragmentBuffer(int length) {
        this.buffer = new byte[length];
        this.fragments = new HashSet<Fragment>();
    }

    public synchronized void updateFrom(FragmentBuffer other) {
        for (Fragment otherFragment : other.fragments) {
            this.addFragment(otherFragment.offset, other.buffer, otherFragment.offset, otherFragment.length);
        }
    }

    public synchronized void addFragment(int offset, byte b) {
        this.addFragment(offset, new byte[]{b});
    }

    public synchronized void addFragment(int offset, byte[] bytes) {
        this.addFragment(offset, bytes, 0, bytes.length);
    }

    public synchronized void addFragment(int offset, byte[] bytes, int srcOffset, int srcLength) {
        if (offset + srcLength > this.buffer.length) {
            this.setLength(2 * Math.max(offset + srcLength, this.buffer.length));
        }
        System.arraycopy(bytes, srcOffset, this.buffer, offset, srcLength);
        int thisOffset = offset;
        int thisLength = srcLength;
        ArrayList<Fragment> otherFragments = new ArrayList<Fragment>(this.fragments);
        for (Fragment other : otherFragments) {
            if (other.getOffset() <= thisOffset && thisOffset + thisLength <= other.getOffset() + other.getLength()) {
                return;
            }
            if (other.getOffset() <= thisOffset && thisOffset <= other.getOffset() + other.getLength()) {
                thisLength = thisOffset + thisLength - other.getOffset();
                thisOffset = other.getOffset();
                this.fragments.remove(other);
                continue;
            }
            if (thisOffset <= other.getOffset() && other.getOffset() + other.getLength() <= thisOffset + thisLength) {
                this.fragments.remove(other);
                continue;
            }
            if (thisOffset > other.getOffset() || other.getOffset() > thisOffset + thisLength) continue;
            thisLength = other.getOffset() + other.getLength() - thisOffset;
            this.fragments.remove(other);
        }
        this.fragments.add(Fragment.getInstance(thisOffset, thisLength));
    }

    public synchronized int getPosition() {
        int result2 = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (!this.isCoveredByFragment(i)) continue;
            result2 = i + 1;
        }
        return result2;
    }

    public synchronized int getBytesBuffered() {
        int result2 = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (!this.isCoveredByFragment(i)) continue;
            ++result2;
        }
        return result2;
    }

    public synchronized boolean isCoveredByFragment(int offset) {
        return this.isCoveredByFragment(offset, 1);
    }

    public synchronized boolean isCoveredByFragment(int offset, int length) {
        for (Fragment fragment : this.fragments) {
            int left = fragment.getOffset();
            int right = fragment.getOffset() + fragment.getLength();
            if (left > offset || offset + length > right) continue;
            return true;
        }
        return false;
    }

    public synchronized int getBufferedLength(int index) {
        int result2 = 0;
        if (index >= this.buffer.length) {
            return 0;
        }
        for (Fragment fragment : this.fragments) {
            int newResult;
            int left = fragment.getOffset();
            int right = fragment.getOffset() + fragment.getLength();
            if (left > index || index >= right || (newResult = right - index) <= result2) continue;
            result2 = newResult;
        }
        return result2;
    }

    public Collection<Fragment> getFragments() {
        return this.fragments;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            return this.buffer.length;
        }
    }

    public synchronized Fragment getSmallestUnbufferedFragment(int offset, int length) {
        int thisOffset = offset;
        int thisLength = length;
        for (Fragment other : this.fragments) {
            if (other.getOffset() <= thisOffset && thisOffset + thisLength <= other.getOffset() + other.getLength()) {
                thisLength = 0;
                break;
            }
            if (other.getOffset() <= thisOffset && thisOffset < other.getOffset() + other.getLength()) {
                int newOffset = other.getOffset() + other.getLength();
                int newLength = thisOffset + thisLength - newOffset;
                thisOffset = newOffset;
                thisLength = newLength;
                continue;
            }
            if (thisOffset <= other.getOffset() && other.getOffset() + other.getLength() <= thisOffset + thisLength || offset > other.getOffset() || other.getOffset() >= thisOffset + thisLength) continue;
            thisLength = other.getOffset() - thisOffset;
        }
        return Fragment.getInstance(thisOffset, thisLength);
    }

    public synchronized String toString() {
        return "FragmentBuffer [" + this.buffer.length + ", " + this.fragments + "]";
    }

    public synchronized boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (otherObject == this) {
            return true;
        }
        if (!otherObject.getClass().equals(FragmentBuffer.class)) {
            return false;
        }
        FragmentBuffer otherBuffer = (FragmentBuffer)otherObject;
        if (otherBuffer.buffer == null && this.buffer != null) {
            return false;
        }
        if (otherBuffer.buffer != null && this.buffer == null) {
            return false;
        }
        if (otherBuffer.fragments == null && this.fragments != null) {
            return false;
        }
        if (otherBuffer.fragments != null && this.fragments == null) {
            return false;
        }
        return Arrays.equals(otherBuffer.buffer, this.buffer) && otherBuffer.fragments.equals(this.fragments);
    }

    public int hashCode() {
        return 3 * Arrays.hashCode(this.buffer) + 2 * this.fragments.hashCode() + 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLength(int length) {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            if (length <= this.buffer.length) {
                return;
            }
            byte[] newBuffer = new byte[length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    public static class Fragment
    implements Serializable {
        private static final long serialVersionUID = -3795931618553980328L;
        private final int offset;
        private final int length;

        private Fragment(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public static Fragment getInstance(int offset, int length) {
            return new Fragment(offset, length);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "[" + this.offset + " .. " + (this.offset + this.length - 1) + " (" + this.length + ")]";
        }

        public boolean equals(Object otherObject) {
            if (otherObject == null) {
                return false;
            }
            if (otherObject == this) {
                return true;
            }
            if (!otherObject.getClass().equals(Fragment.class)) {
                return false;
            }
            Fragment otherFragment = (Fragment)otherObject;
            return otherFragment.offset == this.offset && otherFragment.length == this.length;
        }

        public int hashCode() {
            return 2 * this.offset + 3 * this.length + 5;
        }
    }
}

