/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractLDSInfo;

public abstract class AbstractListInfo<R extends Serializable>
extends AbstractLDSInfo {
    private static final long serialVersionUID = 2970076896364365191L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private List<R> subRecords;

    protected List<R> getSubRecords() {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        return new ArrayList<R>(this.subRecords);
    }

    protected void add(R subRecord) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.add(subRecord);
    }

    protected void addAll(List<R> subRecords) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.addAll(subRecords);
    }

    protected void remove(int index) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.remove(index);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof AbstractListInfo)) {
            return false;
        }
        try {
            AbstractListInfo otherRecord = (AbstractListInfo)other;
            List<R> subRecords = this.getSubRecords();
            List<R> otherSubRecords = otherRecord.getSubRecords();
            int subRecordCount = subRecords.size();
            if (subRecordCount != otherSubRecords.size()) {
                return false;
            }
            for (int i = 0; i < subRecordCount; ++i) {
                Serializable subRecord = (Serializable)subRecords.get(i);
                Serializable otherSubRecord = (Serializable)otherSubRecords.get(i);
                if (!(subRecord == null ? otherSubRecord != null : !subRecord.equals(otherSubRecord))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.WARNING, "Wrong class", cce);
            return false;
        }
    }

    public int hashCode() {
        int result2 = 1234567891;
        List<R> subRecords = this.getSubRecords();
        for (Serializable record : subRecords) {
            if (record == null) {
                result2 = 3 * result2 + 5;
                continue;
            }
            result2 = 5 * (result2 + record.hashCode()) + 7;
        }
        return 7 * result2 + 11;
    }

    @Override
    public abstract void writeObject(OutputStream var1) throws IOException;

    public abstract void readObject(InputStream var1) throws IOException;
}

