/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.StringTokenizer;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractTaggedLDSFile;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.LDSFileUtil;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public class COMFile
extends AbstractTaggedLDSFile {
    private static final long serialVersionUID = 2002455279067170063L;
    private static final int TAG_LIST_TAG = 92;
    private static final int VERSION_UNICODE_TAG = 24374;
    private static final int VERSION_LDS_TAG = 24321;
    private String versionLDS;
    private String updateLevelLDS;
    private String majorVersionUnicode;
    private String minorVersionUnicode;
    private String releaseLevelUnicode;
    private List<Integer> tagList;

    public COMFile(String versionLDS, String updateLevelLDS, String majorVersionUnicode, String minorVersionUnicode, String releaseLevelUnicode, int[] tagList) {
        super(96);
        this.initialize(versionLDS, updateLevelLDS, majorVersionUnicode, minorVersionUnicode, releaseLevelUnicode, tagList);
    }

    public COMFile(String ldsVer, String unicodeVer, int[] tagList) {
        super(96);
        try {
            if (ldsVer == null) {
                throw new IllegalArgumentException("Null versionLDS");
            }
            if (unicodeVer == null) {
                throw new IllegalArgumentException("Null versionUnicode");
            }
            StringTokenizer st = new StringTokenizer(ldsVer, ".");
            if (st.countTokens() != 2) {
                throw new IllegalArgumentException("Could not parse LDS version. Expecting 2 level version number x.y.");
            }
            Integer versionLDS = Integer.parseInt(st.nextToken().trim());
            Integer updateLevelLDS = Integer.parseInt(st.nextToken().trim());
            st = new StringTokenizer(unicodeVer, ".");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("Could not parse unicode version. Expecting 3 level version number x.y.z.");
            }
            Integer majorVersionUnicode = Integer.parseInt(st.nextToken().trim());
            Integer minorVersionUnicode = Integer.parseInt(st.nextToken().trim());
            Integer releaseLevelUnicode = Integer.parseInt(st.nextToken().trim());
            this.initialize(String.format("%02d", versionLDS), String.format("%02d", updateLevelLDS), String.format("%02d", majorVersionUnicode), String.format("%02d", minorVersionUnicode), String.format("%02d", releaseLevelUnicode), tagList);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not parse version number", nfe);
        }
        catch (IllegalFormatConversionException ifce) {
            throw new IllegalArgumentException("Could not parse version number", ifce);
        }
    }

    public COMFile(InputStream in) throws IOException {
        super(96, in);
    }

    @Override
    protected void readContent(InputStream in) throws IOException {
        TLVInputStream tlvIn = in instanceof TLVInputStream ? (TLVInputStream)in : new TLVInputStream(in);
        int versionLDSTag = tlvIn.readTag();
        if (versionLDSTag != 24321) {
            throw new IllegalArgumentException("Excepected VERSION_LDS_TAG (" + Integer.toHexString(24321) + "), found " + Integer.toHexString(versionLDSTag));
        }
        int versionLDSLength = tlvIn.readLength();
        if (versionLDSLength != 4) {
            throw new IllegalArgumentException("Wrong length of LDS version object");
        }
        byte[] versionLDSBytes = tlvIn.readValue();
        this.versionLDS = new String(versionLDSBytes, 0, 2);
        this.updateLevelLDS = new String(versionLDSBytes, 2, 2);
        int versionUnicodeTag = tlvIn.readTag();
        if (versionUnicodeTag != 24374) {
            throw new IllegalArgumentException("Expected VERSION_UNICODE_TAG (" + Integer.toHexString(24374) + "), found " + Integer.toHexString(versionUnicodeTag));
        }
        int versionUnicodeLength = tlvIn.readLength();
        if (versionUnicodeLength != 6) {
            throw new IllegalArgumentException("Wrong length of LDS version object");
        }
        byte[] versionUnicodeBytes = tlvIn.readValue();
        this.majorVersionUnicode = new String(versionUnicodeBytes, 0, 2);
        this.minorVersionUnicode = new String(versionUnicodeBytes, 2, 2);
        this.releaseLevelUnicode = new String(versionUnicodeBytes, 4, 2);
        int tagListTag = tlvIn.readTag();
        if (tagListTag != 92) {
            throw new IllegalArgumentException("Expected TAG_LIST_TAG (" + Integer.toHexString(92) + "), found " + Integer.toHexString(tagListTag));
        }
        tlvIn.readLength();
        byte[] tagBytes = tlvIn.readValue();
        this.tagList = new ArrayList<Integer>();
        for (byte tagByte : tagBytes) {
            int dgTag = tagByte & 0xFF;
            this.tagList.add(dgTag);
        }
    }

    public String getLDSVersion() {
        String ldsVersion = this.versionLDS + "." + this.updateLevelLDS;
        try {
            int major = Integer.parseInt(this.versionLDS);
            int minor = Integer.parseInt(this.updateLevelLDS);
            ldsVersion = major + "." + minor;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ldsVersion;
    }

    public String getUnicodeVersion() {
        String unicodeVersion = this.majorVersionUnicode + "." + this.minorVersionUnicode + "." + this.releaseLevelUnicode;
        try {
            int major = Integer.parseInt(this.majorVersionUnicode);
            int minor = Integer.parseInt(this.minorVersionUnicode);
            int releaseLevel = Integer.parseInt(this.releaseLevelUnicode);
            unicodeVersion = major + "." + minor + "." + releaseLevel;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return unicodeVersion;
    }

    public int[] getTagList() {
        int[] result2 = new int[this.tagList.size()];
        int i = 0;
        for (Integer tag : this.tagList) {
            result2[i++] = tag;
        }
        return result2;
    }

    public void insertTag(Integer tag) {
        if (this.tagList.contains(tag)) {
            return;
        }
        this.tagList.add(tag);
        Collections.sort(this.tagList);
    }

    @Override
    protected void writeContent(OutputStream out) throws IOException {
        TLVOutputStream tlvOut = out instanceof TLVOutputStream ? (TLVOutputStream)out : new TLVOutputStream(out);
        tlvOut.writeTag(24321);
        tlvOut.writeValue((this.versionLDS + this.updateLevelLDS).getBytes());
        tlvOut.writeTag(24374);
        tlvOut.writeValue((this.majorVersionUnicode + this.minorVersionUnicode + this.releaseLevelUnicode).getBytes());
        tlvOut.writeTag(92);
        tlvOut.writeLength(this.tagList.size());
        for (int tag : this.tagList) {
            tlvOut.write((int)((byte)tag));
        }
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("COMFile ");
        result2.append("LDS " + this.versionLDS + "." + this.updateLevelLDS);
        result2.append(", ");
        result2.append("Unicode " + this.majorVersionUnicode + "." + this.minorVersionUnicode + "." + this.releaseLevelUnicode);
        result2.append(", ");
        int i = 0;
        result2.append("[");
        int dgCount = this.tagList.size();
        for (int tag : this.tagList) {
            result2.append("DG" + LDSFileUtil.lookupDataGroupNumberByTag(tag));
            if (i < dgCount - 1) {
                result2.append(", ");
            }
            ++i;
        }
        result2.append("]");
        return result2.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        COMFile otherCOMFile = (COMFile)other;
        return this.versionLDS.equals(otherCOMFile.versionLDS) && this.updateLevelLDS.equals(otherCOMFile.updateLevelLDS) && this.majorVersionUnicode.equals(otherCOMFile.majorVersionUnicode) && this.minorVersionUnicode.equals(otherCOMFile.minorVersionUnicode) && this.releaseLevelUnicode.equals(otherCOMFile.releaseLevelUnicode) && this.tagList.equals(otherCOMFile.tagList);
    }

    public int hashCode() {
        return 3 * this.versionLDS.hashCode() + 5 * this.updateLevelLDS.hashCode() + 7 * this.majorVersionUnicode.hashCode() + 11 * this.minorVersionUnicode.hashCode() + 13 * this.releaseLevelUnicode.hashCode() + 17 * this.tagList.hashCode();
    }

    private void initialize(String versionLDS, String updateLevelLDS, String majorVersionUnicode, String minorVersionUnicode, String releaseLevelUnicode, int[] tagList) {
        if (tagList == null) {
            throw new IllegalArgumentException("Null tag list");
        }
        if (versionLDS == null || versionLDS.length() != 2 || updateLevelLDS == null || updateLevelLDS.length() != 2 || majorVersionUnicode == null || majorVersionUnicode.length() != 2 || minorVersionUnicode == null || minorVersionUnicode.length() != 2 || releaseLevelUnicode == null || releaseLevelUnicode.length() != 2 || tagList == null) {
            throw new IllegalArgumentException();
        }
        this.versionLDS = versionLDS;
        this.updateLevelLDS = updateLevelLDS;
        this.majorVersionUnicode = majorVersionUnicode;
        this.minorVersionUnicode = minorVersionUnicode;
        this.releaseLevelUnicode = releaseLevelUnicode;
        this.tagList = new ArrayList<Integer>(tagList.length);
        for (int tag : tagList) {
            this.tagList.add(tag);
        }
    }
}

