/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockDecoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockEncoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.CBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ComplexCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Decoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Encoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.SimpleCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.StandardBiometricHeader;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.CBEFFDataGroup;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794.FingerInfo;

public class DG3File
extends CBEFFDataGroup<FingerInfo> {
    private static final long serialVersionUID = -1037522331623814528L;
    private static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<FingerInfo>(){

        @Override
        public FingerInfo decode(InputStream inputStream, StandardBiometricHeader sbh, int index, int length) throws IOException {
            return new FingerInfo(sbh, inputStream);
        }
    });
    private static final ISO781611Encoder<FingerInfo> ENCODER = new ISO781611Encoder<FingerInfo>(new BiometricDataBlockEncoder<FingerInfo>(){

        @Override
        public void encode(FingerInfo info, OutputStream outputStream) throws IOException {
            info.writeObject(outputStream);
        }
    });
    private boolean shouldAddRandomDataIfEmpty;

    public DG3File(List<FingerInfo> fingerInfos) {
        this(fingerInfos, true);
    }

    public DG3File(List<FingerInfo> fingerInfos, boolean shouldAddRandomDataIfEmpty) {
        super(99, fingerInfos);
        this.shouldAddRandomDataIfEmpty = shouldAddRandomDataIfEmpty;
    }

    public DG3File(InputStream inputStream) throws IOException {
        super(99, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        ComplexCBEFFInfo cbeffInfo = DECODER.decode(inputStream);
        List<CBEFFInfo> records = cbeffInfo.getSubRecords();
        for (CBEFFInfo record : records) {
            if (!(record instanceof SimpleCBEFFInfo)) {
                throw new IOException("Was expecting a SimpleCBEFFInfo, found " + record.getClass().getSimpleName());
            }
            Object bdb = ((SimpleCBEFFInfo)record).getBiometricDataBlock();
            if (!(bdb instanceof FingerInfo)) {
                throw new IOException("Was expecting a FingerInfo, found " + bdb.getClass().getSimpleName());
            }
            this.add((FingerInfo)bdb);
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        ComplexCBEFFInfo cbeffInfo = new ComplexCBEFFInfo();
        List fingerInfos = this.getSubRecords();
        for (FingerInfo fingerInfo : fingerInfos) {
            SimpleCBEFFInfo<FingerInfo> simpleCBEFFInfo = new SimpleCBEFFInfo<FingerInfo>(fingerInfo);
            cbeffInfo.add(simpleCBEFFInfo);
        }
        ENCODER.encode(cbeffInfo, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return "DG3File [" + super.toString() + "]";
    }

    public List<FingerInfo> getFingerInfos() {
        return this.getSubRecords();
    }

    public void addFingerInfo(FingerInfo fingerInfo) {
        this.add(fingerInfo);
    }

    public void removeFingerInfo(int index) {
        this.remove(index);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.shouldAddRandomDataIfEmpty ? 1231 : 1237);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DG3File other = (DG3File)obj;
        return this.shouldAddRandomDataIfEmpty == other.shouldAddRandomDataIfEmpty;
    }
}

