/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import nashid.verify.sdk.utils.id_card.jmrtd.Util;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.SecureMessagingWrapper;

public class AESSecureMessagingWrapper
extends SecureMessagingWrapper
implements Serializable {
    private static final long serialVersionUID = 2086301081448345496L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private final transient Cipher sscIVCipher;

    public AESSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, long ssc) throws GeneralSecurityException {
        this(ksEnc, ksMac, 256, true, ssc);
    }

    public AESSecureMessagingWrapper(AESSecureMessagingWrapper wrapper) throws GeneralSecurityException {
        this(wrapper.getEncryptionKey(), wrapper.getMACKey(), wrapper.getMaxTranceiveLength(), wrapper.shouldCheckMAC(), wrapper.getSendSequenceCounter());
    }

    public AESSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, int maxTranceiveLength, boolean shouldCheckMAC, long ssc) throws GeneralSecurityException {
        super(ksEnc, ksMac, "AES/CBC/NoPadding", "AESCMAC", maxTranceiveLength, shouldCheckMAC, ssc);
        this.sscIVCipher = Util.getCipher("AES/ECB/NoPadding", 1, ksEnc);
    }

    public String getType() {
        return "AES";
    }

    @Override
    public int getPadLength() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncodedSendSequenceCounter() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
        try {
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(this.getSendSequenceCounter());
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error writing to stream", ioe);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "AESSecureMessagingWrapper [ssc: " + this.getSendSequenceCounter() + ", kEnc: " + this.getEncryptionKey() + ", kMac: " + this.getMACKey() + ", shouldCheckMAC: " + this.shouldCheckMAC() + ", maxTranceiveLength: " + this.getMaxTranceiveLength() + "]";
    }

    @Override
    public int hashCode() {
        return 71 * super.hashCode() + 17;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected IvParameterSpec getIV() throws GeneralSecurityException {
        byte[] encryptedSSC = this.sscIVCipher.doFinal(this.getEncodedSendSequenceCounter());
        return new IvParameterSpec(encryptedSSC);
    }
}

