/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.SecureMessagingWrapper;

public class DESedeSecureMessagingWrapper
extends SecureMessagingWrapper
implements Serializable {
    private static final long serialVersionUID = -2859033943345961793L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final IvParameterSpec ZERO_IV_PARAM_SPEC = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});

    public DESedeSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac) throws GeneralSecurityException {
        this(ksEnc, ksMac, true);
    }

    public DESedeSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, boolean shouldCheckMAC) throws GeneralSecurityException {
        this(ksEnc, ksMac, 256, shouldCheckMAC, 0L);
    }

    public DESedeSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, long ssc) throws GeneralSecurityException {
        this(ksEnc, ksMac, 256, true, ssc);
    }

    public DESedeSecureMessagingWrapper(DESedeSecureMessagingWrapper wrapper) throws GeneralSecurityException {
        this(wrapper.getEncryptionKey(), wrapper.getMACKey(), wrapper.getMaxTranceiveLength(), wrapper.shouldCheckMAC(), wrapper.getSendSequenceCounter());
    }

    public DESedeSecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, int maxTranceiveLength, boolean shouldCheckMAC, long ssc) throws GeneralSecurityException {
        super(ksEnc, ksMac, "DESede/CBC/NoPadding", "ISO9797Alg3Mac", maxTranceiveLength, shouldCheckMAC, ssc);
    }

    public String getType() {
        return "DESede";
    }

    @Override
    public int getPadLength() {
        return 8;
    }

    @Override
    public byte[] getEncodedSendSequenceCounter() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(this.getSendSequenceCounter());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error writing to stream", ioe);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        return "DESedeSecureMessagingWrapper [ssc: " + this.getSendSequenceCounter() + ", kEnc: " + this.getEncryptionKey() + ", kMac: " + this.getMACKey() + ", shouldCheckMAC: " + this.shouldCheckMAC() + ", maxTranceiveLength: " + this.getMaxTranceiveLength() + "]";
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + 13;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected IvParameterSpec getIV() {
        return ZERO_IV_PARAM_SPEC;
    }
}

