/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDataInputStream;

public class OmanCardDG4File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_FULL_NAME_ARABIC = 41994;
    public static final int TAG_FULL_NAME_ENGLISH = 58379;
    String fullNameArabic;
    String fullNameEnglish;

    public OmanCardDG4File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.fullNameArabic = new String(omanCardDataInputStream.getTagValue(41994), charset);
        this.fullNameEnglish = new String(omanCardDataInputStream.getTagValue(58379), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 41994: {
                return this.fullNameArabic;
            }
            case 58379: {
                return this.fullNameEnglish;
            }
        }
        return null;
    }

    public String toString() {
        return "OmanCardDG4File{41994='" + this.fullNameArabic + '\'' + ", " + 58379 + "='" + this.fullNameEnglish + '\'' + '}';
    }

    public String getFullNameEnglish() {
        return this.fullNameEnglish;
    }

    public void setFullNameEnglish(String fullNameEnglish) {
        this.fullNameEnglish = fullNameEnglish;
    }

    public String getFullNameArabic() {
        return this.fullNameArabic;
    }

    public void setFullNameArabic(String fullNameArabic) {
        this.fullNameArabic = fullNameArabic;
    }
}

