package nashid.verify.sdk.model

import com.google.gson.annotations.SerializedName

data class DocumentVerification(
    @SerializedName("metadata")
    val verificationMetadata: VerificationMetadata,
    @SerializedName("type")
    val type: Int,
    @SerializedName("data")
    val data: MainData,
    @SerializedName("artifacts")
    val artifacts: Artifacts,
    @SerializedName("status")
    val status: Int,
)

data class VerificationMetadata(
    @SerializedName("timestamp")
    val timestamp: String,
    @SerializedName("location")
    val location: Location,
    @SerializedName("device_ipv4")
    val deviceIp4: String,
    @SerializedName("device_ipv6")
    val deviceIp6: String,
    @SerializedName("system_name")
    val systemName: String,
    @SerializedName("system_version")
    val systemVersion: String,
    @SerializedName("device_identifier")
    val deviceIdentifier: String,
    @SerializedName("device_type")
    val deviceType: String,
    @SerializedName("gender")
    val gender: String? = null,
    @SerializedName("extradata")
    val extraData: ExtraData? = null,
)

data class Location(
    @SerializedName("longitude")
    val longitude: Double,
    @SerializedName("latitude")
    val latitude: Double,
)

data class MainData(
    @SerializedName("scan")
    val scan: Scan?,
    @SerializedName("NFC")
    val nfc: NFC?,
    @SerializedName("liveness")
    val liveness: Liveness?,
)

data class Scan(
    @SerializedName("mrz_text")
    val mrzText: String = "",
    @SerializedName("document_no")
    val documentNo: String = "",
    @SerializedName("document_type")
    val documentType: String = "",
    @SerializedName("expiry_date")
    val expiryDate: String = "",
    @SerializedName("date_of_birth")
    val dateOfBirth: String = "",
    @SerializedName("full_name")
    val fullName: String = "",
    @SerializedName("nationality")
    val nationality: String = "",
    @SerializedName("country")
    val country: String = "",
    @SerializedName("gender")
    val gender: String = "",
)

data class NFC(
    @SerializedName("full_name_english")
    val fullNameEnglish: String = "",
    @SerializedName("nationality_english")
    val nationalityEnglish: String = "",
    @SerializedName("gender_english")
    val genderEnglish: String = "",
    @SerializedName("gender_arabic")
    val genderArabic: String = "",
    @SerializedName("company_name_english")
    val companyNameEnglish: String = "",
    @SerializedName("permit_type")
    val permitType: String = "",
    @SerializedName("country_of_birth_arabic")
    val countryOfBirthArabic: String = "",
    @SerializedName("place_of_issue_arabic")
    val placeOfIssueArabic: String = "",
    @SerializedName("identity_number")
    val identityNumber: String = "",
    @SerializedName("place_of_issue_english")
    val placeOfIssueEnglish: String = "",
    @SerializedName("expiry_date")
    val expiryDate: String = "",
    @SerializedName("visa_number")
    val visaNumber: String = "",
    @SerializedName("issue_date")
    val issueDate: String = "",
    @SerializedName("full_name_arabic")
    val fullNameArabic: String = "",
    @SerializedName("company_name_arabic")
    val companyNameArabic: String = "",
    @SerializedName("country_of_birth_english")
    val countryOfBirthEnglish: String = "",
    @SerializedName("nationality_arabic")
    val nationalityArabic: String = "",
    @SerializedName("company_address_arabic")
    val companyAddressArabic: String = "",
    @SerializedName("permit_number")
    val permitNumber: String = "",
    @SerializedName("date_of_birth")
    val dateOfBirth: String = "",
    @SerializedName("use_by_date")
    val useByDate: String = "",
)

data class Liveness(
    @SerializedName("passive_liveness_confirmed")
    val passiveLivenessConfirmed: Boolean = false,
    @SerializedName("active_liveness_confirmed")
    val activeLivenessConfirmed: Boolean = false,
    @SerializedName("score")
    val score: String = "",
)

data class Artifacts(
    @SerializedName("back_side_image")
    val backSideImage: String = "",
    @SerializedName("front_side_image")
    val frontSideImage: String = "",
    @SerializedName("ocr_face_image")
    val ocrFaceImage: String = "",
    @SerializedName("nfc_face_image")
    val nfcFaceImage: String = "",
    @SerializedName("liveness_image")
    val livenessImage: String = "",
    @SerializedName("livness_image_without_bg")
    val livenessImageWithoutBg: String = "",
)
