package nashid.verify.sdk.utils.id_card.omn;

import android.util.Base64;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import nashid.verify.sdk.utils.id_card.omn.OmanCardDataInputStream;


public class OmanCardDG2File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_PHOTO = 0x6205;

    public static String toBase64(byte[] barray) {
        if (barray == null) {
            return "";
        }
        String result;
        result = Base64.encodeToString(barray, Base64.NO_WRAP);
        return result;
    }

    String photo;

    public OmanCardDG2File(byte[] buffer) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        byte[] tagId = new byte[2];
        bis.read(tagId);
        byte[] tagSize = new byte[2];
        bis.read(tagSize);
        int size = OmanCardDataInputStream.byteArrayToInt(tagSize, 2);
        byte[] tagVal = new byte[size];
        bis.read(tagVal);
        photo=toBase64(tagVal);
    }

    public String getTagValue(int tag)
    {
        if (tag == TAG_PHOTO) {
            return photo;
        }
        return null;
    }
//    public String toString()
//    {
//        StringBuilder stringBuilder = new StringBuilder();
//        stringBuilder.append("DG2: ");
//        stringBuilder.append("{\"photo\": \"");stringBuilder.append(photo);
//        stringBuilder.append("\"}");
//        return stringBuilder.toString();
//    }

    @Override
    public String toString() {
        return "OmanCardDG2File{" +
                ""+TAG_PHOTO+"='" + photo + '\'' +
                '}';
    }
}
