/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCTag;

public class ICCCurveType
extends ICCTag {
    private static final String eol = System.getProperty("line.separator");
    public final int type;
    public final int reserved;
    public final int nEntries;
    public final int[] entry;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[").append(super.toString()).append(" nentries = ").append(String.valueOf(this.nEntries)).append(", length = " + String.valueOf(this.entry.length) + " ... ");
        return stringBuffer.append("]").toString();
    }

    public static double CurveToDouble(int n) {
        return (double)n / 65535.0;
    }

    public static short DoubleToCurve(double d) {
        return (short)Math.floor(d * 65535.0 + 0.5);
    }

    public static double CurveGammaToDouble(int n) {
        return (double)n / 256.0;
    }

    protected ICCCurveType(int n, byte[] byArray, int n2, int n3) {
        super(n, byArray, n2, n2 + 8);
        this.type = ICCProfile.getInt(byArray, n2);
        this.reserved = ICCProfile.getInt(byArray, n2 + 4);
        this.nEntries = ICCProfile.getInt(byArray, n2 + 8);
        this.entry = new int[this.nEntries];
        for (int i = 0; i < this.nEntries; ++i) {
            this.entry[i] = ICCProfile.getShort(byArray, n2 + 12 + i * 2) & 0xFFFF;
        }
    }

    public final int entry(int n) {
        return this.entry[n];
    }
}

