/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import java.io.IOException;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.entropy.encoder.EBCOTLayer;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.Coord;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.ProgressWatch;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class EBCOTRateAllocator
extends PostCompRateAllocator {
    private static final boolean DO_TIMING = false;
    private long initTime;
    private long buildTime;
    private long writeTime;
    private CBlkRateDistStats[][][][][] cblks;
    private int[][][][][][] truncIdxs;
    private Coord[][][] numPrec;
    private EBCOTLayer[] layers;
    private static final double LOG2 = Math.log(2.0);
    private static final int RD_SUMMARY_OFF = 24;
    private static final int RD_SUMMARY_SIZE = 64;
    private static final float FLOAT_REL_PRECISION = 1.0E-4f;
    private static final float FLOAT_ABS_PRECISION = 1.0E-10f;
    private static final int MIN_AVG_PACKET_SZ = 32;
    private int[] RDSlopesRates;
    private PktEncoder pktEnc;
    private LayersInfo lyrSpec;
    private float maxSlope;
    private float minSlope;

    public EBCOTRateAllocator(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, LayersInfo layersInfo, CodestreamWriter codestreamWriter, EncoderSpecs encoderSpecs, ParameterList parameterList) {
        super(codedCBlkDataSrcEnc, layersInfo.getTotNumLayers(), codestreamWriter, encoderSpecs);
        Coord coord = null;
        this.lyrSpec = layersInfo;
        this.RDSlopesRates = new int[64];
        int n = codedCBlkDataSrcEnc.getNumTiles();
        int n2 = this.getNumComps();
        this.cblks = new CBlkRateDistStats[n][n2][][][];
        this.truncIdxs = new int[n][this.numLayers][n2][][][];
        Coord coord2 = null;
        Coord coord3 = null;
        int n3 = codedCBlkDataSrcEnc.getCbULX();
        int n4 = codedCBlkDataSrcEnc.getCbULY();
        codedCBlkDataSrcEnc.setTile(0, 0);
        for (int i = 0; i < n; ++i) {
            coord3 = codedCBlkDataSrcEnc.getNumTiles(coord3);
            coord2 = codedCBlkDataSrcEnc.getTile(coord2);
            int n5 = this.getImgULX();
            int n6 = this.getImgULY();
            int n7 = n5 + this.getImgWidth();
            int n8 = n6 + this.getImgHeight();
            int n9 = codedCBlkDataSrcEnc.getTilePartULX();
            int n10 = codedCBlkDataSrcEnc.getTilePartULY();
            int n11 = codedCBlkDataSrcEnc.getNomTileWidth();
            int n12 = codedCBlkDataSrcEnc.getNomTileHeight();
            int n13 = coord2.x == 0 ? n5 : n9 + coord2.x * n11;
            int n14 = coord2.y == 0 ? n6 : n10 + coord2.y * n12;
            int n15 = coord2.x != coord3.x - 1 ? n9 + (coord2.x + 1) * n11 : n7;
            int n16 = coord2.y != coord3.y - 1 ? n10 + (coord2.y + 1) * n12 : n8;
            for (int j = 0; j < n2; ++j) {
                int n17;
                SubbandAn subbandAn = codedCBlkDataSrcEnc.getAnSubbandTree(i, j);
                int n18 = subbandAn.resLvl + 1;
                if (this.numPrec == null) {
                    this.numPrec = new Coord[n][n2][];
                }
                if (this.numPrec[i][j] == null) {
                    this.numPrec[i][j] = new Coord[n18];
                }
                int n19 = codedCBlkDataSrcEnc.getCompSubsX(j);
                int n20 = codedCBlkDataSrcEnc.getCompSubsY(j);
                int n21 = (int)Math.ceil((double)n13 / (double)n19);
                int n22 = (int)Math.ceil((double)n14 / (double)n20);
                int n23 = (int)Math.ceil((double)n15 / (double)n19);
                int n24 = (int)Math.ceil((double)n16 / (double)n20);
                this.cblks[i][j] = new CBlkRateDistStats[n18][][];
                for (n17 = 0; n17 < this.numLayers; ++n17) {
                    this.truncIdxs[i][n17][j] = new int[n18][][];
                }
                for (int k = 0; k < n18; ++k) {
                    int n25 = (int)Math.ceil((double)n21 / (double)(1 << n18 - 1 - k));
                    int n26 = (int)Math.ceil((double)n22 / (double)(1 << n18 - 1 - k));
                    int n27 = (int)Math.ceil((double)n23 / (double)(1 << n18 - 1 - k));
                    int n28 = (int)Math.ceil((double)n24 / (double)(1 << n18 - 1 - k));
                    double d = encoderSpecs.pss.getPPX(i, j, k);
                    double d2 = encoderSpecs.pss.getPPY(i, j, k);
                    this.numPrec[i][j][k] = new Coord();
                    this.numPrec[i][j][k].x = n27 > n25 ? (int)Math.ceil((double)(n27 - n3) / d) - (int)Math.floor((double)(n25 - n3) / d) : 0;
                    this.numPrec[i][j][k].y = n28 > n26 ? (int)Math.ceil((double)(n28 - n4) / d2) - (int)Math.floor((double)(n26 - n4) / d2) : 0;
                    int n29 = k == 0 ? 0 : 1;
                    int n30 = k == 0 ? 1 : 4;
                    this.cblks[i][j][k] = new CBlkRateDistStats[n30][];
                    for (n17 = 0; n17 < this.numLayers; ++n17) {
                        this.truncIdxs[i][n17][j][k] = new int[n30][];
                    }
                    for (int i2 = n29; i2 < n30; ++i2) {
                        SubbandAn subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(k, i2);
                        coord = subbandAn2.numCb;
                        int n31 = coord.x * coord.y;
                        this.cblks[i][j][k][i2] = new CBlkRateDistStats[n31];
                        for (n17 = 0; n17 < this.numLayers; ++n17) {
                            this.truncIdxs[i][n17][j][k][i2] = new int[n31];
                            for (int i3 = 0; i3 < n31; ++i3) {
                                this.truncIdxs[i][n17][j][k][i2][i3] = -1;
                            }
                        }
                    }
                }
            }
            if (i == n - 1) continue;
            codedCBlkDataSrcEnc.nextTile();
        }
        this.pktEnc = new PktEncoder(codedCBlkDataSrcEnc, encoderSpecs, this.numPrec, parameterList);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void runAndWrite() throws IOException {
        this.buildAndWriteLayers();
    }

    public void initialize() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.src.getNumTiles();
        int n11 = this.src.getNumComps();
        long l = 0L;
        this.getAllCodeBlocks();
        int n12 = this.RDSlopesRates[0];
        for (n9 = 0; n9 < n10; ++n9) {
            int n13 = 2;
            if (((String)this.encSpec.sops.getTileDef(n9)).equalsIgnoreCase("on")) {
                n13 += 6;
            }
            if (((String)this.encSpec.ephs.getTileDef(n9)).equalsIgnoreCase("on")) {
                n13 += 2;
            }
            for (n8 = 0; n8 < n11; ++n8) {
                n7 = this.src.getAnSubbandTree((int)n9, (int)n8).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n8, n9)) {
                    n12 += this.numLayers * n13 * n7;
                    continue;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = this.numPrec[n9][n8][n6].x * this.numPrec[n9][n8][n6].y;
                    n12 += this.numLayers * n13 * n5;
                }
            }
        }
        int n14 = this.headEnc.getLength();
        float f = (float)(this.src.getImgWidth() * this.src.getImgHeight()) / 8.0f;
        for (n9 = 0; n9 < n10; ++n9) {
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(0, n9);
            n14 += this.headEnc.getLength();
        }
        this.layers = new EBCOTLayer[this.numLayers];
        for (n4 = this.numLayers - 1; n4 >= 0; --n4) {
            this.layers[n4] = new EBCOTLayer();
        }
        int n15 = 0;
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = 0; n8 < n11; ++n8) {
                n7 = this.src.getAnSubbandTree((int)n9, (int)n8).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n8, n9)) {
                    n15 += 32 * n7;
                    continue;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = this.numPrec[n9][n8][n6].x * this.numPrec[n9][n8][n6].y;
                    n15 += 32 * n5;
                }
            }
        }
        n4 = 0;
        int n16 = 0;
        int n17 = 0;
        while (n4 < this.numLayers - 1) {
            double d = Math.floor(this.lyrSpec.getTargetBitrate(n16) * f);
            if (n16 < this.lyrSpec.getNOptPoints() - 1) {
                n3 = (int)(this.lyrSpec.getTargetBitrate(n16 + 1) * f);
                if (n3 > n12) {
                    n3 = n12;
                }
            } else {
                n3 = 1;
            }
            int n18 = this.lyrSpec.getExtraLayers(n16) + 1;
            double d2 = Math.exp(Math.log((double)n3 / d) / (double)n18);
            this.layers[n4].optimize = true;
            for (int i = 0; i < n18; ++i) {
                n2 = (int)d - n17 - n14;
                if (n2 < n15) {
                    d *= d2;
                    --this.numLayers;
                    continue;
                }
                this.layers[n4].maxBytes = n17 = (int)d - n14;
                d *= d2;
                ++n4;
            }
            ++n16;
        }
        n4 = this.numLayers - 2;
        n3 = (int)(this.lyrSpec.getTotBitrate() * f) - n14;
        n2 = n3 - (n4 >= 0 ? this.layers[n4].maxBytes : 0);
        while (n2 < n15) {
            if (this.numLayers == 1) {
                if (n2 > 0) break;
                throw new IllegalArgumentException("Overall target bitrate too low, given the current bit stream header overhead");
            }
            --this.numLayers;
            n2 = n3 - (--n4 >= 0 ? this.layers[n4].maxBytes : 0);
        }
        this.layers[++n4].maxBytes = n3;
        this.layers[n4].optimize = true;
        Progression[] progressionArray = (Progression[])this.encSpec.pocs.getDefault();
        n6 = progressionArray.length;
        for (n = 0; n < progressionArray.length; ++n) {
            if (progressionArray[n].lye <= this.numLayers) continue;
            progressionArray[n].lye = this.numLayers;
        }
        if (n6 == 0) {
            throw new Error("Unable to initialize rate allocator: No default progression type has been defined.");
        }
        for (n = 0; n < n10; ++n) {
            if (!this.encSpec.pocs.isTileSpecified(n)) continue;
            progressionArray = (Progression[])this.encSpec.pocs.getTileDef(n);
            n6 = progressionArray.length;
            for (int i = 0; i < progressionArray.length; ++i) {
                if (progressionArray[i].lye <= this.numLayers) continue;
                progressionArray[i].lye = this.numLayers;
            }
            if (n6 != 0) continue;
            throw new Error("Unable to initialize rate allocator: No default progression type has been defined for tile " + n);
        }
    }

    private void getAllCodeBlocks() {
        CBlkRateDistStats cBlkRateDistStats = null;
        Coord coord = null;
        long l = 0L;
        this.maxSlope = 0.0f;
        this.minSlope = Float.MAX_VALUE;
        int n = this.src.getNumComps();
        int n2 = this.src.getNumTiles();
        int n3 = 0;
        int n4 = 0;
        ProgressWatch progressWatch = FacilityManager.getProgressWatch();
        this.src.setTile(0, 0);
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            n4 = 0;
            n3 = 0;
            for (n6 = 0; n6 < n; ++n6) {
                SubbandAn subbandAn = this.src.getAnSubbandTree(i, n6);
                for (n5 = 0; n5 <= subbandAn.resLvl; ++n5) {
                    SubbandAn subbandAn2;
                    if (n5 == 0) {
                        subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                        if (subbandAn2 == null) continue;
                        n3 += subbandAn2.numCb.x * subbandAn2.numCb.y;
                        continue;
                    }
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n5, 1);
                    if (subbandAn2 != null) {
                        n3 += subbandAn2.numCb.x * subbandAn2.numCb.y;
                    }
                    if ((subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n5, 2)) != null) {
                        n3 += subbandAn2.numCb.x * subbandAn2.numCb.y;
                    }
                    if ((subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n5, 3)) == null) continue;
                    n3 += subbandAn2.numCb.x * subbandAn2.numCb.y;
                }
            }
            if (progressWatch != null) {
                progressWatch.initProgressWatch(0, n3, "Encoding tile " + i + "...");
            }
            for (n6 = 0; n6 < n; ++n6) {
                while ((cBlkRateDistStats = this.src.getNextCodeBlock(n6, cBlkRateDistStats)) != null) {
                    if (progressWatch != null) {
                        progressWatch.updateProgressWatch(++n4, null);
                    }
                    SubbandAn subbandAn = cBlkRateDistStats.sb;
                    n5 = subbandAn.resLvl;
                    int n7 = subbandAn.sbandIdx;
                    coord = subbandAn.numCb;
                    int n8 = -1;
                    for (int j = cBlkRateDistStats.nVldTrunc - 1; j >= 0; --j) {
                        float f = cBlkRateDistStats.truncSlopes[j];
                        if (f > this.maxSlope) {
                            this.maxSlope = f;
                        }
                        if (f < this.minSlope) {
                            this.minSlope = f;
                        }
                        int n9 = EBCOTRateAllocator.getLimitedSIndexFromSlope(f);
                        while (n9 > n8) {
                            int n10 = n9--;
                            this.RDSlopesRates[n10] = this.RDSlopesRates[n10] + cBlkRateDistStats.truncRates[cBlkRateDistStats.truncIdxs[j]];
                        }
                        n8 = EBCOTRateAllocator.getLimitedSIndexFromSlope(f);
                    }
                    this.cblks[i][n6][n5][n7][cBlkRateDistStats.m * coord.x + cBlkRateDistStats.n] = cBlkRateDistStats;
                    cBlkRateDistStats = null;
                }
            }
            if (progressWatch != null) {
                progressWatch.terminateProgressWatch();
            }
            if (i >= n2 - 1) continue;
            this.src.nextTile();
        }
    }

    private void buildAndWriteLayers() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n6 = this.src.getNumComps();
        int n7 = this.src.getNumTiles();
        long l = 0L;
        float f = this.maxSlope;
        int[] nArray = new int[n7];
        int n8 = 0;
        for (int i = 0; i < this.numLayers; ++i) {
            int n9 = this.layers[i].maxBytes;
            if (this.layers[i].optimize) {
                f = this.optimizeBitstreamLayer(i, f, n9, n8);
            } else {
                if (i <= 0 || i >= this.numLayers - 1) {
                    throw new IllegalArgumentException("The first and the last layer thresholds must be optimized");
                }
                f = this.estimateLayerThreshold(n9, this.layers[i - 1]);
            }
            for (n4 = 0; n4 < n7; ++n4) {
                if (i == 0) {
                    this.headEnc.reset();
                    this.headEnc.encodeTilePartHeader(0, n4);
                    int n10 = n4;
                    nArray[n10] = nArray[n10] + this.headEnc.getLength();
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    boolean bl = ((String)this.encSpec.sops.getTileDef(n4)).equalsIgnoreCase("on");
                    boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n4)).equalsIgnoreCase("on");
                    SubbandAn subbandAn = this.src.getAnSubbandTree(n4, n3);
                    int n11 = subbandAn.resLvl + 1;
                    while (subbandAn.subb_LL != null) {
                        subbandAn = subbandAn.subb_LL;
                    }
                    for (n2 = 0; n2 < n11; ++n2) {
                        n5 = this.numPrec[n4][n3][n2].x * this.numPrec[n4][n3][n2].y;
                        for (n = 0; n < n5; ++n) {
                            this.findTruncIndices(i, n3, n2, n4, subbandAn, f, n);
                            bitOutputBuffer = this.pktEnc.encodePacket(i + 1, n3, n2, n4, this.cblks[n4][n3][n2], this.truncIdxs[n4][i][n3][n2], bitOutputBuffer, byArray, n);
                            if (!this.pktEnc.isPacketWritable()) continue;
                            int n12 = this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                            n8 += (n12 += this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen()));
                            int n13 = n4;
                            nArray[n13] = nArray[n13] + n12;
                        }
                        subbandAn = subbandAn.parent;
                    }
                }
            }
            this.layers[i].rdThreshold = f;
            this.layers[i].actualBytes = n8;
        }
        this.pktEnc.reset();
        int[] nArray2 = new int[n6];
        for (int i = 0; i < n7; ++i) {
            int n14;
            int[][] nArrayArray = new int[n6][];
            for (n14 = 0; n14 < n6; ++n14) {
                nArray2[n14] = this.src.getAnSubbandTree((int)i, (int)n14).resLvl;
                nArrayArray[n14] = new int[nArray2[n14] + 1];
            }
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(nArray[i], i);
            this.bsWriter.commitBitstreamHeader(this.headEnc);
            Progression[] progressionArray = (Progression[])this.encSpec.pocs.getTileDef(i);
            for (n14 = 0; n14 < progressionArray.length; ++n14) {
                int n15 = progressionArray[n14].lye;
                n4 = progressionArray[n14].cs;
                n3 = progressionArray[n14].ce;
                n2 = progressionArray[n14].rs;
                n = progressionArray[n14].re;
                switch (progressionArray[n14].type) {
                    case 1: {
                        this.writeResLyCompPos(i, n2, n, n4, n3, nArrayArray, n15);
                        break;
                    }
                    case 0: {
                        this.writeLyResCompPos(i, n2, n, n4, n3, nArrayArray, n15);
                        break;
                    }
                    case 3: {
                        this.writePosCompResLy(i, n2, n, n4, n3, nArrayArray, n15);
                        break;
                    }
                    case 4: {
                        this.writeCompPosResLy(i, n2, n, n4, n3, nArrayArray, n15);
                        break;
                    }
                    case 2: {
                        this.writeResPosCompLy(i, n2, n, n4, n3, nArrayArray, n15);
                        break;
                    }
                    default: {
                        throw new Error("Unsupported bit stream progression type");
                    }
                }
                for (int j = n4; j < n3; ++j) {
                    for (int k = n2; k < n; ++k) {
                        if (k > nArray2[j]) continue;
                        nArrayArray[j][k] = n15;
                    }
                }
            }
        }
    }

    public void writeResLyCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int n8 = this.src.getNumComps();
        int[] nArray2 = new int[n8];
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n9 = 0;
        int n10 = 0;
        for (n7 = 0; n7 < n8; ++n7) {
            nArray2[n7] = this.src.getAnSubbandTree((int)n, (int)n7).resLvl;
            if (nArray2[n7] <= n10) continue;
            n10 = nArray2[n7];
        }
        for (int i = n2; i < n3; ++i) {
            int n11;
            if (i > n10) continue;
            n7 = 100000;
            for (n11 = n4; n11 < n5; ++n11) {
                if (i >= nArray[n11].length || nArray[n11][i] >= n7) continue;
                n7 = nArray[n11][i];
            }
            for (n11 = n7; n11 < n6; ++n11) {
                for (int j = n4; j < n5; ++j) {
                    if (i >= nArray[j].length || n11 < nArray[j][i] || i > nArray2[j]) continue;
                    n9 = this.numPrec[n][j][i].x * this.numPrec[n][j][i].y;
                    for (int k = 0; k < n9; ++k) {
                        boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                        boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                        SubbandAn subbandAn = this.src.getAnSubbandTree(n, j);
                        for (int i2 = nArray2[j]; i2 > i; --i2) {
                            subbandAn = subbandAn.subb_LL;
                        }
                        float f = this.layers[n11].rdThreshold;
                        this.findTruncIndices(n11, j, i, n, subbandAn, f, k);
                        bitOutputBuffer = this.pktEnc.encodePacket(n11 + 1, j, i, n, this.cblks[n][j][i], this.truncIdxs[n][n11][j][i], bitOutputBuffer, byArray, k);
                        if (!this.pktEnc.isPacketWritable()) continue;
                        this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                        this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                    }
                }
            }
        }
    }

    public void writeLyResCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int n8;
        int n9 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n10 = 0;
        int n11 = 100000;
        for (n8 = n4; n8 < n5; ++n8) {
            for (n7 = 0; n7 < nArray.length; ++n7) {
                if (nArray[n8] == null || n7 >= nArray[n8].length || nArray[n8][n7] >= n11) continue;
                n11 = nArray[n8][n7];
            }
        }
        for (n8 = n11; n8 < n6; ++n8) {
            for (n7 = n2; n7 < n3; ++n7) {
                for (int i = n4; i < n5; ++i) {
                    int n12 = this.src.getAnSubbandTree((int)n, (int)i).resLvl;
                    if (n7 > n12 || n7 >= nArray[i].length || n8 < nArray[i][n7]) continue;
                    n10 = this.numPrec[n][i][n7].x * this.numPrec[n][i][n7].y;
                    for (int j = 0; j < n10; ++j) {
                        boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                        boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                        SubbandAn subbandAn = this.src.getAnSubbandTree(n, i);
                        for (int k = n12; k > n7; --k) {
                            subbandAn = subbandAn.subb_LL;
                        }
                        float f = this.layers[n8].rdThreshold;
                        this.findTruncIndices(n8, i, n7, n, subbandAn, f, j);
                        bitOutputBuffer = this.pktEnc.encodePacket(n8 + 1, i, n7, n, this.cblks[n][i][n7], this.truncIdxs[n][n8][i][n7], bitOutputBuffer, byArray, j);
                        if (!this.pktEnc.isPacketWritable()) continue;
                        this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                        this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                    }
                }
            }
        }
    }

    public void writePosCompResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int n8;
        PrecInfo precInfo;
        int n9;
        int n10;
        int n11;
        int n12 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Coord coord = this.src.getNumTiles(null);
        Coord coord2 = this.src.getTile(null);
        int n13 = this.src.getImgULX();
        int n14 = this.src.getImgULY();
        int n15 = n13 + this.src.getImgWidth();
        int n16 = n14 + this.src.getImgHeight();
        int n17 = this.src.getTilePartULX();
        int n18 = this.src.getTilePartULY();
        int n19 = this.src.getNomTileWidth();
        int n20 = this.src.getNomTileHeight();
        int n21 = coord2.x == 0 ? n13 : n17 + coord2.x * n19;
        int n22 = coord2.y == 0 ? n14 : n18 + coord2.y * n20;
        int n23 = coord2.x != coord.x - 1 ? n17 + (coord2.x + 1) * n19 : n15;
        int n24 = coord2.y != coord.y - 1 ? n18 + (coord2.y + 1) * n20 : n16;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int[][] nArrayArray = new int[n5][];
        int n28 = 100000;
        int n29 = n23;
        int n30 = n24;
        int n31 = n21;
        int n32 = n22;
        for (n11 = n4; n11 < n5; ++n11) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n11).resLvl;
            nArrayArray[n11] = new int[n10 + 1];
            for (n9 = n2; n9 < n3; ++n9) {
                if (n9 > n10) continue;
                if (n9 < nArray[n11].length && nArray[n11][n9] < n28) {
                    n28 = nArray[n11][n9];
                }
                for (int i = this.numPrec[n][n11][n9].y * this.numPrec[n][n11][n9].x - 1; i >= 0; --i) {
                    precInfo = this.pktEnc.getPrecInfo(n, n11, n9, i);
                    if (precInfo.rgulx != n21) {
                        if (precInfo.rgulx < n29) {
                            n29 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n31) {
                            n31 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n22) {
                        if (precInfo.rguly < n30) {
                            n30 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n32) {
                            n32 = precInfo.rguly;
                        }
                    }
                    if (n27 == 0) {
                        n25 = precInfo.rgw;
                        n26 = precInfo.rgh;
                    } else {
                        n25 = MathUtil.gcd(n25, precInfo.rgw);
                        n26 = MathUtil.gcd(n26, precInfo.rgh);
                    }
                    ++n27;
                }
            }
        }
        if (n27 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n11 = (n32 - n30) / n26 + 1;
        n9 = (n31 - n29) / n25 + 1;
        int n33 = n22;
        int n34 = n21;
        for (n8 = 0; n8 <= n11; ++n8) {
            for (n7 = 0; n7 <= n9; ++n7) {
                for (int i = n4; i < n5; ++i) {
                    n10 = this.src.getAnSubbandTree((int)n, (int)i).resLvl;
                    for (int j = n2; j < n3; ++j) {
                        if (j > n10 || nArrayArray[i][j] >= this.numPrec[n][i][j].x * this.numPrec[n][i][j].y) continue;
                        precInfo = this.pktEnc.getPrecInfo(n, i, j, nArrayArray[i][j]);
                        if (precInfo.rgulx != n34 || precInfo.rguly != n33) continue;
                        for (int k = n28; k < n6; ++k) {
                            if (j >= nArray[i].length || k < nArray[i][j]) continue;
                            boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                            boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                            SubbandAn subbandAn = this.src.getAnSubbandTree(n, i);
                            for (int i2 = n10; i2 > j; --i2) {
                                subbandAn = subbandAn.subb_LL;
                            }
                            float f = this.layers[k].rdThreshold;
                            this.findTruncIndices(k, i, j, n, subbandAn, f, nArrayArray[i][j]);
                            bitOutputBuffer = this.pktEnc.encodePacket(k + 1, i, j, n, this.cblks[n][i][j], this.truncIdxs[n][k][i][j], bitOutputBuffer, byArray, nArrayArray[i][j]);
                            if (!this.pktEnc.isPacketWritable()) continue;
                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                        }
                        int[] nArray2 = nArrayArray[i];
                        int n35 = j;
                        nArray2[n35] = nArray2[n35] + 1;
                    }
                }
                n34 = n7 != n9 ? n29 + n7 * n25 : n21;
            }
            n33 = n8 != n11 ? n30 + n8 * n26 : n22;
        }
        for (n8 = n4; n8 < n5; ++n8) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n8).resLvl;
            for (n7 = n2; n7 < n3; ++n7) {
                if (n7 > n10 || nArrayArray[n8][n7] >= this.numPrec[n][n8][n7].x * this.numPrec[n][n8][n7].y - 1) continue;
                throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n8 + " in tile " + n + ".");
            }
        }
    }

    public void writeCompPosResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int n8;
        PrecInfo precInfo;
        int n9;
        int n10;
        int n11;
        int n12 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Coord coord = this.src.getNumTiles(null);
        Coord coord2 = this.src.getTile(null);
        int n13 = this.src.getImgULX();
        int n14 = this.src.getImgULY();
        int n15 = n13 + this.src.getImgWidth();
        int n16 = n14 + this.src.getImgHeight();
        int n17 = this.src.getTilePartULX();
        int n18 = this.src.getTilePartULY();
        int n19 = this.src.getNomTileWidth();
        int n20 = this.src.getNomTileHeight();
        int n21 = coord2.x == 0 ? n13 : n17 + coord2.x * n19;
        int n22 = coord2.y == 0 ? n14 : n18 + coord2.y * n20;
        int n23 = coord2.x != coord.x - 1 ? n17 + (coord2.x + 1) * n19 : n15;
        int n24 = coord2.y != coord.y - 1 ? n18 + (coord2.y + 1) * n20 : n16;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int[][] nArrayArray = new int[n5][];
        int n28 = 100000;
        int n29 = n23;
        int n30 = n24;
        int n31 = n21;
        int n32 = n22;
        for (n11 = n4; n11 < n5; ++n11) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n11).resLvl;
            for (n9 = n2; n9 < n3; ++n9) {
                if (n9 > n10) continue;
                nArrayArray[n11] = new int[n10 + 1];
                if (n9 < nArray[n11].length && nArray[n11][n9] < n28) {
                    n28 = nArray[n11][n9];
                }
                for (int i = this.numPrec[n][n11][n9].y * this.numPrec[n][n11][n9].x - 1; i >= 0; --i) {
                    precInfo = this.pktEnc.getPrecInfo(n, n11, n9, i);
                    if (precInfo.rgulx != n21) {
                        if (precInfo.rgulx < n29) {
                            n29 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n31) {
                            n31 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n22) {
                        if (precInfo.rguly < n30) {
                            n30 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n32) {
                            n32 = precInfo.rguly;
                        }
                    }
                    if (n27 == 0) {
                        n25 = precInfo.rgw;
                        n26 = precInfo.rgh;
                    } else {
                        n25 = MathUtil.gcd(n25, precInfo.rgw);
                        n26 = MathUtil.gcd(n26, precInfo.rgh);
                    }
                    ++n27;
                }
            }
        }
        if (n27 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n11 = (n32 - n30) / n26 + 1;
        n9 = (n31 - n29) / n25 + 1;
        for (n8 = n4; n8 < n5; ++n8) {
            int n33 = n22;
            int n34 = n21;
            n10 = this.src.getAnSubbandTree((int)n, (int)n8).resLvl;
            for (n7 = 0; n7 <= n11; ++n7) {
                for (int i = 0; i <= n9; ++i) {
                    for (int j = n2; j < n3; ++j) {
                        if (j > n10 || nArrayArray[n8][j] >= this.numPrec[n][n8][j].x * this.numPrec[n][n8][j].y) continue;
                        precInfo = this.pktEnc.getPrecInfo(n, n8, j, nArrayArray[n8][j]);
                        if (precInfo.rgulx != n34 || precInfo.rguly != n33) continue;
                        for (int k = n28; k < n6; ++k) {
                            if (j >= nArray[n8].length || k < nArray[n8][j]) continue;
                            boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                            boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                            SubbandAn subbandAn = this.src.getAnSubbandTree(n, n8);
                            for (int i2 = n10; i2 > j; --i2) {
                                subbandAn = subbandAn.subb_LL;
                            }
                            float f = this.layers[k].rdThreshold;
                            this.findTruncIndices(k, n8, j, n, subbandAn, f, nArrayArray[n8][j]);
                            bitOutputBuffer = this.pktEnc.encodePacket(k + 1, n8, j, n, this.cblks[n][n8][j], this.truncIdxs[n][k][n8][j], bitOutputBuffer, byArray, nArrayArray[n8][j]);
                            if (!this.pktEnc.isPacketWritable()) continue;
                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                        }
                        int[] nArray2 = nArrayArray[n8];
                        int n35 = j;
                        nArray2[n35] = nArray2[n35] + 1;
                    }
                    n34 = i != n9 ? n29 + i * n25 : n21;
                }
                n33 = n7 != n11 ? n30 + n7 * n26 : n22;
            }
        }
        for (n8 = n4; n8 < n5; ++n8) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n8).resLvl;
            for (n7 = n2; n7 < n3; ++n7) {
                if (n7 > n10 || nArrayArray[n8][n7] >= this.numPrec[n][n8][n7].x * this.numPrec[n][n8][n7].y - 1) continue;
                throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n8 + " in tile " + n + ".");
            }
        }
    }

    public void writeResPosCompLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int n8;
        PrecInfo precInfo;
        int n9;
        int n10;
        int n11;
        int n12 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Coord coord = this.src.getNumTiles(null);
        Coord coord2 = this.src.getTile(null);
        int n13 = this.src.getImgULX();
        int n14 = this.src.getImgULY();
        int n15 = n13 + this.src.getImgWidth();
        int n16 = n14 + this.src.getImgHeight();
        int n17 = this.src.getTilePartULX();
        int n18 = this.src.getTilePartULY();
        int n19 = this.src.getNomTileWidth();
        int n20 = this.src.getNomTileHeight();
        int n21 = coord2.x == 0 ? n13 : n17 + coord2.x * n19;
        int n22 = coord2.y == 0 ? n14 : n18 + coord2.y * n20;
        int n23 = coord2.x != coord.x - 1 ? n17 + (coord2.x + 1) * n19 : n15;
        int n24 = coord2.y != coord.y - 1 ? n18 + (coord2.y + 1) * n20 : n16;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int[][] nArrayArray = new int[n5][];
        int n28 = 100000;
        int n29 = n23;
        int n30 = n24;
        int n31 = n21;
        int n32 = n22;
        for (n11 = n4; n11 < n5; ++n11) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n11).resLvl;
            nArrayArray[n11] = new int[n10 + 1];
            for (n9 = n2; n9 < n3; ++n9) {
                if (n9 > n10) continue;
                if (n9 < nArray[n11].length && nArray[n11][n9] < n28) {
                    n28 = nArray[n11][n9];
                }
                for (int i = this.numPrec[n][n11][n9].y * this.numPrec[n][n11][n9].x - 1; i >= 0; --i) {
                    precInfo = this.pktEnc.getPrecInfo(n, n11, n9, i);
                    if (precInfo.rgulx != n21) {
                        if (precInfo.rgulx < n29) {
                            n29 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n31) {
                            n31 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n22) {
                        if (precInfo.rguly < n30) {
                            n30 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n32) {
                            n32 = precInfo.rguly;
                        }
                    }
                    if (n27 == 0) {
                        n25 = precInfo.rgw;
                        n26 = precInfo.rgh;
                    } else {
                        n25 = MathUtil.gcd(n25, precInfo.rgw);
                        n26 = MathUtil.gcd(n26, precInfo.rgh);
                    }
                    ++n27;
                }
            }
        }
        if (n27 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n11 = (n32 - n30) / n26 + 1;
        n9 = (n31 - n29) / n25 + 1;
        for (n8 = n2; n8 < n3; ++n8) {
            int n33 = n22;
            int n34 = n21;
            for (n7 = 0; n7 <= n11; ++n7) {
                for (int i = 0; i <= n9; ++i) {
                    for (int j = n4; j < n5; ++j) {
                        n10 = this.src.getAnSubbandTree((int)n, (int)j).resLvl;
                        if (n8 > n10 || nArrayArray[j][n8] >= this.numPrec[n][j][n8].x * this.numPrec[n][j][n8].y) continue;
                        precInfo = this.pktEnc.getPrecInfo(n, j, n8, nArrayArray[j][n8]);
                        if (precInfo.rgulx != n34 || precInfo.rguly != n33) continue;
                        for (int k = n28; k < n6; ++k) {
                            if (n8 >= nArray[j].length || k < nArray[j][n8]) continue;
                            boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                            boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                            SubbandAn subbandAn = this.src.getAnSubbandTree(n, j);
                            for (int i2 = n10; i2 > n8; --i2) {
                                subbandAn = subbandAn.subb_LL;
                            }
                            float f = this.layers[k].rdThreshold;
                            this.findTruncIndices(k, j, n8, n, subbandAn, f, nArrayArray[j][n8]);
                            bitOutputBuffer = this.pktEnc.encodePacket(k + 1, j, n8, n, this.cblks[n][j][n8], this.truncIdxs[n][k][j][n8], bitOutputBuffer, byArray, nArrayArray[j][n8]);
                            if (!this.pktEnc.isPacketWritable()) continue;
                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                        }
                        int[] nArray2 = nArrayArray[j];
                        int n35 = n8;
                        nArray2[n35] = nArray2[n35] + 1;
                    }
                    n34 = i != n9 ? n29 + i * n25 : n21;
                }
                n33 = n7 != n11 ? n30 + n7 * n26 : n22;
            }
        }
        for (n8 = n4; n8 < n5; ++n8) {
            n10 = this.src.getAnSubbandTree((int)n, (int)n8).resLvl;
            for (n7 = n2; n7 < n3; ++n7) {
                if (n7 > n10 || nArrayArray[n8][n7] >= this.numPrec[n][n8][n7].x * this.numPrec[n][n8][n7].y - 1) continue;
                throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n8 + " in tile " + n + ".");
            }
        }
    }

    private float optimizeBitstreamLayer(int n, float f, int n2, int n3) throws IOException {
        float f2;
        int n4;
        this.pktEnc.save();
        int n5 = this.src.getNumTiles();
        int n6 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        for (n4 = 63; n4 > 0 && this.RDSlopesRates[n4] < n2; --n4) {
        }
        float f3 = EBCOTRateAllocator.getSlopeFromSIndex(n4);
        if (f3 >= f) {
            f3 = EBCOTRateAllocator.getSlopeFromSIndex(--n4);
        }
        if (n4 <= 0) {
            f3 = 0.0f;
        }
        if ((f2 = (f + f3) / 2.0f) <= f3) {
            f2 = f;
        }
        do {
            int n7 = n3;
            this.src.setTile(0, 0);
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    boolean bl = ((String)this.encSpec.sops.getTileDef(i)).equalsIgnoreCase("on");
                    boolean bl2 = ((String)this.encSpec.ephs.getTileDef(i)).equalsIgnoreCase("on");
                    SubbandAn subbandAn = this.src.getAnSubbandTree(i, j);
                    int n8 = subbandAn.resLvl + 1;
                    subbandAn = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                    for (int k = 0; k < n8; ++k) {
                        int n9 = this.numPrec[i][j][k].x * this.numPrec[i][j][k].y;
                        for (int i2 = 0; i2 < n9; ++i2) {
                            this.findTruncIndices(n, j, k, i, subbandAn, f2, i2);
                            bitOutputBuffer = this.pktEnc.encodePacket(n + 1, j, k, i, this.cblks[i][j][k], this.truncIdxs[i][n][j][k], bitOutputBuffer, byArray, i2);
                            if (!this.pktEnc.isPacketWritable()) continue;
                            byArray = this.pktEnc.getLastBodyBuf();
                            n7 += this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                            n7 += this.bsWriter.writePacketBody(byArray, this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                        }
                        subbandAn = subbandAn.parent;
                    }
                }
            }
            if (n7 > n2) {
                f3 = f2;
            } else {
                f = f2;
            }
            f2 = (f + f3) / 2.0f;
            if (f2 <= f3) {
                f2 = f;
            }
            this.pktEnc.restore();
        } while (f2 < f * 0.9999f && f2 < f - 1.0E-10f);
        f2 = f2 <= 1.0E-10f ? 0.0f : f;
        return f2;
    }

    private float estimateLayerThreshold(int n, EBCOTLayer eBCOTLayer) {
        float f;
        float f2;
        float f3;
        float f4 = eBCOTLayer.rdThreshold;
        if (f4 > this.maxSlope) {
            f4 = this.maxSlope;
        }
        if (f4 < 1.0E-10f) {
            return 0.0f;
        }
        int n2 = EBCOTRateAllocator.getLimitedSIndexFromSlope(f4);
        if (n2 >= 63) {
            n2 = 62;
        }
        if (this.RDSlopesRates[n2 + 1] == 0) {
            f3 = (float)Math.log((this.RDSlopesRates[n2] << 1) + 1);
            f2 = (float)Math.log(this.RDSlopesRates[n2] + 1);
            f = (float)Math.log(eBCOTLayer.actualBytes + this.RDSlopesRates[n2] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 + 1]);
            f = (float)Math.log(eBCOTLayer.actualBytes);
        }
        float f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        float f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 + 1));
        float f7 = (float)Math.log(f4);
        float f8 = f3 + (f7 - f5) * (f3 - f2) / (f5 - f6);
        float f9 = f - f8;
        if (f9 < 0.0f) {
            f9 = 0.0f;
        }
        int n3 = (int)((float)n / (float)Math.exp(f9));
        for (n2 = 63; n2 >= 0 && this.RDSlopesRates[n2] < n3; --n2) {
        }
        if (++n2 >= 64) {
            n2 = 63;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.RDSlopesRates[n2] == 0) {
            f3 = (float)Math.log(this.RDSlopesRates[n2 - 1] + 1);
            f2 = (float)Math.log((this.RDSlopesRates[n2 - 1] << 1) + 1);
            f8 = (float)Math.log(n3 + this.RDSlopesRates[n2 - 1] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 - 1]);
            f8 = (float)Math.log(n3);
        }
        f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 - 1));
        f7 = f5 + (f8 - f3) * (f5 - f6) / (f3 - f2);
        float f10 = (float)Math.exp(f7);
        if (f10 > f4) {
            f10 = f4;
        }
        if (f10 < 1.0E-10f) {
            f10 = 0.0f;
        }
        return f10;
    }

    private void findTruncIndices(int n, int n2, int n3, int n4, SubbandAn subbandAn, float f, int n5) {
        Object var13_8 = null;
        PrecInfo precInfo = this.pktEnc.getPrecInfo(n4, n2, n3, n5);
        SubbandAn subbandAn2 = subbandAn;
        while (subbandAn2.subb_HH != null) {
            subbandAn2 = subbandAn2.subb_HH;
        }
        int n6 = n3 == 0 ? 0 : 1;
        int n7 = n3 == 0 ? 1 : 4;
        subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, n6);
        for (int i = n6; i < n7; ++i) {
            int n8 = precInfo.cblk[i] != null ? precInfo.cblk[i].length : 0;
            for (int j = 0; j < n8; ++j) {
                int n9 = precInfo.cblk[i][j] != null ? precInfo.cblk[i][j].length : 0;
                for (int k = 0; k < n9; ++k) {
                    int n10;
                    Coord coord = precInfo.cblk[i][j][k].idx;
                    int n11 = coord.x + coord.y * subbandAn2.numCb.x;
                    CBlkRateDistStats cBlkRateDistStats = this.cblks[n4][n2][n3][i][n11];
                    for (n10 = 0; n10 < cBlkRateDistStats.nVldTrunc && !(cBlkRateDistStats.truncSlopes[n10] < f); ++n10) {
                    }
                    this.truncIdxs[n4][n][n2][n3][i][n11] = n10 - 1;
                }
            }
            subbandAn2 = (SubbandAn)subbandAn2.nextSubband();
        }
    }

    private static int getLimitedSIndexFromSlope(float f) {
        int n = (int)Math.floor(Math.log(f) / LOG2) + 24;
        if (n < 0) {
            return 0;
        }
        if (n >= 64) {
            return 63;
        }
        return n;
    }

    private static float getSlopeFromSIndex(int n) {
        return (float)Math.pow(2.0, n - 24);
    }
}

