/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.fileformat.reader;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.fileformat.FileFormatBoxes;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.FacilityManager;

public class FileFormatReader
implements FileFormatBoxes {
    private RandomAccessIO in;
    private Vector codeStreamPos;
    private Vector codeStreamLength;
    public boolean JP2FFUsed;

    public FileFormatReader(RandomAccessIO randomAccessIO) {
        this.in = randomAccessIO;
    }

    public void readFileFormat() throws IOException, EOFException {
        boolean bl = false;
        long l = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (this.in.readInt() != 12 || this.in.readInt() != 1783636000 || this.in.readInt() != 218793738) {
                this.in.seek(0);
                short s = this.in.readShort();
                if (s != -177) {
                    throw new Error("File is neither valid JP2 file nor valid JPEG 2000 codestream");
                }
                this.JP2FFUsed = false;
                this.in.seek(0);
                return;
            }
            this.JP2FFUsed = true;
            if (!this.readFileTypeBox()) {
                throw new Error("Invalid JP2 file: File Type box missing");
            }
            while (!bl3) {
                int n;
                int n2 = this.in.getPos();
                if (n2 + (n = this.in.readInt()) == this.in.length()) {
                    bl3 = true;
                }
                int n3 = this.in.readInt();
                if (n == 0) {
                    bl3 = true;
                    n = this.in.length() - this.in.getPos();
                } else {
                    if (n == 1) {
                        l = this.in.readLong();
                        throw new IOException("File too long.");
                    }
                    l = 0L;
                }
                switch (n3) {
                    case 1785737827: {
                        if (!bl2) {
                            throw new Error("Invalid JP2 file: JP2Header box not found before Contiguous codestream box ");
                        }
                        this.readContiguousCodeStreamBox(n2, n, l);
                        break;
                    }
                    case 1785737832: {
                        if (bl2) {
                            throw new Error("Invalid JP2 file: Multiple JP2Header boxes found");
                        }
                        this.readJP2HeaderBox(n2, n, l);
                        bl2 = true;
                        break;
                    }
                    case 1685074537: {
                        this.readIntPropertyBox(n);
                        break;
                    }
                    case 2020437024: {
                        this.readXMLBox(n);
                        break;
                    }
                    case 1970628964: {
                        this.readUUIDBox(n);
                        break;
                    }
                    case 1969843814: {
                        this.readUUIDInfoBox(n);
                        break;
                    }
                    default: {
                        FacilityManager.getMsgLogger().printmsg(2, "Unknown box-type: 0x" + Integer.toHexString(n3));
                    }
                }
                if (bl3) continue;
                this.in.seek(n2 + n);
            }
        }
        catch (EOFException eOFException) {
            throw new Error("EOF reached before finding Contiguous Codestream Box");
        }
        if (this.codeStreamPos.size() == 0) {
            throw new Error("Invalid JP2 file: Contiguous codestream box missing");
        }
    }

    public boolean readFileTypeBox() throws IOException, EOFException {
        int n;
        long l = 0L;
        boolean bl = false;
        int n2 = this.in.getPos();
        int n3 = this.in.readInt();
        if (n3 == 0) {
            throw new Error("Zero-length of Profile Box");
        }
        if (this.in.readInt() != 1718909296) {
            return false;
        }
        if (n3 == 1) {
            l = this.in.readLong();
            throw new IOException("File too long.");
        }
        this.in.readInt();
        this.in.readInt();
        for (int i = n = (n3 - 16) / 4; i > 0; --i) {
            if (this.in.readInt() != 1785737760) continue;
            bl = true;
        }
        return bl;
    }

    public boolean readJP2HeaderBox(long l, int n, long l2) throws IOException, EOFException {
        if (n == 0) {
            throw new Error("Zero-length of JP2Header Box");
        }
        return true;
    }

    public boolean readContiguousCodeStreamBox(long l, int n, long l2) throws IOException, EOFException {
        int n2 = this.in.getPos();
        if (this.codeStreamPos == null) {
            this.codeStreamPos = new Vector();
        }
        this.codeStreamPos.addElement(new Integer(n2));
        if (this.codeStreamLength == null) {
            this.codeStreamLength = new Vector();
        }
        this.codeStreamLength.addElement(new Integer(n));
        return true;
    }

    public void readIntPropertyBox(int n) {
    }

    public void readXMLBox(int n) {
    }

    public void readUUIDBox(int n) {
    }

    public void readUUIDInfoBox(int n) {
    }

    public long[] getCodeStreamPos() {
        int n = this.codeStreamPos.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = ((Integer)this.codeStreamPos.elementAt(i)).longValue();
        }
        return lArray;
    }

    public int getFirstCodeStreamPos() {
        return (Integer)this.codeStreamPos.elementAt(0);
    }

    public int getFirstCodeStreamLength() {
        return (Integer)this.codeStreamLength.elementAt(0);
    }
}

