/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import java.util.StringTokenizer;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.ForwWT;
import jj2000.j2k.wavelet.analysis.ForwWTFull;

public abstract class ForwardWT
extends ImgDataAdapter
implements ForwWT,
CBlkWTDataSrc {
    public static final int WT_DECOMP_DYADIC = 0;
    public static final char OPT_PREFIX = 'W';
    private static final String[][] pinfo = new String[][]{{"Wlev", "<number of decomposition levels>", "Specifies the number of wavelet decomposition levels to apply to the image. If 0 no wavelet transform is performed. All components and all tiles have the same number of decomposition levels.", "5"}, {"Wwt", "[full]", "Specifies the wavelet transform to be used. Possible value is: 'full' (full page). The value 'full' performs a normal DWT.", "full"}, {"Wcboff", "<x y>", "Code-blocks partition offset in the reference grid. Allowed for <x> and <y> are 0 and 1.\nNote: This option is defined in JPEG 2000 part 2 and may not be supported by all JPEG 2000 decoders.", "0 0"}};

    protected ForwardWT(ImgData imgData) {
        super(imgData);
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static ForwardWT createInstance(BlkImgDataSrc blkImgDataSrc, ParameterList parameterList, EncoderSpecs encoderSpecs) {
        parameterList.checkList('W', ParameterList.toNameArray(pinfo));
        int n = (Integer)encoderSpecs.dls.getDefault();
        String string = "";
        if (parameterList.getParameter("Wcboff") == null) {
            throw new Error("You must specify an argument to the '-Wcboff' option. See usage with the '-u' option");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(parameterList.getParameter("Wcboff"));
        if (stringTokenizer.countTokens() != 2) {
            throw new IllegalArgumentException("'-Wcboff' option needs two arguments. See usage with the '-u' option.");
        }
        int n2 = 0;
        string = stringTokenizer.nextToken();
        try {
            n2 = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad first parameter for the '-Wcboff' option: " + string);
        }
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("Invalid horizontal code-block partition origin.");
        }
        int n3 = 0;
        string = stringTokenizer.nextToken();
        try {
            n3 = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad second parameter for the '-Wcboff' option: " + string);
        }
        if (n3 < 0 || n3 > 1) {
            throw new IllegalArgumentException("Invalid vertical code-block partition origin.");
        }
        if (n2 != 0 || n3 != 0) {
            FacilityManager.getMsgLogger().printmsg(2, "Code-blocks partition origin is different from (0,0). This is defined in JPEG 2000 part 2 and may be not supported by all JPEG 2000 decoders.");
        }
        return new ForwWTFull(blkImgDataSrc, encoderSpecs, n2, n3);
    }
}

