/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.jj2000;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jj2000.j2k.fileformat.FileFormatBoxes;

class MyFileFormatWriter
implements FileFormatBoxes {
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private int height;
    private int width;
    private int nc;
    private int[] bpc;
    private boolean bpcVaries;
    private int clength;
    private static final int CSB_LENGTH = 15;
    private static final int FTB_LENGTH = 20;
    private static final int IHB_LENGTH = 22;
    private static final int BPC_LENGTH = 8;

    public MyFileFormatWriter(InputStream inputStream, OutputStream outputStream, int height, int width, int nc, int[] bpc, int clength) {
        this.height = height;
        this.width = width;
        this.nc = nc;
        this.bpc = bpc;
        this.clength = clength;
        this.dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.bpcVaries = false;
        int fixbpc = bpc[0];
        int i = nc - 1;
        while (i > 0) {
            if (bpc[i] != fixbpc) {
                this.bpcVaries = true;
            }
            --i;
        }
    }

    public int writeFileFormat() throws IOException {
        byte[] codestream = new byte[this.clength];
        this.dataInputStream.readFully(codestream, 0, this.clength);
        try {
            this.dataOutputStream.writeInt(12);
            this.dataOutputStream.writeInt(1783636000);
            this.dataOutputStream.writeInt(218793738);
            this.writeFileTypeBox();
            this.writeJP2HeaderBox();
            this.writeContiguousCodeStreamBox(codestream);
            this.dataOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Error while writing JP2 file format " + e.getMessage());
        }
        if (this.bpcVaries) {
            return 85 + this.nc + 8;
        }
        return 85;
    }

    public void writeFileTypeBox() throws IOException {
        this.dataOutputStream.writeInt(20);
        this.dataOutputStream.writeInt(1718909296);
        this.dataOutputStream.writeInt(1785737760);
        this.dataOutputStream.writeInt(0);
        this.dataOutputStream.writeInt(1785737760);
    }

    public void writeJP2HeaderBox() throws IOException {
        if (this.bpcVaries) {
            this.dataOutputStream.writeInt(53 + this.nc);
        } else {
            this.dataOutputStream.writeInt(45);
        }
        this.dataOutputStream.writeInt(1785737832);
        this.writeImageHeaderBox();
        this.writeColourSpecificationBox();
        if (this.bpcVaries) {
            this.writeBitsPerComponentBox();
        }
    }

    public void writeBitsPerComponentBox() throws IOException {
        this.dataOutputStream.writeInt(8 + this.nc);
        this.dataOutputStream.writeInt(1651532643);
        int i = 0;
        while (i < this.nc) {
            this.dataOutputStream.writeByte(this.bpc[i] - 1);
            ++i;
        }
    }

    public void writeColourSpecificationBox() throws IOException {
        this.dataOutputStream.writeInt(15);
        this.dataOutputStream.writeInt(1668246642);
        this.dataOutputStream.writeByte(1);
        this.dataOutputStream.writeByte(0);
        this.dataOutputStream.writeByte(0);
        if (this.nc > 1) {
            this.dataOutputStream.writeInt(16);
        } else {
            this.dataOutputStream.writeInt(17);
        }
    }

    public void writeImageHeaderBox() throws IOException {
        this.dataOutputStream.writeInt(22);
        this.dataOutputStream.writeInt(1768449138);
        this.dataOutputStream.writeInt(this.height);
        this.dataOutputStream.writeInt(this.width);
        this.dataOutputStream.writeShort(this.nc);
        if (this.bpcVaries) {
            this.dataOutputStream.writeByte(255);
        } else {
            this.dataOutputStream.writeByte(this.bpc[0] - 1);
        }
        this.dataOutputStream.writeByte(7);
        this.dataOutputStream.writeByte(1);
        this.dataOutputStream.writeByte(0);
    }

    public void writeContiguousCodeStreamBox(byte[] cs) throws IOException {
        this.dataOutputStream.writeInt(this.clength + 8);
        this.dataOutputStream.writeInt(1785737827);
        int i = 0;
        while (i < this.clength) {
            this.dataOutputStream.writeByte(cs[i]);
            ++i;
        }
    }
}

