/*
 * Decompiled with CFR 0.152.
 */
package nashid.mv.liveness;

import android.content.res.AssetManager;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.mv.engine.FaceBoxes;
import nashid.mv.engine.FaceDetectors;
import nashid.mv.engine.Lives;
import nashid.mv.liveness.DetectionResults;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnashid/mv/liveness/EngineWrappers;", "", "assetManager", "Landroid/content/res/AssetManager;", "(Landroid/content/res/AssetManager;)V", "faceDetectors", "Lnashid/mv/engine/FaceDetectors;", "lives", "Lnashid/mv/engine/Lives;", "destroy", "", "detect", "Lnashid/mv/liveness/DetectionResults;", "yuv", "", "width", "", "height", "orientation", "detectFace", "", "Lnashid/mv/engine/FaceBoxes;", "detectLive", "", "faceBoxes", "init", "", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class EngineWrappers {
    @NotNull
    private AssetManager assetManager;
    @NotNull
    private FaceDetectors faceDetectors;
    @NotNull
    private Lives lives;
    public static final int $stable = 8;

    public EngineWrappers(@NotNull AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        this.assetManager = assetManager;
        this.faceDetectors = new FaceDetectors();
        this.lives = new Lives();
    }

    public final boolean init() {
        int ret = this.faceDetectors.loadModel(this.assetManager);
        if (ret == 0) {
            ret = this.lives.loadModel(this.assetManager);
            return ret == 0;
        }
        return false;
    }

    public final void destroy() {
        this.faceDetectors.destroy();
        this.lives.destroy();
    }

    @NotNull
    public final DetectionResults detect(@NotNull byte[] yuv, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)yuv, (String)"yuv");
        List<FaceBoxes> boxes = this.detectFace(yuv, width, height, orientation);
        Log.d((String)"TAG", (String)("detectAndCropFace:box " + boxes));
        if (!((Collection)boxes).isEmpty()) {
            FaceBoxes faceBoxes;
            long begin = System.currentTimeMillis();
            FaceBoxes $this$detect_u24lambda_u240 = faceBoxes = boxes.get(0);
            boolean bl = false;
            float c = this.detectLive(yuv, width, height, orientation, $this$detect_u24lambda_u240);
            $this$detect_u24lambda_u240.setConfidence(c);
            FaceBoxes box = faceBoxes;
            long end = System.currentTimeMillis();
            return new DetectionResults(box, end - begin, true);
        }
        return new DetectionResults();
    }

    private final List<FaceBoxes> detectFace(byte[] yuv, int width, int height, int orientation) {
        return this.faceDetectors.detect(yuv, width, height, orientation);
    }

    private final float detectLive(byte[] yuv, int width, int height, int orientation, FaceBoxes faceBoxes) {
        return this.lives.detect(yuv, width, height, orientation, faceBoxes);
    }
}

