/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk;

import android.content.Context;
import android.content.Intent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Observer;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import nashid.verify.sdk.model.AuthCallback;
import nashid.verify.sdk.model.AuthData;
import nashid.verify.sdk.model.AuthResponse;
import nashid.verify.sdk.model.DocumentType;
import nashid.verify.sdk.model.DocumentVerification;
import nashid.verify.sdk.model.ExtraData;
import nashid.verify.sdk.model.SDKConfig;
import nashid.verify.sdk.model.SDKStatus;
import nashid.verify.sdk.request.AuthRequest;
import nashid.verify.sdk.ui.MainScreen;
import nashid.verify.sdk.utils.KoinEnvironment;
import nashid.verify.sdk.utils.Loggers;
import nashid.verify.sdk.utils.NetWorkResult;
import nashid.verify.sdk.utils.SdkConfig;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.LocaleUtil;
import nashid.verify.sdk.utils.helpers.ScanDocumentResult;
import nashid.verify.sdk.utils.helpers.Storage;
import nashid.verify.sdk.utils.helpers.VerificationHandler;
import nashid.verify.sdk.viewmodel.AuthViewModel;
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel;
import nashid.verify.sdk.viewmodel.SkipNfcLiveNessViewModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001e0\"J4\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\b\b\u0002\u0010'\u001a\u00020 2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010!\u001a\u00020*J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J$\u0010.\u001a\u00020\u001e2\b\b\u0002\u0010/\u001a\u0002002\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u001e0\"R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\t\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\t\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lnashid/verify/sdk/VerifySDKManager;", "Lorg/koin/core/component/KoinComponent;", "Lnashid/verify/sdk/utils/helpers/VerificationHandler;", "()V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context$delegate", "Lkotlin/Lazy;", "logger", "Lnashid/verify/sdk/utils/Loggers$LoggerInstance;", "scanDocumentViewModel", "Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "getScanDocumentViewModel", "()Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "scanDocumentViewModel$delegate", "skipNfcLiveNessViewModel", "Lnashid/verify/sdk/viewmodel/SkipNfcLiveNessViewModel;", "getSkipNfcLiveNessViewModel", "()Lnashid/verify/sdk/viewmodel/SkipNfcLiveNessViewModel;", "skipNfcLiveNessViewModel$delegate", "viewModel", "Lnashid/verify/sdk/viewmodel/AuthViewModel;", "getViewModel", "()Lnashid/verify/sdk/viewmodel/AuthViewModel;", "viewModel$delegate", "getKoin", "Lorg/koin/core/Koin;", "getVerificationResult", "", "verificationId", "", "callback", "Lkotlin/Function1;", "Lnashid/verify/sdk/utils/helpers/ScanDocumentResult$GetScanResultResponse;", "initialize", "sdkKey", "sdkSecret", "languageType", "extraData", "Lnashid/verify/sdk/model/ExtraData;", "Lnashid/verify/sdk/model/AuthCallback;", "submitVerification", "verification", "Lnashid/verify/sdk/model/DocumentVerification;", "verify", "documentType", "Lnashid/verify/sdk/model/DocumentType;", "Lnashid/verify/sdk/utils/helpers/ScanDocumentResult$ScanDocumentResponse;", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVerifySDKManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifySDKManager.kt\nnashid/verify/sdk/VerifySDKManager\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,163:1\n58#2,6:164\n58#2,6:170\n58#2,6:176\n58#2,6:182\n*S KotlinDebug\n*F\n+ 1 VerifySDKManager.kt\nnashid/verify/sdk/VerifySDKManager\n*L\n36#1:164,6\n37#1:170,6\n38#1:176,6\n39#1:182,6\n*E\n"})
public final class VerifySDKManager
implements KoinComponent,
VerificationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy scanDocumentViewModel$delegate;
    @NotNull
    private final Lazy skipNfcLiveNessViewModel$delegate;
    @NotNull
    private final Lazy context$delegate;
    @NotNull
    private final Loggers.LoggerInstance logger;
    public static final int $stable = 8;
    @Nullable
    private static volatile VerifySDKManager instance;

    public VerifySDKManager() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.viewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AuthViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AuthViewModel invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(AuthViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(AuthViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.scanDocumentViewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ScanDocumentViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ScanDocumentViewModel invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ScanDocumentViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ScanDocumentViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.skipNfcLiveNessViewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<SkipNfcLiveNessViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SkipNfcLiveNessViewModel invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(SkipNfcLiveNessViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(SkipNfcLiveNessViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.context$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<Context>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Context invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Context.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Context.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.logger = Loggers.INSTANCE.withTag("VerifySDKManager");
    }

    @NotNull
    public Koin getKoin() {
        if (KoinEnvironment.INSTANCE.getKoin() == null) {
            throw new IllegalStateException("Koin has not been initialized. Make sure MyEnvironment.initKoin(context) is called before using VerifySDKManager.");
        }
        Koin koin = KoinEnvironment.INSTANCE.getKoin();
        Intrinsics.checkNotNull((Object)koin);
        return koin;
    }

    private final AuthViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (AuthViewModel)((Object)lazy.getValue());
    }

    private final ScanDocumentViewModel getScanDocumentViewModel() {
        Lazy lazy = this.scanDocumentViewModel$delegate;
        return (ScanDocumentViewModel)((Object)lazy.getValue());
    }

    private final SkipNfcLiveNessViewModel getSkipNfcLiveNessViewModel() {
        Lazy lazy = this.skipNfcLiveNessViewModel$delegate;
        return (SkipNfcLiveNessViewModel)((Object)lazy.getValue());
    }

    private final Context getContext() {
        Lazy lazy = this.context$delegate;
        return (Context)lazy.getValue();
    }

    public final void initialize(@NotNull String sdkKey, @NotNull String sdkSecret, @NotNull String languageType, @Nullable ExtraData extraData, @NotNull AuthCallback callback) {
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)sdkSecret, (String)"sdkSecret");
        Intrinsics.checkNotNullParameter((Object)languageType, (String)"languageType");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.logger.log("Starting initialization with SDK Keys");
        Function1 function1 = (Function1)new Function1<NetWorkResult<AuthResponse>, Unit>(this, callback, languageType, extraData){
            final /* synthetic */ VerifySDKManager this$0;
            final /* synthetic */ AuthCallback $callback;
            final /* synthetic */ String $languageType;
            final /* synthetic */ ExtraData $extraData;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$languageType = $languageType;
                this.$extraData = $extraData;
                super(1);
            }

            public final void invoke(NetWorkResult<AuthResponse> result2) {
                NetWorkResult<AuthResponse> netWorkResult = result2;
                if (netWorkResult instanceof NetWorkResult.Success) {
                    AuthResponse authResponse = result2.getData();
                    VerifySDKManager.access$getLogger$p(this.this$0).log("SDK initialization successful: " + (authResponse != null ? authResponse.toString() : null));
                    AuthResponse authResponse2 = result2.getData();
                    this.$callback.initializeResponse(true, authResponse2 != null ? authResponse2.getMessage() : null);
                    Object object = result2.getData();
                    if (object != null && (object = ((AuthResponse)object).getData()) != null && (object = ((AuthData)object).getSdkConfig()) != null) {
                        Object object2 = object;
                        String string2 = this.$languageType;
                        ExtraData extraData = this.$extraData;
                        Object sdkConfig = object2;
                        boolean bl = false;
                        Integer n = ((SDKConfig)sdkConfig).getNfcMaximumRetries();
                        SdkConfig.INSTANCE.updateConfig(((SDKConfig)sdkConfig).getSandboxSdkKey(), ((SDKConfig)sdkConfig).getSandboxSdkSecret(), string2, ((SDKConfig)sdkConfig).getName(), ((SDKConfig)sdkConfig).getDescription(), ((SDKConfig)sdkConfig).isNfcScanningEnabled(), ((SDKConfig)sdkConfig).isNfcMultiTriesEnabled(), ((SDKConfig)sdkConfig).isFaceMatchingEnabled(), ((SDKConfig)sdkConfig).isOcrEnabled(), ((SDKConfig)sdkConfig).isMrzEnabled(), ((SDKConfig)sdkConfig).getCallbackProtocol(), ((SDKConfig)sdkConfig).getCallbackHost(), ((SDKConfig)sdkConfig).getShowInstructions(), ((SDKConfig)sdkConfig).isNfcSkippable(), n != null ? n : 0, extraData);
                    }
                } else if (netWorkResult instanceof NetWorkResult.Error) {
                    VerifySDKManager.access$getLogger$p(this.this$0).log("Initialization failed: " + result2.getMessage());
                    SdkConfig.INSTANCE.setSdkStatus(SDKStatus.FAILED);
                    this.$callback.initializeResponse(false, result2.getMessage());
                }
            }
        };
        this.getViewModel().getAuthResult().observeForever(new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        this.getViewModel().authenticateUser(new AuthRequest(sdkKey, sdkSecret, null, 4, null));
        new Storage(this.getContext()).setPreferredLocale(languageType);
        LocaleUtil.Companion.applyLocalizedContext(this.getContext(), languageType);
    }

    public static /* synthetic */ void initialize$default(VerifySDKManager verifySDKManager, String string, String string2, String string3, ExtraData extraData, AuthCallback authCallback, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "en";
        }
        if ((n & 8) != 0) {
            extraData = null;
        }
        verifySDKManager.initialize(string, string2, string3, extraData, authCallback);
    }

    public final void verify(@NotNull DocumentType documentType, @NotNull Function1<? super ScanDocumentResult.ScanDocumentResponse, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (SdkConfig.INSTANCE.getSdkStatus() == SDKStatus.INITIALIZED) {
            Intent intent;
            this.logger.log("scanDocument called with DocumentType: " + documentType.getDisplayName());
            SdkConfig.INSTANCE.setViewType(documentType);
            Function1 function1 = (Function1)new Function1<ScanDocumentResult, Unit>(callback, this){
                final /* synthetic */ Function1<ScanDocumentResult.ScanDocumentResponse, Unit> $callback;
                final /* synthetic */ VerifySDKManager this$0;
                {
                    this.$callback = $callback;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ScanDocumentResult it) {
                    if (it instanceof ScanDocumentResult.ScanDocumentResponse) {
                        this.$callback.invoke((Object)it);
                        VerifySDKManager.access$getSkipNfcLiveNessViewModel(this.this$0).getLiveNessData().requestFinishActivity();
                        if (!((ScanDocumentResult.ScanDocumentResponse)it).getResult()) {
                            VerifySDKManager.access$getSkipNfcLiveNessViewModel(this.this$0).getLiveNessData().hideProgressBar();
                        }
                    }
                }
            };
            this.getScanDocumentViewModel().getResult().observeForever(new /* invalid duplicate definition of identical inner class */);
            Intent $this$verify_u24lambda_u240 = intent = new Intent(this.getContext(), MainScreen.class);
            boolean bl = false;
            $this$verify_u24lambda_u240.setFlags(0x10000000);
            Intent intent2 = intent;
            this.getContext().startActivity(intent2);
        } else {
            this.logger.log("Failed to initialize SDK");
            callback.invoke((Object)new ScanDocumentResult.ScanDocumentResponse(false, "Failed to initialize SDK", ""));
        }
    }

    public static /* synthetic */ void verify$default(VerifySDKManager verifySDKManager, DocumentType documentType, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            documentType = DocumentType.OMAN_ID;
        }
        verifySDKManager.verify(documentType, (Function1<? super ScanDocumentResult.ScanDocumentResponse, Unit>)function1);
    }

    public final void getVerificationResult(@NotNull String verificationId, @NotNull Function1<? super ScanDocumentResult.GetScanResultResponse, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.logger.log("getScanResult called with verificationId: " + verificationId);
        if (SdkConfig.INSTANCE.getSdkStatus() == SDKStatus.INITIALIZED) {
            ScanDocumentViewModel scanDocumentViewModel = this.getScanDocumentViewModel();
            String string2 = SdkConfig.INSTANCE.getRegisterToken();
            Intrinsics.checkNotNull((Object)string2);
            scanDocumentViewModel.getVerification(string2, Utility.Companion.getInstance().getAppKey(), verificationId);
            Function1 function1 = (Function1)new Function1<ScanDocumentResult, Unit>(callback, this){
                final /* synthetic */ Function1<ScanDocumentResult.GetScanResultResponse, Unit> $callback;
                final /* synthetic */ VerifySDKManager this$0;
                {
                    this.$callback = $callback;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ScanDocumentResult it) {
                    if (it instanceof ScanDocumentResult.GetScanResultResponse) {
                        this.$callback.invoke((Object)it);
                        VerifySDKManager.access$getSkipNfcLiveNessViewModel(this.this$0).getLiveNessData().requestFinishActivity();
                    }
                }
            };
            this.getScanDocumentViewModel().getResult().observeForever(new /* invalid duplicate definition of identical inner class */);
        } else {
            this.logger.log("SDK not initialized");
        }
    }

    @Override
    public void submitVerification(@NotNull DocumentVerification verification) {
        Intrinsics.checkNotNullParameter((Object)verification, (String)"verification");
        ScanDocumentViewModel scanDocumentViewModel = this.getScanDocumentViewModel();
        String string2 = SdkConfig.INSTANCE.getRegisterToken();
        Intrinsics.checkNotNull((Object)string2);
        scanDocumentViewModel.submitVerification(string2, Utility.Companion.getInstance().getAppKey(), verification);
    }

    @JvmStatic
    @NotNull
    public static final VerifySDKManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Loggers.LoggerInstance access$getLogger$p(VerifySDKManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SkipNfcLiveNessViewModel access$getSkipNfcLiveNessViewModel(VerifySDKManager $this) {
        return $this.getSkipNfcLiveNessViewModel();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnashid/verify/sdk/VerifySDKManager$Companion;", "", "()V", "instance", "Lnashid/verify/sdk/VerifySDKManager;", "getInstance", "VerifySDK_release"})
    @SourceDebugExtension(value={"SMAP\nVerifySDKManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifySDKManager.kt\nnashid/verify/sdk/VerifySDKManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final VerifySDKManager getInstance() {
            VerifySDKManager verifySDKManager = instance;
            if (verifySDKManager == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    VerifySDKManager verifySDKManager2 = instance;
                    if (verifySDKManager2 == null) {
                        VerifySDKManager verifySDKManager3;
                        VerifySDKManager it = verifySDKManager3 = new VerifySDKManager();
                        boolean bl2 = false;
                        instance = it;
                        verifySDKManager2 = verifySDKManager3;
                    }
                    VerifySDKManager verifySDKManager4 = verifySDKManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    verifySDKManager = verifySDKManager4;
                }
            }
            return verifySDKManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

