/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.data.repository;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nashid.verify.sdk.utils.ScanDocument;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper;
import nashid.verify.sdk.viewmodel.CameraXLiveData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0019\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnashid/verify/sdk/data/repository/IdCardRepository;", "", "cameraXLiveData", "Lnashid/verify/sdk/viewmodel/CameraXLiveData;", "scanDocument", "Lnashid/verify/sdk/utils/ScanDocument;", "(Lnashid/verify/sdk/viewmodel/CameraXLiveData;Lnashid/verify/sdk/utils/ScanDocument;)V", "addCharactersToReachLength", "", "input", "desiredLength", "", "readIdCardBackView", "", "textAll", "", "([Ljava/lang/String;)V", "readIdCardFrontView", "originalText", "removeKValueFromString", "modifiedMRZText", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIdCardRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdCardRepository.kt\nnashid/verify/sdk/data/repository/IdCardRepository\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,256:1\n107#2:257\n79#2,22:258\n*S KotlinDebug\n*F\n+ 1 IdCardRepository.kt\nnashid/verify/sdk/data/repository/IdCardRepository\n*L\n49#1:257\n49#1:258,22\n*E\n"})
public final class IdCardRepository {
    @NotNull
    private final CameraXLiveData cameraXLiveData;
    @NotNull
    private final ScanDocument scanDocument;
    public static final int $stable = 8;

    public IdCardRepository(@NotNull CameraXLiveData cameraXLiveData, @NotNull ScanDocument scanDocument) {
        Intrinsics.checkNotNullParameter((Object)cameraXLiveData, (String)"cameraXLiveData");
        Intrinsics.checkNotNullParameter((Object)scanDocument, (String)"scanDocument");
        this.cameraXLiveData = cameraXLiveData;
        this.scanDocument = scanDocument;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void readIdCardBackView(@NotNull String[] textAll) {
        Intrinsics.checkNotNullParameter((Object)textAll, (String)"textAll");
        String gender = "";
        Pattern pattern1 = Pattern.compile("([A|C|I][A-Z0-9<K]{1})([A-Z]{3})([A-Z0-9<]{9})([0-9]{1})");
        Pattern pattern2 = Pattern.compile("([0-9]{6})([0-9]{1})([MFX]{1})([0-9]{6})([0-9]{1})([A-Z]{3})([A-Z0-9<]{11})([A-Z0-9<]{1})");
        Pattern pattern3 = Pattern.compile("([A-Z]+)<([A-Z<]+)");
        if (Intrinsics.areEqual((Object)this.cameraXLiveData.getAlgoHeaderDetect().getValue(), (Object)false)) {
            String string2 = String.join((CharSequence)" ", Arrays.copyOf(textAll, textAll.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            if (OmanIdCardReaderHelper.Companion.isSimilarEnough(string2)) {
                this.cameraXLiveData.setAlgoHeaderDetect(true);
            }
        }
        if (Intrinsics.areEqual((Object)this.cameraXLiveData.getAlgoHeaderDetect().getValue(), (Object)true) && (Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)true) || Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)true) || Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)true))) {
            for (String data : textAll) {
                Matcher matcher1;
                char lastChar;
                Object replacedString;
                StringBuilder updatedString = new StringBuilder(StringsKt.replace$default((String)data, (String)" ", (String)"", (boolean)false, (int)4, null));
                String string3 = updatedString.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                String removeKString = this.removeKValueFromString(string3);
                updatedString = new StringBuilder(StringsKt.replace$default((String)removeKString, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                Matcher matcher3 = pattern3.matcher(updatedString.toString());
                StringBuilder name = new StringBuilder(StringsKt.replace$default((String)StringsKt.replace$default((String)data, (String)"NAME ", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"<", (boolean)false, (int)4, null));
                if (matcher3.matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)true)) {
                    void $this$trim$iv;
                    Utility utility = Utility.Companion.getInstance();
                    String string4 = updatedString.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    String string5 = StringsKt.replace$default((String)StringsKt.replace$default((String)string4, (String)"<", (String)" ", (boolean)false, (int)4, null), (String)"\u00ab", (String)" ", (boolean)false, (int)4, null);
                    Utility utility2 = utility;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    utility2.setName(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    int length = 30 - name.length();
                    for (int i = 0; i < length; ++i) {
                        name.append("<");
                    }
                    String string6 = name.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                    String updatedName = this.removeKValueFromString(string6);
                    Utility.Companion.getInstance().setMrzLine3(StringsKt.replace$default((String)updatedName, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                    this.cameraXLiveData.setIdLine3(false);
                }
                int index = updatedString.indexOf("MN");
                Intrinsics.checkNotNullExpressionValue((Object)updatedString.toString(), (String)"toString(...)");
                if (index > 1 && updatedString.charAt(index - 1) == '0') {
                    String secondPart;
                    String firstPart = updatedString.substring(0, index - 1);
                    String startIndex$iv$iv = secondPart = updatedString.substring(index - 1);
                    Intrinsics.checkNotNull((Object)startIndex$iv$iv);
                    if (StringsKt.startsWith$default((String)startIndex$iv$iv, (String)"0", (boolean)false, (int)2, null)) {
                        startIndex$iv$iv = secondPart;
                        Intrinsics.checkNotNull((Object)startIndex$iv$iv);
                        secondPart = StringsKt.replace$default((String)startIndex$iv$iv, (String)"0", (String)"O", (boolean)false, (int)4, null);
                    }
                    replacedString = firstPart + secondPart;
                }
                if (Character.isLetter(lastChar = ((String)replacedString).charAt(((String)replacedString).length() - 1)) && (lastChar == 'O' || lastChar == 'o')) {
                    String string7 = ((String)replacedString).substring(0, ((String)replacedString).length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    replacedString = string7 + "0";
                }
                if (((String)replacedString).length() >= 25) {
                    replacedString = this.addCharactersToReachLength((String)replacedString, 30);
                }
                Matcher matcher2 = pattern2.matcher(OmanIdCardReaderHelper.Companion.cleanString((String)replacedString));
                String matcherString = updatedString.toString();
                if (updatedString.length() > 15) {
                    matcherString = updatedString.substring(0, 15);
                }
                if ((matcher1 = pattern1.matcher(String.valueOf(matcherString))).matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)true)) {
                    int length = 30 - updatedString.length();
                    for (int i = 0; i < length; ++i) {
                        updatedString.append("<");
                    }
                    Utility.Companion.getInstance().setMrzLine1(updatedString.toString());
                    String string8 = Objects.requireNonNull(matcher1.group(3));
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"requireNonNull(...)");
                    this.cameraXLiveData.setIdNo(OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(string8));
                    String string9 = Objects.requireNonNull(matcher1.group(2));
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"requireNonNull(...)");
                    String country = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(string9);
                    Utility.Companion.getInstance().setCountry(country);
                    Utility.Companion.getInstance().setDocumentType(matcher1.group(1));
                    this.cameraXLiveData.setIdLine1(false);
                }
                if (((String)replacedString).length() == 30 && matcher2.matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)true)) {
                    updatedString = new StringBuilder(OmanIdCardReaderHelper.Companion.cleanString((String)replacedString));
                    Utility.Companion.getInstance().setMrzLine2(updatedString.toString());
                    this.cameraXLiveData.setDOB(matcher2.group(1));
                    this.cameraXLiveData.setExpiryDate(matcher2.group(4));
                    String string10 = matcher2.group(3);
                    if (string10 == null || (string10 = string10.toString()) == null) {
                        string10 = "";
                    }
                    gender = string10;
                    String nationality = matcher2.group(6);
                    Utility.Companion.getInstance().setNationality(nationality);
                    this.cameraXLiveData.setIdLine2(false);
                }
                if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)false) && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)false) && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)false)) break;
            }
        }
        if (Utility.Companion.getInstance().getMrzLine1() != null && Utility.Companion.getInstance().getMrzLine2() != null && Utility.Companion.getInstance().getMrzLine3() != null) {
            if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontViewScanned().getValue(), (Object)false)) {
                this.cameraXLiveData.setIdNo(null);
                this.cameraXLiveData.setDOB(null);
                this.cameraXLiveData.setExpiryDate(null);
                this.cameraXLiveData.setIdLine1(true);
                this.cameraXLiveData.setIdLine2(true);
                this.cameraXLiveData.setIdLine3(true);
                this.cameraXLiveData.setIsSuccess(false);
                return;
            }
            if (this.cameraXLiveData.getExpiryDate().getValue() != null) {
                Object object = this.cameraXLiveData.getExpiryDate().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((CharSequence)object).length() > 0) {
                    if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontViewScanned().getValue(), (Object)true)) {
                        Object object2 = Objects.requireNonNull(this.cameraXLiveData.getIdNo().getValue());
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requireNonNull(...)");
                        if (((CharSequence)object2).length() > 0) {
                            Object object3 = Objects.requireNonNull(this.cameraXLiveData.getDOB().getValue());
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"requireNonNull(...)");
                            if (((CharSequence)object3).length() > 0) {
                                String documentNumber = (String)this.cameraXLiveData.getIdNo().getValue();
                                String dateOfBirthDay = (String)this.cameraXLiveData.getDOB().getValue();
                                String expiryDate = (String)this.cameraXLiveData.getExpiryDate().getValue();
                                try {
                                    String string11 = expiryDate;
                                    Intrinsics.checkNotNull((Object)string11);
                                    if (((CharSequence)string11).length() > 0) {
                                        this.scanDocument.setDocumentNo(documentNumber);
                                        this.scanDocument.setDateOfBirth(dateOfBirthDay);
                                        this.scanDocument.setExpiryDate(expiryDate);
                                        Utility.Companion.getInstance().setPassportNumber(documentNumber);
                                        Utility.Companion.getInstance().setDateOfBirth(dateOfBirthDay);
                                        Utility.Companion.getInstance().setExpiryDate(expiryDate);
                                        Utility.Companion.getInstance().setGender(gender);
                                        this.cameraXLiveData.setFlag(false);
                                        this.cameraXLiveData.setCloseAnalysisUseCase(true);
                                        this.cameraXLiveData.setIsSuccess(true);
                                        this.cameraXLiveData.setCTimer(true);
                                        this.cameraXLiveData.setCaptureAnImage(true);
                                        return;
                                    }
                                    this.cameraXLiveData.setIsSuccess(false);
                                    return;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.cameraXLiveData.setIsSuccess(false);
                                }
                                return;
                            }
                        }
                    }
                    this.cameraXLiveData.setIsSuccess(false);
                    return;
                }
            }
            this.cameraXLiveData.setIsSuccess(false);
            return;
        }
        this.cameraXLiveData.setIsSuccess(false);
    }

    public final void readIdCardFrontView(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        String text = originalText;
        String string2 = StringsKt.replace$default((String)text, (String)" ", (String)"", (boolean)false, (int)4, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        text = string3;
        string2 = StringsKt.replace$default((String)text, (String)"\n", (String)" ", (boolean)false, (int)4, null);
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string4 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        text = string4;
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)"SULTANATEOFOMAN", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)text, (CharSequence)"IDENTITY CARD", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"RESIDENT CARD", (boolean)false, (int)2, null))) {
            this.cameraXLiveData.setIdNo(null);
            this.cameraXLiveData.setDOB(null);
            this.cameraXLiveData.setExpiryDate(null);
            this.cameraXLiveData.setIsFrontView(true);
            this.cameraXLiveData.setIdLine1(true);
            this.cameraXLiveData.setIdLine2(true);
            this.cameraXLiveData.setCaptureAnImage(true);
            this.cameraXLiveData.setIsSuccess(true);
        } else {
            this.cameraXLiveData.setIsSuccess(false);
        }
        this.cameraXLiveData.setCTimer(false);
    }

    private final String removeKValueFromString(String modifiedMRZText) {
        StringBuilder latest = new StringBuilder();
        int n = modifiedMRZText.length();
        for (int l = 0; l < n; ++l) {
            if (l != 0) {
                if (modifiedMRZText.charAt(l) == 'K') {
                    if (l == modifiedMRZText.length() - 1) {
                        if (modifiedMRZText.charAt(l) == 'K') continue;
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) != '<' && modifiedMRZText.charAt(l + 1) != '<') {
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) == '<' && modifiedMRZText.charAt(l + 1) == '<') continue;
                    latest.append(modifiedMRZText.charAt(l));
                    continue;
                }
                latest.append(modifiedMRZText.charAt(l));
                continue;
            }
            latest.append(modifiedMRZText.charAt(l));
        }
        String string2 = latest.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("\\bK+\\b");
        String string3 = "";
        return regex.replace(charSequence, string3);
    }

    private final String addCharactersToReachLength(String input, int desiredLength) {
        if (input.length() >= desiredLength) {
            return input;
        }
        char lastChar = input.charAt(input.length() - 1);
        if (Character.isDigit(lastChar)) {
            int additionalChars = desiredLength - input.length();
            StringBuilder sb = new StringBuilder(input);
            for (int i = 0; i < additionalChars; ++i) {
                sb.insert(sb.length() - 1, '<');
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        return input;
    }
}

