/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.data.repository;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.mlkit.vision.text.Text;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nashid.verify.sdk.utils.ScanDocument;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper;
import nashid.verify.sdk.viewmodel.CameraXLiveData;
import nashid.verify.sdkNew.R;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnashid/verify/sdk/data/repository/PassportRepository;", "", "cameraXLiveData", "Lnashid/verify/sdk/viewmodel/CameraXLiveData;", "scanDocument", "Lnashid/verify/sdk/utils/ScanDocument;", "context", "Landroid/content/Context;", "(Lnashid/verify/sdk/viewmodel/CameraXLiveData;Lnashid/verify/sdk/utils/ScanDocument;Landroid/content/Context;)V", "name", "", "passportMRZ", "readAllDetailOfPassport", "", "readPassportData", "blocks", "", "Lcom/google/mlkit/vision/text/Text$TextBlock;", "removeKValueFromString", "modifiedMRZText", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPassportRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PassportRepository.kt\nnashid/verify/sdk/data/repository/PassportRepository\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,152:1\n107#2:153\n79#2,22:154\n*S KotlinDebug\n*F\n+ 1 PassportRepository.kt\nnashid/verify/sdk/data/repository/PassportRepository\n*L\n66#1:153\n66#1:154,22\n*E\n"})
public final class PassportRepository {
    @NotNull
    private final CameraXLiveData cameraXLiveData;
    @NotNull
    private final ScanDocument scanDocument;
    @NotNull
    private final Context context;
    @NotNull
    private String passportMRZ;
    @NotNull
    private String name;
    public static final int $stable = 8;

    public PassportRepository(@NotNull CameraXLiveData cameraXLiveData, @NotNull ScanDocument scanDocument, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)cameraXLiveData, (String)"cameraXLiveData");
        Intrinsics.checkNotNullParameter((Object)scanDocument, (String)"scanDocument");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.cameraXLiveData = cameraXLiveData;
        this.scanDocument = scanDocument;
        this.context = context;
        this.passportMRZ = "";
        this.name = "";
    }

    /*
     * WARNING - void declaration
     */
    public final void readPassportData(@NotNull List<? extends Text.TextBlock> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        if (StringsKt.equals((String)((String)Objects.requireNonNull(this.cameraXLiveData.getSelectedDoc().getValue())), (String)this.context.getString(R.string.e_passport), (boolean)true)) {
            int n = blocks.size();
            for (int i = 0; i < n; ++i) {
                List lines;
                Intrinsics.checkNotNullExpressionValue((Object)blocks.get(i).getLines(), (String)"getLines(...)");
                int n2 = lines.size();
                for (int j = 0; j < n2; ++j) {
                    List elements;
                    Intrinsics.checkNotNullExpressionValue((Object)((Text.Line)lines.get(j)).getElements(), (String)"getElements(...)");
                    int n3 = elements.size();
                    for (int k = 0; k < n3; ++k) {
                        if (((Text.Element)elements.get(k)).getText().length() <= 30) continue;
                        try {
                            void $this$trim$iv;
                            String countrySubstring;
                            String string2;
                            Intrinsics.checkNotNullExpressionValue((Object)((Text.Element)elements.get(k)).getText(), (String)"getText(...)");
                            int n4 = 10;
                            int n5 = 13;
                            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n4, n5), (String)"substring(...)");
                            String newCountryCode = StringsKt.replace$default((String)countrySubstring, (String)"0", (String)"O", (boolean)false, (int)4, null);
                            String string3 = ((Text.Element)elements.get(k)).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                            String modifiedMRZText = StringsKt.replace$default((String)string3, (String)countrySubstring, (String)newCountryCode, (boolean)false, (int)4, null);
                            modifiedMRZText = StringsKt.replace$default((String)modifiedMRZText, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null);
                            Pattern patternPassportTD3Line2 = Pattern.compile("([A-Z0-9<]{9})([0-9]{1})([A-Z]{3})([0-9]{6})([0-9]{1})([M|F|X|<]{1})([0-9]{6})([0-9]{1})");
                            Pattern patternPassportTD3Line1 = Pattern.compile("(P[A-Z0-9<]{1})([A-Z]{3})([A-Z0-9<]{39})");
                            Matcher matcherPassportTD3Line2 = patternPassportTD3Line2.matcher(modifiedMRZText);
                            Matcher matcherPassportTD3Line1 = patternPassportTD3Line1.matcher(modifiedMRZText);
                            if (matcherPassportTD3Line2.find() && ((CharSequence)this.passportMRZ).length() == 0) {
                                Intrinsics.checkNotNullExpressionValue((Object)((Text.Element)elements.get(k)).getText(), (String)"getText(...)");
                                this.passportMRZ = this.passportMRZ;
                                Utility.Companion.getInstance().setMrzLine2(StringsKt.replace$default((String)this.passportMRZ, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                            }
                            if (!matcherPassportTD3Line1.matches() || !(((CharSequence)this.name).length() == 0)) continue;
                            String latest = this.removeKValueFromString(modifiedMRZText);
                            Utility.Companion.getInstance().setMrzLine1(latest);
                            String string4 = latest.substring(5, latest.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                            String string5 = this.name = StringsKt.replace$default((String)string4, (String)"<", (String)" ", (boolean)false, (int)4, null);
                            Utility utility = Utility.Companion.getInstance();
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            utility.setName(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                            Utility utility2 = Utility.Companion.getInstance();
                            String string6 = latest.substring(2, 5);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                            utility2.setCountry(string6);
                            Utility utility3 = Utility.Companion.getInstance();
                            String string7 = latest.substring(0, 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                            utility3.setDocumentType(string7);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void readAllDetailOfPassport() {
        if (((CharSequence)this.passportMRZ).length() > 0 && ((CharSequence)this.name).length() > 0) {
            String line = this.passportMRZ;
            String string2 = line.substring(0, 9);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String documentNumber = string2;
            String string3 = line.substring(10, 13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String nationality = string3;
            String string4 = line.substring(13, 19);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String dateOfBirthDay = string4;
            String string5 = line.substring(20, 21);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String gender = string5;
            String string6 = line.substring(21, 27);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            this.cameraXLiveData.setExpiryDate(string6);
            nationality = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(nationality);
            dateOfBirthDay = OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(dateOfBirthDay);
            gender = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(gender);
            this.cameraXLiveData.setExpiryDate(OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(String.valueOf(this.cameraXLiveData.getExpiryDate().getValue())));
            documentNumber = StringsKt.replace$default((String)documentNumber, (String)"O", (String)"0", (boolean)false, (int)4, null);
            if (((CharSequence)documentNumber).length() > 0 && ((CharSequence)dateOfBirthDay).length() > 0) {
                Object object = this.cameraXLiveData.getExpiryDate().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((CharSequence)object).length() > 0 && ((CharSequence)nationality).length() > 0 && ((CharSequence)gender).length() > 0) {
                    this.scanDocument.setDocumentNo(documentNumber);
                    this.scanDocument.setDateOfBirth(dateOfBirthDay);
                    this.scanDocument.setExpiryDate((String)this.cameraXLiveData.getExpiryDate().getValue());
                    Utility.Companion.getInstance().setPassportNumber(documentNumber);
                    Utility.Companion.getInstance().setDateOfBirth(dateOfBirthDay);
                    Utility.Companion.getInstance().setExpiryDate((String)this.cameraXLiveData.getExpiryDate().getValue());
                    Utility.Companion.getInstance().setNationality(nationality);
                    Utility.Companion.getInstance().setGender(gender);
                    this.cameraXLiveData.setFlag(false);
                    this.cameraXLiveData.setCloseAnalysisUseCase(true);
                    this.cameraXLiveData.setIsSuccess(true);
                    this.cameraXLiveData.setCaptureAnImage(true);
                    return;
                }
            }
            this.cameraXLiveData.setIsSuccess(false);
            return;
        }
        this.cameraXLiveData.setIsSuccess(false);
    }

    private final String removeKValueFromString(String modifiedMRZText) {
        StringBuilder latest = new StringBuilder();
        int n = modifiedMRZText.length();
        for (int l = 0; l < n; ++l) {
            if (l != 0) {
                if (modifiedMRZText.charAt(l) == 'K') {
                    if (l == modifiedMRZText.length() - 1) {
                        if (modifiedMRZText.charAt(l) == 'K') continue;
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) != '<' && modifiedMRZText.charAt(l + 1) != '<') {
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) == '<' && modifiedMRZText.charAt(l + 1) == '<') continue;
                    latest.append(modifiedMRZText.charAt(l));
                    continue;
                }
                latest.append(modifiedMRZText.charAt(l));
                continue;
            }
            latest.append(modifiedMRZText.charAt(l));
        }
        String string2 = latest.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("\\bK+\\b");
        String string3 = "";
        return regex.replace(charSequence, string3);
    }
}

