/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nashid.verify.sdk.model.AdditionalPersonDetails;
import nashid.verify.sdk.ui.adapter.NFCDetailAdapter;
import nashid.verify.sdk.utils.AdditionalDGFiles;
import nashid.verify.sdk.utils.EDocument;
import nashid.verify.sdk.utils.LivenessData;
import nashid.verify.sdk.utils.PersonDetails;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.TextSizeConverter;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG10File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG11File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG13File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG1File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG4File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG6File;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.FragmentNfcBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020\u0013H\u0003J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0003J\b\u0010(\u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u000201H\u0002J\u001c\u00102\u001a\u00020\u00132\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000104H\u0002J\b\u00106\u001a\u00020\u0013H\u0002J\u000e\u00107\u001a\u00020\u0007*\u0004\u0018\u00010\u0007H\u0002J\u0014\u00108\u001a\u00020\u0007*\n\u0012\u0004\u0012\u00020\u0007\u0018\u000109H\u0002J\u001c\u0010:\u001a\u00020\u0013*\u00020\u00152\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0002J0\u0010=\u001a\u00020\u0013*\u00020>2\"\u0010?\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070@j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`AH\u0002J,\u0010B\u001a\u00020\u0013*\u00020\u00152\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000eH\u0002J\u0014\u0010G\u001a\u00020\u0013*\u00020\u00152\u0006\u0010H\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lnashid/verify/sdk/ui/NFCFragment;", "Landroidx/fragment/app/Fragment;", "()V", "binding", "Lnashid/verify/sdkNew/databinding/FragmentNfcBinding;", "companyHashmap", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "documentHashmap", "emptyString", "personalHashmap", "sponsorHashmap", "textSize", "", "visaHashmap", "formatDate", "inputDate", "initView", "", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "setAdditionalDocumentFiles", "files", "Lnashid/verify/sdk/utils/AdditionalDGFiles;", "eDocument", "Lnashid/verify/sdk/utils/EDocument;", "setAdditionalPersonDetails", "details", "Lnashid/verify/sdk/model/AdditionalPersonDetails;", "setCompanyDetails", "setDocumentDetails", "setIDCardDetail", "setPassportDetail", "setPersonalDetails", "setTextSize", "view", "Landroid/widget/TextView;", "size", "", "setVisaDetails", "setupLayoutParameters", "textSizeConverter", "Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "setupPersonImages", "faceImage", "Landroid/graphics/Bitmap;", "signatureImage", "setupRecyclerViews", "cleanNull", "getOrEmpty", "", "resize", "width", "height", "setLayoutManagerAndAdapter", "Landroidx/recyclerview/widget/RecyclerView;", "dataMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "setMargins", "left", "top", "right", "bottom", "setPaddingAllSides", "value", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNFCFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NFCFragment.kt\nnashid/verify/sdk/ui/NFCFragment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
public final class NFCFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FragmentNfcBinding binding;
    @NotNull
    private final LinkedHashMap<String, String> personalHashmap = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, String> documentHashmap = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, String> visaHashmap = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, String> sponsorHashmap = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, String> companyHashmap = new LinkedHashMap();
    @NotNull
    private final String emptyString;
    private final int textSize;
    public static final int $stable = 8;
    @Nullable
    private static JSONObject nfcData;

    public NFCFragment() {
        this.emptyString = "";
        this.textSize = 20;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        this.binding = FragmentNfcBinding.inflate(inflater, container, false);
        this.initView();
        FragmentNfcBinding fragmentNfcBinding = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding);
        LinearLayout linearLayout = fragmentNfcBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"getRoot(...)");
        return (View)linearLayout;
    }

    private final void initView() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        TextSizeConverter textSizeConverter = new TextSizeConverter(context);
        this.setupLayoutParameters(textSizeConverter);
        this.setupRecyclerViews();
        try {
            if (Intrinsics.areEqual((Object)Utility.Companion.getInstance().getSelectedDoc(), (Object)this.getString(R.string.e_passport))) {
                this.setPassportDetail();
                FragmentNfcBinding fragmentNfcBinding = this.binding;
                Intrinsics.checkNotNull((Object)fragmentNfcBinding);
                fragmentNfcBinding.imgSignature.setVisibility(0);
            } else {
                this.setIDCardDetail();
                FragmentNfcBinding fragmentNfcBinding = this.binding;
                Intrinsics.checkNotNull((Object)fragmentNfcBinding);
                fragmentNfcBinding.imgSignature.setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void setupLayoutParameters(TextSizeConverter textSizeConverter) {
        FragmentNfcBinding fragmentNfcBinding;
        FragmentNfcBinding fragmentNfcBinding2 = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding2);
        LinearLayout linearLayout = fragmentNfcBinding2.mainNfcFragmnent;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"mainNfcFragmnent");
        this.setPaddingAllSides((View)linearLayout, textSizeConverter.getPaddingOrMarginValue(16));
        FragmentNfcBinding fragmentNfcBinding3 = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding3);
        LinearLayout linearLayout2 = fragmentNfcBinding3.mainPhotoLayout;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout2, (String)"mainPhotoLayout");
        this.setMargins((View)linearLayout2, 0, textSizeConverter.getPaddingOrMarginValue(28), 0, 0);
        FragmentNfcBinding fragmentNfcBinding4 = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding4);
        FragmentNfcBinding $this$setupLayoutParameters_u24lambda_u240 = fragmentNfcBinding = fragmentNfcBinding4;
        boolean bl = false;
        CardView cardView = $this$setupLayoutParameters_u24lambda_u240.profileCard;
        Intrinsics.checkNotNullExpressionValue((Object)cardView, (String)"profileCard");
        this.resize((View)cardView, textSizeConverter.getWidth(106), textSizeConverter.getHeight(106));
        ImageView imageView = $this$setupLayoutParameters_u24lambda_u240.imgSignature;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imgSignature");
        this.resize((View)imageView, textSizeConverter.getWidth(106), textSizeConverter.getHeight(52));
        TextView textView = $this$setupLayoutParameters_u24lambda_u240.txtUserName;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"txtUserName");
        this.setTextSize(textView, textSizeConverter.getTextSize(14));
        TextView textView2 = $this$setupLayoutParameters_u24lambda_u240.txtDocNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"txtDocNumber");
        this.setTextSize(textView2, textSizeConverter.getTextSize(12));
        TextView textView3 = $this$setupLayoutParameters_u24lambda_u240.txtPersonalInfoHeader;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"txtPersonalInfoHeader");
        this.setTextSize(textView3, textSizeConverter.getTextSize(this.textSize));
        TextView textView4 = $this$setupLayoutParameters_u24lambda_u240.txtPersonalImfo;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"txtPersonalImfo");
        this.setTextSize(textView4, textSizeConverter.getTextSize(this.textSize));
        TextView textView5 = $this$setupLayoutParameters_u24lambda_u240.txtDocument;
        Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"txtDocument");
        this.setTextSize(textView5, textSizeConverter.getTextSize(this.textSize));
        TextView textView6 = $this$setupLayoutParameters_u24lambda_u240.txtVisa;
        Intrinsics.checkNotNullExpressionValue((Object)textView6, (String)"txtVisa");
        this.setTextSize(textView6, textSizeConverter.getTextSize(this.textSize));
        TextView textView7 = $this$setupLayoutParameters_u24lambda_u240.txtSponser;
        Intrinsics.checkNotNullExpressionValue((Object)textView7, (String)"txtSponser");
        this.setTextSize(textView7, textSizeConverter.getTextSize(this.textSize));
        TextView textView8 = $this$setupLayoutParameters_u24lambda_u240.txtCompany;
        Intrinsics.checkNotNullExpressionValue((Object)textView8, (String)"txtCompany");
        this.setTextSize(textView8, textSizeConverter.getTextSize(this.textSize));
    }

    private final void setupRecyclerViews() {
        FragmentNfcBinding fragmentNfcBinding;
        FragmentNfcBinding fragmentNfcBinding2 = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding2);
        FragmentNfcBinding $this$setupRecyclerViews_u24lambda_u241 = fragmentNfcBinding = fragmentNfcBinding2;
        boolean bl = false;
        RecyclerView recyclerView = $this$setupRecyclerViews_u24lambda_u241.recyclerviewPersonalInfo;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"recyclerviewPersonalInfo");
        this.setLayoutManagerAndAdapter(recyclerView, (HashMap<String, String>)this.personalHashmap);
        RecyclerView recyclerView2 = $this$setupRecyclerViews_u24lambda_u241.rcyclerviewDocument;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"rcyclerviewDocument");
        this.setLayoutManagerAndAdapter(recyclerView2, (HashMap<String, String>)this.documentHashmap);
        RecyclerView recyclerView3 = $this$setupRecyclerViews_u24lambda_u241.recyclerviewVisa;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView3, (String)"recyclerviewVisa");
        this.setLayoutManagerAndAdapter(recyclerView3, (HashMap<String, String>)this.visaHashmap);
        RecyclerView recyclerView4 = $this$setupRecyclerViews_u24lambda_u241.recyclerviewSponser;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView4, (String)"recyclerviewSponser");
        this.setLayoutManagerAndAdapter(recyclerView4, (HashMap<String, String>)this.sponsorHashmap);
        RecyclerView recyclerView5 = $this$setupRecyclerViews_u24lambda_u241.recyclerviewCompany;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView5, (String)"recyclerviewCompany");
        this.setLayoutManagerAndAdapter(recyclerView5, (HashMap<String, String>)this.companyHashmap);
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void setPassportDetail() {
        LinkedHashMap<String, String> linkedHashMap;
        EDocument eDocument = LivenessData.getInstance().geteDocument();
        PersonDetails personDetails = eDocument.getPersonDetails();
        AdditionalPersonDetails additionalPersonDetails = eDocument.getAdditionalPersonDetails();
        AdditionalDGFiles additionalDGFiles = eDocument.getAdditionalDGFiles();
        LinkedHashMap<String, String> $this$setPassportDetail_u24lambda_u242 = linkedHashMap = this.personalHashmap;
        boolean bl = false;
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passdocumentType), eDocument.getDocType().name());
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passdocumentNumber), personDetails.getSerialNumber());
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passissuingAuthority), personDetails.getIssuerAuthority());
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passdateOfBirth), personDetails.getBirthDate());
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passgender), personDetails.getGender());
        $this$setPassportDetail_u24lambda_u242.put(this.getString(R.string.passdocumentExpiryDate), personDetails.getExpiryDate());
        this.setupPersonImages(personDetails.getFaceImage(), personDetails.getSignature());
        this.setAdditionalPersonDetails(additionalPersonDetails);
        Intrinsics.checkNotNull((Object)additionalDGFiles);
        Intrinsics.checkNotNull((Object)eDocument);
        this.setAdditionalDocumentFiles(additionalDGFiles, eDocument);
        FragmentNfcBinding fragmentNfcBinding = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding);
        fragmentNfcBinding.txtDocNumber.setText((CharSequence)(personDetails.getNationality() + " | " + personDetails.getSerialNumber()));
    }

    private final void setupPersonImages(Bitmap faceImage, Bitmap signatureImage) {
        FragmentNfcBinding fragmentNfcBinding;
        FragmentNfcBinding fragmentNfcBinding2 = this.binding;
        Intrinsics.checkNotNull((Object)fragmentNfcBinding2);
        FragmentNfcBinding $this$setupPersonImages_u24lambda_u243 = fragmentNfcBinding = fragmentNfcBinding2;
        boolean bl = false;
        $this$setupPersonImages_u24lambda_u243.imgProfile.setImageBitmap(faceImage);
        Glide.with((FragmentActivity)this.requireActivity()).load(signatureImage).into($this$setupPersonImages_u24lambda_u243.imgSignature);
    }

    private final void setAdditionalPersonDetails(AdditionalPersonDetails details) {
        block5: {
            String it1;
            LinkedHashMap<String, String> linkedHashMap;
            AdditionalPersonDetails additionalPersonDetails = details;
            if (additionalPersonDetails == null) break block5;
            AdditionalPersonDetails it = additionalPersonDetails;
            boolean bl = false;
            FragmentNfcBinding fragmentNfcBinding = this.binding;
            Intrinsics.checkNotNull((Object)fragmentNfcBinding);
            fragmentNfcBinding.txtUserName.setText((CharSequence)it.getNameOfHolder());
            LinkedHashMap<String, String> $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249 = linkedHashMap = this.personalHashmap;
            boolean bl2 = false;
            $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passfullName), this.cleanNull(it.getNameOfHolder()));
            $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passplaceOfBirth), this.getOrEmpty(it.getPlaceOfBirth()));
            $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passaddress), this.getOrEmpty(it.getPermanentAddress()));
            String string2 = it.getProfession();
            if (string2 != null) {
                it1 = string2;
                boolean bl3 = false;
                $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passprofession), it1);
            }
            String string3 = it.getTitle();
            if (string3 != null) {
                it1 = string3;
                boolean bl4 = false;
                $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passtitle), it1);
            }
            String string4 = it.getPersonalSummary();
            if (string4 != null) {
                it1 = string4;
                boolean bl5 = false;
                $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passpersonalSummary), it1);
            }
            $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passtdNumbers), this.getOrEmpty(it.getOtherValidTDNumbers()));
            String string5 = it.getCustodyInformation();
            if (string5 != null) {
                it1 = string5;
                boolean bl6 = false;
                $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passcustodyInfo), it1);
            }
            $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passproofOfCitizenship), String.valueOf(it.getProofOfCitizenship()));
            String string6 = it.getTelephone();
            if (string6 != null) {
                it1 = string6;
                boolean bl7 = false;
                $this$setAdditionalPersonDetails_u24lambda_u2410_u24lambda_u249.put(this.getString(R.string.passtelephone), it1);
            }
        }
    }

    private final void setAdditionalDocumentFiles(AdditionalDGFiles files, EDocument eDocument) {
        LinkedHashMap<String, String> linkedHashMap;
        LinkedHashMap<String, String> $this$setAdditionalDocumentFiles_u24lambda_u2411 = linkedHashMap = this.personalHashmap;
        boolean bl = false;
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passnfcissuingCountry), files.getIssueingAuthority());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passfrontImage), files.getFrontImage().toString());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passrearImage), files.getBackImage().toString());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passPersonalizationNumber), files.getPersonalizationDeviceSerialNumber());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passPersonalizationTime), files.getPersonalizationTime());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passsecurityInfos), files.getSecurityInfos());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passrsaPublicKey), eDocument.getRSAPublicKey());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passecdsaPublicKey), eDocument.getECDSAPublicKey());
        $this$setAdditionalDocumentFiles_u24lambda_u2411.put(this.getString(R.string.passive_authentication), String.valueOf(eDocument.getPersonDetails().isDigitalSigVerification()));
    }

    private final void setIDCardDetail() throws IOException {
        FragmentNfcBinding fragmentNfcBinding = this.binding;
        if (fragmentNfcBinding != null && (fragmentNfcBinding = fragmentNfcBinding.imgProfile) != null) {
            fragmentNfcBinding.setImageBitmap(LivenessData.getInstance().getNfcImage());
        }
        try {
            this.setDocumentDetails();
            this.setPersonalDetails();
            this.setVisaDetails();
            this.setCompanyDetails();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void setDocumentDetails() {
        LinkedHashMap<String, String> linkedHashMap;
        OmanCardDG1File dg1Parser = new OmanCardDG1File(Utility.Companion.getInstance().getDgFile1());
        FragmentNfcBinding fragmentNfcBinding = this.binding;
        Object object = fragmentNfcBinding != null ? fragmentNfcBinding.txtUserName : null;
        if (object != null) {
            JSONObject jSONObject = nfcData;
            object.setText((CharSequence)(jSONObject != null ? jSONObject.getString(this.getString(R.string.idcardfullNameEnglish)) : null));
        }
        FragmentNfcBinding fragmentNfcBinding2 = this.binding;
        Object object2 = fragmentNfcBinding2 != null ? fragmentNfcBinding2.txtDocNumber : null;
        if (object2 != null) {
            object2.setText((CharSequence)(new OmanCardDG6File(Utility.Companion.getInstance().getDgFile6()).getNationalityEnglish() + " | " + dg1Parser.getIdNumber()));
        }
        LinkedHashMap<String, String> $this$setDocumentDetails_u24lambda_u2412 = linkedHashMap = this.documentHashmap;
        boolean bl = false;
        $this$setDocumentDetails_u24lambda_u2412.put(this.getString(R.string.idcardidNumber), dg1Parser.getIdNumber());
        String string2 = this.getString(R.string.idcardissueDate);
        String string3 = dg1Parser.getIssueDate();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIssueDate(...)");
        $this$setDocumentDetails_u24lambda_u2412.put(string2, this.formatDate(string3));
        String string4 = this.getString(R.string.idcardexpiryDate);
        String string5 = dg1Parser.getExpiryDate();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getExpiryDate(...)");
        $this$setDocumentDetails_u24lambda_u2412.put(string4, this.formatDate(string5));
        $this$setDocumentDetails_u24lambda_u2412.put(this.getString(R.string.idcardplaceOfIssueArabic), dg1Parser.getPlaceOfIssueArabic());
        $this$setDocumentDetails_u24lambda_u2412.put(this.getString(R.string.idcardplaceOfIssueEnglish), dg1Parser.getPlaceOfIssueEnglish());
    }

    private final void setPersonalDetails() {
        OmanCardDG4File dg4Parser = new OmanCardDG4File(Utility.Companion.getInstance().getDgFile4());
        OmanCardDG6File dg6Parser = new OmanCardDG6File(Utility.Companion.getInstance().getDgFile6());
        Object it = dg4Parser;
        boolean bl = false;
        LinkedHashMap<String, String> linkedHashMap = this.personalHashmap;
        String string2 = this.getString(R.string.idcardfullNameArabic);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = string2;
        String string4 = ((OmanCardDG4File)it).getFullNameArabic();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFullNameArabic(...)");
        String string5 = string4;
        linkedHashMap.put(string3, string5);
        linkedHashMap = this.personalHashmap;
        String string6 = this.getString(R.string.idcardfullNameEnglish);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
        string3 = string6;
        String string7 = ((OmanCardDG4File)it).getFullNameEnglish();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getFullNameEnglish(...)");
        string5 = string7;
        linkedHashMap.put(string3, string5);
        it = dg6Parser;
        boolean bl2 = false;
        LinkedHashMap<String, String> $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414 = linkedHashMap = this.personalHashmap;
        boolean bl3 = false;
        String string8 = this.getString(R.string.idcarddateOfBirth);
        String string9 = ((OmanCardDG6File)it).getDateOfBirth();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getDateOfBirth(...)");
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(string8, this.formatDate(string9));
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardcountryOfBirthArabic), ((OmanCardDG6File)it).getCountryOfBirthArabic());
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardplaceOfBirthEnglish), ((OmanCardDG6File)it).getPlaceOfBirthEnglish());
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardnationalityArabic), ((OmanCardDG6File)it).getNationalityArabic());
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardgenderArabic), ((OmanCardDG6File)it).getGenderArabic());
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardnationalityEnglish), ((OmanCardDG6File)it).getNationalityEnglish());
        $this$setPersonalDetails_u24lambda_u2415_u24lambda_u2414.put(this.getString(R.string.idcardgenderEnglish), ((OmanCardDG6File)it).getGenderEnglish());
    }

    private final void setVisaDetails() {
        block5: {
            String string2;
            String string3;
            OmanCardDG10File omanCardDG10File;
            OmanCardDG13File omanCardDG13File;
            Object it;
            byte[] byArray = Utility.Companion.getInstance().getDgFile13();
            if (byArray != null) {
                it = byArray;
                boolean bl = false;
                omanCardDG13File = new OmanCardDG13File((byte[])it);
            } else {
                omanCardDG13File = null;
            }
            OmanCardDG13File dg13Parser = omanCardDG13File;
            byte[] byArray2 = Utility.Companion.getInstance().getDgFile10();
            if (byArray2 != null) {
                byte[] it2 = byArray2;
                boolean bl = false;
                omanCardDG10File = new OmanCardDG10File(it2);
            } else {
                omanCardDG10File = null;
            }
            OmanCardDG10File dg10Parser = omanCardDG10File;
            FragmentNfcBinding fragmentNfcBinding = this.binding;
            FragmentNfcBinding fragmentNfcBinding2 = this.binding;
            Utility.Companion.getInstance().setVisibility((View)(fragmentNfcBinding != null ? fragmentNfcBinding.txtSponser : null), (View)(fragmentNfcBinding2 != null ? fragmentNfcBinding2.recyclerviewSponser : null), dg13Parser != null);
            OmanCardDG13File omanCardDG13File2 = dg13Parser;
            if (omanCardDG13File2 != null) {
                it = omanCardDG13File2;
                boolean bl = false;
                Map map = this.visaHashmap;
                String string4 = this.getString(R.string.idcardvisaNumber);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                string3 = string4;
                String string5 = ((OmanCardDG13File)it).getSponsorNumber();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getSponsorNumber(...)");
                string2 = string5;
                map.put(string3, string2);
                map = this.sponsorHashmap;
                String string6 = this.getString(R.string.idcardPermitType);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
                string3 = string6;
                String string7 = ((OmanCardDG13File)it).getSponsorRelationship();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getSponsorRelationship(...)");
                string2 = string7;
                map.put(string3, string2);
                map = this.visaHashmap;
                String string8 = this.getString(R.string.idcardsponsorIssueDate);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
                string3 = string8;
                String string9 = ((OmanCardDG13File)it).getSponsorIssueDate();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getSponsorIssueDate(...)");
                string2 = this.formatDate(string9);
                map.put(string3, string2);
                map = this.visaHashmap;
                String string10 = this.getString(R.string.idcardsponsorExpiryDate);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getString(...)");
                string3 = string10;
                String string11 = ((OmanCardDG13File)it).getSponsorExpiryDate();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getSponsorExpiryDate(...)");
                string2 = this.formatDate(string11);
                map.put(string3, string2);
            }
            FragmentNfcBinding fragmentNfcBinding3 = this.binding;
            FragmentNfcBinding fragmentNfcBinding4 = this.binding;
            Utility.Companion.getInstance().setVisibility((View)(fragmentNfcBinding3 != null ? fragmentNfcBinding3.txtVisa : null), (View)(fragmentNfcBinding4 != null ? fragmentNfcBinding4.recyclerviewVisa : null), dg10Parser != null);
            OmanCardDG10File omanCardDG10File2 = dg10Parser;
            if (omanCardDG10File2 == null) break block5;
            it = omanCardDG10File2;
            boolean bl = false;
            Map map = this.visaHashmap;
            String string12 = this.getString(R.string.idcardvisaExpiryDate);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getString(...)");
            string3 = string12;
            String string13 = ((OmanCardDG10File)it).getVisaExpiryDate();
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getVisaExpiryDate(...)");
            string2 = this.formatDate(string13);
            map.put(string3, string2);
            map = this.visaHashmap;
            String string14 = this.getString(R.string.idcardvisaPlaceOfIssueArabic);
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getString(...)");
            string3 = string14;
            String string15 = ((OmanCardDG10File)it).getVisaPlaceOfIssueArabic();
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getVisaPlaceOfIssueArabic(...)");
            string2 = string15;
            map.put(string3, string2);
            map = this.sponsorHashmap;
            String string16 = this.getString(R.string.idcardPermitNumber);
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getString(...)");
            string3 = string16;
            String string17 = ((OmanCardDG10File)it).getVisaNumber();
            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"getVisaNumber(...)");
            string2 = string17;
            map.put(string3, string2);
        }
    }

    private final void setCompanyDetails() {
        block2: {
            LinkedHashMap<String, String> linkedHashMap;
            OmanCardDG11File omanCardDG11File;
            byte[] byArray = Utility.Companion.getInstance().getDgFile11();
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                omanCardDG11File = new OmanCardDG11File(it);
            } else {
                omanCardDG11File = null;
            }
            OmanCardDG11File dg11Parser = omanCardDG11File;
            FragmentNfcBinding fragmentNfcBinding = this.binding;
            FragmentNfcBinding fragmentNfcBinding2 = this.binding;
            Utility.Companion.getInstance().setVisibility((View)(fragmentNfcBinding != null ? fragmentNfcBinding.txtCompany : null), (View)(fragmentNfcBinding2 != null ? fragmentNfcBinding2.recyclerviewCompany : null), dg11Parser != null);
            OmanCardDG11File omanCardDG11File2 = dg11Parser;
            if (omanCardDG11File2 == null) break block2;
            OmanCardDG11File it = omanCardDG11File2;
            boolean bl = false;
            LinkedHashMap<String, String> $this$setCompanyDetails_u24lambda_u2422_u24lambda_u2421 = linkedHashMap = this.companyHashmap;
            boolean bl2 = false;
            $this$setCompanyDetails_u24lambda_u2422_u24lambda_u2421.put(this.getString(R.string.idcardcompanyNameArabic), it.getCompanyNameArabic());
            $this$setCompanyDetails_u24lambda_u2422_u24lambda_u2421.put(this.getString(R.string.idcardcompanyNameEnglish), it.getCompanyNameEnglish());
            $this$setCompanyDetails_u24lambda_u2422_u24lambda_u2421.put(this.getString(R.string.idcardcompanyAddressArabic), it.getCompanyAddressArabic());
        }
    }

    private final String formatDate(String inputDate) {
        try {
            DateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            Date date = sdf.parse(inputDate);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-dd-MM", Locale.ENGLISH);
            Date date2 = date;
            Intrinsics.checkNotNull((Object)date2);
            String string2 = simpleDateFormat.format(date2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        catch (Exception exception) {
            return inputDate;
        }
    }

    private final void setTextSize(TextView view, float size) {
        view.setTextSize(0, size);
    }

    private final void setPaddingAllSides(View $this$setPaddingAllSides, int value) {
        $this$setPaddingAllSides.setPadding(value, value, value, value);
    }

    private final void setMargins(View $this$setMargins, int left, int top, int right, int bottom) {
        block0: {
            ViewGroup.LayoutParams layoutParams = $this$setMargins.getLayoutParams();
            ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
            if (marginLayoutParams == null) break block0;
            marginLayoutParams.setMargins(left, top, right, bottom);
        }
    }

    private final void resize(View $this$resize, int width, int height) {
        $this$resize.getLayoutParams().width = width;
        $this$resize.getLayoutParams().height = height;
    }

    private final void setLayoutManagerAndAdapter(RecyclerView $this$setLayoutManagerAndAdapter, HashMap<String, String> dataMap) {
        $this$setLayoutManagerAndAdapter.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$setLayoutManagerAndAdapter.getContext(), 1, false));
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        $this$setLayoutManagerAndAdapter.setAdapter((RecyclerView.Adapter)new NFCDetailAdapter(context, dataMap));
    }

    private final String cleanNull(String $this$cleanNull) {
        String string2 = $this$cleanNull;
        if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"null ", (String)"", (boolean)false, (int)4, null)) == null) {
            string2 = this.emptyString;
        }
        return string2;
    }

    private final String getOrEmpty(List<String> $this$getOrEmpty) {
        List<String> list = $this$getOrEmpty;
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            list = this.emptyString;
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnashid/verify/sdk/ui/NFCFragment$Companion;", "", "()V", "nfcData", "Lorg/json/JSONObject;", "getNfcData", "()Lorg/json/JSONObject;", "setNfcData", "(Lorg/json/JSONObject;)V", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final JSONObject getNfcData() {
            return nfcData;
        }

        public final void setNfcData(@Nullable JSONObject jSONObject) {
            nfcData = jSONObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

