/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherKt;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import io.reactivex.disposables.CompositeDisposable;
import java.util.Objects;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nashid.verify.sdk.model.TagProvider;
import nashid.verify.sdk.ui.BaseActivity;
import nashid.verify.sdk.ui.NfcActivity;
import nashid.verify.sdk.utils.OtherConstant;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.ErrorUtility;
import nashid.verify.sdk.utils.helpers.NfcLayoutAndTextSize;
import nashid.verify.sdk.utils.helpers.TextSizeConverter;
import nashid.verify.sdk.utils.id_card.jmrtd.BACKey;
import nashid.verify.sdk.utils.id_card.jmrtd.BACKeySpec;
import nashid.verify.sdk.viewmodel.NFCViewModel;
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.ActivityWaitingForNfcBinding;
import nashid.verify.sdkNew.databinding.BottomSheetDialogBinding;
import nashid.verify.sdkNew.databinding.DialogEmailPhoneConfirmationBinding;
import nashid.verify.sdkNew.databinding.DialogFailureNfcBinding;
import nashid.verify.sdkNew.databinding.DialogSuccessBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.android.ext.android.AndroidKoinScopeExtKt;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020*H\u0002J\b\u0010/\u001a\u00020*H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020*H\u0002J\b\u00103\u001a\u00020*H\u0002J\u0012\u00104\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u000106H\u0014J\b\u00107\u001a\u00020*H\u0014J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020\u001eH\u0016J\b\u0010:\u001a\u00020*H\u0016J\b\u0010;\u001a\u00020*H\u0016J\b\u0010<\u001a\u00020*H\u0014J\b\u0010=\u001a\u00020*H\u0002J\u0012\u0010>\u001a\u00020*2\b\u0010?\u001a\u0004\u0018\u00010@H\u0002J\u0010\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\fH\u0007J\b\u0010C\u001a\u00020*H\u0002J\b\u0010D\u001a\u00020*H\u0002J\b\u0010E\u001a\u00020*H\u0002J\u0012\u0010F\u001a\u00020*2\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u0010\u0010I\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010J\u001a\u00020*H\u0002J\b\u0010K\u001a\u00020*H\u0002J\b\u0010L\u001a\u00020*H\u0002J\b\u0010M\u001a\u00020*H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001b\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u001b\u001a\u0004\b&\u0010'\u00a8\u0006N"}, d2={"Lnashid/verify/sdk/ui/NfcActivity;", "Lnashid/verify/sdk/ui/BaseActivity;", "()V", "binding", "Lnashid/verify/sdkNew/databinding/ActivityWaitingForNfcBinding;", "errorDialog", "Landroid/app/Dialog;", "isActivityRunning", "", "mNfcAdapter", "Landroid/nfc/NfcAdapter;", "maxRetryCount", "", "nfcLayoutAndTextSize", "Lnashid/verify/sdk/utils/helpers/NfcLayoutAndTextSize;", "pendingIntent", "Landroid/app/PendingIntent;", "progressBar", "Landroid/widget/ProgressBar;", "progressDialog", "progressText", "Landroid/widget/TextView;", "scanDocumentViewModel", "Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "getScanDocumentViewModel", "()Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "scanDocumentViewModel$delegate", "Lkotlin/Lazy;", "someActivityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "textSizeConverter", "Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "getTextSizeConverter", "()Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "textSizeConverter$delegate", "viewModel", "Lnashid/verify/sdk/viewmodel/NFCViewModel;", "getViewModel", "()Lnashid/verify/sdk/viewmodel/NFCViewModel;", "viewModel$delegate", "backPress", "", "dismissDialog", "displayResult", "isDisplaying", "handleIntentData", "handleInternetConnection", "handleInternetConnectionData", "isAvailable", "initAdapter", "initView", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onNewIntent", "intent", "onPause", "onResume", "onStop", "openBackPressDialog", "readPassport", "tagFromIntent", "Landroid/nfc/Tag;", "setMRTDProgressBarPercentage", "progress", "setObservable", "setOtherViews", "showDialog", "showError", "message", "", "showFailureDialog", "showNfcNotEnabledDialog", "showNfcNotSupportedDialog", "showResult", "showSuccessDialog", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNfcActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NfcActivity.kt\nnashid/verify/sdk/ui/NfcActivity\n+ 2 ComponentCallbackExt.kt\norg/koin/android/ext/android/ComponentCallbackExtKt\n*L\n1#1,751:1\n40#2,5:752\n40#2,5:757\n40#2,5:762\n*S KotlinDebug\n*F\n+ 1 NfcActivity.kt\nnashid/verify/sdk/ui/NfcActivity\n*L\n59#1:752,5\n60#1:757,5\n61#1:762,5\n*E\n"})
public final class NfcActivity
extends BaseActivity {
    @Nullable
    private ActivityWaitingForNfcBinding binding;
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy textSizeConverter$delegate;
    @NotNull
    private final Lazy scanDocumentViewModel$delegate;
    @Nullable
    private NfcAdapter mNfcAdapter;
    @Nullable
    private PendingIntent pendingIntent;
    private NfcLayoutAndTextSize nfcLayoutAndTextSize;
    @Nullable
    private Dialog errorDialog;
    @Nullable
    private Dialog progressDialog;
    private boolean isActivityRunning;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private TextView progressText;
    private int maxRetryCount;
    @NotNull
    private final ActivityResultLauncher<Intent> someActivityResultLauncher;
    public static final int $stable = 8;

    public NfcActivity() {
        ComponentCallbacks $this$inject_u24default$iv = (ComponentCallbacks)this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.viewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<NFCViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NFCViewModel invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = AndroidKoinScopeExtKt.getKoinScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(NFCViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.textSizeConverter$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<TextSizeConverter>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TextSizeConverter invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = AndroidKoinScopeExtKt.getKoinScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(TextSizeConverter.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.scanDocumentViewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ScanDocumentViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ScanDocumentViewModel invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = AndroidKoinScopeExtKt.getKoinScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ScanDocumentViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        this.someActivityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> NfcActivity.someActivityResultLauncher$lambda$7(this, arg_0));
    }

    private final NFCViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (NFCViewModel)((Object)lazy.getValue());
    }

    private final TextSizeConverter getTextSizeConverter() {
        Lazy lazy = this.textSizeConverter$delegate;
        return (TextSizeConverter)lazy.getValue();
    }

    private final ScanDocumentViewModel getScanDocumentViewModel() {
        Lazy lazy = this.scanDocumentViewModel$delegate;
        return (ScanDocumentViewModel)((Object)lazy.getValue());
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityWaitingForNfcBinding activityWaitingForNfcBinding = this.binding = ActivityWaitingForNfcBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNull((Object)activityWaitingForNfcBinding);
        this.setContentView((View)activityWaitingForNfcBinding.getRoot());
        this.initView();
        this.backPress();
    }

    private final void initView() {
        this.isActivityRunning = true;
        this.handleIntentData();
        TextSizeConverter textSizeConverter = this.getTextSizeConverter();
        ActivityWaitingForNfcBinding activityWaitingForNfcBinding = this.binding;
        Intrinsics.checkNotNull((Object)activityWaitingForNfcBinding);
        this.nfcLayoutAndTextSize = new NfcLayoutAndTextSize(textSizeConverter, activityWaitingForNfcBinding, (Activity)this, this.getStorage(), this.getViewModel(), this.getScanDocumentViewModel());
        NfcLayoutAndTextSize nfcLayoutAndTextSize = this.nfcLayoutAndTextSize;
        if (nfcLayoutAndTextSize == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nfcLayoutAndTextSize");
            nfcLayoutAndTextSize = null;
        }
        nfcLayoutAndTextSize.setLayoutAndTextSize();
        this.setOtherViews();
        this.handleInternetConnection();
        this.setObservable();
    }

    private final void setObservable() {
        Function1 function1 = (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean skipNFC) {
                NfcLayoutAndTextSize nfcLayoutAndTextSize = NfcActivity.access$getNfcLayoutAndTextSize$p(this.this$0);
                if (nfcLayoutAndTextSize == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nfcLayoutAndTextSize");
                    nfcLayoutAndTextSize = null;
                }
                nfcLayoutAndTextSize.handleSkipNFC(skipNFC);
            }
        };
        this.getViewModel().getNfcLiveData().getSkipNFC().observe((LifecycleOwner)this, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        function1 = (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean isAvailable) {
                NfcActivity.access$handleInternetConnectionData(this.this$0, isAvailable);
            }
        };
        this.getViewModel().getNfcLiveData().isInternetAvailable().observe((LifecycleOwner)this, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int progress) {
                this.this$0.setMRTDProgressBarPercentage(progress);
            }
        };
        this.getViewModel().getNfcLiveData().getMrtdPercentage().observe((LifecycleOwner)this, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable String message) {
                NfcActivity.access$showError(this.this$0, message);
            }
        };
        this.getViewModel().getNfcLiveData().getShowError().observe((LifecycleOwner)this, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean isDisplaying) {
                NfcActivity.access$displayResult(this.this$0, isDisplaying);
            }
        };
        this.getViewModel().getNfcLiveData().getShowResult().observe((LifecycleOwner)this, new /* invalid duplicate definition of identical inner class */);
        function1 = setObservable.6.INSTANCE;
        this.getScanDocumentViewModel().getResult().observeForever(new /* invalid duplicate definition of identical inner class */);
    }

    private final void handleInternetConnectionData(boolean isAvailable) {
        this.getLogger().log("handleInternetConnectionData: " + isAvailable);
        if (!isAvailable) {
            ErrorUtility.Companion.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
        }
    }

    private final void handleInternetConnection() {
        this.getLogger().log("handleInternetConnection: ");
        this.getViewModel().setInternetConnection(this.isInternetAvailable());
        if (Intrinsics.areEqual((Object)true, (Object)this.getViewModel().getNfcLiveData().isInternetAvailable().getValue())) {
            this.getViewModel().setIsApiCalled(true);
            this.initAdapter();
            if (this.errorDialog != null) {
                Dialog dialog = this.errorDialog;
                Intrinsics.checkNotNull((Object)dialog);
                dialog.dismiss();
            }
            if (this.progressDialog != null) {
                Dialog dialog = this.progressDialog;
                Intrinsics.checkNotNull((Object)dialog);
                dialog.dismiss();
            }
            this.getViewModel().validateUser();
        }
    }

    public void onNewIntent(@NotNull Intent intent) {
        Tag tagFromIntent;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.getLogger().log("onNewIntent: ");
        TagProvider.closeTag();
        Tag tag = tagFromIntent = Build.VERSION.SDK_INT >= 33 ? (Tag)intent.getParcelableExtra("android.nfc.extra.TAG", Tag.class) : (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (tagFromIntent != null) {
            TagProvider.setTag(IsoDep.get((Tag)tagFromIntent));
        }
        System.out.println((Object)"Got new intent!");
        if (this.errorDialog != null) {
            Dialog dialog = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
        if (this.progressDialog != null) {
            Dialog dialog = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
        this.readPassport(tagFromIntent);
    }

    private final void readPassport(Tag tagFromIntent) {
        if (Intrinsics.areEqual((Object)true, (Object)this.getViewModel().getNfcLiveData().isApiCalled().getValue())) {
            this.showDialog();
            if (StringsKt.equals((String)((String)Objects.requireNonNull(this.getViewModel().getNfcLiveData().getSelectedDoc().getValue())), (String)this.getString(R.string.e_passport), (boolean)true)) {
                this.getViewModel().readPassportNfc(tagFromIntent);
            } else {
                this.getLogger().log("readPassport: ");
                Object object = this.getViewModel().getNfcLiveData().getPassportNumber().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((CharSequence)object).length() > 0) {
                    Object object2 = this.getViewModel().getNfcLiveData().getDateOfExpiration().getValue();
                    Intrinsics.checkNotNull((Object)object2);
                    if (((CharSequence)object2).length() > 0) {
                        Object object3 = this.getViewModel().getNfcLiveData().getDateOfBirth().getValue();
                        Intrinsics.checkNotNull((Object)object3);
                        if (((CharSequence)object3).length() > 0) {
                            this.getLogger().log("readPassport: tag found");
                            if (TagProvider.getTag() != null) {
                                BACKeySpec bacKey = new BACKey((String)this.getViewModel().getNfcLiveData().getPassportNumber().getValue(), (String)this.getViewModel().getNfcLiveData().getDateOfBirth().getValue(), (String)this.getViewModel().getNfcLiveData().getDateOfExpiration().getValue());
                                this.getLogger().log("readPassport: " + bacKey);
                                this.getViewModel().cancelNfcRead();
                                NFCViewModel nFCViewModel = this.getViewModel();
                                IsoDep isoDep = TagProvider.getTag();
                                Intrinsics.checkNotNullExpressionValue((Object)isoDep, (String)"getTag(...)");
                                nFCViewModel.readData(isoDep, bacKey);
                            }
                        }
                    }
                }
            }
        }
    }

    private final void showDialog() {
        if (this.isActivityRunning) {
            Dialog dialog = this.progressDialog = new Dialog((Context)this);
            Intrinsics.checkNotNull((Object)dialog);
            dialog.requestWindowFeature(1);
            Dialog dialog2 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog2);
            BottomSheetDialogBinding bottomSheetDialogBinding = BottomSheetDialogBinding.inflate(dialog2.getLayoutInflater());
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetDialogBinding, (String)"inflate(...)");
            BottomSheetDialogBinding binding = bottomSheetDialogBinding;
            Dialog dialog3 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog3);
            dialog3.setContentView((View)binding.getRoot());
            if (StringsKt.equals((String)this.getStorage().getPreferredLocale(), (String)"ar", (boolean)true)) {
                binding.progressBar.setRotation(180.0f);
            }
            this.progressBar = binding.progressBar;
            this.progressText = binding.txtDialogPercentage;
            int padding = this.getTextSizeConverter().getPaddingOrMarginValue(16);
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding);
            ViewGroup.LayoutParams layoutParams2 = binding.progressBar.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(200);
            layoutParams2.height = -2;
            binding.progressBar.setLayoutParams(layoutParams2);
            ViewGroup.LayoutParams layoutParams = binding.progressBar.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams)layoutParams;
            layoutParams3.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(8), 0, 0);
            binding.progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            binding.txtDialogPercentage.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
            binding.txtScanning.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(20));
            binding.txtDialogDesc.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
            ViewGroup.LayoutParams layoutParams4 = binding.txtScanning.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams4, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams3 = (LinearLayout.LayoutParams)layoutParams4;
            layoutParams3.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(24), 0, 0);
            binding.txtScanning.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            ViewGroup.LayoutParams layoutParams5 = binding.txtDialogDesc.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams5, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams3 = (LinearLayout.LayoutParams)layoutParams5;
            layoutParams3.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, this.getTextSizeConverter().getPaddingOrMarginValue(28));
            binding.txtDialogDesc.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            if (StringsKt.equals((String)((String)Objects.requireNonNull(this.getViewModel().getNfcLiveData().getSelectedDoc().getValue())), (String)this.getString(R.string.e_passport), (boolean)true)) {
                binding.txtDialogDesc.setText((CharSequence)this.getString(R.string.dialog_dontmove_pass));
            } else {
                binding.txtDialogDesc.setText((CharSequence)this.getString(R.string.dialog_dontmove));
            }
            Dialog dialog4 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog4);
            dialog4.show();
            Dialog dialog5 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog5);
            dialog5.setCancelable(false);
            Dialog dialog6 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog6);
            Window window = dialog6.getWindow();
            Intrinsics.checkNotNull((Object)window);
            window.setLayout(-1, -2);
            Dialog dialog7 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog7);
            Window window2 = dialog7.getWindow();
            Intrinsics.checkNotNull((Object)window2);
            window2.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            Dialog dialog8 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog8);
            Intrinsics.checkNotNull((Object)dialog8.getWindow());
            dialog8.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
            Dialog dialog9 = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog9);
            Window window3 = dialog9.getWindow();
            Intrinsics.checkNotNull((Object)window3);
            window3.setGravity(80);
        }
    }

    private final void showError(String message) {
        Log.d((String)"NfcActivity", (String)("showError: " + message));
        if (message != null) {
            this.runOnUiThread(() -> NfcActivity.showError$lambda$0(message, this));
        }
    }

    private final void displayResult(boolean isDisplaying) {
        Log.d((String)"NfcActivity", (String)("displayResult: " + isDisplaying));
        if (isDisplaying) {
            this.showResult();
        }
    }

    private final void showResult() {
        NfcLayoutAndTextSize nfcLayoutAndTextSize = this.nfcLayoutAndTextSize;
        if (nfcLayoutAndTextSize == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nfcLayoutAndTextSize");
            nfcLayoutAndTextSize = null;
        }
        nfcLayoutAndTextSize.storeNFCData();
        if (this.progressDialog != null) {
            Dialog dialog = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
        this.setMRTDProgressBarPercentage(96);
        this.setMRTDProgressBarPercentage(100);
        if (this.progressBar != null) {
            ProgressBar progressBar = this.progressBar;
            Intrinsics.checkNotNull((Object)progressBar);
            progressBar.setProgressTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)((Context)this), (int)R.color.progress_complete)));
        }
        this.showSuccessDialog();
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setMRTDProgressBarPercentage(int progress) {
        Log.d((String)"NfcActivity", (String)("setMRTDProgressBarPercentage: " + progress));
        if (progress != 0) {
            this.runOnUiThread(() -> NfcActivity.setMRTDProgressBarPercentage$lambda$1(this, progress));
        }
    }

    private final void showSuccessDialog() {
        if (this.isActivityRunning) {
            Dialog dialog = new Dialog((Context)this);
            dialog.requestWindowFeature(1);
            DialogSuccessBinding dialogSuccessBinding = DialogSuccessBinding.inflate(dialog.getLayoutInflater());
            Intrinsics.checkNotNullExpressionValue((Object)dialogSuccessBinding, (String)"inflate(...)");
            DialogSuccessBinding binding = dialogSuccessBinding;
            dialog.setContentView((View)binding.getRoot());
            int padding = this.getTextSizeConverter().getPaddingOrMarginValue(16);
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding);
            ViewGroup.LayoutParams layoutParams2 = binding.imgScanComplete.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(56);
            layoutParams2.height = this.getTextSizeConverter().getHeight(56);
            binding.imgScanComplete.setLayoutParams(layoutParams2);
            ViewGroup.LayoutParams layoutParams = binding.imgScanComplete.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams)layoutParams;
            layoutParams3.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(8), 0, 0);
            binding.imgScanComplete.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            binding.txtScanCompleted.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(24));
            ViewGroup.LayoutParams layoutParams4 = binding.txtScanCompleted.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams4, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams3 = (LinearLayout.LayoutParams)layoutParams4;
            layoutParams3.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, this.getTextSizeConverter().getPaddingOrMarginValue(28));
            binding.txtScanCompleted.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            binding.imgScanComplete.playAnimation();
            binding.imgScanComplete.setAnimation(R.raw.scan_completed);
            binding.imgScanComplete.addAnimatorListener((Animator.AnimatorListener)new AnimatorListenerAdapter(dialog, this){
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ NfcActivity this$0;
                {
                    this.$dialog = $dialog;
                    this.this$0 = $receiver;
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    super.onAnimationEnd(animation);
                    this.$dialog.dismiss();
                    TagProvider.closeTag();
                    NfcActivity.access$dismissDialog(this.this$0);
                    NfcActivity.access$getViewModel(this.this$0).validateLivensUser();
                }
            });
            dialog.show();
            dialog.setCancelable(false);
            Window window = dialog.getWindow();
            if (window != null) {
                window.setLayout(-1, -2);
            }
            Window window2 = dialog.getWindow();
            Intrinsics.checkNotNull((Object)window2);
            window2.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            Intrinsics.checkNotNull((Object)dialog.getWindow());
            dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
            Window window3 = dialog.getWindow();
            Intrinsics.checkNotNull((Object)window3);
            window3.setGravity(80);
        }
    }

    private final void showFailureDialog(String message) {
        if (this.isActivityRunning) {
            if (this.errorDialog != null) {
                Dialog dialog = this.errorDialog;
                Intrinsics.checkNotNull((Object)dialog);
                dialog.dismiss();
            }
            if (Intrinsics.areEqual((Object)true, (Object)this.getViewModel().getNfcLiveData().getSkipNFC().getValue())) {
                Object object = this.getViewModel().getNfcLiveData().getMaxTry().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (this.maxRetryCount >= ((Number)object).intValue()) {
                    Integer n = (Integer)this.getViewModel().getNfcLiveData().getMaxTry().getValue();
                    if (n == null || n != 0) {
                        OtherConstant.Companion.getInstance().setSkipNFC(true);
                        this.dismissDialog();
                        this.getViewModel().validateLivensUser();
                    }
                }
            }
            ++this.maxRetryCount;
            Dialog dialog = this.errorDialog = new Dialog((Context)this);
            Intrinsics.checkNotNull((Object)dialog);
            dialog.requestWindowFeature(1);
            Dialog dialog2 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog2);
            DialogFailureNfcBinding dialogFailureNfcBinding = DialogFailureNfcBinding.inflate(dialog2.getLayoutInflater());
            Intrinsics.checkNotNullExpressionValue((Object)dialogFailureNfcBinding, (String)"inflate(...)");
            DialogFailureNfcBinding binding = dialogFailureNfcBinding;
            Dialog dialog3 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog3);
            dialog3.setContentView((View)binding.getRoot());
            int padding = this.getTextSizeConverter().getPaddingOrMarginValue(16);
            binding.mainDialogLyt.setPadding(padding, padding, padding, padding);
            ViewGroup.LayoutParams layoutParams2 = binding.imgScanFailure.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(56);
            layoutParams2.height = this.getTextSizeConverter().getHeight(56);
            binding.imgScanFailure.setLayoutParams(layoutParams2);
            layoutParams2 = binding.imgInfo1.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(20);
            layoutParams2.height = this.getTextSizeConverter().getHeight(20);
            binding.imgInfo1.setLayoutParams(layoutParams2);
            layoutParams2 = binding.imgNfcFailed.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(145);
            layoutParams2.height = this.getTextSizeConverter().getHeight(145);
            binding.imgNfcFailed.setLayoutParams(layoutParams2);
            ViewGroup.LayoutParams layoutParams = binding.imgNfcFailed.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams layoutParams1 = (LinearLayout.LayoutParams)layoutParams;
            layoutParams1.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(24), 0, this.getTextSizeConverter().getPaddingOrMarginValue(18));
            binding.imgNfcFailed.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
            layoutParams2 = binding.imgInfo2.getLayoutParams();
            layoutParams2.width = this.getTextSizeConverter().getWidth(20);
            layoutParams2.height = this.getTextSizeConverter().getHeight(20);
            binding.imgInfo2.setLayoutParams(layoutParams2);
            ViewGroup.LayoutParams layoutParams3 = binding.imgScanFailure.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams layoutParams4 = (LinearLayout.LayoutParams)layoutParams3;
            layoutParams4.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(8), 0, 0);
            binding.imgScanFailure.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            binding.txtScanCompleted.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(20));
            ViewGroup.LayoutParams layoutParams5 = binding.txtScanCompleted.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams5, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams5;
            layoutParams4.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(24), 0, 0);
            binding.txtScanCompleted.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            binding.txtScanNotCompleteDesc1.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
            ViewGroup.LayoutParams layoutParams6 = binding.txtScanNotCompleteDesc1.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams6, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams6;
            layoutParams4.setMargins(this.getTextSizeConverter().getPaddingOrMarginValue(6), this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, 0);
            binding.txtScanNotCompleteDesc1.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            binding.txtScanNotCompleteDesc2.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
            binding.imgNfcFailed.playAnimation();
            binding.imgNfcFailed.setRepeatCount(-1);
            binding.imgNfcFailed.setAnimation(R.raw.nfc_read_failed);
            if (StringsKt.equals((String)message, (String)"card", (boolean)true)) {
                binding.txtScanCompleted.setVisibility(8);
                binding.imgNfcFailed.setVisibility(8);
                binding.txtScanNotCompleteDesc1.setText((CharSequence)this.getResources().getString(R.string.mrz_wrong));
            } else if (StringsKt.equals((String)((String)Objects.requireNonNull(this.getViewModel().getNfcLiveData().getSelectedDoc().getValue())), (String)this.getString(R.string.e_passport), (boolean)true)) {
                binding.txtScanNotCompleteDesc1.setText((CharSequence)this.getResources().getString(R.string.passport_scan_not_complete_desc));
            } else {
                binding.txtScanNotCompleteDesc1.setText((CharSequence)this.getResources().getString(R.string.scan_not_complete_desc2));
            }
            ViewGroup.LayoutParams layoutParams7 = binding.txtScanNotCompleteDesc2.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams7, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams7;
            layoutParams4.setMargins(this.getTextSizeConverter().getPaddingOrMarginValue(6), this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, 0);
            binding.txtScanNotCompleteDesc2.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            ViewGroup.LayoutParams layoutParams8 = binding.imgInfo1.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams8, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams8;
            layoutParams4.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, 0);
            binding.imgInfo1.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            ViewGroup.LayoutParams layoutParams9 = binding.imgInfo2.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams9, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams9;
            layoutParams4.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, 0);
            binding.imgInfo2.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            ViewGroup.LayoutParams layoutParams10 = binding.btnRetry.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams10, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            layoutParams4 = (LinearLayout.LayoutParams)layoutParams10;
            layoutParams4.setMargins(0, this.getTextSizeConverter().getPaddingOrMarginValue(16), 0, this.getTextSizeConverter().getPaddingOrMarginValue(12));
            binding.btnRetry.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
            padding = this.getTextSizeConverter().getPaddingOrMarginValue(12);
            binding.txtBtnRetry.setPadding(0, padding, 0, padding);
            binding.btnRetry.setRadius((float)this.getTextSizeConverter().calculateRadius(8));
            binding.txtBtnRetry.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
            binding.btnRetry.setOnClickListener(arg_0 -> NfcActivity.showFailureDialog$lambda$2(this, arg_0));
            Dialog dialog4 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog4);
            dialog4.show();
            Dialog dialog5 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog5);
            dialog5.setCancelable(false);
            Dialog dialog6 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog6);
            Window window = dialog6.getWindow();
            Intrinsics.checkNotNull((Object)window);
            window.setLayout(-1, -2);
            Dialog dialog7 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog7);
            Window window2 = dialog7.getWindow();
            Intrinsics.checkNotNull((Object)window2);
            window2.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            Dialog dialog8 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog8);
            Intrinsics.checkNotNull((Object)dialog8.getWindow());
            dialog8.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
            Dialog dialog9 = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog9);
            Window window3 = dialog9.getWindow();
            Intrinsics.checkNotNull((Object)window3);
            window3.setGravity(80);
            if (this.progressDialog != null) {
                Dialog dialog10 = this.progressDialog;
                Intrinsics.checkNotNull((Object)dialog10);
                dialog10.dismiss();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void initAdapter() {
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)((Context)this));
        if (this.mNfcAdapter != null) {
            NfcAdapter nfcAdapter = this.mNfcAdapter;
            Intrinsics.checkNotNull((Object)nfcAdapter);
            if (nfcAdapter.isEnabled()) {
                PendingIntent pendingIntent;
                if (Build.VERSION.SDK_INT >= 23) {
                    Intent intent = new Intent((Context)this, this.getClass()).addFlags(0x20000000);
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"addFlags(...)");
                    Intent intent2 = intent;
                    pendingIntent = PendingIntent.getActivity((Context)((Context)this), (int)0, (Intent)intent2, (int)0x2000000);
                } else {
                    pendingIntent = PendingIntent.getActivity((Context)((Context)this), (int)0, (Intent)new Intent((Context)this, this.getClass()).addFlags(0x20000000), (int)0);
                }
                this.pendingIntent = pendingIntent;
                return;
            }
        }
        if (this.mNfcAdapter != null) {
            NfcAdapter nfcAdapter = this.mNfcAdapter;
            Intrinsics.checkNotNull((Object)nfcAdapter);
            if (!nfcAdapter.isEnabled()) {
                this.showNfcNotEnabledDialog();
                return;
            }
        }
        this.showNfcNotSupportedDialog();
    }

    private final void showNfcNotSupportedDialog() {
        block0: {
            ActivityWaitingForNfcBinding activityWaitingForNfcBinding;
            ActivityWaitingForNfcBinding activityWaitingForNfcBinding2 = this.binding;
            if (activityWaitingForNfcBinding2 == null) break block0;
            ActivityWaitingForNfcBinding $this$showNfcNotSupportedDialog_u24lambda_u244 = activityWaitingForNfcBinding = activityWaitingForNfcBinding2;
            boolean bl = false;
            $this$showNfcNotSupportedDialog_u24lambda_u244.nfcDialogTurnon.mainDialogLyt.setVisibility(0);
            $this$showNfcNotSupportedDialog_u24lambda_u244.nfcDialogTurnon.lyoutError1.setVisibility(0);
            $this$showNfcNotSupportedDialog_u24lambda_u244.nfcDialogTurnon.txtScanNotCompleteDesc1.setText((CharSequence)this.getString(R.string.nfc_not_supported_desc));
            $this$showNfcNotSupportedDialog_u24lambda_u244.nfcDialogTurnon.txtBtnRetry.setText((CharSequence)this.getString(R.string.nfc_not_enabled_btn_ok));
            $this$showNfcNotSupportedDialog_u24lambda_u244.nfcDialogTurnon.btnRetry.setOnClickListener(arg_0 -> NfcActivity.showNfcNotSupportedDialog$lambda$4$lambda$3($this$showNfcNotSupportedDialog_u24lambda_u244, arg_0));
        }
    }

    private final void showNfcNotEnabledDialog() {
        block0: {
            ActivityWaitingForNfcBinding activityWaitingForNfcBinding;
            ActivityWaitingForNfcBinding activityWaitingForNfcBinding2 = this.binding;
            if (activityWaitingForNfcBinding2 == null) break block0;
            ActivityWaitingForNfcBinding $this$showNfcNotEnabledDialog_u24lambda_u246 = activityWaitingForNfcBinding = activityWaitingForNfcBinding2;
            boolean bl = false;
            $this$showNfcNotEnabledDialog_u24lambda_u246.nfcDialogTurnon.mainDialogLyt.setVisibility(0);
            $this$showNfcNotEnabledDialog_u24lambda_u246.nfcDialogTurnon.btnRetry.setOnClickListener(arg_0 -> NfcActivity.showNfcNotEnabledDialog$lambda$6$lambda$5(this, $this$showNfcNotEnabledDialog_u24lambda_u246, arg_0));
        }
    }

    private final void setOtherViews() {
        ActivityWaitingForNfcBinding activityWaitingForNfcBinding = this.binding;
        Intrinsics.checkNotNull((Object)activityWaitingForNfcBinding);
        activityWaitingForNfcBinding.layoutHeader.imgBack.setOnClickListener(arg_0 -> NfcActivity.setOtherViews$lambda$8(this, arg_0));
        try {
            Matrix matrix = new Matrix();
            matrix.postRotate(90.0f);
            byte[] byArray = Utility.Companion.getInstance().getScannedImage();
            byte[] byArray2 = Utility.Companion.getInstance().getScannedImage();
            Intrinsics.checkNotNull((Object)byArray2);
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray2.length);
            Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)bmp, (int)2048, (int)2048, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(...)");
            Bitmap scaledBitmap = bitmap;
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
            Bitmap rotatedBitmap = bitmap2;
            ImageView image = (ImageView)this.findViewById(R.id.imageview);
            image.setImageBitmap(rotatedBitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActivityWaitingForNfcBinding activityWaitingForNfcBinding2 = this.binding;
        Intrinsics.checkNotNull((Object)activityWaitingForNfcBinding2);
        activityWaitingForNfcBinding2.txtSkip.setOnClickListener(arg_0 -> NfcActivity.setOtherViews$lambda$9(this, arg_0));
    }

    private final void dismissDialog() {
        if (this.errorDialog != null) {
            Dialog dialog = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
        if (this.progressDialog != null) {
            Dialog dialog = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
    }

    private final void handleIntentData() {
        String selectedDoc;
        if (this.getIntent().hasExtra(this.getString(R.string.doc_key)) && (selectedDoc = this.getIntent().getStringExtra(this.getString(R.string.doc_key))) != null) {
            this.getViewModel().setSelectedDoc(selectedDoc);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mNfcAdapter != null) {
            NfcAdapter nfcAdapter = this.mNfcAdapter;
            Intrinsics.checkNotNull((Object)nfcAdapter);
            nfcAdapter.disableForegroundDispatch((Activity)this);
        }
        if (this.isFinishing()) {
            this.isActivityRunning = false;
            this.getViewModel().cancelNfcRead();
            if (this.progressDialog != null) {
                Dialog dialog = this.progressDialog;
                Intrinsics.checkNotNull((Object)dialog);
                if (dialog.isShowing()) {
                    Dialog dialog2 = this.progressDialog;
                    Intrinsics.checkNotNull((Object)dialog2);
                    dialog2.dismiss();
                }
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (this.mNfcAdapter != null && this.pendingIntent != null) {
                NfcAdapter nfcAdapter = this.mNfcAdapter;
                Intrinsics.checkNotNull((Object)nfcAdapter);
                nfcAdapter.enableForegroundDispatch((Activity)this, this.pendingIntent, null, null);
            }
        }
        catch (Exception e) {
            System.out.println((Object)"onResume error");
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ErrorUtility.Companion.getInstance().unregisterConnectivityManager((Activity)this);
        CompositeDisposable disposable = this.getViewModel().getDisposable();
        if (!disposable.isDisposed()) {
            disposable.dispose();
            disposable.clear();
        }
        this.isActivityRunning = false;
        this.getViewModel().cancelNfcRead();
        this.getViewModel().getNfcLiveData().resetState();
    }

    protected void onStop() {
        super.onStop();
        this.isActivityRunning = false;
        this.getViewModel().cancelNfcRead();
    }

    private final void backPress() {
        OnBackPressedDispatcherKt.addCallback$default((OnBackPressedDispatcher)this.getOnBackPressedDispatcher(), (LifecycleOwner)((LifecycleOwner)this), (boolean)false, (Function1)((Function1)new Function1<OnBackPressedCallback, Unit>(this){
            final /* synthetic */ NfcActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OnBackPressedCallback $this$addCallback) {
                Intrinsics.checkNotNullParameter((Object)$this$addCallback, (String)"$this$addCallback");
                ActivityWaitingForNfcBinding activityWaitingForNfcBinding = NfcActivity.access$getBinding$p(this.this$0);
                Intrinsics.checkNotNull((Object)activityWaitingForNfcBinding);
                if (activityWaitingForNfcBinding.customLoader.getRoot().getVisibility() != 0) {
                    NfcActivity.access$openBackPressDialog(this.this$0);
                }
            }
        }), (int)2, null);
    }

    private final void openBackPressDialog() {
        Dialog dialog = new Dialog((Context)this);
        dialog.requestWindowFeature(1);
        DialogEmailPhoneConfirmationBinding dialogEmailPhoneConfirmationBinding = DialogEmailPhoneConfirmationBinding.inflate(dialog.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)dialogEmailPhoneConfirmationBinding, (String)"inflate(...)");
        DialogEmailPhoneConfirmationBinding binding = dialogEmailPhoneConfirmationBinding;
        dialog.setContentView((View)binding.getRoot());
        ViewGroup.LayoutParams layoutParams = binding.dialogHeader.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)layoutParams;
        int padding = this.getTextSizeConverter().getPaddingOrMarginValue(16);
        layoutParams2.setMargins(padding, padding, padding, 0);
        binding.dialogHeader.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        ViewGroup.LayoutParams layoutParams22 = binding.cardConfirmation.getLayoutParams();
        layoutParams22.width = this.getTextSizeConverter().getWidth(280);
        binding.cardConfirmation.setLayoutParams(layoutParams22);
        binding.cardConfirmation.setRadius((float)this.getTextSizeConverter().calculateRadius(14));
        binding.dialogHeader.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(18));
        binding.dialogSubtitle.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(14));
        binding.btnNo.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
        binding.btnYes.setTextSize(0, (float)this.getTextSizeConverter().getTextSize(16));
        ViewGroup.LayoutParams layoutParams3 = binding.dialogSubtitle.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams2 = (LinearLayout.LayoutParams)layoutParams3;
        layoutParams2.setMargins(padding, padding, padding, padding);
        binding.dialogSubtitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        padding = this.getTextSizeConverter().getPaddingOrMarginValue(12);
        ViewGroup.LayoutParams layoutParams4 = binding.btnNo.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams4, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams2 = (LinearLayout.LayoutParams)layoutParams4;
        layoutParams2.setMargins(0, padding, 0, padding);
        binding.btnNo.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        ViewGroup.LayoutParams layoutParams5 = binding.btnYes.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams5, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams2 = (LinearLayout.LayoutParams)layoutParams5;
        layoutParams2.setMargins(this.getTextSizeConverter().getPaddingOrMarginValue(24), padding, this.getTextSizeConverter().getPaddingOrMarginValue(16), padding);
        binding.btnYes.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        binding.dialogHeader.setTypeface(ResourcesCompat.getFont((Context)this.getApplicationContext(), (int)R.font.pingmedium));
        binding.dialogSubtitle.setTypeface(ResourcesCompat.getFont((Context)this.getApplicationContext(), (int)R.font.regular));
        binding.dialogHeader.setText((CharSequence)this.getString(R.string.back_dialog_header));
        binding.dialogSubtitle.setText((CharSequence)this.getString(R.string.back_dialog_title));
        binding.btnYes.setOnClickListener(arg_0 -> NfcActivity.openBackPressDialog$lambda$10(dialog, this, arg_0));
        binding.btnNo.setOnClickListener(arg_0 -> NfcActivity.openBackPressDialog$lambda$11(dialog, arg_0));
        dialog.show();
        dialog.setCancelable(false);
        Window window = dialog.getWindow();
        Intrinsics.checkNotNull((Object)window);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        Intrinsics.checkNotNull((Object)dialog.getWindow());
        dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
    }

    private static final void showError$lambda$0(String $message, NfcActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.d((String)"TAG", (String)("showError: " + $message));
        this$0.showFailureDialog($message);
    }

    private static final void setMRTDProgressBarPercentage$lambda$1(NfcActivity this$0, int $progress) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.progressBar != null && this$0.progressText != null) {
            ProgressBar progressBar = this$0.progressBar;
            Intrinsics.checkNotNull((Object)progressBar);
            progressBar.setProgress($progress);
            TextView textView = this$0.progressText;
            Intrinsics.checkNotNull((Object)textView);
            textView.setText((CharSequence)($progress + "%"));
        }
    }

    private static final void showFailureDialog$lambda$2(NfcActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Dialog dialog = this$0.errorDialog;
        Intrinsics.checkNotNull((Object)dialog);
        dialog.dismiss();
        Dialog dialog2 = this$0.progressDialog;
        Intrinsics.checkNotNull((Object)dialog2);
        dialog2.dismiss();
        this$0.getViewModel().cancelNfcRead();
    }

    private static final void showNfcNotSupportedDialog$lambda$4$lambda$3(ActivityWaitingForNfcBinding $this_apply, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        $this_apply.nfcDialogTurnon.mainDialogLyt.setVisibility(8);
    }

    private static final void showNfcNotEnabledDialog$lambda$6$lambda$5(NfcActivity this$0, ActivityWaitingForNfcBinding $this_apply, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intent nfcIntent = new Intent("android.settings.NFC_SETTINGS");
        this$0.someActivityResultLauncher.launch((Object)nfcIntent);
        $this_apply.nfcDialogTurnon.mainDialogLyt.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void someActivityResultLauncher$lambda$7(NfcActivity this$0, ActivityResult result2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (result2.getResultCode() != -1) return;
        this$0.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)((Context)this$0));
        if (this$0.mNfcAdapter != null) {
            NfcAdapter nfcAdapter = this$0.mNfcAdapter;
            Intrinsics.checkNotNull((Object)nfcAdapter);
            if (nfcAdapter.isEnabled()) {
                PendingIntent pendingIntent;
                if (Build.VERSION.SDK_INT >= 23) {
                    Intent intent = new Intent((Context)this$0, this$0.getClass()).addFlags(0x20000000);
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"addFlags(...)");
                    Intent intent2 = intent;
                    pendingIntent = PendingIntent.getActivity((Context)((Context)this$0), (int)0, (Intent)intent2, (int)0x2000000);
                } else {
                    pendingIntent = PendingIntent.getActivity((Context)((Context)this$0), (int)0, (Intent)new Intent((Context)this$0, this$0.getClass()).addFlags(0x20000000), (int)0);
                }
                this$0.pendingIntent = pendingIntent;
                return;
            }
        }
        if (this$0.mNfcAdapter != null) {
            NfcAdapter nfcAdapter = this$0.mNfcAdapter;
            Intrinsics.checkNotNull((Object)nfcAdapter);
            if (!nfcAdapter.isEnabled()) {
                this$0.showNfcNotEnabledDialog();
                return;
            }
        }
        this$0.showNfcNotSupportedDialog();
    }

    private static final void setOtherViews$lambda$8(NfcActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getOnBackPressedDispatcher().onBackPressed();
    }

    private static final void setOtherViews$lambda$9(NfcActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OtherConstant.Companion.getInstance().setSkipNFC(true);
        this$0.dismissDialog();
        this$0.getViewModel().validateLivensUser();
    }

    private static final void openBackPressDialog$lambda$10(Dialog $dialog, NfcActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $dialog.dismiss();
        this$0.finish();
    }

    private static final void openBackPressDialog$lambda$11(Dialog $dialog, View it) {
        Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
        $dialog.dismiss();
    }

    public static final /* synthetic */ NfcLayoutAndTextSize access$getNfcLayoutAndTextSize$p(NfcActivity $this) {
        return $this.nfcLayoutAndTextSize;
    }

    public static final /* synthetic */ void access$handleInternetConnectionData(NfcActivity $this, boolean isAvailable) {
        $this.handleInternetConnectionData(isAvailable);
    }

    public static final /* synthetic */ void access$showError(NfcActivity $this, String message) {
        $this.showError(message);
    }

    public static final /* synthetic */ void access$displayResult(NfcActivity $this, boolean isDisplaying) {
        $this.displayResult(isDisplaying);
    }

    public static final /* synthetic */ void access$dismissDialog(NfcActivity $this) {
        $this.dismissDialog();
    }

    public static final /* synthetic */ NFCViewModel access$getViewModel(NfcActivity $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ ActivityWaitingForNfcBinding access$getBinding$p(NfcActivity $this) {
        return $this.binding;
    }

    public static final /* synthetic */ void access$openBackPressDialog(NfcActivity $this) {
        $this.openBackPressDialog();
    }
}

