/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nashid.verify.sdk.utils.EACCredentials;
import nashid.verify.sdk.utils.FeatureStatus;
import nashid.verify.sdk.utils.MRTDTrustStore;
import nashid.verify.sdk.utils.PassportNfcUtils;
import nashid.verify.sdk.utils.VerificationStatus;
import nashid.verify.sdk.utils.helpers.JMRTDSecurityProvider;
import net.sf.scuba.smartcards.CardServiceException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jmrtd.AccessKeySpec;
import org.jmrtd.BACKey;
import org.jmrtd.BACKeySpec;
import org.jmrtd.PACEKeySpec;
import org.jmrtd.PassportService;
import org.jmrtd.Util;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;
import org.jmrtd.lds.AbstractLDSFile;
import org.jmrtd.lds.AbstractTaggedLDSFile;
import org.jmrtd.lds.ActiveAuthenticationInfo;
import org.jmrtd.lds.CVCAFile;
import org.jmrtd.lds.CardAccessFile;
import org.jmrtd.lds.ChipAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import org.jmrtd.lds.LDSFileUtil;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.lds.SODFile;
import org.jmrtd.lds.SecurityInfo;
import org.jmrtd.lds.icao.COMFile;
import org.jmrtd.lds.icao.DG11File;
import org.jmrtd.lds.icao.DG12File;
import org.jmrtd.lds.icao.DG14File;
import org.jmrtd.lds.icao.DG15File;
import org.jmrtd.lds.icao.DG1File;
import org.jmrtd.lds.icao.DG2File;
import org.jmrtd.lds.icao.DG3File;
import org.jmrtd.lds.icao.DG5File;
import org.jmrtd.lds.icao.DG7File;
import org.jmrtd.lds.icao.MRZInfo;
import org.jmrtd.protocol.AAResult;
import org.jmrtd.protocol.BACResult;
import org.jmrtd.protocol.EACCAResult;
import org.jmrtd.protocol.EACTAResult;
import org.jmrtd.protocol.PACEResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00a0\u00012\u00020\u0001:\u0002\u00a0\u0001B)\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010d\u001a\u00020e2\b\u0010f\u001a\u0004\u0018\u00010gH\u0002J\u0018\u0010h\u001a\u00020i2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J2\u0010j\u001a\b\u0012\u0004\u0012\u00020l0k2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010Y\u001a\u0004\u0018\u00010XH\u0002JJ\u0010m\u001a\b\u0012\u0004\u0012\u00020n0k2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010o\u001a\u0004\u0018\u00010p2\b\u0010q\u001a\u0004\u0018\u00010l2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s0kH\u0002J \u0010t\u001a\u00020p2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020E2\b\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020xH\u0002J\u0018\u0010z\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010{\u001a\u0004\u0018\u00010|2\u0006\u0010}\u001a\u00020\tH\u0002J\u0018\u0010~\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u007f\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0080\u0001\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0081\u0001\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0082\u0001\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0083\u0001\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0084\u0001\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0085\u0001\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\u0086\u0001\u001a\u0002052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0087\u0001\u001a\u0004\u0018\u00010:2\u0007\u0010\u0088\u0001\u001a\u00020EH\u0002J\u0018\u0010Z\u001a\u00020X2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J+\u0010\u0089\u0001\u001a\u00020e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010Y\u001a\u0004\u0018\u00010XJ\u001d\u0010\u008a\u0001\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010k2\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001H\u0002J\u0016\u0010\u008d\u0001\u001a\u00030\u008e\u00012\n\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0090\u0001H\u0002J\n\u0010\u0091\u0001\u001a\u00030\u008e\u0001H\u0002J;\u0010\u0091\u0001\u001a\u00020e2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010E2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010E2\u0007\u0010\u0095\u0001\u001a\u00020x2\u0007\u0010\u0096\u0001\u001a\u00020xH\u0002J\n\u0010\u0097\u0001\u001a\u00030\u008e\u0001H\u0002J\n\u0010\u0098\u0001\u001a\u00030\u008e\u0001H\u0002J\n\u0010\u0099\u0001\u001a\u00030\u008e\u0001H\u0002J\u0015\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020\tH\u0002J,\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020\t2\u0015\u0010\u009d\u0001\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0005\u0012\u00030\u009b\u00010\u009e\u0001H\u0002J\u0007\u0010\u009f\u0001\u001a\u00020aR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\f\u001a\u0004\u0018\u00010\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\f\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\"\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\f\u001a\u0004\u0018\u00010)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\"\u0010.\u001a\u0004\u0018\u00010-2\b\u0010\f\u001a\u0004\u0018\u00010-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\"\u00102\u001a\u0004\u0018\u0001012\b\u0010\f\u001a\u0004\u0018\u000101@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\"\u00106\u001a\u0004\u0018\u0001052\b\u0010\f\u001a\u0004\u0018\u000105@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010;\u001a\u0004\u0018\u00010<2\b\u0010;\u001a\u0004\u0018\u00010<@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0010\u0010A\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0011\u0010J\u001a\u00020K\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010P\u001a\u0004\u0018\u00010EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010G\"\u0004\bR\u0010IR\u000e\u0010S\u001a\u00020TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010Y\u001a\u0004\u0018\u00010X2\b\u0010\f\u001a\u0004\u0018\u00010X@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u0011\u0010`\u001a\u00020a\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010c\u00a8\u0006\u00a1\u0001"}, d2={"Lnashid/verify/sdk/utils/PassportNFC;", "", "ps", "Lorg/jmrtd/PassportService;", "trustManager", "Lnashid/verify/sdk/utils/MRTDTrustStore;", "mrzInfo", "Lorg/jmrtd/lds/icao/MRZInfo;", "maxBlockSize", "", "(Lorg/jmrtd/PassportService;Lnashid/verify/sdk/utils/MRTDTrustStore;Lorg/jmrtd/lds/icao/MRZInfo;I)V", "()V", "<set-?>", "Lorg/jmrtd/lds/icao/COMFile;", "comFile", "getComFile", "()Lorg/jmrtd/lds/icao/COMFile;", "Lorg/jmrtd/lds/CVCAFile;", "cvcaFile", "getCvcaFile", "()Lorg/jmrtd/lds/CVCAFile;", "Lorg/jmrtd/lds/icao/DG11File;", "dg11File", "getDg11File", "()Lorg/jmrtd/lds/icao/DG11File;", "Lorg/jmrtd/lds/icao/DG12File;", "dg12File", "getDg12File", "()Lorg/jmrtd/lds/icao/DG12File;", "Lorg/jmrtd/lds/icao/DG14File;", "dg14File", "getDg14File", "()Lorg/jmrtd/lds/icao/DG14File;", "Lorg/jmrtd/lds/icao/DG15File;", "dg15File", "getDg15File", "()Lorg/jmrtd/lds/icao/DG15File;", "Lorg/jmrtd/lds/icao/DG1File;", "dg1File", "getDg1File", "()Lorg/jmrtd/lds/icao/DG1File;", "Lorg/jmrtd/lds/icao/DG2File;", "dg2File", "getDg2File", "()Lorg/jmrtd/lds/icao/DG2File;", "Lorg/jmrtd/lds/icao/DG3File;", "dg3File", "getDg3File", "()Lorg/jmrtd/lds/icao/DG3File;", "Lorg/jmrtd/lds/icao/DG5File;", "dg5File", "getDg5File", "()Lorg/jmrtd/lds/icao/DG5File;", "Lorg/jmrtd/lds/icao/DG7File;", "dg7File", "getDg7File", "()Lorg/jmrtd/lds/icao/DG7File;", "digest", "Ljava/security/MessageDigest;", "docSigningPrivateKey", "Ljava/security/PrivateKey;", "getDocSigningPrivateKey", "()Ljava/security/PrivateKey;", "setDocSigningPrivateKey", "(Ljava/security/PrivateKey;)V", "ecdsaAADigest", "ecdsaAASignature", "Ljava/security/Signature;", "ecdsaPublicKey", "", "getEcdsaPublicKey", "()Ljava/lang/String;", "setEcdsaPublicKey", "(Ljava/lang/String;)V", "features", "Lnashid/verify/sdk/utils/FeatureStatus;", "getFeatures", "()Lnashid/verify/sdk/utils/FeatureStatus;", "random", "Ljava/util/Random;", "rasPublicKey", "getRasPublicKey", "setRasPublicKey", "rsaAACipher", "Ljavax/crypto/Cipher;", "rsaAADigest", "rsaAASignature", "service", "Lorg/jmrtd/lds/SODFile;", "sodFile", "getSodFile", "()Lorg/jmrtd/lds/SODFile;", "getTrustManager", "()Lnashid/verify/sdk/utils/MRTDTrustStore;", "setTrustManager", "(Lnashid/verify/sdk/utils/MRTDTrustStore;)V", "verificationStatus", "Lnashid/verify/sdk/utils/VerificationStatus;", "getVerificationStatus", "()Lnashid/verify/sdk/utils/VerificationStatus;", "checkDocSignature", "", "docSigningCert", "Ljava/security/cert/Certificate;", "doBAC", "Lorg/jmrtd/protocol/BACResult;", "doEACCA", "", "Lorg/jmrtd/protocol/EACCAResult;", "doEACTA", "Lorg/jmrtd/protocol/EACTAResult;", "paceResult", "Lorg/jmrtd/protocol/PACEResult;", "eaccaResult", "cvcaKeyStores", "Ljava/security/KeyStore;", "doPACE", "findSaltRsapss", "digestEncryptionAlgorithm", "eContent", "", "signature", "getCVCAFile", "getDG", "Lorg/jmrtd/lds/AbstractTaggedLDSFile;", "dg", "getDG11File", "getDG12File", "getDG14File", "getDG15File", "getDG1File", "getDG2File", "getDG3File", "getDG5File", "getDG7File", "getDigest", "digestAlgorithm", "isChipAuthenticationInfoAvailable", "toDataGroupList", "tagList", "", "updateCOMSODFile", "", "newCertificate", "Ljava/security/cert/X509Certificate;", "verifyAA", "publicKey", "Ljava/security/PublicKey;", "signatureAlgorithm", "challenge", "response", "verifyCS", "verifyDS", "verifyHT", "verifyHash", "Lnashid/verify/sdk/utils/VerificationStatus$HashMatchResult;", "dgNumber", "hashResults", "", "verifySecurity", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPassportNFC.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PassportNFC.kt\nnashid/verify/sdk/utils/PassportNFC\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1543:1\n1#2:1544\n*E\n"})
public final class PassportNFC {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MessageDigest digest;
    @NotNull
    private final FeatureStatus features;
    @NotNull
    private final VerificationStatus verificationStatus;
    @Nullable
    private transient Signature rsaAASignature;
    @Nullable
    private transient MessageDigest rsaAADigest;
    @NotNull
    private final transient Cipher rsaAACipher;
    @Nullable
    private transient Signature ecdsaAASignature;
    @Nullable
    private transient MessageDigest ecdsaAADigest;
    @Nullable
    private MRTDTrustStore trustManager;
    @Nullable
    private PrivateKey docSigningPrivateKey;
    @Nullable
    private PassportService service;
    @NotNull
    private final Random random;
    @Nullable
    private String rasPublicKey;
    @Nullable
    private String ecdsaPublicKey;
    @Nullable
    private COMFile comFile;
    @Nullable
    private SODFile sodFile;
    @Nullable
    private DG1File dg1File;
    @Nullable
    private DG2File dg2File;
    @Nullable
    private DG3File dg3File;
    @Nullable
    private DG5File dg5File;
    @Nullable
    private DG7File dg7File;
    @Nullable
    private DG11File dg11File;
    @Nullable
    private DG12File dg12File;
    @Nullable
    private DG14File dg14File;
    @Nullable
    private DG15File dg15File;
    @Nullable
    private CVCAFile cvcaFile;
    public static final int $stable = 8;
    private static final String TAG = PassportNFC.class.getSimpleName();
    @Nullable
    private static final Provider BC_PROVIDER = JMRTDSecurityProvider.Companion.getSpongyCastleProvider();
    @NotNull
    private static final List<BACKey> EMPTY_TRIED_BAC_ENTRY_LIST = CollectionsKt.emptyList();
    @NotNull
    private static final List<Certificate> EMPTY_CERTIFICATE_CHAIN = CollectionsKt.emptyList();
    private static final int MAX_BLOCK_SIZE = 223;
    private static final int MAX_TRANSCEIVE_LENGTH_FOR_SECURE_MESSAGING = 256;
    private static final int MAX_TRANSCEIVE_LENGTH_FOR_PACE = 256;

    private PassportNFC() throws GeneralSecurityException {
        this.features = new FeatureStatus();
        this.verificationStatus = new VerificationStatus();
        this.random = new SecureRandom();
        this.rsaAADigest = MessageDigest.getInstance("SHA1");
        this.rsaAASignature = Signature.getInstance("SHA1WithRSA/ISO9796-2", BC_PROVIDER);
        Cipher cipher = Cipher.getInstance("RSA/NONE/NoPadding");
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(...)");
        this.rsaAACipher = cipher;
        this.ecdsaAASignature = Signature.getInstance("SHA256withECDSA", BC_PROVIDER);
        this.ecdsaAADigest = MessageDigest.getInstance("SHA-256");
    }

    @NotNull
    public final FeatureStatus getFeatures() {
        return this.features;
    }

    @NotNull
    public final VerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    @Nullable
    public final MRTDTrustStore getTrustManager() {
        return this.trustManager;
    }

    public final void setTrustManager(@Nullable MRTDTrustStore mRTDTrustStore) {
        this.trustManager = mRTDTrustStore;
    }

    @Nullable
    public final PrivateKey getDocSigningPrivateKey() {
        return this.docSigningPrivateKey;
    }

    public final void setDocSigningPrivateKey(@Nullable PrivateKey docSigningPrivateKey) {
        this.docSigningPrivateKey = docSigningPrivateKey;
        this.updateCOMSODFile(null);
    }

    @Nullable
    public final String getRasPublicKey() {
        return this.rasPublicKey;
    }

    public final void setRasPublicKey(@Nullable String string2) {
        this.rasPublicKey = string2;
    }

    @Nullable
    public final String getEcdsaPublicKey() {
        return this.ecdsaPublicKey;
    }

    public final void setEcdsaPublicKey(@Nullable String string2) {
        this.ecdsaPublicKey = string2;
    }

    @Nullable
    public final COMFile getComFile() {
        return this.comFile;
    }

    @Nullable
    public final SODFile getSodFile() {
        return this.sodFile;
    }

    @Nullable
    public final DG1File getDg1File() {
        return this.dg1File;
    }

    @Nullable
    public final DG2File getDg2File() {
        return this.dg2File;
    }

    @Nullable
    public final DG3File getDg3File() {
        return this.dg3File;
    }

    @Nullable
    public final DG5File getDg5File() {
        return this.dg5File;
    }

    @Nullable
    public final DG7File getDg7File() {
        return this.dg7File;
    }

    @Nullable
    public final DG11File getDg11File() {
        return this.dg11File;
    }

    @Nullable
    public final DG12File getDg12File() {
        return this.dg12File;
    }

    @Nullable
    public final DG14File getDg14File() {
        return this.dg14File;
    }

    @Nullable
    public final DG15File getDg15File() {
        return this.dg15File;
    }

    @Nullable
    public final CVCAFile getCvcaFile() {
        return this.cvcaFile;
    }

    public PassportNFC(@Nullable PassportService ps, @NotNull MRTDTrustStore trustManager, @NotNull MRZInfo mrzInfo, int maxBlockSize) throws CardServiceException, GeneralSecurityException {
        boolean hasAA;
        boolean hasCA;
        boolean hasBAC;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        Intrinsics.checkNotNullParameter((Object)mrzInfo, (String)"mrzInfo");
        this();
        if (ps == null) {
            throw new IllegalArgumentException("Service cannot be null");
        }
        this.service = ps;
        this.trustManager = trustManager;
        boolean hasSAC = false;
        boolean isSACSucceeded = false;
        PACEResult paceResult = null;
        if (!ps.isOpen()) {
            ps.open();
        }
        try {
            try {
                Log.i((String)TAG, (String)"Inspecting card access file");
                PassportService passportService = this.service;
                Intrinsics.checkNotNull((Object)passportService, (String)"null cannot be cast to non-null type org.jmrtd.PassportService");
                CardAccessFile cardAccessFile = new CardAccessFile((InputStream)passportService.getInputStream((short)284, maxBlockSize));
                Collection securityInfos = cardAccessFile.getSecurityInfos();
                for (SecurityInfo securityInfo : securityInfos) {
                    if (!(securityInfo instanceof PACEInfo)) continue;
                    this.features.setSAC(FeatureStatus.Verdict.PRESENT);
                }
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)("DEBUG: failed to get card access file: " + e.getMessage()));
                e.printStackTrace();
            }
            boolean bl = hasSAC = this.features.hasSAC() == FeatureStatus.Verdict.PRESENT;
            if (hasSAC) {
                try {
                    paceResult = this.doPACE(ps, mrzInfo, maxBlockSize);
                    isSACSucceeded = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)"PACE failed, falling back to BAC");
                    isSACSucceeded = false;
                }
            }
            PassportService passportService = this.service;
            Intrinsics.checkNotNull((Object)passportService, (String)"null cannot be cast to non-null type org.jmrtd.PassportService");
            passportService.sendSelectApplet(isSACSucceeded);
        }
        catch (CardServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CardServiceException("Cannot open document. " + e.getMessage());
        }
        try {
            PassportService passportService = this.service;
            Intrinsics.checkNotNull((Object)passportService, (String)"null cannot be cast to non-null type org.jmrtd.PassportService");
            new COMFile((InputStream)passportService.getInputStream((short)286, maxBlockSize));
            if (isSACSucceeded) {
                this.verificationStatus.setSAC(VerificationStatus.Verdict.SUCCEEDED, "Succeeded");
                this.features.setBAC(FeatureStatus.Verdict.UNKNOWN);
                this.verificationStatus.setBAC(VerificationStatus.Verdict.NOT_CHECKED, "Using SAC, BAC not checked", EMPTY_TRIED_BAC_ENTRY_LIST);
            } else {
                this.features.setBAC(FeatureStatus.Verdict.NOT_PRESENT);
                this.verificationStatus.setBAC(VerificationStatus.Verdict.NOT_PRESENT, "Non-BAC document", EMPTY_TRIED_BAC_ENTRY_LIST);
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)("Attempt to read EF.COM before BAC failed with: " + e.getMessage()));
            this.features.setBAC(FeatureStatus.Verdict.PRESENT);
            this.verificationStatus.setBAC(VerificationStatus.Verdict.NOT_CHECKED, "BAC document", EMPTY_TRIED_BAC_ENTRY_LIST);
        }
        boolean bl = hasBAC = this.features.hasBAC() == FeatureStatus.Verdict.PRESENT;
        if (!(!hasBAC || hasSAC && isSACSucceeded)) {
            BACKey bacKey = new BACKey(mrzInfo.getDocumentNumber(), mrzInfo.getDateOfBirth(), mrzInfo.getDateOfExpiry());
            ArrayList<BACKey> triedBACEntries = new ArrayList<BACKey>();
            triedBACEntries.add(bacKey);
            try {
                PassportService passportService = this.service;
                Intrinsics.checkNotNull((Object)passportService, (String)"null cannot be cast to non-null type org.jmrtd.PassportService");
                this.doBAC(passportService, mrzInfo);
                this.verificationStatus.setBAC(VerificationStatus.Verdict.SUCCEEDED, "BAC succeeded with key " + bacKey, (List<? extends BACKey>)triedBACEntries);
            }
            catch (Exception e) {
                this.verificationStatus.setBAC(VerificationStatus.Verdict.FAILED, "BAC failed", (List<? extends BACKey>)triedBACEntries);
            }
        }
        TreeSet<Integer> dgNumbersAlreadyRead = new TreeSet<Integer>();
        try {
            this.comFile = this.getComFile(ps, maxBlockSize);
            this.sodFile = this.getSodFile(ps, maxBlockSize);
            this.dg1File = this.getDG1File(ps, maxBlockSize);
            dgNumbersAlreadyRead.add(1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Log.w((String)TAG, (String)"Could not read file");
        }
        try {
            this.dg14File = this.getDG14File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.cvcaFile = this.getCVCAFile(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList dgNumbers = new ArrayList();
        if (this.sodFile != null) {
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            dgNumbers.addAll(sODFile.getDataGroupHashes().keySet());
        } else if (this.comFile != null) {
            Log.w((String)TAG, (String)"Failed to get DG list from EF.SOd. Getting DG list from EF.COM.");
            COMFile cOMFile = this.comFile;
            Intrinsics.checkNotNull((Object)cOMFile);
            int[] tagList = cOMFile.getTagList();
            List<Integer> list = this.toDataGroupList(tagList);
            Intrinsics.checkNotNull(list);
            dgNumbers.addAll(list);
        }
        CollectionsKt.sort((List)dgNumbers);
        Log.i((String)TAG, (String)("Found DGs: " + dgNumbers));
        Map hashResults = this.verificationStatus.getHashResults();
        if (hashResults == null) {
            hashResults = new TreeMap();
        }
        if (this.sodFile != null) {
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            Map storedHashes = sODFile.getDataGroupHashes();
            for (Integer dgNumber : dgNumbers) {
                byte[] storedHash = (byte[])storedHashes.get(dgNumber);
                VerificationStatus.HashMatchResult hashResult = (VerificationStatus.HashMatchResult)hashResults.get(dgNumber);
                if (hashResult != null) continue;
                if (dgNumbersAlreadyRead.contains(dgNumber)) {
                    Intrinsics.checkNotNull((Object)dgNumber);
                    hashResult = this.verifyHash(dgNumber);
                } else {
                    Intrinsics.checkNotNull((Object)storedHash);
                    hashResult = new VerificationStatus.HashMatchResult(storedHash, null);
                }
                Intrinsics.checkNotNull((Object)dgNumber);
                VerificationStatus.HashMatchResult hashMatchResult = hashResult;
                Intrinsics.checkNotNull((Object)hashMatchResult);
                hashResults.put(dgNumber, hashMatchResult);
            }
        }
        this.verificationStatus.setHT(VerificationStatus.Verdict.UNKNOWN, this.verificationStatus.getHtReason(), hashResults);
        if (dgNumbers.contains(14)) {
            this.features.setEAC(FeatureStatus.Verdict.PRESENT);
            if (this.isChipAuthenticationInfoAvailable(ps, mrzInfo, this.dg14File, this.sodFile)) {
                this.features.setCA(FeatureStatus.Verdict.PRESENT);
            } else {
                this.features.setCA(FeatureStatus.Verdict.NOT_PRESENT);
            }
        } else {
            this.features.setEAC(FeatureStatus.Verdict.NOT_PRESENT);
            this.features.setCA(FeatureStatus.Verdict.NOT_PRESENT);
        }
        boolean bl2 = hasCA = this.features.hasCA() == FeatureStatus.Verdict.PRESENT;
        if (hasCA) {
            try {
                List<EACCAResult> eaccaResults = this.doEACCA(ps, mrzInfo, this.dg14File, this.sodFile);
                this.verificationStatus.setCA(VerificationStatus.Verdict.SUCCEEDED, "EAC succeeded", eaccaResults.get(0));
            }
            catch (Exception e) {
                this.verificationStatus.setCA(VerificationStatus.Verdict.FAILED, "CA Failed", null);
            }
        }
        boolean hasEAC = this.features.hasEAC() == FeatureStatus.Verdict.PRESENT;
        List<KeyStore> cvcaKeyStores = trustManager.getCvcaStores();
        if (hasEAC && cvcaKeyStores != null && cvcaKeyStores.size() > 0 && this.verificationStatus.getCa() == VerificationStatus.Verdict.SUCCEEDED) {
            try {
                List<EACTAResult> eactaResults = this.doEACTA(ps, mrzInfo, this.cvcaFile, paceResult, this.verificationStatus.getCaResult(), cvcaKeyStores);
                this.verificationStatus.setEAC(VerificationStatus.Verdict.SUCCEEDED, "EAC succeeded", eactaResults.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.verificationStatus.setEAC(VerificationStatus.Verdict.FAILED, "EAC Failed", null);
            }
            dgNumbersAlreadyRead.add(14);
        }
        Log.d((String)TAG, (String)("alldgnumber: " + dgNumbers));
        if (dgNumbers.contains(15)) {
            this.features.setAA(FeatureStatus.Verdict.PRESENT);
        } else {
            this.features.setAA(FeatureStatus.Verdict.NOT_PRESENT);
        }
        boolean bl3 = hasAA = this.features.hasAA() == FeatureStatus.Verdict.PRESENT;
        if (hasAA) {
            try {
                this.dg15File = this.getDG15File(ps, maxBlockSize);
                dgNumbersAlreadyRead.add(15);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.w((String)TAG, (String)"Could not read file");
            }
            catch (Exception e) {
                this.verificationStatus.setAA(VerificationStatus.Verdict.NOT_CHECKED, "Failed to read DG15");
            }
        } else {
            this.verificationStatus.setAA(VerificationStatus.Verdict.NOT_PRESENT, "AA is not supported");
        }
        try {
            this.dg2File = this.getDG2File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dg3File = this.getDG3File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dg5File = this.getDG5File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dg7File = this.getDG7File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dg11File = this.getDG11File(ps, maxBlockSize);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"dg11: ");
            e.printStackTrace();
        }
        try {
            this.dg12File = this.getDG12File(ps, maxBlockSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final VerificationStatus verifySecurity() {
        this.verifyCS();
        this.verifyDS();
        this.verifyHT();
        if (this.service != null && this.dg15File != null) {
            this.verifyAA();
        }
        return this.verificationStatus;
    }

    private final void updateCOMSODFile(X509Certificate newCertificate) {
        try {
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            String digestAlg = sODFile.getDigestAlgorithm();
            SODFile sODFile2 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile2);
            String signatureAlg = sODFile2.getDigestEncryptionAlgorithm();
            X509Certificate x509Certificate = newCertificate;
            if (x509Certificate == null) {
                SODFile sODFile3 = this.sodFile;
                Intrinsics.checkNotNull((Object)sODFile3);
                x509Certificate = sODFile3.getDocSigningCertificate();
            }
            X509Certificate cert = x509Certificate;
            SODFile sODFile4 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile4);
            byte[] signature = sODFile4.getEncryptedDigest();
            TreeMap dgHashes = new TreeMap();
            List dgFids = LDSFileUtil.getDataGroupNumbers((SODFile)this.sodFile);
            MessageDigest digest = null;
            MessageDigest messageDigest = MessageDigest.getInstance(digestAlg);
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
            digest = messageDigest;
            Iterator iterator = dgFids.iterator();
            while (iterator.hasNext()) {
                byte[] byArray;
                Integer fid;
                Integer n = fid = (Integer)iterator.next();
                int n2 = 286;
                if (n != null && n == n2) continue;
                Integer n3 = fid;
                n2 = 285;
                if (n3 != null && n3 == n2) continue;
                Integer n4 = fid;
                n2 = 284;
                if (n4 != null && n4 == n2) continue;
                Intrinsics.checkNotNull((Object)fid);
                AbstractTaggedLDSFile dg = this.getDG(fid);
                if (dg == null) {
                    Log.w((String)TAG, (String)("Could not get input stream for " + Integer.toHexString(fid)));
                    continue;
                }
                byte tag = dg.getEncoded()[0];
                Map map = dgHashes;
                Integer n5 = LDSFileUtil.lookupDataGroupNumberByTag((int)tag);
                Intrinsics.checkNotNullExpressionValue((Object)digest.digest(dg.getEncoded()), (String)"digest(...)");
                map.put(n5, byArray);
                COMFile cOMFile = this.comFile;
                Intrinsics.checkNotNull((Object)cOMFile);
                cOMFile.insertTag(Integer.valueOf(tag & 0xFF));
            }
            this.sodFile = this.docSigningPrivateKey != null ? new SODFile(digestAlg, signatureAlg, (Map)dgHashes, this.docSigningPrivateKey, cert) : new SODFile(digestAlg, signatureAlg, (Map)dgHashes, signature, cert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void verifyAA() {
        if (this.dg15File == null || this.service == null) {
            this.verificationStatus.setAA(VerificationStatus.Verdict.FAILED, "AA failed");
            return;
        }
        try {
            DG15File dG15File = this.dg15File;
            Intrinsics.checkNotNull((Object)dG15File);
            PublicKey pubKey = dG15File.getPublicKey();
            String pubKeyAlgorithm = pubKey.getAlgorithm();
            String digestAlgorithm = "SHA1";
            String signatureAlgorithm = "SHA1WithRSA/ISO9796-2";
            if (Intrinsics.areEqual((Object)"EC", (Object)pubKeyAlgorithm) || Intrinsics.areEqual((Object)"ECDSA", (Object)pubKeyAlgorithm)) {
                ArrayList<SecurityInfo> activeAuthenticationInfoList = new ArrayList<SecurityInfo>();
                DG14File dG14File = this.dg14File;
                Intrinsics.checkNotNull((Object)dG14File);
                Collection securityInfos = dG14File.getSecurityInfos();
                for (SecurityInfo securityInfo : securityInfos) {
                    if (!(securityInfo instanceof ActiveAuthenticationInfo)) continue;
                    activeAuthenticationInfoList.add(securityInfo);
                }
                int activeAuthenticationInfoCount = activeAuthenticationInfoList.size();
                if (activeAuthenticationInfoCount < 1) {
                    this.verificationStatus.setAA(VerificationStatus.Verdict.FAILED, "Found no active authentication info in EF.DG14");
                    return;
                }
                if (activeAuthenticationInfoCount > 1) {
                    Log.w((String)TAG, (String)("Found " + activeAuthenticationInfoCount + " in EF.DG14, expected 1."));
                }
                Object e = activeAuthenticationInfoList.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                ActiveAuthenticationInfo activeAuthenticationInfo = (ActiveAuthenticationInfo)e;
                String signatureAlgorithmOID = activeAuthenticationInfo.getSignatureAlgorithmOID();
                String string2 = ActiveAuthenticationInfo.lookupMnemonicByOID((String)signatureAlgorithmOID);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lookupMnemonicByOID(...)");
                signatureAlgorithm = string2;
                String string3 = Util.inferDigestAlgorithmFromSignatureAlgorithm((String)signatureAlgorithm);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inferDigestAlgorithmFromSignatureAlgorithm(...)");
                digestAlgorithm = string3;
            }
            int challengeLength = 8;
            byte[] challenge = new byte[challengeLength];
            this.random.nextBytes(challenge);
            PassportService passportService = this.service;
            Intrinsics.checkNotNull((Object)passportService, (String)"null cannot be cast to non-null type org.jmrtd.PassportService");
            DG15File dG15File2 = this.dg15File;
            Intrinsics.checkNotNull((Object)dG15File2);
            PublicKey publicKey = dG15File2.getPublicKey();
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            String string4 = sODFile.getDigestAlgorithm();
            SODFile sODFile2 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile2);
            AAResult aaResult = passportService.doAA(publicKey, string4, sODFile2.getSignerInfoDigestAlgorithm(), challenge);
            Intrinsics.checkNotNull((Object)pubKey);
            byte[] byArray = aaResult.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getResponse(...)");
            if (this.verifyAA(pubKey, digestAlgorithm, signatureAlgorithm, challenge, byArray)) {
                this.verificationStatus.setAA(VerificationStatus.Verdict.SUCCEEDED, "AA succeeded");
            } else {
                this.verificationStatus.setAA(VerificationStatus.Verdict.FAILED, "AA failed due to signature failure");
            }
        }
        catch (CardServiceException cse) {
            cse.printStackTrace();
            this.verificationStatus.setAA(VerificationStatus.Verdict.FAILED, "AA failed due to exception");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.verificationStatus.setAA(VerificationStatus.Verdict.FAILED, "AA failed due to exception");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyAA(PublicKey publicKey, String digestAlgorithm, String signatureAlgorithm, byte[] challenge, byte[] response) throws CardServiceException {
        try {
            block18: {
                ECPublicKey ecdsaPublicKey;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                String pubKeyAlgorithm = publicKey.getAlgorithm();
                                if (Intrinsics.areEqual((Object)"RSA", (Object)pubKeyAlgorithm)) {
                                    MessageDigest messageDigest;
                                    String string2;
                                    String string3 = digestAlgorithm;
                                    if (string3 == null) {
                                        string3 = "null";
                                    }
                                    if ((string2 = signatureAlgorithm) == null) {
                                        string2 = "null";
                                    }
                                    Log.w((String)TAG, (String)("Unexpected algorithms for RSA AA: digest algorithm = " + string3 + ", signature algorithm = " + string2));
                                    PassportNFC passportNFC = this;
                                    String string4 = digestAlgorithm;
                                    if (string4 != null) {
                                        void it;
                                        String string5 = string4;
                                        PassportNFC passportNFC2 = passportNFC;
                                        boolean bl = false;
                                        messageDigest = MessageDigest.getInstance((String)it);
                                        passportNFC = passportNFC2;
                                    } else {
                                        messageDigest = null;
                                    }
                                    passportNFC.rsaAADigest = messageDigest;
                                    this.rsaAASignature = Signature.getInstance(signatureAlgorithm, BC_PROVIDER);
                                    Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                                    RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                                    this.rasPublicKey = rsaPublicKey.toString();
                                    this.rsaAACipher.init(2, rsaPublicKey);
                                    Signature signature = this.rsaAASignature;
                                    Intrinsics.checkNotNull((Object)signature);
                                    signature.initVerify(rsaPublicKey);
                                    MessageDigest messageDigest2 = this.rsaAADigest;
                                    Intrinsics.checkNotNull((Object)messageDigest2);
                                    int digestLength = messageDigest2.getDigestLength();
                                    if (digestLength != 20) {
                                        throw new AssertionError();
                                    }
                                    byte[] plaintext = this.rsaAACipher.doFinal(response);
                                    byte[] m1 = Util.recoverMessage((int)digestLength, (byte[])plaintext);
                                    Signature signature2 = this.rsaAASignature;
                                    Intrinsics.checkNotNull((Object)signature2);
                                    signature2.update(m1);
                                    Signature signature3 = this.rsaAASignature;
                                    Intrinsics.checkNotNull((Object)signature3);
                                    signature3.update(challenge);
                                    Signature signature4 = this.rsaAASignature;
                                    Intrinsics.checkNotNull((Object)signature4);
                                    return signature4.verify(response);
                                }
                                if (!Intrinsics.areEqual((Object)"EC", (Object)pubKeyAlgorithm) && !Intrinsics.areEqual((Object)"ECDSA", (Object)pubKeyAlgorithm)) break block18;
                                Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                                ecdsaPublicKey = (ECPublicKey)publicKey;
                                this.ecdsaPublicKey = ecdsaPublicKey.toString();
                                if (this.ecdsaAASignature == null) break block19;
                                if (signatureAlgorithm == null) break block20;
                                Signature signature = this.ecdsaAASignature;
                                Intrinsics.checkNotNull((Object)signature);
                                if (Intrinsics.areEqual((Object)signatureAlgorithm, (Object)signature.getAlgorithm())) break block20;
                            }
                            String string6 = signatureAlgorithm;
                            Intrinsics.checkNotNull((Object)string6);
                            Log.w((String)TAG, (String)("Re-initializing ecdsaAASignature with signature algorithm " + string6));
                            this.ecdsaAASignature = Signature.getInstance(signatureAlgorithm);
                        }
                        if (this.ecdsaAADigest == null) break block21;
                        if (digestAlgorithm == null) break block22;
                        MessageDigest messageDigest = this.ecdsaAADigest;
                        Intrinsics.checkNotNull((Object)messageDigest);
                        if (Intrinsics.areEqual((Object)digestAlgorithm, (Object)messageDigest.getAlgorithm())) break block22;
                    }
                    String string7 = digestAlgorithm;
                    Intrinsics.checkNotNull((Object)string7);
                    Log.w((String)TAG, (String)("Re-initializing ecdsaAADigest with digest algorithm " + string7));
                    this.ecdsaAADigest = MessageDigest.getInstance(digestAlgorithm);
                }
                Signature signature = this.ecdsaAASignature;
                Intrinsics.checkNotNull((Object)signature);
                signature.initVerify(ecdsaPublicKey);
                if (response.length % 2 != 0) {
                    Log.w((String)TAG, (String)"Active Authentication response is not of even length");
                }
                int l = response.length / 2;
                BigInteger r = Util.os2i((byte[])response, (int)0, (int)l);
                BigInteger s = Util.os2i((byte[])response, (int)l, (int)l);
                Signature signature5 = this.ecdsaAASignature;
                Intrinsics.checkNotNull((Object)signature5);
                signature5.update(challenge);
                try {
                    ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{new ASN1Integer(r), new ASN1Integer(s)};
                    DERSequence asn1Sequence = new DERSequence(aSN1EncodableArray);
                    Signature signature6 = this.ecdsaAASignature;
                    Intrinsics.checkNotNull((Object)signature6);
                    return signature6.verify(asn1Sequence.getEncoded());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        catch (IllegalArgumentException iae) {
            throw new CardServiceException(iae.toString());
        }
        catch (GeneralSecurityException iae) {
            throw new CardServiceException(iae.toString());
        }
    }

    private final void verifyDS() {
        try {
            this.verificationStatus.setDS(VerificationStatus.Verdict.UNKNOWN, "Unknown");
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            X509Certificate docSigningCert = sODFile.getDocSigningCertificate();
            if (docSigningCert == null) {
                Log.w((String)TAG, (String)"Could not get document signer certificate from EF.SOd");
            }
            if (this.checkDocSignature(docSigningCert)) {
                this.verificationStatus.setDS(VerificationStatus.Verdict.SUCCEEDED, "Signature checked");
            } else {
                this.verificationStatus.setDS(VerificationStatus.Verdict.FAILED, "Signature incorrect");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            this.verificationStatus.setDS(VerificationStatus.Verdict.FAILED, "Unsupported signature algorithm");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.verificationStatus.setDS(VerificationStatus.Verdict.FAILED, "Unexpected exception");
            return;
        }
    }

    private final void verifyCS() {
        try {
            Set<TrustAnchor> cscaTrustAnchors;
            List<CertStore> cscaStores;
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            if (this.sodFile == null) {
                this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "Unable to build certificate chain", (List<? extends Certificate>)chain);
                return;
            }
            X509Certificate docSigningCertificate = null;
            X500Principal sodIssuer = null;
            BigInteger sodSerialNumber = null;
            try {
                SODFile sODFile = this.sodFile;
                Intrinsics.checkNotNull((Object)sODFile);
                sodIssuer = sODFile.getIssuerX500Principal();
                SODFile sODFile2 = this.sodFile;
                Intrinsics.checkNotNull((Object)sODFile2);
                sodSerialNumber = sODFile2.getSerialNumber();
                SODFile sODFile3 = this.sodFile;
                Intrinsics.checkNotNull((Object)sODFile3);
                docSigningCertificate = sODFile3.getDocSigningCertificate();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Error getting document signing certificate: " + e.getMessage()));
            }
            if (docSigningCertificate != null) {
                chain.add(docSigningCertificate);
            } else {
                Log.w((String)TAG, (String)"Error getting document signing certificate from EF.SOd");
            }
            MRTDTrustStore mRTDTrustStore = this.trustManager;
            List<CertStore> list = cscaStores = mRTDTrustStore != null ? mRTDTrustStore.getCscaStores() : null;
            if (cscaStores == null || cscaStores.size() <= 0) {
                Log.w((String)TAG, (String)"No CSCA certificate stores found.");
                this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "No CSCA certificate stores found", (List<? extends Certificate>)chain);
            }
            MRTDTrustStore mRTDTrustStore2 = this.trustManager;
            Set<TrustAnchor> set = cscaTrustAnchors = mRTDTrustStore2 != null ? mRTDTrustStore2.getCscaAnchors() : null;
            if (cscaTrustAnchors == null || cscaTrustAnchors.size() <= 0) {
                Log.w((String)TAG, (String)"No CSCA trust anchors found.");
                this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "No CSCA trust anchors found", (List<? extends Certificate>)chain);
            }
            if (docSigningCertificate != null) {
                X500Principal docIssuer = docSigningCertificate.getIssuerX500Principal();
                BigInteger docSerialNumber = docSigningCertificate.getSerialNumber();
                if (sodSerialNumber != null && !Intrinsics.areEqual((Object)sodSerialNumber, (Object)docSerialNumber)) {
                    Log.w((String)TAG, (String)"Security object serial number is different from embedded DS certificate serial number!");
                }
            }
            X500Principal x500Principal = sodIssuer;
            Intrinsics.checkNotNull((Object)x500Principal);
            BigInteger bigInteger = sodSerialNumber;
            Intrinsics.checkNotNull((Object)bigInteger);
            List<CertStore> list2 = cscaStores;
            Intrinsics.checkNotNull(list2);
            Set<TrustAnchor> set2 = cscaTrustAnchors;
            Intrinsics.checkNotNull(set2);
            List<Certificate> pkixChain = PassportNfcUtils.INSTANCE.getCertificateChain(docSigningCertificate, x500Principal, bigInteger, list2, set2);
            if (pkixChain == null) {
                this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "Could not build chain to trust anchor (pkixChain == null)", (List<? extends Certificate>)chain);
                return;
            }
            for (Certificate certificate : pkixChain) {
                if (Intrinsics.areEqual((Object)certificate, (Object)docSigningCertificate)) continue;
                chain.add(certificate);
            }
            int chainDepth = chain.size();
            if (chainDepth <= 1) {
                this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "Could not build chain to trust anchor", (List<? extends Certificate>)chain);
                return;
            }
            if (chainDepth > 1 && this.verificationStatus.getCs() == VerificationStatus.Verdict.UNKNOWN) {
                this.verificationStatus.setCS(VerificationStatus.Verdict.SUCCEEDED, "Found a chain to a trust anchor", (List<? extends Certificate>)chain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.verificationStatus.setCS(VerificationStatus.Verdict.FAILED, "Signature failed", EMPTY_CERTIFICATE_CHAIN);
        }
    }

    private final void verifyHT() {
        Map hashResults = this.verificationStatus.getHashResults();
        if (hashResults == null) {
            hashResults = new TreeMap();
        }
        if (this.sodFile == null) {
            this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "No SOd", hashResults);
            return;
        }
        SODFile sODFile = this.sodFile;
        Intrinsics.checkNotNull((Object)sODFile);
        Map storedHashes = sODFile.getDataGroupHashes();
        for (Integer dgNumber : storedHashes.keySet()) {
            Intrinsics.checkNotNull((Object)dgNumber);
            this.verifyHash(dgNumber, hashResults);
        }
        if (this.verificationStatus.getHt() == VerificationStatus.Verdict.UNKNOWN) {
            this.verificationStatus.setHT(VerificationStatus.Verdict.SUCCEEDED, "All hashes match", hashResults);
        } else {
            VerificationStatus.Verdict verdict = this.verificationStatus.getHt();
            Intrinsics.checkNotNull((Object)((Object)verdict));
            this.verificationStatus.setHT(verdict, this.verificationStatus.getHtReason(), hashResults);
        }
    }

    private final VerificationStatus.HashMatchResult verifyHash(int dgNumber) {
        Map hashResults = this.verificationStatus.getHashResults();
        if (hashResults == null) {
            hashResults = new TreeMap();
        }
        return this.verifyHash(dgNumber, hashResults);
    }

    private final VerificationStatus.HashMatchResult verifyHash(int dgNumber, Map<Integer, VerificationStatus.HashMatchResult> hashResults) {
        short fid = LDSFileUtil.lookupFIDByTag((int)LDSFileUtil.lookupTagByDataGroupNumber((int)dgNumber));
        byte[] storedHash = null;
        try {
            SODFile sODFile = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile);
            Map storedHashes = sODFile.getDataGroupHashes();
            storedHash = (byte[])storedHashes.get(dgNumber);
        }
        catch (Exception e) {
            this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "DG" + dgNumber + " failed, could not get stored hash", hashResults);
            return null;
        }
        SODFile sODFile = this.sodFile;
        Intrinsics.checkNotNull((Object)sODFile);
        String digestAlgorithm = sODFile.getDigestAlgorithm();
        try {
            Intrinsics.checkNotNull((Object)digestAlgorithm);
            this.digest = this.getDigest(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "Unsupported algorithm \"" + digestAlgorithm + "\"", null);
            return null;
        }
        byte[] dgBytes = null;
        try {
            AbstractTaggedLDSFile abstractTaggedLDSFile = this.getDG(fid);
            if (abstractTaggedLDSFile != null) {
                dgBytes = abstractTaggedLDSFile.getEncoded();
            }
            if (abstractTaggedLDSFile == null && this.verificationStatus.getEac() != VerificationStatus.Verdict.SUCCEEDED && (fid == 259 || fid == 260)) {
                Log.w((String)TAG, (String)("Skipping DG" + dgNumber + " during HT verification because EAC failed."));
                Intrinsics.checkNotNull((Object)storedHash);
                VerificationStatus.HashMatchResult hashResult = new VerificationStatus.HashMatchResult(storedHash, null);
                Integer n = dgNumber;
                hashResults.put(n, hashResult);
                return hashResult;
            }
            if (abstractTaggedLDSFile == null) {
                Log.w((String)TAG, (String)("Skipping DG" + dgNumber + " during HT verification because file could not be read."));
                Intrinsics.checkNotNull((Object)storedHash);
                VerificationStatus.HashMatchResult hashResult = new VerificationStatus.HashMatchResult(storedHash, null);
                Integer n = dgNumber;
                hashResults.put(n, hashResult);
                return hashResult;
            }
        }
        catch (Exception e) {
            Intrinsics.checkNotNull((Object)storedHash);
            VerificationStatus.HashMatchResult hashResult = new VerificationStatus.HashMatchResult(storedHash, null);
            Integer n = dgNumber;
            hashResults.put(n, hashResult);
            this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "DG" + dgNumber + " failed due to exception", hashResults);
            return hashResult;
        }
        try {
            MessageDigest messageDigest = this.digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            byte[] computedHash = messageDigest.digest(dgBytes);
            Intrinsics.checkNotNull((Object)storedHash);
            VerificationStatus.HashMatchResult hashResult = new VerificationStatus.HashMatchResult(storedHash, computedHash);
            Integer n = dgNumber;
            hashResults.put(n, hashResult);
            if (!Arrays.equals(storedHash, computedHash)) {
                this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "Hash mismatch", hashResults);
            }
            return hashResult;
        }
        catch (Exception ioe) {
            Intrinsics.checkNotNull((Object)storedHash);
            VerificationStatus.HashMatchResult hashResult = new VerificationStatus.HashMatchResult(storedHash, null);
            Integer n = dgNumber;
            hashResults.put(n, hashResult);
            this.verificationStatus.setHT(VerificationStatus.Verdict.FAILED, "Hash failed due to exception", hashResults);
            return hashResult;
        }
    }

    private final MessageDigest getDigest(String digestAlgorithm) throws NoSuchAlgorithmException {
        if (this.digest != null) {
            MessageDigest messageDigest = this.digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            messageDigest.reset();
            return this.digest;
        }
        Log.i((String)TAG, (String)("Using hash algorithm " + digestAlgorithm));
        this.digest = Security.getAlgorithms("MessageDigest").contains(digestAlgorithm) ? MessageDigest.getInstance(digestAlgorithm) : MessageDigest.getInstance(digestAlgorithm, BC_PROVIDER);
        return this.digest;
    }

    private final AbstractTaggedLDSFile getDG(int dg) {
        switch (dg) {
            case 1: {
                return (AbstractTaggedLDSFile)this.dg1File;
            }
            case 2: {
                return (AbstractTaggedLDSFile)this.dg2File;
            }
            case 3: {
                return (AbstractTaggedLDSFile)this.dg3File;
            }
            case 5: {
                return (AbstractTaggedLDSFile)this.dg5File;
            }
            case 7: {
                return (AbstractTaggedLDSFile)this.dg7File;
            }
            case 11: {
                return (AbstractTaggedLDSFile)this.dg11File;
            }
            case 12: {
                return (AbstractTaggedLDSFile)this.dg12File;
            }
            case 14: {
                return (AbstractTaggedLDSFile)this.dg14File;
            }
            case 15: {
                return (AbstractTaggedLDSFile)this.dg15File;
            }
        }
        return null;
    }

    private final boolean checkDocSignature(Certificate docSigningCert) throws GeneralSecurityException {
        SODFile sODFile = this.sodFile;
        Intrinsics.checkNotNull((Object)sODFile);
        byte[] eContent = sODFile.getEContent();
        SODFile sODFile2 = this.sodFile;
        Intrinsics.checkNotNull((Object)sODFile2);
        byte[] signature = sODFile2.getEncryptedDigest();
        Object digestEncryptionAlgorithm = null;
        try {
            SODFile sODFile3 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile3);
            digestEncryptionAlgorithm = sODFile3.getDigestEncryptionAlgorithm();
        }
        catch (Exception e) {
            digestEncryptionAlgorithm = null;
        }
        if (digestEncryptionAlgorithm == null) {
            SODFile sODFile4 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile4);
            String digestAlg = sODFile4.getSignerInfoDigestAlgorithm();
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance(digestAlg);
            }
            catch (Exception e) {
                digest = MessageDigest.getInstance(digestAlg, BC_PROVIDER);
            }
            MessageDigest messageDigest = digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            messageDigest.update(eContent);
            byte[] digestBytes = digest.digest();
            return Arrays.equals(digestBytes, signature);
        }
        if (Intrinsics.areEqual((Object)"SSAwithRSA/PSS", (Object)digestEncryptionAlgorithm)) {
            SODFile sODFile5 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile5);
            String digestAlg = sODFile5.getSignerInfoDigestAlgorithm();
            Intrinsics.checkNotNull((Object)digestAlg);
            digestEncryptionAlgorithm = StringsKt.replace$default((String)digestAlg, (String)"-", (String)"", (boolean)false, (int)4, null) + "withRSA/PSS";
        }
        if (Intrinsics.areEqual((Object)"RSA", (Object)digestEncryptionAlgorithm)) {
            SODFile sODFile6 = this.sodFile;
            Intrinsics.checkNotNull((Object)sODFile6);
            String digestJavaString = sODFile6.getSignerInfoDigestAlgorithm();
            Intrinsics.checkNotNull((Object)digestJavaString);
            digestEncryptionAlgorithm = StringsKt.replace$default((String)digestJavaString, (String)"-", (String)"", (boolean)false, (int)4, null) + "withRSA";
        }
        Log.i((String)TAG, (String)("digestEncryptionAlgorithm = " + (String)digestEncryptionAlgorithm));
        Signature sig = null;
        sig = Signature.getInstance((String)digestEncryptionAlgorithm, BC_PROVIDER);
        if (StringsKt.endsWith$default((String)digestEncryptionAlgorithm, (String)"withRSA/PSS", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNull((Object)eContent);
            Intrinsics.checkNotNull((Object)signature);
            int saltLength = this.findSaltRsapss((String)digestEncryptionAlgorithm, docSigningCert, eContent, signature);
            MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec("SHA-256");
            PSSParameterSpec pssParameterSpec = new PSSParameterSpec("SHA-256", "MGF1", mgf1ParameterSpec, saltLength, 1);
            Signature signature2 = sig;
            Intrinsics.checkNotNull((Object)signature2);
            signature2.setParameter(pssParameterSpec);
        }
        Signature signature3 = sig;
        Intrinsics.checkNotNull((Object)signature3);
        signature3.initVerify(docSigningCert);
        sig.update(eContent);
        return sig.verify(signature);
    }

    private final int findSaltRsapss(String digestEncryptionAlgorithm, Certificate docSigningCert, byte[] eContent, byte[] signature) {
        for (int i = 0; i < 513; ++i) {
            try {
                Signature sig = null;
                sig = Signature.getInstance(digestEncryptionAlgorithm, BC_PROVIDER);
                if (StringsKt.endsWith$default((String)digestEncryptionAlgorithm, (String)"withRSA/PSS", (boolean)false, (int)2, null)) {
                    MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec("SHA-256");
                    PSSParameterSpec pssParameterSpec = new PSSParameterSpec("SHA-256", "MGF1", mgf1ParameterSpec, i, 1);
                    Signature signature2 = sig;
                    Intrinsics.checkNotNull((Object)signature2);
                    signature2.setParameter(pssParameterSpec);
                }
                Signature signature3 = sig;
                Intrinsics.checkNotNull((Object)signature3);
                signature3.initVerify(docSigningCert);
                sig.update(eContent);
                boolean verify2 = sig.verify(signature);
                if (!verify2) continue;
                return i;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PACEResult doPACE(PassportService ps, MRZInfo mrzInfo, int maxBlockSize) throws IOException, CardServiceException, GeneralSecurityException {
        PACEResult paceResult;
        block9: {
            paceResult = null;
            InputStream isCardAccessFile = null;
            try {
                BACKey bacKey = new BACKey(mrzInfo.getDocumentNumber(), mrzInfo.getDateOfBirth(), mrzInfo.getDateOfExpiry());
                PACEKeySpec paceKeySpec = PACEKeySpec.createMRZKey((BACKeySpec)((BACKeySpec)bacKey));
                isCardAccessFile = (InputStream)ps.getInputStream((short)284, maxBlockSize);
                CardAccessFile cardAccessFile = new CardAccessFile(isCardAccessFile);
                ArrayList<SecurityInfo> paceInfos = new ArrayList<SecurityInfo>();
                for (SecurityInfo securityInfo : cardAccessFile.getSecurityInfos()) {
                    if (!(securityInfo instanceof PACEInfo)) continue;
                    paceInfos.add(securityInfo);
                }
                if (!(!((Collection)paceInfos).isEmpty())) break block9;
                for (PACEInfo pACEInfo : paceInfos) {
                    try {
                        paceResult = ps.doPACE((AccessKeySpec)paceKeySpec, pACEInfo.getObjectIdentifier(), PACEInfo.toParameterSpec((BigInteger)pACEInfo.getParameterId()), pACEInfo.getParameterId());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (isCardAccessFile != null) {
                    isCardAccessFile.close();
                    isCardAccessFile = null;
                }
            }
        }
        if (paceResult == null) {
            throw new Exception("PACE authentication failed");
        }
        return paceResult;
    }

    private final BACResult doBAC(PassportService ps, MRZInfo mrzInfo) throws CardServiceException {
        BACKey bacKey = new BACKey(mrzInfo.getDocumentNumber(), mrzInfo.getDateOfBirth(), mrzInfo.getDateOfExpiry());
        BACResult bACResult = ps.doBAC((AccessKeySpec)bacKey);
        Intrinsics.checkNotNullExpressionValue((Object)bACResult, (String)"doBAC(...)");
        return bACResult;
    }

    private final List<EACCAResult> doEACCA(PassportService ps, MRZInfo mrzInfo, DG14File dg14File, SODFile sodFile) {
        if (dg14File == null) {
            throw new NullPointerException("dg14File is null");
        }
        if (sodFile == null) {
            throw new NullPointerException("sodFile is null");
        }
        ArrayList<EACCAResult> eaccaResults = new ArrayList<EACCAResult>();
        ChipAuthenticationInfo chipAuthenticationInfo = null;
        ArrayList<SecurityInfo> chipAuthenticationPublicKeyInfos = new ArrayList<SecurityInfo>();
        Collection securityInfos = dg14File.getSecurityInfos();
        for (SecurityInfo securityInfo : securityInfos) {
            if (securityInfo instanceof ChipAuthenticationInfo) {
                chipAuthenticationInfo = (ChipAuthenticationInfo)securityInfo;
                continue;
            }
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            chipAuthenticationPublicKeyInfos.add(securityInfo);
        }
        Iterator iterator = chipAuthenticationPublicKeyInfos.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator publicKeyInfoIterator = iterator;
        while (publicKeyInfoIterator.hasNext()) {
            Object e = publicKeyInfoIterator.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ChipAuthenticationPublicKeyInfo authenticationPublicKeyInfo = (ChipAuthenticationPublicKeyInfo)e;
            try {
                Log.i((String)"EMRTD", (String)"Chip Authentication starting");
                ChipAuthenticationInfo chipAuthenticationInfo2 = chipAuthenticationInfo;
                Intrinsics.checkNotNull((Object)chipAuthenticationInfo2);
                EACCAResult doEACCA = ps.doEACCA(chipAuthenticationInfo2.getKeyId(), chipAuthenticationInfo.getObjectIdentifier(), chipAuthenticationInfo.getProtocolOIDString(), authenticationPublicKeyInfo.getSubjectPublicKey());
                eaccaResults.add(doEACCA);
            }
            catch (CardServiceException cse) {
                cse.printStackTrace();
            }
        }
        return eaccaResults;
    }

    public final boolean isChipAuthenticationInfoAvailable(@NotNull PassportService ps, @NotNull MRZInfo mrzInfo, @Nullable DG14File dg14File, @Nullable SODFile sodFile) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Intrinsics.checkNotNullParameter((Object)mrzInfo, (String)"mrzInfo");
        if (dg14File == null) {
            throw new NullPointerException("dg14File is null");
        }
        if (sodFile == null) {
            throw new NullPointerException("sodFile is null");
        }
        ArrayList<SecurityInfo> chipAuthenticationPublicKeyInfos = new ArrayList<SecurityInfo>();
        Collection securityInfos = dg14File.getSecurityInfos();
        for (SecurityInfo securityInfo : securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            chipAuthenticationPublicKeyInfos.add(securityInfo);
        }
        return !((Collection)chipAuthenticationPublicKeyInfos).isEmpty();
    }

    private final List<EACTAResult> doEACTA(PassportService ps, MRZInfo mrzInfo, CVCAFile cvcaFile, PACEResult paceResult, EACCAResult eaccaResult, List<? extends KeyStore> cvcaKeyStores) throws IOException, CardServiceException, GeneralSecurityException, IllegalArgumentException, NullPointerException {
        if (cvcaFile == null) {
            throw new NullPointerException("CVCAFile is null");
        }
        if (eaccaResult == null) {
            throw new NullPointerException("EACCAResult is null");
        }
        ArrayList<EACTAResult> eactaResults = new ArrayList<EACTAResult>();
        CVCPrincipal[] cVCPrincipalArray = new CVCPrincipal[]{cvcaFile.getCAReference(), cvcaFile.getAltCAReference()};
        for (CVCPrincipal caReference : cVCPrincipalArray) {
            EACCredentials eacCredentials;
            Intrinsics.checkNotNull((Object)caReference);
            if (PassportNfcUtils.INSTANCE.getEACCredentials(caReference, cvcaKeyStores) == null) continue;
            PrivateKey privateKey = eacCredentials.getPrivateKey();
            Certificate[] chain = eacCredentials.getChain();
            ArrayList<CardVerifiableCertificate> terminalCerts = new ArrayList<CardVerifiableCertificate>(chain.length);
            for (Certificate c : chain) {
                Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type org.jmrtd.cert.CardVerifiableCertificate");
                terminalCerts.add((CardVerifiableCertificate)c);
            }
            try {
                if (paceResult == null) {
                    EACTAResult eactaResult = ps.doEACTA(caReference, (List)terminalCerts, privateKey, null, eaccaResult, mrzInfo.getDocumentNumber());
                    eactaResults.add(eactaResult);
                    break;
                }
                EACTAResult eactaResult = ps.doEACTA(caReference, (List)terminalCerts, privateKey, null, eaccaResult, paceResult);
                eactaResults.add(eactaResult);
                break;
            }
            catch (CardServiceException cse) {
                cse.printStackTrace();
            }
        }
        return eactaResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final COMFile getComFile(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isComFile = null;
        try {
            isComFile = (InputStream)ps.getInputStream((short)286, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)286, (InputStream)isComFile);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.COMFile");
            COMFile cOMFile = (COMFile)abstractLDSFile;
            return cOMFile;
        }
        finally {
            if (isComFile != null) {
                isComFile.close();
                isComFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SODFile getSodFile(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isSodFile = null;
        try {
            isSodFile = (InputStream)ps.getInputStream((short)285, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)285, (InputStream)isSodFile);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.SODFile");
            SODFile sODFile = (SODFile)abstractLDSFile;
            return sODFile;
        }
        finally {
            if (isSodFile != null) {
                isSodFile.close();
                isSodFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG1File getDG1File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG1 = null;
        try {
            isDG1 = (InputStream)ps.getInputStream((short)257, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)257, (InputStream)isDG1);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG1File");
            DG1File dG1File = (DG1File)abstractLDSFile;
            return dG1File;
        }
        finally {
            if (isDG1 != null) {
                isDG1.close();
                isDG1 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG2File getDG2File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG2 = null;
        try {
            isDG2 = (InputStream)ps.getInputStream((short)258, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)258, (InputStream)isDG2);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG2File");
            DG2File dG2File = (DG2File)abstractLDSFile;
            return dG2File;
        }
        finally {
            if (isDG2 != null) {
                isDG2.close();
                isDG2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG3File getDG3File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG3 = null;
        try {
            isDG3 = (InputStream)ps.getInputStream((short)259, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)259, (InputStream)isDG3);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG3File");
            DG3File dG3File = (DG3File)abstractLDSFile;
            return dG3File;
        }
        finally {
            if (isDG3 != null) {
                isDG3.close();
                isDG3 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG5File getDG5File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG5 = null;
        try {
            isDG5 = (InputStream)ps.getInputStream((short)261, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)261, (InputStream)isDG5);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG5File");
            DG5File dG5File = (DG5File)abstractLDSFile;
            return dG5File;
        }
        finally {
            if (isDG5 != null) {
                isDG5.close();
                isDG5 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG7File getDG7File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG7 = null;
        try {
            isDG7 = (InputStream)ps.getInputStream((short)263, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)263, (InputStream)isDG7);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG7File");
            DG7File dG7File = (DG7File)abstractLDSFile;
            return dG7File;
        }
        finally {
            if (isDG7 != null) {
                isDG7.close();
                isDG7 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG11File getDG11File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG11 = null;
        try {
            isDG11 = (InputStream)ps.getInputStream((short)267, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)267, (InputStream)isDG11);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG11File");
            DG11File dG11File = (DG11File)abstractLDSFile;
            return dG11File;
        }
        finally {
            if (isDG11 != null) {
                isDG11.close();
                isDG11 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG12File getDG12File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG12 = null;
        try {
            isDG12 = (InputStream)ps.getInputStream((short)268, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)268, (InputStream)isDG12);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG12File");
            DG12File dG12File = (DG12File)abstractLDSFile;
            return dG12File;
        }
        finally {
            if (isDG12 != null) {
                isDG12.close();
                isDG12 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG14File getDG14File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG14 = null;
        try {
            isDG14 = (InputStream)ps.getInputStream((short)270, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)270, (InputStream)isDG14);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG14File");
            DG14File dG14File = (DG14File)abstractLDSFile;
            return dG14File;
        }
        finally {
            if (isDG14 != null) {
                isDG14.close();
                isDG14 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DG15File getDG15File(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isDG15 = null;
        try {
            isDG15 = (InputStream)ps.getInputStream((short)271, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)271, (InputStream)isDG15);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.icao.DG15File");
            DG15File dG15File = (DG15File)abstractLDSFile;
            return dG15File;
        }
        finally {
            if (isDG15 != null) {
                isDG15.close();
                isDG15 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CVCAFile getCVCAFile(PassportService ps, int maxBlockSize) throws CardServiceException, IOException {
        InputStream isEfCvCa = null;
        try {
            isEfCvCa = (InputStream)ps.getInputStream((short)284, maxBlockSize);
            AbstractLDSFile abstractLDSFile = LDSFileUtil.getLDSFile((short)284, (InputStream)isEfCvCa);
            Intrinsics.checkNotNull((Object)abstractLDSFile, (String)"null cannot be cast to non-null type org.jmrtd.lds.CVCAFile");
            CVCAFile cVCAFile = (CVCAFile)abstractLDSFile;
            return cVCAFile;
        }
        finally {
            if (isEfCvCa != null) {
                isEfCvCa.close();
                isEfCvCa = null;
            }
        }
    }

    private final List<Integer> toDataGroupList(int[] tagList) {
        if (tagList == null) {
            return null;
        }
        ArrayList<Integer> dgNumberList = new ArrayList<Integer>(tagList.length);
        for (int tag : tagList) {
            try {
                int dgNumber = LDSFileUtil.lookupDataGroupNumberByTag((int)tag);
                dgNumberList.add(dgNumber);
            }
            catch (NumberFormatException nfe) {
                Log.w((String)TAG, (String)("Could not find DG number for tag: " + Integer.toHexString(tag)));
                nfe.printStackTrace();
            }
        }
        return dgNumberList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnashid/verify/sdk/utils/PassportNFC$Companion;", "", "()V", "BC_PROVIDER", "Ljava/security/Provider;", "EMPTY_CERTIFICATE_CHAIN", "", "Ljava/security/cert/Certificate;", "EMPTY_TRIED_BAC_ENTRY_LIST", "Lorg/jmrtd/BACKey;", "MAX_BLOCK_SIZE", "", "getMAX_BLOCK_SIZE", "()I", "MAX_TRANSCEIVE_LENGTH_FOR_PACE", "getMAX_TRANSCEIVE_LENGTH_FOR_PACE", "MAX_TRANSCEIVE_LENGTH_FOR_SECURE_MESSAGING", "getMAX_TRANSCEIVE_LENGTH_FOR_SECURE_MESSAGING", "TAG", "", "kotlin.jvm.PlatformType", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_BLOCK_SIZE() {
            return MAX_BLOCK_SIZE;
        }

        public final int getMAX_TRANSCEIVE_LENGTH_FOR_SECURE_MESSAGING() {
            return MAX_TRANSCEIVE_LENGTH_FOR_SECURE_MESSAGING;
        }

        public final int getMAX_TRANSCEIVE_LENGTH_FOR_PACE() {
            return MAX_TRANSCEIVE_LENGTH_FOR_PACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

