/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.utils.EACCredentials;
import nashid.verify.sdk.utils.ImageUtil;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.DisplayedImageInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.icao.DG7File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;
import org.jmrtd.lds.icao.DG2File;
import org.jmrtd.lds.icao.DG3File;
import org.jmrtd.lds.icao.DG5File;
import org.jmrtd.lds.iso19794.FaceImageInfo;
import org.jmrtd.lds.iso19794.FaceInfo;
import org.jmrtd.lds.iso19794.FingerImageInfo;
import org.jmrtd.lds.iso19794.FingerInfo;
import org.spongycastle.jce.provider.BouncyCastleProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\tJ\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020+J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020,J \u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lnashid/verify/sdk/utils/PassportNfcUtils;", "", "()V", "IS_PKIX_REVOCATION_CHECING_ENABLED", "", "TAG", "", "kotlin.jvm.PlatformType", "getCertificateChain", "", "Ljava/security/cert/Certificate;", "docSigningCertificate", "Ljava/security/cert/X509Certificate;", "sodIssuer", "Ljavax/security/auth/x500/X500Principal;", "sodSerialNumber", "Ljava/math/BigInteger;", "cscaStores", "Ljava/security/cert/CertStore;", "cscaTrustAnchors", "", "Ljava/security/cert/TrustAnchor;", "getEACCredentials", "Lnashid/verify/sdk/utils/EACCredentials;", "caReference", "Lorg/jmrtd/cert/CVCPrincipal;", "cvcaStores", "Ljava/security/KeyStore;", "cvcaStore", "retrieveFaceImage", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "dg2File", "Lorg/jmrtd/lds/icao/DG2File;", "retrieveFingerPrintImage", "dg3File", "Lorg/jmrtd/lds/icao/DG3File;", "retrievePortraitImage", "dg5File", "Lorg/jmrtd/lds/icao/DG5File;", "retrieveSignatureImage", "dg7File", "Lnashid/verify/sdk/utils/id_card/jmrtd/lds/icao/DG7File;", "Lorg/jmrtd/lds/icao/DG7File;", "toBitmap", "imageLength", "", "inputStream", "Ljava/io/InputStream;", "mimeType", "VerifySDK_release"})
@StabilityInferred(parameters=1)
public final class PassportNfcUtils {
    @NotNull
    public static final PassportNfcUtils INSTANCE = new PassportNfcUtils();
    private static final String TAG = PassportNfcUtils.class.getSimpleName();
    private static final boolean IS_PKIX_REVOCATION_CHECING_ENABLED;
    public static final int $stable;

    private PassportNfcUtils() {
    }

    @NotNull
    public final Bitmap retrieveFaceImage(@NotNull Context context, @NotNull DG2File dg2File) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dg2File, (String)"dg2File");
        ArrayList allFaceImageInfos = new ArrayList();
        List faceInfos = dg2File.getFaceInfos();
        for (FaceInfo faceInfo : faceInfos) {
            allFaceImageInfos.addAll(faceInfo.getFaceImageInfos());
        }
        if (!allFaceImageInfos.isEmpty()) {
            Object e = allFaceImageInfos.iterator().next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FaceImageInfo faceImageInfo = (FaceImageInfo)e;
            int n = faceImageInfo.getImageLength();
            InputStream inputStream = faceImageInfo.getImageInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getImageInputStream(...)");
            String string2 = faceImageInfo.getMimeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMimeType(...)");
            return this.toBitmap(n, inputStream, string2);
        }
        throw new IOException("Unable to decodeImage Image");
    }

    @NotNull
    public final Bitmap retrievePortraitImage(@NotNull Context context, @NotNull DG5File dg5File) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dg5File, (String)"dg5File");
        List faceInfos = dg5File.getImages();
        if (!faceInfos.isEmpty()) {
            org.jmrtd.lds.DisplayedImageInfo faceImageInfo = (org.jmrtd.lds.DisplayedImageInfo)faceInfos.iterator().next();
            int n = faceImageInfo.getImageLength();
            InputStream inputStream = faceImageInfo.getImageInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getImageInputStream(...)");
            String string2 = faceImageInfo.getMimeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMimeType(...)");
            return this.toBitmap(n, inputStream, string2);
        }
        throw new IOException("Unable to decodeImage Image");
    }

    @NotNull
    public final Bitmap retrieveSignatureImage(@NotNull Context context, @NotNull org.jmrtd.lds.icao.DG7File dg7File) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dg7File, (String)"dg7File");
        List displayedImageInfos = dg7File.getImages();
        if (!displayedImageInfos.isEmpty()) {
            org.jmrtd.lds.DisplayedImageInfo displayedImageInfo = (org.jmrtd.lds.DisplayedImageInfo)displayedImageInfos.iterator().next();
            int n = displayedImageInfo.getImageLength();
            InputStream inputStream = displayedImageInfo.getImageInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getImageInputStream(...)");
            String string2 = displayedImageInfo.getMimeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMimeType(...)");
            return this.toBitmap(n, inputStream, string2);
        }
        throw new IOException("Unable to decodeImage Image");
    }

    @NotNull
    public final Bitmap retrieveSignatureImage(@NotNull Context context, @NotNull DG7File dg7File) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dg7File, (String)"dg7File");
        List<DisplayedImageInfo> displayedImageInfos = dg7File.getImages();
        if (!displayedImageInfos.isEmpty()) {
            Log.d((String)TAG, (String)"doInBackground retrieveSignatureImage: ");
            DisplayedImageInfo displayedImageInfo = displayedImageInfos.iterator().next();
            int n = displayedImageInfo.getImageLength();
            InputStream inputStream = displayedImageInfo.getImageInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getImageInputStream(...)");
            String string2 = displayedImageInfo.getMimeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMimeType(...)");
            return this.toBitmap(n, inputStream, string2);
        }
        throw new IOException("Unable to decodeImage Image");
    }

    @NotNull
    public final List<Bitmap> retrieveFingerPrintImage(@NotNull Context context, @NotNull DG3File dg3File) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dg3File, (String)"dg3File");
        ArrayList allFingerImageInfos = new ArrayList();
        List fingerInfos = dg3File.getFingerInfos();
        ArrayList<Bitmap> fingerprintsImage = new ArrayList<Bitmap>();
        for (FingerInfo fingerInfo : fingerInfos) {
            allFingerImageInfos.addAll(fingerInfo.getFingerImageInfos());
        }
        Iterator iterator = allFingerImageInfos.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FingerImageInfo fingerImageInfo = (FingerImageInfo)e;
            int n = fingerImageInfo.getImageLength();
            InputStream inputStream = fingerImageInfo.getImageInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getImageInputStream(...)");
            String string2 = fingerImageInfo.getMimeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMimeType(...)");
            Bitmap bitmap = this.toBitmap(n, inputStream, string2);
            fingerprintsImage.add(bitmap);
        }
        if (fingerprintsImage.isEmpty()) {
            throw new IOException("Unable to decodeImage Finger print Image");
        }
        return fingerprintsImage;
    }

    private final Bitmap toBitmap(int imageLength, InputStream inputStream, String mimeType) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] buffer = new byte[imageLength];
        dataInputStream.readFully(buffer, 0, imageLength);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer, 0, imageLength);
        Log.d((String)TAG, (String)"doInBackground retrieveSignatureImage:tobitmap ");
        return ImageUtil.INSTANCE.decodeImage(byteArrayInputStream, imageLength, mimeType);
    }

    @Nullable
    public final EACCredentials getEACCredentials(@NotNull CVCPrincipal caReference, @NotNull List<? extends KeyStore> cvcaStores) throws GeneralSecurityException {
        Intrinsics.checkNotNullParameter((Object)caReference, (String)"caReference");
        Intrinsics.checkNotNullParameter(cvcaStores, (String)"cvcaStores");
        for (KeyStore keyStore : cvcaStores) {
            EACCredentials eacCredentials = this.getEACCredentials(caReference, keyStore);
            if (eacCredentials == null) continue;
            return eacCredentials;
        }
        return null;
    }

    private final EACCredentials getEACCredentials(CVCPrincipal caReference, KeyStore cvcaStore) throws GeneralSecurityException {
        if (caReference == null) {
            throw new IllegalArgumentException("CA reference cannot be null");
        }
        PrivateKey privateKey = null;
        Certificate[] chain = null;
        ArrayList<String> aliases = Collections.list(cvcaStore.aliases());
        for (String alias : aliases) {
            if (cvcaStore.isKeyEntry(alias)) {
                char[] cArray = "".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                Key key = cvcaStore.getKey(alias, cArray);
                if (!(key instanceof PrivateKey)) {
                    Log.w((String)TAG, (String)("skipping non-private key " + alias));
                    continue;
                }
                privateKey = (PrivateKey)key;
                chain = cvcaStore.getCertificateChain(alias);
                Intrinsics.checkNotNull((Object)chain);
                return new EACCredentials(privateKey, chain);
            }
            if (cvcaStore.isCertificateEntry(alias)) {
                Certificate certificate = cvcaStore.getCertificate(alias);
                Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type org.jmrtd.cert.CardVerifiableCertificate");
                CardVerifiableCertificate certificate2 = (CardVerifiableCertificate)certificate;
                CVCPrincipal authRef = certificate2.getAuthorityReference();
                CVCPrincipal holderRef = certificate2.getHolderReference();
                if (!Intrinsics.areEqual((Object)caReference, (Object)authRef)) continue;
                String string2 = holderRef.getName();
                char[] cArray = "".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                Key key = cvcaStore.getKey(string2, cArray);
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
                privateKey = (PrivateKey)key;
                chain = cvcaStore.getCertificateChain(holderRef.getName());
                Log.i((String)TAG, (String)("found a key, privateKey = " + privateKey));
                Intrinsics.checkNotNull((Object)chain);
                return new EACCredentials(privateKey, chain);
            }
            if (privateKey == null || chain != null) continue;
        }
        return null;
    }

    @NotNull
    public final List<Certificate> getCertificateChain(@Nullable X509Certificate docSigningCertificate, @NotNull X500Principal sodIssuer, @NotNull BigInteger sodSerialNumber, @NotNull List<? extends CertStore> cscaStores, @NotNull Set<? extends TrustAnchor> cscaTrustAnchors) {
        Intrinsics.checkNotNullParameter((Object)sodIssuer, (String)"sodIssuer");
        Intrinsics.checkNotNullParameter((Object)sodSerialNumber, (String)"sodSerialNumber");
        Intrinsics.checkNotNullParameter(cscaStores, (String)"cscaStores");
        Intrinsics.checkNotNullParameter(cscaTrustAnchors, (String)"cscaTrustAnchors");
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        X509CertSelector selector = new X509CertSelector();
        try {
            X509Certificate x509Certificate;
            CertPath certPath;
            if (docSigningCertificate != null) {
                selector.setCertificate(docSigningCertificate);
            } else {
                selector.setIssuer(sodIssuer);
                selector.setSerialNumber(sodSerialNumber);
            }
            Intrinsics.checkNotNull((Object)docSigningCertificate, (String)"null cannot be cast to non-null type java.security.cert.Certificate");
            CollectionCertStoreParameters docStoreParams = new CollectionCertStoreParameters(SetsKt.setOf((Object)docSigningCertificate));
            CertStore docStore = CertStore.getInstance("Collection", docStoreParams);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "SC");
            PKIXBuilderParameters buildParams = new PKIXBuilderParameters(cscaTrustAnchors, (CertSelector)selector);
            buildParams.addCertStore(docStore);
            for (CertStore certStore : cscaStores) {
                buildParams.addCertStore(certStore);
            }
            buildParams.setRevocationEnabled(IS_PKIX_REVOCATION_CHECING_ENABLED);
            PKIXCertPathBuilderResult result2 = null;
            try {
                CertPathBuilderResult certPathBuilderResult = builder.build(buildParams);
                Intrinsics.checkNotNull((Object)certPathBuilderResult, (String)"null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
                result2 = (PKIXCertPathBuilderResult)certPathBuilderResult;
            }
            catch (CertPathBuilderException certPathBuilderException) {
                certPathBuilderException.printStackTrace();
            }
            if (result2 != null && (certPath = result2.getCertPath()) != null) {
                chain.addAll((Collection)certPath.getCertificates());
            }
            if (!chain.contains(docSigningCertificate)) {
                Log.w((String)TAG, (String)"Adding doc signing certificate after PKIXBuilder finished");
                chain.add(0, docSigningCertificate);
            }
            if (result2 != null && (x509Certificate = result2.getTrustAnchor().getTrustedCert()) != null && !chain.contains(x509Certificate)) {
                Log.w((String)TAG, (String)"Adding trust anchor certificate after PKIXBuilder finished");
                chain.add(x509Certificate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)("Building a chain failed (" + e.getMessage() + ")."));
        }
        return chain;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

