/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"Lnashid/verify/sdk/utils/helpers/JMRTDSecurityProvider;", "Ljava/security/Provider;", "()V", "replicateFromProvider", "", "serviceName", "", "algorithmName", "provider", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=1)
public final class JMRTDSecurityProvider
extends Provider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final long serialVersionUID;
    private static final Logger LOGGER;
    @NotNull
    private static final String SUN_PROVIDER_CLASS_NAME;
    @NotNull
    private static final String BC_PROVIDER_CLASS_NAME;
    @NotNull
    private static final String SC_PROVIDER_CLASS_NAME;
    @NotNull
    private static final BouncyCastleProvider BC_PROVIDER;
    @NotNull
    private static final org.spongycastle.jce.provider.BouncyCastleProvider SC_PROVIDER;
    @NotNull
    private static final Provider instance;

    private JMRTDSecurityProvider() {
        super("JMRTD", 0.1, "JMRTD Security Provider");
        this.put("CertificateFactory.CVC", "org.jmrtd.cert.CVCertificateFactorySpi");
        this.put("CertStore.PKD", "org.jmrtd.cert.PKDCertStoreSpi");
        this.put("CertStore.JKS", "org.jmrtd.cert.KeyStoreCertStoreSpi");
        this.put("CertStore.BKS", "org.jmrtd.cert.KeyStoreCertStoreSpi");
        this.put("CertStore.PKCS12", "org.jmrtd.cert.KeyStoreCertStoreSpi");
        if (BC_PROVIDER != null) {
            Provider provider = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider);
            this.replicateFromProvider("CertificateFactory", "X.509", provider);
            Provider provider2 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider2);
            this.replicateFromProvider("CertStore", "Collection", provider2);
            Provider provider3 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider3);
            this.replicateFromProvider("MessageDigest", "SHA1", provider3);
            Provider provider4 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider4);
            this.replicateFromProvider("Signature", "SHA1withRSA/ISO9796-2", provider4);
            Provider provider5 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider5);
            this.replicateFromProvider("Signature", "MD2withRSA", provider5);
            Provider provider6 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider6);
            this.replicateFromProvider("Signature", "MD4withRSA", provider6);
            Provider provider7 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider7);
            this.replicateFromProvider("Signature", "MD5withRSA", provider7);
            Provider provider8 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider8);
            this.replicateFromProvider("Signature", "SHA1withRSA", provider8);
            Provider provider9 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider9);
            this.replicateFromProvider("Signature", "SHA1withRSA/ISO9796-2", provider9);
            Provider provider10 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider10);
            this.replicateFromProvider("Signature", "SHA256withRSA", provider10);
            Provider provider11 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider11);
            this.replicateFromProvider("Signature", "SHA256withRSA/ISO9796-2", provider11);
            Provider provider12 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider12);
            this.replicateFromProvider("Signature", "SHA384withRSA", provider12);
            Provider provider13 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider13);
            this.replicateFromProvider("Signature", "SHA384withRSA/ISO9796-2", provider13);
            Provider provider14 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider14);
            this.replicateFromProvider("Signature", "SHA512withRSA", provider14);
            Provider provider15 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider15);
            this.replicateFromProvider("Signature", "SHA512withRSA/ISO9796-2", provider15);
            Provider provider16 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider16);
            this.replicateFromProvider("Signature", "SHA224withRSA", provider16);
            Provider provider17 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider17);
            this.replicateFromProvider("Signature", "SHA224withRSA/ISO9796-2", provider17);
            Provider provider18 = Companion.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider18);
            this.replicateFromProvider("Signature", "SHA256withRSA/PSS", provider18);
            this.put("Alg.Alias.Mac.ISO9797Alg3Mac", "ISO9797ALG3MAC");
            this.put("Alg.Alias.CertificateFactory.X509", "X.509");
        }
    }

    private final void replicateFromProvider(String serviceName, String algorithmName, Provider provider) {
        String name = serviceName + "." + algorithmName;
        Object service = provider.get(name);
        if (service != null) {
            this.put(name, service);
        }
    }

    static {
        serialVersionUID = -2881416441551680704L;
        LOGGER = Logger.getLogger("org.jmrtd");
        SUN_PROVIDER_CLASS_NAME = "sun.security.provider.Sun";
        BC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        SC_PROVIDER_CLASS_NAME = "org.spongycastle.jce.provider.BouncyCastleProvider";
        BC_PROVIDER = new BouncyCastleProvider();
        SC_PROVIDER = new org.spongycastle.jce.provider.BouncyCastleProvider();
        instance = new JMRTDSecurityProvider();
        Security.insertProviderAt((Provider)new org.spongycastle.jce.provider.BouncyCastleProvider(), 1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J \u0010 \u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\""}, d2={"Lnashid/verify/sdk/utils/helpers/JMRTDSecurityProvider$Companion;", "", "()V", "BC_PROVIDER", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "BC_PROVIDER_CLASS_NAME", "", "LOGGER", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "SC_PROVIDER", "Lorg/spongycastle/jce/provider/BouncyCastleProvider;", "SC_PROVIDER_CLASS_NAME", "SUN_PROVIDER_CLASS_NAME", "bouncyCastleProvider", "Ljava/security/Provider;", "getBouncyCastleProvider", "()Ljava/security/Provider;", "instance", "getInstance", "serialVersionUID", "", "spongyCastleProvider", "getSpongyCastleProvider", "beginPreferBouncyCastleProvider", "", "endPreferBouncyCastleProvider", "", "i", "getProvider", "serviceName", "algorithmName", "getProviders", "", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider getInstance() {
            return instance;
        }

        public final int beginPreferBouncyCastleProvider() {
            Provider provider = this.getBouncyCastleProvider();
            if (provider == null) {
                return -1;
            }
            Provider bcProvider = provider;
            Provider[] providers = Security.getProviders();
            int n = providers.length;
            for (int i = 0; i < n; ++i) {
                Provider provider2 = providers[i];
                if (!Intrinsics.areEqual((Object)bcProvider.getClass().getCanonicalName(), (Object)provider2.getClass().getCanonicalName())) continue;
                Security.removeProvider(provider2.getName());
                Security.insertProviderAt(bcProvider, 1);
                return i + 1;
            }
            return -1;
        }

        public final void endPreferBouncyCastleProvider(int i) {
            Provider bcProvider;
            Provider provider = bcProvider = this.getBouncyCastleProvider();
            Intrinsics.checkNotNull((Object)provider);
            Security.removeProvider(provider.getName());
            if (i > 0) {
                Security.insertProviderAt(bcProvider, i);
            }
        }

        @Nullable
        public final Provider getBouncyCastleProvider() {
            if (BC_PROVIDER != null) {
                return (Provider)BC_PROVIDER;
            }
            if (SC_PROVIDER != null) {
                return (Provider)SC_PROVIDER;
            }
            LOGGER.severe("No Bouncy or Spongy provider");
            return null;
        }

        @Nullable
        public final Provider getSpongyCastleProvider() {
            if (SC_PROVIDER != null) {
                return (Provider)SC_PROVIDER;
            }
            if (BC_PROVIDER != null) {
                return (Provider)BC_PROVIDER;
            }
            LOGGER.severe("No Bouncy or Spongy provider");
            return null;
        }

        private final Provider getProvider(String serviceName, String algorithmName) {
            List<Provider> providers = this.getProviders(serviceName, algorithmName);
            return providers != null && providers.size() > 0 ? providers.get(0) : null;
        }

        private final List<Provider> getProviders(String serviceName, String algorithmName) {
            if (Security.getAlgorithms(serviceName).contains(algorithmName)) {
                Provider[] providers = Security.getProviders(serviceName + "." + algorithmName);
                return new ArrayList(Arrays.asList(Arrays.copyOf(providers, providers.length)));
            }
            if (BC_PROVIDER != null && BC_PROVIDER.getService(serviceName, algorithmName) != null) {
                return new ArrayList(CollectionsKt.listOf((Object)BC_PROVIDER));
            }
            if (SC_PROVIDER != null && SC_PROVIDER.getService(serviceName, algorithmName) != null) {
                return new ArrayList(CollectionsKt.listOf((Object)SC_PROVIDER));
            }
            return this.getInstance() != null && this.getInstance().getService(serviceName, algorithmName) != null ? (List)new ArrayList(CollectionsKt.listOf((Object)this.getInstance())) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

