/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.camera.core.ImageProxy;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.utils.helpers.Storage;
import nashid.verify.sdk.utils.helpers.TextSizeConverter;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.LivenessActivityMainBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnashid/verify/sdk/utils/helpers/LiveNessCameraLayout;", "", "activity", "Landroid/app/Activity;", "binding", "Lnashid/verify/sdkNew/databinding/LivenessActivityMainBinding;", "storage", "Lnashid/verify/sdk/utils/helpers/Storage;", "textSizeConverter", "Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "(Landroid/app/Activity;Lnashid/verify/sdkNew/databinding/LivenessActivityMainBinding;Lnashid/verify/sdk/utils/helpers/Storage;Lnashid/verify/sdk/utils/helpers/TextSizeConverter;)V", "changeTextSize", "", "getFrontCameraId", "", "getYuvDataFromImage", "", "image", "Landroidx/camera/core/ImageProxy;", "isFaceCenteredInRectangle", "", "rect", "Landroid/graphics/Rect;", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class LiveNessCameraLayout {
    @NotNull
    private final Activity activity;
    @NotNull
    private final LivenessActivityMainBinding binding;
    @NotNull
    private final Storage storage;
    @NotNull
    private final TextSizeConverter textSizeConverter;
    public static final int $stable = 8;

    public LiveNessCameraLayout(@NotNull Activity activity, @NotNull LivenessActivityMainBinding binding, @NotNull Storage storage, @NotNull TextSizeConverter textSizeConverter) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)textSizeConverter, (String)"textSizeConverter");
        this.activity = activity;
        this.binding = binding;
        this.storage = storage;
        this.textSizeConverter = textSizeConverter;
    }

    public final void changeTextSize() {
        if (Build.VERSION.SDK_INT >= 30) {
            this.activity.getWindow().setDecorFitsSystemWindows(false);
            WindowInsetsController windowInsetsController = this.activity.getWindow().getInsetsController();
            if (windowInsetsController != null) {
                WindowInsetsController windowInsetsController2;
                WindowInsetsController $this$changeTextSize_u24lambda_u240 = windowInsetsController2 = windowInsetsController;
                boolean bl = false;
                $this$changeTextSize_u24lambda_u240.hide(WindowInsets.Type.statusBars());
                $this$changeTextSize_u24lambda_u240.setSystemBarsBehavior(2);
            }
        } else {
            this.activity.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        ViewGroup.LayoutParams layoutParams2 = this.binding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(24);
        layoutParams2.height = this.textSizeConverter.getHeight(24);
        this.binding.layoutHeader.imgBack.setLayoutParams(layoutParams2);
        this.binding.layoutHeader.txtHelp.setText((CharSequence)this.activity.getString(R.string.header_doc_scan));
        this.binding.layoutHeader.txtHelp.setTextSize(0, (float)this.textSizeConverter.getTextSize(17));
        this.binding.layoutHeader.imgBack.setImageResource(R.drawable.back_white);
        if (StringsKt.equals((String)this.storage.getPreferredLocale(), (String)"ar", (boolean)true)) {
            this.binding.layoutHeader.imgBack.setRotation(180.0f);
        }
        this.binding.layoutHeader.txtHelp.setText(R.string.face_header);
        this.binding.layoutHeader.txtHelp.setTextColor(-1);
        LinearLayout.LayoutParams layoutParams = this.textSizeConverter.getLinearLayoutParam();
        if (Build.VERSION.SDK_INT >= 30) {
            layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(4), 0, 0);
        } else {
            layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(42), 0, 0);
        }
        this.binding.layoutHeader.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams2 = this.binding.layoutStepMain.lytStep.getLayoutParams();
        layoutParams2.width = -1;
        layoutParams2.height = this.textSizeConverter.getHeight(26);
        this.binding.layoutStepMain.lytStep.setLayoutParams(layoutParams2);
        ViewGroup.LayoutParams layoutParams3 = this.binding.layoutStepMain.lytStep.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        LinearLayout.LayoutParams marginLayoutParam = (LinearLayout.LayoutParams)layoutParams3;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(16), 0, 0);
        this.binding.layoutStepMain.lytStep.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        int padding = this.textSizeConverter.getPaddingOrMarginValue(16);
        this.binding.lytTopView.setPadding(padding, padding, padding, 0);
        this.binding.lytBottomMain.setPadding(padding, 0, padding, padding);
        int stepIconSize = 22;
        ViewGroup.LayoutParams stepLayoutParam = this.binding.layoutStepMain.txtStep1.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep1.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.txtStep2.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep2.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.txtStep3.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep3.setLayoutParams(stepLayoutParam);
        this.binding.txtTakeSelfie.setTextSize(0, (float)this.textSizeConverter.getTextSize(14));
        ViewGroup.LayoutParams layoutParams4 = this.binding.txtTakeSelfie.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams4, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams4;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(20), 0, 0);
        this.binding.txtTakeSelfie.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        ViewGroup.LayoutParams layoutParams5 = this.binding.cardStartDesc.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams5, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        RelativeLayout.LayoutParams marginLayoutParam1 = (RelativeLayout.LayoutParams)layoutParams5;
        marginLayoutParam1.setMargins(this.textSizeConverter.getPaddingOrMarginValue(34), 0, this.textSizeConverter.getPaddingOrMarginValue(34), 0);
        this.binding.cardStartDesc.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam1);
        this.binding.txtStartRecording.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.txtStartRecordingDesc2.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.imgStartRecording.setImageResource(R.drawable.start_recording);
        ViewGroup.LayoutParams layoutParams6 = this.binding.imgStartRecording.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams6, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams6;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(16), 0, this.textSizeConverter.getPaddingOrMarginValue(16));
        this.binding.imgStartRecording.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        stepLayoutParam = this.binding.imgStartRecording.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(74);
        stepLayoutParam.height = this.textSizeConverter.getHeight(74);
        this.binding.imgStartRecording.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.viewStep2Divider.getLayoutParams();
        stepLayoutParam.width = -1;
        stepLayoutParam.height = this.textSizeConverter.getHeight(2);
        this.binding.layoutStepMain.viewStep2Divider.setLayoutParams(stepLayoutParam);
        this.binding.layoutStepMain.txtStep1.setImageResource(R.drawable.complete_step1);
        this.binding.layoutStepMain.txtStep2.setImageResource(R.drawable.complete_step1);
        this.binding.layoutStepMain.txtStep3.setImageResource(R.drawable.scan_complete_step3);
        this.binding.layoutStepMain.viewStep2Divider.setBackgroundResource(R.drawable.gradient_straight_line);
        this.binding.layoutStepMain.viewStep1Divider.setBackground(ContextCompat.getDrawable((Context)((Context)this.activity), (int)R.drawable.complete_straight_line));
        this.binding.txtPressDesc.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.txtPressDesc.setPadding(this.textSizeConverter.getPaddingOrMarginValue(4), this.textSizeConverter.getPaddingOrMarginValue(12), this.textSizeConverter.getPaddingOrMarginValue(4), this.textSizeConverter.getPaddingOrMarginValue(12));
        this.binding.cardPressDesc.setRadius((float)this.textSizeConverter.calculateRadius(4));
        this.binding.cardStartDesc.setRadius((float)this.textSizeConverter.calculateRadius(4));
        this.binding.txtScanCompleted.setTextSize(0, (float)this.textSizeConverter.getTextSize(20));
        ViewGroup.LayoutParams layoutParams7 = this.binding.txtScanCompleted.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams7, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams7;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, 0);
        this.binding.txtScanCompleted.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        stepLayoutParam = this.binding.imgScanComplete.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(56);
        stepLayoutParam.height = this.textSizeConverter.getHeight(56);
        this.binding.imgScanComplete.setLayoutParams(stepLayoutParam);
        this.binding.imgScanComplete.setAnimation(R.raw.scan_completed);
        this.binding.overlayMainLayout.setBackgroundColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.transparent));
        this.binding.lytTopView.setBackgroundColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.face_camera_back));
        this.binding.lytBottomMain.setBackgroundColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.face_camera_back));
        layoutParams2 = this.binding.imgScanFail.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(56);
        layoutParams2.height = this.textSizeConverter.getHeight(56);
        this.binding.imgScanFail.setLayoutParams(layoutParams2);
        ViewGroup.LayoutParams layoutParams8 = this.binding.txtScanFail.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams8, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams8;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, 0);
        this.binding.txtScanFail.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        this.binding.txtScanFail.setTextSize(0, (float)this.textSizeConverter.getTextSize(20));
        ViewGroup.LayoutParams layoutParams9 = this.binding.btnRescanningDocuments.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams9, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams9;
        marginLayoutParam.setMargins(this.textSizeConverter.getPaddingOrMarginValue(16), 0, this.textSizeConverter.getPaddingOrMarginValue(16), this.textSizeConverter.getPaddingOrMarginValue(44));
        this.binding.btnRescanningDocuments.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        padding = this.textSizeConverter.getPaddingOrMarginValue(12);
        this.binding.txtRescanningDocuments.setPadding(0, padding, 0, padding);
        this.binding.txtRescanningDocuments.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.btnRescanningDocuments.setRadius((float)this.textSizeConverter.calculateRadius(8));
        this.binding.txtError3.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.txtError3.setPadding(0, 0, 0, this.textSizeConverter.getPaddingOrMarginValue(38));
    }

    @Nullable
    public final String getFrontCameraId() {
        Object object = this.activity.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        String[] stringArray = cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
        for (String id2 : stringArray) {
            CameraCharacteristics characteristics;
            Integer facing;
            Intrinsics.checkNotNullExpressionValue((Object)cameraManager.getCameraCharacteristics(id2), (String)"getCameraCharacteristics(...)");
            Integer n = facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            if (n == null || n != 0) continue;
            return id2;
        }
        return null;
    }

    @NotNull
    public final byte[] getYuvDataFromImage(@NotNull ImageProxy image) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int width = image.getWidth();
        int height = image.getHeight();
        int ySize = width * height;
        int uvSize = width * height / 4;
        byte[] nv21 = new byte[ySize + uvSize * 2];
        ByteBuffer byteBuffer = image.getPlanes()[0].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer yBuffer = byteBuffer;
        ByteBuffer byteBuffer2 = image.getPlanes()[1].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer uBuffer = byteBuffer2;
        ByteBuffer byteBuffer3 = image.getPlanes()[2].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        ByteBuffer vBuffer = byteBuffer3;
        int rowStride = image.getPlanes()[0].getRowStride();
        boolean bl3 = bl2 = image.getPlanes()[0].getPixelStride() == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (rowStride == width) {
            yBuffer.get(nv21, 0, ySize);
            pos += ySize;
        } else {
            long yBufferPos = -((long)rowStride);
            for (int pos = 0; pos < ySize; pos += width) {
                yBuffer.position((int)(yBufferPos += (long)rowStride));
                yBuffer.get(nv21, pos, width);
            }
        }
        rowStride = image.getPlanes()[2].getRowStride();
        int pixelStride = image.getPlanes()[2].getPixelStride();
        boolean bl4 = bl = rowStride == image.getPlanes()[1].getRowStride();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl5 = bl = pixelStride == image.getPlanes()[1].getPixelStride();
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        if (pixelStride == 2 && rowStride == width && uBuffer.get(0) == vBuffer.get(1)) {
            byte savePixel = vBuffer.get(1);
            try {
                vBuffer.put(1, ~savePixel);
                if (uBuffer.get(0) == (byte)(~savePixel)) {
                    vBuffer.put(1, savePixel);
                    vBuffer.position(0);
                    uBuffer.position(0);
                    vBuffer.get(nv21, ySize, 1);
                    uBuffer.get(nv21, ySize + 1, uBuffer.remaining());
                    return nv21;
                }
            }
            catch (ReadOnlyBufferException ex) {
                ex.printStackTrace();
            }
            vBuffer.put(1, savePixel);
        }
        int n = height / 2;
        for (int row = 0; row < n; ++row) {
            int n2 = width / 2;
            for (int col = 0; col < n2; ++col) {
                int vuPos = col * pixelStride + row * rowStride;
                nv21[pos++] = vBuffer.get(vuPos);
                nv21[pos++] = uBuffer.get(vuPos);
            }
        }
        return nv21;
    }

    public final boolean isFaceCenteredInRectangle(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        RectF faceBounds = new RectF(this.binding.coverView.getRect().left, this.binding.coverView.getRect().top, this.binding.coverView.getRect().right, this.binding.coverView.getRect().bottom);
        float faceCenterX = (faceBounds.left + faceBounds.right) / (float)2;
        int rectCenterX = (rect.left + rect.right) / 2;
        double thresholdX = 0.1;
        double d = (double)rectCenterX - thresholdX * (double)rect.width();
        double d2 = (double)rectCenterX + thresholdX * (double)rect.width();
        double d3 = faceCenterX;
        if (!(d <= d3) || d3 <= d2) {
            // empty if block
        }
        boolean isTooFarRight = (double)faceCenterX > (double)rectCenterX + thresholdX * (double)rect.width();
        boolean isTooFarLeft = (double)faceCenterX < (double)rectCenterX - thresholdX * (double)rect.width();
        return isTooFarLeft || isTooFarRight;
    }
}

