/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.ConfigurationCompat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnashid/verify/sdk/utils/helpers/LocaleUtil;", "", "()V", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=1)
public final class LocaleUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final List<String> supportedLocales;
    @NotNull
    public static final String OPTION_PHONE_LANGUAGE = "sys_def";

    static {
        Object[] objectArray = new String[]{"en", "ar"};
        supportedLocales = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnashid/verify/sdk/utils/helpers/LocaleUtil$Companion;", "", "()V", "OPTION_PHONE_LANGUAGE", "", "supportedLocales", "", "applyLocalizedContext", "", "baseContext", "Landroid/content/Context;", "prefLocaleCode", "getLocaleFromConfiguration", "Ljava/util/Locale;", "configuration", "Landroid/content/res/Configuration;", "getLocaleFromPrefCode", "prefCode", "getLocalizedConfiguration", "locale", "getLocalizedContext", "getLocalizedResources", "Landroid/content/res/Resources;", "resources", "VerifySDK_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Locale getLocaleFromPrefCode(String prefCode) {
            String string2;
            if (!Intrinsics.areEqual((Object)prefCode, (Object)LocaleUtil.OPTION_PHONE_LANGUAGE)) {
                string2 = prefCode;
            } else {
                String systemLang;
                Locale locale = ConfigurationCompat.getLocales((Configuration)Resources.getSystem().getConfiguration()).get(0);
                String string3 = systemLang = locale != null ? locale.getLanguage() : null;
                if (CollectionsKt.contains((Iterable)supportedLocales, (Object)systemLang)) {
                    string2 = systemLang;
                    if (string2 == null) {
                        string2 = "en";
                    }
                } else {
                    string2 = "en";
                }
            }
            String localeCode = string2;
            return new Locale(localeCode);
        }

        @NotNull
        public final Configuration getLocalizedConfiguration(@NotNull String prefLocaleCode) {
            Intrinsics.checkNotNullParameter((Object)prefLocaleCode, (String)"prefLocaleCode");
            Locale locale = this.getLocaleFromPrefCode(prefLocaleCode);
            return this.getLocalizedConfiguration(locale);
        }

        private final Configuration getLocalizedConfiguration(Locale locale) {
            Configuration config;
            Configuration configuration;
            Configuration $this$getLocalizedConfiguration_u24lambda_u240 = configuration = (config = new Configuration());
            boolean bl = false;
            config.setLayoutDirection(locale);
            if (Build.VERSION.SDK_INT >= 26) {
                config.setLocale(locale);
                Locale[] localeArray = new Locale[]{locale};
                LocaleList localeList = new LocaleList(localeArray);
                LocaleList.setDefault((LocaleList)localeList);
                config.setLocales(localeList);
            } else {
                config.setLocale(locale);
            }
            return configuration;
        }

        @NotNull
        public final Context getLocalizedContext(@NotNull Context baseContext, @NotNull String prefLocaleCode) {
            Context context;
            Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
            Intrinsics.checkNotNullParameter((Object)prefLocaleCode, (String)"prefLocaleCode");
            Locale currentLocale = this.getLocaleFromPrefCode(prefLocaleCode);
            Configuration configuration = baseContext.getResources().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getConfiguration(...)");
            Locale baseLocale = this.getLocaleFromConfiguration(configuration);
            Locale.setDefault(currentLocale);
            if (!StringsKt.equals((String)baseLocale.toString(), (String)currentLocale.toString(), (boolean)true)) {
                Configuration config = this.getLocalizedConfiguration(currentLocale);
                baseContext.createConfigurationContext(config);
                context = baseContext;
            } else {
                context = baseContext;
            }
            return context;
        }

        public final void applyLocalizedContext(@NotNull Context baseContext, @NotNull String prefLocaleCode) {
            Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
            Intrinsics.checkNotNullParameter((Object)prefLocaleCode, (String)"prefLocaleCode");
            Locale currentLocale = this.getLocaleFromPrefCode(prefLocaleCode);
            Configuration configuration = baseContext.getResources().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getConfiguration(...)");
            Locale baseLocale = this.getLocaleFromConfiguration(configuration);
            Locale.setDefault(currentLocale);
            if (!StringsKt.equals((String)baseLocale.toString(), (String)currentLocale.toString(), (boolean)true)) {
                Configuration config = this.getLocalizedConfiguration(currentLocale);
                baseContext.getResources().updateConfiguration(config, baseContext.getResources().getDisplayMetrics());
            }
        }

        private final Locale getLocaleFromConfiguration(Configuration configuration) {
            Locale locale;
            if (Build.VERSION.SDK_INT >= 26) {
                Locale locale2 = configuration.getLocales().get(0);
                Intrinsics.checkNotNull((Object)locale2);
                locale = locale2;
            } else {
                Locale locale3 = configuration.locale;
                Intrinsics.checkNotNull((Object)locale3);
                locale = locale3;
            }
            return locale;
        }

        @NotNull
        public final Resources getLocalizedResources(@NotNull Resources resources, @NotNull String prefLocaleCode) {
            Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
            Intrinsics.checkNotNullParameter((Object)prefLocaleCode, (String)"prefLocaleCode");
            Locale locale = this.getLocaleFromPrefCode(prefLocaleCode);
            Configuration config = resources.getConfiguration();
            config.locale = locale;
            config.setLayoutDirection(locale);
            resources.updateConfiguration(config, resources.getDisplayMetrics());
            return resources;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

