/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nashid.verify.sdk.model.AdditionalPersonDetails;
import nashid.verify.sdk.model.IDCardNFCData;
import nashid.verify.sdk.ui.NFCFragment;
import nashid.verify.sdk.utils.AdditionalDGFiles;
import nashid.verify.sdk.utils.ArtifactType;
import nashid.verify.sdk.utils.EDocument;
import nashid.verify.sdk.utils.LivenessData;
import nashid.verify.sdk.utils.PersonDetails;
import nashid.verify.sdk.utils.SdkConfig;
import nashid.verify.sdk.utils.Utility;
import nashid.verify.sdk.utils.helpers.Storage;
import nashid.verify.sdk.utils.helpers.TextSizeConverter;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG10File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG11File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG13File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG1File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG4File;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDG6File;
import nashid.verify.sdk.viewmodel.NFCViewModel;
import nashid.verify.sdk.viewmodel.ScanDocumentViewModel;
import nashid.verify.sdkNew.R;
import nashid.verify.sdkNew.databinding.ActivityWaitingForNfcBinding;
import okhttp3.MultipartBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0003J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\u0012\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010$\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnashid/verify/sdk/utils/helpers/NfcLayoutAndTextSize;", "", "textSizeConverter", "Lnashid/verify/sdk/utils/helpers/TextSizeConverter;", "binding", "Lnashid/verify/sdkNew/databinding/ActivityWaitingForNfcBinding;", "context", "Landroid/app/Activity;", "storage", "Lnashid/verify/sdk/utils/helpers/Storage;", "viewModel", "Lnashid/verify/sdk/viewmodel/NFCViewModel;", "scanDocumentViewModel", "Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;", "(Lnashid/verify/sdk/utils/helpers/TextSizeConverter;Lnashid/verify/sdkNew/databinding/ActivityWaitingForNfcBinding;Landroid/app/Activity;Lnashid/verify/sdk/utils/helpers/Storage;Lnashid/verify/sdk/viewmodel/NFCViewModel;Lnashid/verify/sdk/viewmodel/ScanDocumentViewModel;)V", "dateFormat", "", "errorDialog", "Landroid/app/Dialog;", "idCardNFCData", "Lnashid/verify/sdk/model/IDCardNFCData;", "personalHashmap", "Lorg/json/JSONObject;", "progressDialog", "dismissDialog", "", "formattedFrosting", "inputDate", "handleSkipNFC", "skipNFC", "", "setLayoutAndTextSize", "storeNFCData", "uploadArtifact", "bitmap", "Landroid/graphics/Bitmap;", "uploadArtifacts", "VerifySDK_release"})
@StabilityInferred(parameters=0)
public final class NfcLayoutAndTextSize {
    @NotNull
    private final TextSizeConverter textSizeConverter;
    @NotNull
    private final ActivityWaitingForNfcBinding binding;
    @NotNull
    private final Activity context;
    @NotNull
    private final Storage storage;
    @NotNull
    private final NFCViewModel viewModel;
    @NotNull
    private final ScanDocumentViewModel scanDocumentViewModel;
    @Nullable
    private Dialog progressDialog;
    @Nullable
    private Dialog errorDialog;
    @NotNull
    private final String dateFormat;
    @NotNull
    private JSONObject personalHashmap;
    private IDCardNFCData idCardNFCData;
    public static final int $stable = 8;

    public NfcLayoutAndTextSize(@NotNull TextSizeConverter textSizeConverter, @NotNull ActivityWaitingForNfcBinding binding, @NotNull Activity context, @NotNull Storage storage, @NotNull NFCViewModel viewModel, @NotNull ScanDocumentViewModel scanDocumentViewModel) {
        Intrinsics.checkNotNullParameter((Object)textSizeConverter, (String)"textSizeConverter");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)scanDocumentViewModel), (String)"scanDocumentViewModel");
        this.textSizeConverter = textSizeConverter;
        this.binding = binding;
        this.context = context;
        this.storage = storage;
        this.viewModel = viewModel;
        this.scanDocumentViewModel = scanDocumentViewModel;
        this.dateFormat = "yyyyMMdd";
        this.personalHashmap = new JSONObject();
    }

    public final void setLayoutAndTextSize() {
        this.textSizeConverter.changeStatusBarColor(this.context);
        this.binding.layoutHeader.imgBack.setImageResource(R.drawable.back);
        if (StringsKt.equals((String)this.storage.getPreferredLocale(), (String)"ar", (boolean)true)) {
            this.binding.layoutHeader.imgBack.setRotation(180.0f);
        }
        ViewGroup.LayoutParams layoutParams2 = this.binding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(24);
        layoutParams2.height = this.textSizeConverter.getHeight(24);
        this.binding.layoutHeader.imgBack.setLayoutParams(layoutParams2);
        LinearLayout.LayoutParams layoutParams = this.textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(4), 0, 0);
        this.binding.layoutHeader.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.layoutHeader.txtHelp.setText((CharSequence)this.context.getString(R.string.nfc_chip_rading));
        this.binding.layoutHeader.txtHelp.setTextSize(0, (float)this.textSizeConverter.getTextSize(17));
        int padding = this.textSizeConverter.getPaddingOrMarginValue(16);
        this.binding.layoutMainNfc.setPadding(padding, padding, padding, padding);
        layoutParams2 = this.binding.layoutStepMain.lytStep.getLayoutParams();
        layoutParams2.width = -1;
        layoutParams2.height = this.textSizeConverter.getHeight(30);
        this.binding.layoutStepMain.lytStep.setLayoutParams(layoutParams2);
        ViewGroup.LayoutParams layoutParams3 = this.binding.layoutStepMain.lytStep.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        LinearLayout.LayoutParams marginLayoutParam = (LinearLayout.LayoutParams)layoutParams3;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(32), 0, 0);
        this.binding.layoutStepMain.lytStep.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        int stepIconSize = 22;
        ViewGroup.LayoutParams stepLayoutParam = this.binding.layoutStepMain.txtStep1.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep1.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.txtStep2.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep2.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.txtStep3.getLayoutParams();
        stepLayoutParam.width = this.textSizeConverter.getWidth(stepIconSize);
        stepLayoutParam.height = this.textSizeConverter.getHeight(stepIconSize);
        this.binding.layoutStepMain.txtStep3.setLayoutParams(stepLayoutParam);
        stepLayoutParam = this.binding.layoutStepMain.viewStep1Divider.getLayoutParams();
        stepLayoutParam.width = -1;
        stepLayoutParam.height = this.textSizeConverter.getHeight(2);
        this.binding.layoutStepMain.viewStep1Divider.setLayoutParams(stepLayoutParam);
        this.binding.layoutStepMain.txtStep1.setImageResource(R.drawable.complete_step1);
        this.binding.layoutStepMain.txtStep2.setImageResource(R.drawable.scan_complete_step2);
        this.binding.layoutStepMain.txtStep3.setImageTintList(ContextCompat.getColorStateList((Context)((Context)this.context), (int)R.color.dottedline_tint));
        this.binding.layoutStepMain.viewStep1Divider.setBackgroundResource(R.drawable.gradient_straight_line);
        this.binding.layoutStepMain.viewStep2Divider.setBackgroundTintList(ContextCompat.getColorStateList((Context)((Context)this.context), (int)R.color.dottedline_tint));
        ViewGroup.LayoutParams layoutParams4 = this.binding.txtTapHold.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams4, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams4;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, 0);
        this.binding.txtTapHold.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        this.binding.txtTapHold.setTextSize(0, (float)this.textSizeConverter.getTextSize(14));
        ViewGroup.LayoutParams layoutParams5 = this.binding.txtTapHold.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams5, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        marginLayoutParam = (LinearLayout.LayoutParams)layoutParams5;
        marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, 0);
        this.binding.txtTapHold.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
        this.binding.txtTapHold.setTextSize(0, (float)this.textSizeConverter.getTextSize(14));
        this.viewModel.callNfcStatus();
        layoutParams2 = this.binding.nfcDialogTurnon.imgScanFailure.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(56);
        layoutParams2.height = this.textSizeConverter.getHeight(56);
        this.binding.nfcDialogTurnon.imgScanFailure.setLayoutParams(layoutParams2);
        layoutParams2 = this.binding.nfcDialogTurnon.imgInfo1.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(20);
        layoutParams2.height = this.textSizeConverter.getHeight(20);
        this.binding.nfcDialogTurnon.imgInfo1.setLayoutParams(layoutParams2);
        layoutParams2 = this.binding.nfcDialogTurnon.imgNfcFailed.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(145);
        layoutParams2.height = this.textSizeConverter.getHeight(145);
        this.binding.nfcDialogTurnon.imgNfcFailed.setLayoutParams(layoutParams2);
        ViewGroup.LayoutParams layoutParams6 = this.binding.nfcDialogTurnon.imgNfcFailed.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams6, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        LinearLayout.LayoutParams layoutParams1 = (LinearLayout.LayoutParams)layoutParams6;
        layoutParams1.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, this.textSizeConverter.getPaddingOrMarginValue(18));
        this.binding.nfcDialogTurnon.imgNfcFailed.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
        layoutParams2 = this.binding.nfcDialogTurnon.imgInfo2.getLayoutParams();
        layoutParams2.width = this.textSizeConverter.getWidth(20);
        layoutParams2.height = this.textSizeConverter.getHeight(20);
        this.binding.nfcDialogTurnon.imgInfo2.setLayoutParams(layoutParams2);
        ViewGroup.LayoutParams layoutParams7 = this.binding.nfcDialogTurnon.imgScanFailure.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams7, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams7;
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(8), 0, 0);
        this.binding.nfcDialogTurnon.imgScanFailure.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.nfcDialogTurnon.txtScanCompleted.setTextSize(0, (float)this.textSizeConverter.getTextSize(20));
        ViewGroup.LayoutParams layoutParams8 = this.binding.nfcDialogTurnon.txtScanCompleted.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams8, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams8;
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, 0);
        this.binding.nfcDialogTurnon.txtScanCompleted.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.nfcDialogTurnon.txtScanNotCompleteDesc1.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        ViewGroup.LayoutParams layoutParams9 = this.binding.nfcDialogTurnon.txtScanNotCompleteDesc1.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams9, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams9;
        layoutParams.setMargins(this.textSizeConverter.getPaddingOrMarginValue(6), this.textSizeConverter.getPaddingOrMarginValue(16), 0, 0);
        this.binding.nfcDialogTurnon.txtScanNotCompleteDesc1.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.nfcDialogTurnon.txtScanNotCompleteDesc2.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.nfcDialogTurnon.imgNfcFailed.playAnimation();
        this.binding.nfcDialogTurnon.imgNfcFailed.setRepeatCount(-1);
        this.binding.nfcDialogTurnon.imgNfcFailed.setAnimation(R.raw.nfc_read_failed);
        ViewGroup.LayoutParams layoutParams10 = this.binding.nfcDialogTurnon.txtScanNotCompleteDesc2.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams10, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams10;
        layoutParams.setMargins(this.textSizeConverter.getPaddingOrMarginValue(6), this.textSizeConverter.getPaddingOrMarginValue(16), 0, 0);
        this.binding.nfcDialogTurnon.txtScanNotCompleteDesc2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewGroup.LayoutParams layoutParams11 = this.binding.nfcDialogTurnon.imgInfo1.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams11, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams11;
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(16), 0, 0);
        this.binding.nfcDialogTurnon.imgInfo1.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewGroup.LayoutParams layoutParams12 = this.binding.nfcDialogTurnon.imgInfo2.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams12, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams12;
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(16), 0, 0);
        this.binding.nfcDialogTurnon.imgInfo2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewGroup.LayoutParams layoutParams13 = this.binding.nfcDialogTurnon.btnRetry.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams13, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        layoutParams = (LinearLayout.LayoutParams)layoutParams13;
        layoutParams.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(24), 0, this.textSizeConverter.getPaddingOrMarginValue(28));
        this.binding.nfcDialogTurnon.btnRetry.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        padding = this.textSizeConverter.getPaddingOrMarginValue(12);
        this.binding.nfcDialogTurnon.txtBtnRetry.setPadding(0, padding, 0, padding);
        this.binding.nfcDialogTurnon.btnRetry.setRadius((float)this.textSizeConverter.calculateRadius(8));
        this.binding.nfcDialogTurnon.lyoutError1.setVisibility(8);
        this.binding.nfcDialogTurnon.txtBtnRetry.setText((CharSequence)this.context.getString(R.string.turn_on_nfc));
        this.binding.nfcDialogTurnon.txtBtnRetry.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
        this.binding.logo.setImageResource(R.drawable.logo);
        this.binding.backbutton.setImageResource(R.drawable.arowback);
        this.binding.imgBackcrdScan.setAnimation(R.raw.nfc);
        this.binding.imgBackcrdScan.playAnimation();
        this.binding.imgBackcrdScan.setRepeatCount(-1);
    }

    public final void handleSkipNFC(boolean skipNFC) {
        Log.d((String)"NfcActivity", (String)("handleSkipNFC: " + skipNFC));
        if (skipNFC) {
            this.binding.txtSkip.setVisibility(0);
        } else {
            this.binding.txtSkip.setVisibility(8);
        }
        if (skipNFC) {
            Integer n = (Integer)this.viewModel.getNfcLiveData().getMaxTry().getValue();
            int margin = n != null && n == 0 ? this.textSizeConverter.getPaddingOrMarginValue(100) : 0;
            ViewGroup.LayoutParams layoutParams = this.binding.txtBottomDesc.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams marginLayoutParam = (LinearLayout.LayoutParams)layoutParams;
            marginLayoutParam.setMargins(0, 0, 0, margin);
            this.binding.txtBottomDesc.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
            this.binding.txtBottomDesc.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
            ViewGroup.LayoutParams layoutParams2 = this.binding.txtSkip.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams2, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            marginLayoutParam = (LinearLayout.LayoutParams)layoutParams2;
            marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(28), 0, this.textSizeConverter.getPaddingOrMarginValue(68));
            this.binding.txtSkip.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
            this.binding.txtSkip.setTextSize(0, (float)this.textSizeConverter.getTextSize(14));
        } else {
            ViewGroup.LayoutParams layoutParams = this.binding.txtBottomDesc.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            LinearLayout.LayoutParams marginLayoutParam = (LinearLayout.LayoutParams)layoutParams;
            marginLayoutParam.setMargins(0, 0, 0, this.textSizeConverter.getPaddingOrMarginValue(100));
            this.binding.txtBottomDesc.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
            this.binding.txtBottomDesc.setTextSize(0, (float)this.textSizeConverter.getTextSize(16));
            ViewGroup.LayoutParams layoutParams3 = this.binding.txtSkip.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams3, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            marginLayoutParam = (LinearLayout.LayoutParams)layoutParams3;
            marginLayoutParam.setMargins(0, this.textSizeConverter.getPaddingOrMarginValue(28), 0, this.textSizeConverter.getPaddingOrMarginValue(68));
            this.binding.txtSkip.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParam);
            this.binding.txtSkip.setTextSize(0, (float)this.textSizeConverter.getTextSize(14));
        }
    }

    private final void dismissDialog() {
        if (this.errorDialog != null) {
            Dialog dialog = this.errorDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
        if (this.progressDialog != null) {
            Dialog dialog = this.progressDialog;
            Intrinsics.checkNotNull((Object)dialog);
            dialog.dismiss();
        }
    }

    public final void storeNFCData() {
        if (StringsKt.equals((String)((String)Objects.requireNonNull(this.viewModel.getNfcLiveData().getSelectedDoc().getValue())), (String)this.context.getString(R.string.e_passport), (boolean)true)) {
            String string2 = this.context.getString(R.string.passemptyString);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String emptyString = string2;
            EDocument eDocument = this.viewModel.getEDocument();
            LivenessData.getInstance().seteDocument(eDocument);
            PersonDetails personDetails = eDocument.getPersonDetails();
            AdditionalPersonDetails additionalPersonDetails = eDocument.getAdditionalPersonDetails();
            AdditionalDGFiles additionalDGFiles = eDocument.getAdditionalDGFiles();
            try {
                this.personalHashmap.put(this.context.getString(R.string.passdocumentType), (Object)eDocument.getDocType().name());
                this.personalHashmap.put(this.context.getString(R.string.passdocumentNumber), (Object)personDetails.getSerialNumber());
                this.personalHashmap.put(this.context.getString(R.string.passissuingAuthority), (Object)personDetails.getIssuerAuthority());
                this.personalHashmap.put(this.context.getString(R.string.passdateOfBirth), (Object)personDetails.getBirthDate());
                this.personalHashmap.put(this.context.getString(R.string.passgender), (Object)personDetails.getGender());
                this.personalHashmap.put(this.context.getString(R.string.passdocumentExpiryDate), (Object)personDetails.getExpiryDate());
                this.personalHashmap.put(this.context.getString(R.string.passimage), (Object)personDetails.getFaceImage());
                if (additionalPersonDetails != null) {
                    this.personalHashmap.put(this.context.getString(R.string.passfullName), (Object)additionalPersonDetails.getNameOfHolder());
                    this.personalHashmap.put(this.context.getString(R.string.passpersonalNumber), (Object)additionalPersonDetails.getPersonalNumber());
                    if (additionalPersonDetails.getPlaceOfBirth() != null) {
                        String string3 = this.context.getString(R.string.passplaceOfBirth);
                        List<String> list = additionalPersonDetails.getPlaceOfBirth();
                        Intrinsics.checkNotNull(list);
                        this.personalHashmap.put(string3, (Object)list.get(0));
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passplaceOfBirth), (Object)emptyString);
                    }
                    this.personalHashmap.put(this.context.getString(R.string.passnfcDateOfBirth), (Object)additionalPersonDetails.getFullDateOfBirth());
                    if (additionalPersonDetails.getPermanentAddress() != null) {
                        String string4 = this.context.getString(R.string.passaddress);
                        List<String> list = additionalPersonDetails.getPermanentAddress();
                        Intrinsics.checkNotNull(list);
                        this.personalHashmap.put(string4, (Object)list.get(0));
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passaddress), (Object)emptyString);
                    }
                    this.personalHashmap.put(this.context.getString(R.string.passprofession), (Object)additionalPersonDetails.getProfession());
                    this.personalHashmap.put(this.context.getString(R.string.passtitle), (Object)additionalPersonDetails.getTitle());
                    this.personalHashmap.put(this.context.getString(R.string.passpersonalSummary), (Object)additionalPersonDetails.getPersonalSummary());
                    if (additionalPersonDetails.getOtherValidTDNumbers() != null) {
                        String string5 = this.context.getString(R.string.passtdNumbers);
                        List<String> list = additionalPersonDetails.getOtherValidTDNumbers();
                        Intrinsics.checkNotNull(list);
                        this.personalHashmap.put(string5, (Object)list.get(0));
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passtdNumbers), (Object)emptyString);
                    }
                    this.personalHashmap.put(this.context.getString(R.string.passcustodyInfo), (Object)additionalPersonDetails.getCustodyInformation());
                    if (additionalPersonDetails.getProofOfCitizenship() != null) {
                        this.personalHashmap.put(this.context.getString(R.string.passproofOfCitizenship), (Object)String.valueOf(additionalPersonDetails.getProofOfCitizenship()));
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passproofOfCitizenship), (Object)emptyString);
                    }
                    this.personalHashmap.put(this.context.getString(R.string.passtelephone), (Object)additionalPersonDetails.getTelephone());
                }
                if (additionalDGFiles != null) {
                    this.personalHashmap.put(this.context.getString(R.string.passnfcissuingCountry), (Object)additionalDGFiles.getIssueingAuthority());
                    if (additionalDGFiles.getFrontImage() != null) {
                        this.personalHashmap.put(this.context.getString(R.string.passfrontImage), (Object)additionalDGFiles.getFrontImage());
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passfrontImage), (Object)emptyString);
                    }
                    if (additionalDGFiles.getBackImage() != null) {
                        this.personalHashmap.put(this.context.getString(R.string.passrearImage), (Object)additionalDGFiles.getBackImage());
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passrearImage), (Object)emptyString);
                    }
                    if (additionalDGFiles.getSecurityInfos() != null) {
                        this.personalHashmap.put(this.context.getString(R.string.passsecurityInfos), (Object)additionalDGFiles.getSecurityInfos());
                    } else {
                        this.personalHashmap.put(this.context.getString(R.string.passsecurityInfos), (Object)emptyString);
                    }
                }
                NFCFragment.Companion.setNfcData(this.personalHashmap);
                this.uploadArtifact(personDetails.getFaceImage());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.idCardNFCData = IDCardNFCData.Companion.getInstance();
            JSONObject documentHashmap = new JSONObject();
            try {
                OmanCardDG13File dg13Parser;
                OmanCardDG1File dg1Parser = new OmanCardDG1File(Utility.Companion.getInstance().getDgFile1());
                OmanCardDG4File dg4Parser = new OmanCardDG4File(Utility.Companion.getInstance().getDgFile4());
                OmanCardDG6File dg6Parser = new OmanCardDG6File(Utility.Companion.getInstance().getDgFile6());
                documentHashmap.put(this.context.getString(R.string.idcardphoto), (Object)LivenessData.getInstance().getNfcImage());
                documentHashmap.put(this.context.getString(R.string.idcardidNumber), (Object)dg1Parser.getIdNumber());
                String string6 = this.context.getString(R.string.idcardissueDate);
                String string7 = dg1Parser.getIssueDate();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getIssueDate(...)");
                documentHashmap.put(string6, (Object)this.formattedFrosting(string7));
                String string8 = this.context.getString(R.string.idcardexpiryDate);
                String string9 = dg1Parser.getExpiryDate();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getExpiryDate(...)");
                documentHashmap.put(string8, (Object)this.formattedFrosting(string9));
                documentHashmap.put(this.context.getString(R.string.idcardplaceOfIssueArabic), (Object)dg1Parser.getPlaceOfIssueArabic());
                documentHashmap.put(this.context.getString(R.string.idcardplaceOfIssueEnglish), (Object)dg1Parser.getPlaceOfIssueEnglish());
                IDCardNFCData iDCardNFCData = this.idCardNFCData;
                if (iDCardNFCData == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData = null;
                }
                iDCardNFCData.setIdentityNumber(dg1Parser.getIdNumber());
                IDCardNFCData iDCardNFCData2 = this.idCardNFCData;
                if (iDCardNFCData2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData2 = null;
                }
                String string10 = dg1Parser.getIssueDate();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getIssueDate(...)");
                iDCardNFCData2.setIssueDate(this.formattedFrosting(string10));
                IDCardNFCData iDCardNFCData3 = this.idCardNFCData;
                if (iDCardNFCData3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData3 = null;
                }
                String string11 = dg1Parser.getExpiryDate();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getExpiryDate(...)");
                iDCardNFCData3.setExpiryDate(this.formattedFrosting(string11));
                IDCardNFCData iDCardNFCData4 = this.idCardNFCData;
                if (iDCardNFCData4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData4 = null;
                }
                iDCardNFCData4.setPlaceOfIssueArabic(dg1Parser.getPlaceOfIssueArabic());
                IDCardNFCData iDCardNFCData5 = this.idCardNFCData;
                if (iDCardNFCData5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData5 = null;
                }
                iDCardNFCData5.setPlaceOfIssueEnglish(dg1Parser.getPlaceOfIssueEnglish());
                documentHashmap.put(this.context.getString(R.string.idcardfullNameArabic), (Object)dg4Parser.getFullNameArabic());
                documentHashmap.put(this.context.getString(R.string.idcardfullNameEnglish), (Object)dg4Parser.getFullNameEnglish());
                IDCardNFCData iDCardNFCData6 = this.idCardNFCData;
                if (iDCardNFCData6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData6 = null;
                }
                iDCardNFCData6.setFullNameArabic(dg4Parser.getFullNameArabic());
                IDCardNFCData iDCardNFCData7 = this.idCardNFCData;
                if (iDCardNFCData7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData7 = null;
                }
                iDCardNFCData7.setFullNameEnglish(dg4Parser.getFullNameEnglish());
                String string12 = this.context.getString(R.string.idcarddateOfBirth);
                String string13 = dg6Parser.getDateOfBirth();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getDateOfBirth(...)");
                documentHashmap.put(string12, (Object)this.formattedFrosting(string13));
                documentHashmap.put(this.context.getString(R.string.idcardcountryOfBirthArabic), (Object)dg6Parser.getCountryOfBirthArabic());
                documentHashmap.put(this.context.getString(R.string.idcardplaceOfBirthEnglish), (Object)dg6Parser.getPlaceOfBirthEnglish());
                documentHashmap.put(this.context.getString(R.string.idcardnationalityArabic), (Object)dg6Parser.getNationalityArabic());
                documentHashmap.put(this.context.getString(R.string.idcardgenderArabic), (Object)dg6Parser.getGenderArabic());
                documentHashmap.put(this.context.getString(R.string.idcardnationalityEnglish), (Object)dg6Parser.getNationalityEnglish());
                documentHashmap.put(this.context.getString(R.string.idcardgenderEnglish), (Object)dg6Parser.getGenderEnglish());
                IDCardNFCData iDCardNFCData8 = this.idCardNFCData;
                if (iDCardNFCData8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData8 = null;
                }
                String string14 = dg6Parser.getDateOfBirth();
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getDateOfBirth(...)");
                iDCardNFCData8.setDateOfBirth(this.formattedFrosting(string14));
                IDCardNFCData iDCardNFCData9 = this.idCardNFCData;
                if (iDCardNFCData9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData9 = null;
                }
                iDCardNFCData9.setPlaceOfBirthArabic(dg6Parser.getCountryOfBirthArabic());
                IDCardNFCData iDCardNFCData10 = this.idCardNFCData;
                if (iDCardNFCData10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData10 = null;
                }
                iDCardNFCData10.setPlaceOfBirthEnglish(dg6Parser.getPlaceOfBirthEnglish());
                IDCardNFCData iDCardNFCData11 = this.idCardNFCData;
                if (iDCardNFCData11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData11 = null;
                }
                iDCardNFCData11.setNationalityArabic(dg6Parser.getNationalityArabic());
                IDCardNFCData iDCardNFCData12 = this.idCardNFCData;
                if (iDCardNFCData12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData12 = null;
                }
                iDCardNFCData12.setGenderArabic(dg6Parser.getGenderArabic());
                IDCardNFCData iDCardNFCData13 = this.idCardNFCData;
                if (iDCardNFCData13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData13 = null;
                }
                iDCardNFCData13.setNationalityEnglish(dg6Parser.getNationalityEnglish());
                IDCardNFCData iDCardNFCData14 = this.idCardNFCData;
                if (iDCardNFCData14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                    iDCardNFCData14 = null;
                }
                iDCardNFCData14.setGenderEnglish(dg6Parser.getGenderEnglish());
                if (Utility.Companion.getInstance().getDgFile13() != null) {
                    dg13Parser = new OmanCardDG13File(Utility.Companion.getInstance().getDgFile13());
                    documentHashmap.put(this.context.getString(R.string.idcardvisaNumber), (Object)dg13Parser.getSponsorNumber());
                    documentHashmap.put(this.context.getString(R.string.idcardPermitType), (Object)dg13Parser.getSponsorRelationship());
                    IDCardNFCData iDCardNFCData15 = this.idCardNFCData;
                    if (iDCardNFCData15 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData15 = null;
                    }
                    iDCardNFCData15.setVisaNumber(dg13Parser.getSponsorNumber());
                    IDCardNFCData iDCardNFCData16 = this.idCardNFCData;
                    if (iDCardNFCData16 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData16 = null;
                    }
                    iDCardNFCData16.setPermitType(dg13Parser.getSponsorRelationship());
                }
                if (Utility.Companion.getInstance().getDgFile10() != null) {
                    OmanCardDG10File dg10Parser = new OmanCardDG10File(Utility.Companion.getInstance().getDgFile10());
                    String string15 = this.context.getString(R.string.idcardvisaExpiryDate);
                    String string16 = dg10Parser.getVisaExpiryDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getVisaExpiryDate(...)");
                    documentHashmap.put(string15, (Object)this.formattedFrosting(string16));
                    documentHashmap.put(this.context.getString(R.string.idcardvisaPlaceOfIssueArabic), (Object)dg10Parser.getVisaPlaceOfIssueArabic());
                    documentHashmap.put(this.context.getString(R.string.idcardPermitNumber), (Object)dg10Parser.getVisaNumber());
                    IDCardNFCData iDCardNFCData17 = this.idCardNFCData;
                    if (iDCardNFCData17 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData17 = null;
                    }
                    String string17 = dg10Parser.getVisaExpiryDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"getVisaExpiryDate(...)");
                    iDCardNFCData17.setUseByDate(this.formattedFrosting(string17));
                    IDCardNFCData iDCardNFCData18 = this.idCardNFCData;
                    if (iDCardNFCData18 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData18 = null;
                    }
                    iDCardNFCData18.setVisaPlaceOfIssueArabic(dg10Parser.getVisaPlaceOfIssueArabic());
                    IDCardNFCData iDCardNFCData19 = this.idCardNFCData;
                    if (iDCardNFCData19 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData19 = null;
                    }
                    iDCardNFCData19.setPermitNumber(dg10Parser.getVisaNumber());
                }
                if (Utility.Companion.getInstance().getDgFile13() != null) {
                    dg13Parser = new OmanCardDG13File(Utility.Companion.getInstance().getDgFile13());
                    String string18 = this.context.getString(R.string.idcardsponsorIssueDate);
                    String string19 = dg13Parser.getSponsorIssueDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"getSponsorIssueDate(...)");
                    documentHashmap.put(string18, (Object)this.formattedFrosting(string19));
                    String string20 = this.context.getString(R.string.idcardsponsorExpiryDate);
                    String string21 = dg13Parser.getSponsorExpiryDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"getSponsorExpiryDate(...)");
                    documentHashmap.put(string20, (Object)this.formattedFrosting(string21));
                    IDCardNFCData iDCardNFCData20 = this.idCardNFCData;
                    if (iDCardNFCData20 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData20 = null;
                    }
                    String string22 = dg13Parser.getSponsorIssueDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"getSponsorIssueDate(...)");
                    iDCardNFCData20.setSponsorIssueDate(this.formattedFrosting(string22));
                    IDCardNFCData iDCardNFCData21 = this.idCardNFCData;
                    if (iDCardNFCData21 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData21 = null;
                    }
                    String string23 = dg13Parser.getSponsorExpiryDate();
                    Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"getSponsorExpiryDate(...)");
                    iDCardNFCData21.setSponsorExpiryDate(this.formattedFrosting(string23));
                }
                if (Utility.Companion.getInstance().getDgFile11() != null) {
                    OmanCardDG11File dg11Parser = new OmanCardDG11File(Utility.Companion.getInstance().getDgFile11());
                    documentHashmap.put(this.context.getString(R.string.idcardcompanyNameArabic), (Object)dg11Parser.getCompanyNameArabic());
                    documentHashmap.put(this.context.getString(R.string.idcardcompanyNameEnglish), (Object)dg11Parser.getCompanyNameEnglish());
                    documentHashmap.put(this.context.getString(R.string.idcardcompanyAddressArabic), (Object)dg11Parser.getCompanyAddressArabic());
                    IDCardNFCData iDCardNFCData22 = this.idCardNFCData;
                    if (iDCardNFCData22 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData22 = null;
                    }
                    iDCardNFCData22.setCompanyNameArabic(dg11Parser.getCompanyNameArabic());
                    IDCardNFCData iDCardNFCData23 = this.idCardNFCData;
                    if (iDCardNFCData23 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData23 = null;
                    }
                    iDCardNFCData23.setCompanyNameEnglish(dg11Parser.getCompanyNameEnglish());
                    IDCardNFCData iDCardNFCData24 = this.idCardNFCData;
                    if (iDCardNFCData24 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idCardNFCData");
                        iDCardNFCData24 = null;
                    }
                    iDCardNFCData24.setCompanyAddressAraic(dg11Parser.getCompanyAddressArabic());
                }
                NFCFragment.Companion.setNfcData(documentHashmap);
                this.uploadArtifact(LivenessData.getInstance().getNfcImage());
            }
            catch (Exception e) {
                Log.d((String)"TAG", (String)("setIDCardDetail: " + e));
            }
        }
    }

    private final void uploadArtifact(Bitmap bitmap) {
        block0: {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) break block0;
            Bitmap it = bitmap2;
            boolean bl = false;
            this.uploadArtifacts(it);
        }
    }

    private final void uploadArtifacts(Bitmap bitmap) {
        Utility utility = Utility.Companion.getInstance();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        File file = utility.bitmapToFile(bitmap2, (Context)this.context);
        MultipartBody.Part filePart = Utility.Companion.getInstance().createMultipartBody(file);
        String string2 = SdkConfig.INSTANCE.getRegisterToken();
        Intrinsics.checkNotNull((Object)string2);
        this.scanDocumentViewModel.uploadArtifact(string2, Utility.Companion.getInstance().getAppKey(), filePart, ArtifactType.NFC_IMAGE.getType());
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private final String formattedFrosting(String inputDate) {
        try {
            DateFormat sdf = new SimpleDateFormat(this.dateFormat);
            Date date = sdf.parse(inputDate);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-dd-MM");
            Date date2 = date;
            Intrinsics.checkNotNull((Object)date2);
            String string2 = simpleDateFormat.format(date2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        catch (Exception exception) {
            return inputDate;
        }
    }
}

