/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.helpers;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nashid.verify.sdk.utils.helpers.GeneralHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnashid/verify/sdk/utils/helpers/OmanIdCardReaderHelper;", "", "()V", "Companion", "VerifySDK_release"})
@StabilityInferred(parameters=1)
public final class OmanIdCardReaderHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lnashid/verify/sdk/utils/helpers/OmanIdCardReaderHelper$Companion;", "", "()V", "cleanString", "", "input", "isSimilarEnough", "", "a", "b", "threshold", "", "replaceAlfaWithNumber", "str", "replaceNumberWithAlfa", "VerifySDK_release"})
    @SourceDebugExtension(value={"SMAP\nOmanIdCardReaderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmanIdCardReaderHelper.kt\nnashid/verify/sdk/utils/helpers/OmanIdCardReaderHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1559#2:76\n1590#2,4:77\n970#3:81\n1041#3,2:82\n1043#3:85\n970#3:86\n1041#3,3:87\n1#4:84\n*S KotlinDebug\n*F\n+ 1 OmanIdCardReaderHelper.kt\nnashid/verify/sdk/utils/helpers/OmanIdCardReaderHelper$Companion\n*L\n34#1:76\n34#1:77,4\n58#1:81\n58#1:82,2\n58#1:85\n71#1:86\n71#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSimilarEnough(@NotNull String a, @NotNull String b, double threshold) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int maxLength = Math.max(a.length(), b.length());
            int distance = GeneralHelper.Companion.fuzzyMapping(a, b);
            double similarity = 1.0 - (double)distance / (double)maxLength;
            Log.d((String)"OmanIdCardReaderHelper", (String)("maxLength:" + maxLength + ", distance:" + distance + ", similarity:" + similarity));
            return similarity >= threshold;
        }

        public final boolean isSimilarEnough(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String string2 = input.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return this.isSimilarEnough(string2, "ROYAL OMAN POLICE D.G. OF CIVIL STATUS", 0.29);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String cleanString(@NotNull String input) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (input.length() < 18) {
                return "";
            }
            Log.d((String)"OmanIdCardReaderHelper", (String)("length: " + input.length() + ", input:" + input));
            Object[] objectArray = new String[4];
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(0, 7), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(7, 8), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(8, 15), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(15, 18), (String)"substring(...)");
            List groups = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$mapIndexed$iv = groups;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                String string2;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string3 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                switch (index) {
                    case 0: 
                    case 2: {
                        void group;
                        string2 = Companion.replaceAlfaWithNumber((String)group);
                        break;
                    }
                    case 1: 
                    case 3: {
                        void group;
                        string2 = Companion.replaceNumberWithAlfa((String)group);
                        break;
                    }
                    default: {
                        void group;
                        string2 = group;
                    }
                }
                collection.add(string2);
            }
            List mappedGroups = (List)destination$iv$iv;
            Object result2 = CollectionsKt.joinToString$default((Iterable)mappedGroups, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            result2 = (String)result2 + StringsKt.repeat((CharSequence)"<", (int)(29 - ((String)result2).length()));
            result2 = (String)result2 + StringsKt.last((CharSequence)input);
            Log.d((String)"OmanIdCardReaderHelper", (String)("length: " + ((String)result2).length() + ", result:" + (String)result2));
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String replaceNumberWithAlfa(@NotNull String str) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('0'), (Object)Character.valueOf('O')), TuplesKt.to((Object)Character.valueOf('1'), (Object)Character.valueOf('I')), TuplesKt.to((Object)Character.valueOf('2'), (Object)Character.valueOf('Z')), TuplesKt.to((Object)Character.valueOf('5'), (Object)Character.valueOf('S')), TuplesKt.to((Object)Character.valueOf('r'), (Object)Character.valueOf('F'))};
            Map replacementDigitMap = MapsKt.mapOf((Pair[])pairArray);
            CharSequence $this$map$iv = str;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map map = replacementDigitMap;
                Object object = map.get(Character.valueOf((char)it));
                if (object == null) {
                    boolean bl2 = false;
                    object = Character.valueOf((char)it);
                }
                collection.add(Character.valueOf(((Character)object).charValue()));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String replaceAlfaWithNumber(@NotNull String str) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('Z'), (Object)Character.valueOf('2')), TuplesKt.to((Object)Character.valueOf('S'), (Object)Character.valueOf('5')), TuplesKt.to((Object)Character.valueOf('I'), (Object)Character.valueOf('1')), TuplesKt.to((Object)Character.valueOf('O'), (Object)Character.valueOf('0')), TuplesKt.to((Object)Character.valueOf('B'), (Object)Character.valueOf('8')), TuplesKt.to((Object)Character.valueOf('T'), (Object)Character.valueOf('1'))};
            Map replacementCharMap = MapsKt.mapOf((Pair[])pairArray);
            CharSequence $this$map$iv = str;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map map = replacementCharMap;
                Object object = map.get(Character.valueOf((char)it));
                if (object == null) {
                    boolean bl2 = false;
                    object = Character.valueOf((char)it);
                }
                collection.add(Character.valueOf(((Character)object).charValue()));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

