/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.cbeff;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlock;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockDecoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.CBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ComplexCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.SimpleCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.StandardBiometricHeader;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVUtil;

public class ISO781611Decoder
implements ISO781611 {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private final BiometricDataBlockDecoder<?> bdbDecoder;

    public ISO781611Decoder(BiometricDataBlockDecoder<?> bdbDecoder) {
        this.bdbDecoder = bdbDecoder;
    }

    public ComplexCBEFFInfo decode(InputStream inputStream) throws IOException {
        return this.readBITGroup(inputStream);
    }

    private ComplexCBEFFInfo readBITGroup(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int tag = tlvIn.readTag();
        if (tag != 32609) {
            throw new IllegalArgumentException("Expected tag " + Integer.toHexString(32609) + ", found " + Integer.toHexString(tag));
        }
        int length = tlvIn.readLength();
        return this.readBITGroup(tag, length, inputStream);
    }

    private ComplexCBEFFInfo readBITGroup(int tag, int length, InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        ComplexCBEFFInfo result2 = new ComplexCBEFFInfo();
        if (tag != 32609) {
            throw new IllegalArgumentException("Expected tag " + Integer.toHexString(32609) + ", found " + Integer.toHexString(tag));
        }
        int bitCountTag = tlvIn.readTag();
        if (bitCountTag != 2) {
            throw new IllegalArgumentException("Expected tag BIOMETRIC_INFO_COUNT_TAG (" + Integer.toHexString(2) + ") in CBEFF structure, found " + Integer.toHexString(bitCountTag));
        }
        int bitCountLength = tlvIn.readLength();
        if (bitCountLength != 1) {
            throw new IllegalArgumentException("BIOMETRIC_INFO_COUNT should have length 1, found length " + bitCountLength);
        }
        int bitCount = tlvIn.readValue()[0] & 0xFF;
        for (int i = 0; i < bitCount; ++i) {
            result2.add(this.readBIT(inputStream, i));
        }
        return result2;
    }

    private CBEFFInfo readBIT(InputStream inputStream, int index) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int tag = tlvIn.readTag();
        int length = tlvIn.readLength();
        return this.readBIT(tag, length, inputStream, index);
    }

    private CBEFFInfo readBIT(int tag, int length, InputStream inputStream, int index) throws IOException {
        TLVInputStream tlvIn;
        TLVInputStream tLVInputStream = tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        if (tag != 32608) {
            throw new IllegalArgumentException("Expected tag BIOMETRIC_INFORMATION_TEMPLATE_TAG (" + Integer.toHexString(32608) + "), found " + Integer.toHexString(tag) + ", index is " + index);
        }
        int bhtTag = tlvIn.readTag();
        int bhtLength = tlvIn.readLength();
        if (bhtTag != 125) {
            if ((bhtTag & 0xA0) == 160) {
                StandardBiometricHeader sbh = this.readBHT(inputStream, bhtTag, bhtLength, index);
                BiometricDataBlock bdb = this.readBiometricDataBlock(inputStream, sbh, index);
                return new SimpleCBEFFInfo<BiometricDataBlock>(bdb);
            }
            throw new IllegalArgumentException("Unsupported template tag: " + Integer.toHexString(bhtTag));
        }
        this.readStaticallyProtectedBIT(inputStream, bhtTag, bhtLength, index);
        return null;
    }

    private StandardBiometricHeader readBHT(InputStream inputStream, int bhtTag, int bhtLength, int index) throws IOException {
        byte[] value;
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int expectedBHTTag = 161;
        if (bhtTag != expectedBHTTag) {
            LOGGER.warning("Expected tag " + Integer.toHexString(expectedBHTTag) + ", found " + Integer.toHexString(bhtTag));
        }
        HashMap<Integer, byte[]> elements = new HashMap<Integer, byte[]>();
        for (int bytesRead = 0; bytesRead < bhtLength; bytesRead += value.length) {
            int tag = tlvIn.readTag();
            bytesRead += TLVUtil.getTagLength((int)tag);
            int length = tlvIn.readLength();
            bytesRead += TLVUtil.getLengthLength((int)length);
            value = tlvIn.readValue();
            elements.put(tag, value);
        }
        return new StandardBiometricHeader(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStaticallyProtectedBIT(InputStream inputStream, int tag, int length, int index) throws IOException {
        try (TLVInputStream tlvBHTIn = new TLVInputStream((InputStream)new ByteArrayInputStream(this.decodeSMTValue(inputStream)));){
            int headerTemplateTag = tlvBHTIn.readTag();
            int headerTemplateLength = tlvBHTIn.readLength();
            StandardBiometricHeader sbh = this.readBHT((InputStream)tlvBHTIn, headerTemplateTag, headerTemplateLength, index);
            ByteArrayInputStream biometricDataBlockIn = new ByteArrayInputStream(this.decodeSMTValue(inputStream));
            this.readBiometricDataBlock(biometricDataBlockIn, sbh, index);
        }
    }

    private byte[] decodeSMTValue(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int doTag = tlvIn.readTag();
        int doLength = tlvIn.readLength();
        switch (doTag) {
            case 129: {
                return tlvIn.readValue();
            }
            case 133: {
                throw new AccessControlException("Access denied. Biometric Information Template is statically protected.");
            }
            case 142: {
                for (long skippedBytes = 0L; skippedBytes < (long)doLength; skippedBytes += tlvIn.skip((long)doLength)) {
                }
                return null;
            }
            case 158: {
                for (long skippedBytes = 0L; skippedBytes < (long)doLength; skippedBytes += tlvIn.skip((long)doLength)) {
                }
                return null;
            }
        }
        LOGGER.info("Unsupported data object tag " + Integer.toHexString(doTag));
        return null;
    }

    private BiometricDataBlock readBiometricDataBlock(InputStream inputStream, StandardBiometricHeader sbh, int index) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int bioDataBlockTag = tlvIn.readTag();
        if (bioDataBlockTag != 24366 && bioDataBlockTag != 32558) {
            throw new IllegalArgumentException("Expected tag BIOMETRIC_DATA_BLOCK_TAG (" + Integer.toHexString(24366) + ") or BIOMETRIC_DATA_BLOCK_TAG_ALT (" + Integer.toHexString(32558) + "), found " + Integer.toHexString(bioDataBlockTag));
        }
        int length = tlvIn.readLength();
        return this.bdbDecoder.decode(inputStream, sbh, index, length);
    }
}

