/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import nashid.verify.sdk.utils.id_card.jmrtd.cert.CardVerifiableCertificate;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public class CVCertificateFactorySpi
extends CertificateFactorySpi {
    private static final int CV_CERTIFICATE_TAG = 32545;

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            TLVInputStream tlvIn = new TLVInputStream(inputStream);
            int tag = tlvIn.readTag();
            if (tag != 32545) {
                throw new CertificateException("Expected CV_CERTIFICATE_TAG, found " + Integer.toHexString(tag));
            }
            tlvIn.readLength();
            byte[] value = tlvIn.readValue();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TLVOutputStream tlvOut = new TLVOutputStream((OutputStream)out);
            tlvOut.writeTag(32545);
            tlvOut.writeValue(value);
            tlvOut.close();
            CVCertificate parsedObject = CertificateParser.parseCertificate((byte[])out.toByteArray());
            return new CardVerifiableCertificate(parsedObject);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe);
        }
        catch (ConstructionException ce) {
            throw new CertificateException(ce);
        }
        catch (ParseException pe) {
            throw new CertificateException(pe);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        return null;
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) throws CRLException {
        return null;
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream in) throws CertificateException {
        return null;
    }
}

