/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.io.SplittableInputStream;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractLDSFile;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public abstract class AbstractTaggedLDSFile
extends AbstractLDSFile {
    private static final long serialVersionUID = -4761360877353069639L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private int tag;
    private int length;

    protected AbstractTaggedLDSFile(int dataGroupTag) {
        this.tag = dataGroupTag;
    }

    protected AbstractTaggedLDSFile(int tag, InputStream inputStream) throws IOException {
        this.tag = tag;
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int inputTag = tlvIn.readTag();
        if (inputTag != this.tag) {
            throw new IllegalArgumentException("Was expecting tag " + Integer.toHexString(this.tag) + ", found " + Integer.toHexString(inputTag));
        }
        this.length = tlvIn.readLength();
        this.readContent(new SplittableInputStream(inputStream, this.length));
    }

    @Override
    protected void writeObject(OutputStream outputStream) throws IOException {
        int ourLength;
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        int ourTag = this.getTag();
        if (this.tag != ourTag) {
            this.tag = ourTag;
        }
        tlvOut.writeTag(ourTag);
        byte[] value = this.getContent();
        int n = ourLength = value == null ? 0 : value.length;
        if (this.length != ourLength) {
            this.length = ourLength;
        }
        tlvOut.writeValue(value);
    }

    protected abstract void readContent(InputStream var1) throws IOException;

    protected abstract void writeContent(OutputStream var1) throws IOException;

    public String toString() {
        return "TaggedLDSFile [" + Integer.toHexString(this.getTag()) + " (" + this.getLength() + ")]";
    }

    public int getTag() {
        return this.tag;
    }

    @Override
    public int getLength() {
        if (this.length <= 0) {
            this.length = this.getContent().length;
        }
        return this.length;
    }

    private byte[] getContent() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not get DG content", ioe);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
    }
}

