/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.SecurityInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DLSet;

public class CardAccessFile
implements Serializable {
    private static final long serialVersionUID = -3536507558193769951L;
    private Set<SecurityInfo> securityInfos;

    public CardAccessFile(Collection<SecurityInfo> securityInfos) {
        if (securityInfos == null) {
            throw new IllegalArgumentException("Null securityInfos");
        }
        this.securityInfos = new HashSet<SecurityInfo>(securityInfos);
    }

    public CardAccessFile(InputStream inputStream) throws IOException {
        this.readContent(inputStream);
    }

    protected void readContent(InputStream inputStream) throws IOException {
        this.securityInfos = new HashSet<SecurityInfo>();
        ASN1InputStream asn1In = new ASN1InputStream(inputStream);
        ASN1Set set = (ASN1Set)asn1In.readObject();
        for (int i = 0; i < set.size(); ++i) {
            ASN1Primitive object = set.getObjectAt(i).toASN1Primitive();
            SecurityInfo securityInfo = SecurityInfo.getInstance(object);
            if (securityInfo == null) continue;
            this.securityInfos.add(securityInfo);
        }
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (SecurityInfo securityInfo : this.securityInfos) {
            vector.add((ASN1Encodable)securityInfo.getDERObject());
        }
        DLSet derSet = new DLSet(vector);
        outputStream.write(derSet.getEncoded("DER"));
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return Collections.unmodifiableCollection(this.securityInfos);
    }

    public String toString() {
        return "CardAccessFile [" + this.securityInfos.toString() + "]";
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!otherObj.getClass().equals(this.getClass())) {
            return false;
        }
        CardAccessFile other = (CardAccessFile)otherObj;
        if (this.securityInfos == null) {
            return other.securityInfos == null;
        }
        if (other.securityInfos == null) {
            return this.securityInfos == null;
        }
        return this.securityInfos.equals(other.securityInfos);
    }

    public int hashCode() {
        return 7 * this.securityInfos.hashCode() + 61;
    }
}

