/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import nashid.verify.sdk.utils.id_card.jmrtd.Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public final class SignedDataUtil {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String RFC_3369_SIGNED_DATA_OID = "1.2.840.113549.1.7.2";
    public static final String RFC_3369_CONTENT_TYPE_OID = "1.2.840.113549.1.9.3";
    public static final String RFC_3369_MESSAGE_DIGEST_OID = "1.2.840.113549.1.9.4";
    public static final String PKCS1_RSA_OID = "1.2.840.113549.1.1.1";
    public static final String PKCS1_MD2_WITH_RSA_OID = "1.2.840.113549.1.1.2";
    public static final String PKCS1_MD4_WITH_RSA_OID = "1.2.840.113549.1.1.3";
    public static final String PKCS1_MD5_WITH_RSA_OID = "1.2.840.113549.1.1.4";
    public static final String PKCS1_SHA1_WITH_RSA_OID = "1.2.840.113549.1.1.5";
    public static final String PKCS1_MGF1 = "1.2.840.113549.1.1.8";
    public static final String PKCS1_RSASSA_PSS_OID = "1.2.840.113549.1.1.10";
    public static final String PKCS1_SHA256_WITH_RSA_OID = "1.2.840.113549.1.1.11";
    public static final String PKCS1_SHA384_WITH_RSA_OID = "1.2.840.113549.1.1.12";
    public static final String PKCS1_SHA512_WITH_RSA_OID = "1.2.840.113549.1.1.13";
    public static final String PKCS1_SHA224_WITH_RSA_OID = "1.2.840.113549.1.1.14";
    public static final String X9_SHA1_WITH_ECDSA_OID = "1.2.840.10045.4.1";
    public static final String X9_SHA224_WITH_ECDSA_OID = "1.2.840.10045.4.3.1";
    public static final String X9_SHA256_WITH_ECDSA_OID = "1.2.840.10045.4.3.2";
    public static final String X9_SHA384_WITH_ECDSA_OID = "1.2.840.10045.4.3.3";
    public static final String X9_SHA512_WITH_ECDSA_OID = "1.2.840.10045.4.3.4";
    public static final String IEEE_P1363_SHA1_OID = "1.3.14.3.2.26";

    private SignedDataUtil() {
    }

    public static SignedData readSignedData(InputStream inputStream) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(inputStream);
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        if (sequence.size() != 2) {
            throw new IOException("Was expecting a DER sequence of length 2, found a DER sequence of length " + sequence.size());
        }
        String contentTypeOID = ((ASN1ObjectIdentifier)sequence.getObjectAt(0)).getId();
        if (!RFC_3369_SIGNED_DATA_OID.equals(contentTypeOID)) {
            throw new IOException("Was expecting signed-data content type OID (1.2.840.113549.1.7.2), found " + contentTypeOID);
        }
        ASN1Primitive asn1SequenceWithSignedData = SignedDataUtil.getObjectFromTaggedObject(sequence.getObjectAt(1));
        if (!(asn1SequenceWithSignedData instanceof ASN1Sequence)) {
            throw new IOException("Was expecting an ASN.1 sequence as content");
        }
        return SignedData.getInstance((Object)asn1SequenceWithSignedData);
    }

    public static void writeData(SignedData signedData, OutputStream outputStream) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(RFC_3369_SIGNED_DATA_OID));
        v.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)signedData));
        DLSequence fileContentsObject = new DLSequence(v);
        byte[] fileContentsBytes = fileContentsObject.getEncoded("DER");
        outputStream.write(fileContentsBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASN1Primitive getContent(SignedData signedData) {
        ContentInfo encapContentInfo = signedData.getEncapContentInfo();
        DEROctetString eContent = (DEROctetString)encapContentInfo.getContent();
        ASN1InputStream inputStream = null;
        try {
            inputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(eContent.getOctets()));
            ASN1Primitive aSN1Primitive = inputStream.readObject();
            return aSN1Primitive;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Unexpected exception", ioe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, "Exception closing input stream", ioe);
                }
            }
        }
        return null;
    }

    public static ASN1Primitive getObjectFromTaggedObject(ASN1Encodable asn1Encodable) throws IOException {
        ASN1TaggedObject asn1TaggedObject = null;
        if (!(asn1Encodable instanceof ASN1TaggedObject)) {
            asn1TaggedObject = (ASN1TaggedObject)asn1Encodable;
            throw new IOException("Was expecting an ASN1TaggedObject, found " + asn1Encodable.getClass().getCanonicalName());
        }
        int tagNo = asn1TaggedObject.getTagNo();
        if (tagNo != 0) {
            throw new IOException("Was expecting tag 0, found " + Integer.toHexString(tagNo));
        }
        return asn1TaggedObject.getLoadedObject();
    }

    public static String getSignerInfoDigestAlgorithm(SignedData signedData) {
        try {
            SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
            String digestAlgOID = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
            return SignedDataUtil.lookupMnemonicByOID(digestAlgOID);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.log(Level.WARNING, "No such algorithm" + nsae);
            return null;
        }
    }

    public static AlgorithmParameterSpec getDigestEncryptionAlgorithmParams(SignedData signedData) {
        try {
            SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
            AlgorithmIdentifier digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
            ASN1Encodable params = digestEncryptionAlgorithm.getParameters();
            String digestEncryptionAlgorithmOID = digestEncryptionAlgorithm.getAlgorithm().getId();
            if (PKCS1_RSASSA_PSS_OID.equals(digestEncryptionAlgorithmOID)) {
                RSASSAPSSparams rsaSSAParams = RSASSAPSSparams.getInstance((Object)params);
                return SignedDataUtil.toAlgorithmParameterSpec(rsaSSAParams);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
        }
        return null;
    }

    public static String getDigestEncryptionAlgorithm(SignedData signedData) {
        try {
            SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
            String digestEncryptionAlgorithmOID = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().getId();
            if (digestEncryptionAlgorithmOID == null) {
                LOGGER.warning("Could not determine digest encryption algorithm OID");
                return null;
            }
            return SignedDataUtil.lookupMnemonicByOID(digestEncryptionAlgorithmOID);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.log(Level.WARNING, "No such algorithm", nsae);
            return null;
        }
    }

    public static byte[] getEContent(SignedData signedData) throws SignatureException {
        SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
        ASN1Set signedAttributesSet = signerInfo.getAuthenticatedAttributes();
        ContentInfo contentInfo = signedData.getEncapContentInfo();
        byte[] contentBytes = ((DEROctetString)contentInfo.getContent()).getOctets();
        if (signedAttributesSet.size() == 0) {
            return contentBytes;
        }
        byte[] attributesBytes = null;
        String digAlg = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
        try {
            attributesBytes = signedAttributesSet.getEncoded("DER");
            SignedDataUtil.checkEContent(SignedDataUtil.getAttributes(signedAttributesSet), digAlg, contentBytes);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.log(Level.WARNING, "Error checking signedAttributes in eContent! No such algorithm: \"" + digAlg, nsae);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error getting signedAttributes", ioe);
        }
        return attributesBytes;
    }

    public static byte[] getEncryptedDigest(SignedData signedData) {
        SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
        return signerInfo.getEncryptedDigest().getOctets();
    }

    public static IssuerAndSerialNumber getIssuerAndSerialNumber(SignedData signedData) {
        SignerInfo signerInfo = SignedDataUtil.getSignerInfo(signedData);
        SignerIdentifier signerIdentifier = signerInfo.getSID();
        ASN1Encodable signerIdentifierId = signerIdentifier.getId();
        if (!(signerIdentifierId instanceof ASN1Sequence) && !(signerIdentifierId instanceof IssuerAndSerialNumber)) {
            return null;
        }
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifierId);
        X500Name issuer = issuerAndSerialNumber.getName();
        BigInteger serialNumber = issuerAndSerialNumber.getSerialNumber().getValue();
        return new IssuerAndSerialNumber(issuer, serialNumber);
    }

    public static List<ASN1Primitive> getObjectsFromOctetString(ASN1OctetString octetString) {
        ArrayList<ASN1Primitive> result2 = new ArrayList<ASN1Primitive>();
        byte[] octets = octetString.getOctets();
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(octets));
        try {
            ASN1Primitive derObject;
            while ((derObject = derInputStream.readObject()) != null) {
                result2.add(derObject);
            }
            derInputStream.close();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception", ioe);
        }
        return result2;
    }

    public static List<X509Certificate> getCertificates(SignedData signedData) {
        ASN1Set encodedCertificates = signedData.getCertificates();
        int certificateCount = encodedCertificates == null ? 0 : encodedCertificates.size();
        ArrayList<X509Certificate> result2 = new ArrayList<X509Certificate>(certificateCount);
        if (certificateCount <= 0) {
            return result2;
        }
        for (int i = 0; i < certificateCount; ++i) {
            try {
                Certificate certAsASN1Object = Certificate.getInstance((Object)encodedCertificates.getObjectAt(i));
                result2.add(SignedDataUtil.decodeCertificate(certAsASN1Object));
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception in decoding certificate", e);
            }
        }
        return result2;
    }

    public static X509Certificate decodeCertificate(Certificate certAsASN1Object) throws IOException, GeneralSecurityException {
        byte[] certSpec = certAsASN1Object.getEncoded("DER");
        CertificateFactory factory = CertificateFactory.getInstance("X.509", Util.getBouncyCastleProvider());
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certSpec));
    }

    public static SignedData createSignedData(String digestAlgorithm, String digestEncryptionAlgorithm, String contentTypeOID, ContentInfo contentInfo, byte[] encryptedDigest, X509Certificate docSigningCertificate) throws GeneralSecurityException {
        ASN1Set digestAlgorithmsSet = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createDigestAlgorithms(digestAlgorithm));
        ASN1Set certificates = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createCertificate(docSigningCertificate));
        ASN1Set crls = null;
        ASN1Set signerInfos = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createSignerInfo(digestAlgorithm, digestEncryptionAlgorithm, contentTypeOID, contentInfo, encryptedDigest, docSigningCertificate).toASN1Primitive());
        return new SignedData(digestAlgorithmsSet, contentInfo, certificates, crls, signerInfos);
    }

    public static SignerInfo createSignerInfo(String digestAlgorithm, String digestEncryptionAlgorithm, String contentTypeOID, ContentInfo contentInfo, byte[] encryptedDigest, X509Certificate docSigningCertificate) throws GeneralSecurityException {
        if (encryptedDigest == null) {
            throw new IllegalArgumentException("Encrypted digest cannot be null");
        }
        X500Principal docSignerPrincipal = docSigningCertificate.getIssuerX500Principal();
        X500Name docSignerName = new X500Name(docSignerPrincipal.getName("RFC2253"));
        BigInteger serial = docSigningCertificate.getSerialNumber();
        SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(docSignerName, serial));
        AlgorithmIdentifier digestAlgorithmObject = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(digestAlgorithm)));
        AlgorithmIdentifier digestEncryptionAlgorithmObject = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(digestEncryptionAlgorithm)));
        ASN1Set authenticatedAttributes = SignedDataUtil.createAuthenticatedAttributes(digestAlgorithm, contentTypeOID, contentInfo);
        DEROctetString encryptedDigestObject = new DEROctetString(encryptedDigest);
        ASN1Set unAuthenticatedAttributes = null;
        return new SignerInfo(sid, digestAlgorithmObject, authenticatedAttributes, digestEncryptionAlgorithmObject, (ASN1OctetString)encryptedDigestObject, unAuthenticatedAttributes);
    }

    public static ASN1Set createAuthenticatedAttributes(String digestAlgorithm, String contentTypeOID, ContentInfo contentInfo) throws GeneralSecurityException {
        if ("SHA256".equals(digestAlgorithm)) {
            digestAlgorithm = "SHA-256";
        }
        MessageDigest dig = Util.getMessageDigest(digestAlgorithm);
        byte[] contentBytes = ((DEROctetString)contentInfo.getContent()).getOctets();
        byte[] digestedContentBytes = dig.digest(contentBytes);
        DEROctetString digestedContent = new DEROctetString(digestedContentBytes);
        Attribute contentTypeAttribute = new Attribute(new ASN1ObjectIdentifier(RFC_3369_CONTENT_TYPE_OID), SignedDataUtil.createSingletonSet((ASN1Object)new ASN1ObjectIdentifier(contentTypeOID)));
        Attribute messageDigestAttribute = new Attribute(new ASN1ObjectIdentifier(RFC_3369_MESSAGE_DIGEST_OID), SignedDataUtil.createSingletonSet((ASN1Object)digestedContent));
        ASN1Object[] result2 = new ASN1Object[]{contentTypeAttribute.toASN1Primitive(), messageDigestAttribute.toASN1Primitive()};
        return new DLSet((ASN1Encodable[])result2);
    }

    public static ASN1Sequence createDigestAlgorithms(String digestAlgorithm) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier algorithmIdentifier = new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(digestAlgorithm));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)algorithmIdentifier);
        return new DLSequence(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASN1Sequence createCertificate(X509Certificate certificate) throws CertificateException {
        ASN1Sequence aSN1Sequence;
        if (certificate == null) {
            throw new IllegalArgumentException("Cannot encode null certificate");
        }
        byte[] certSpec = certificate.getEncoded();
        ASN1InputStream asn1In = new ASN1InputStream(certSpec);
        try {
            aSN1Sequence = (ASN1Sequence)asn1In.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    asn1In.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, "Error closing stream", ioe);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new CertificateException("Could not construct certificate byte stream", ioe);
            }
        }
        try {
            asn1In.close();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error closing stream", ioe);
        }
        return aSN1Sequence;
    }

    public static byte[] signData(String digestAlgorithm, String digestEncryptionAlgorithm, String contentTypeOID, ContentInfo contentInfo, PrivateKey privateKey, String provider) {
        byte[] encryptedDigest = null;
        try {
            byte[] dataToBeSigned = SignedDataUtil.createAuthenticatedAttributes(digestAlgorithm, contentTypeOID, contentInfo).getEncoded("DER");
            Signature s = null;
            s = provider != null ? Signature.getInstance(digestEncryptionAlgorithm, provider) : Signature.getInstance(digestEncryptionAlgorithm);
            s.initSign(privateKey);
            s.update(dataToBeSigned);
            encryptedDigest = s.sign();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
            return null;
        }
        return encryptedDigest;
    }

    public static String lookupMnemonicByOID(String oid) throws NoSuchAlgorithmException {
        if (oid == null) {
            return null;
        }
        if (oid.equals(X509ObjectIdentifiers.organization.getId())) {
            return "O";
        }
        if (oid.equals(X509ObjectIdentifiers.organizationalUnitName.getId())) {
            return "OU";
        }
        if (oid.equals(X509ObjectIdentifiers.commonName.getId())) {
            return "CN";
        }
        if (oid.equals(X509ObjectIdentifiers.countryName.getId())) {
            return "C";
        }
        if (oid.equals(X509ObjectIdentifiers.stateOrProvinceName.getId())) {
            return "ST";
        }
        if (oid.equals(X509ObjectIdentifiers.localityName.getId())) {
            return "L";
        }
        if (oid.equals(X509ObjectIdentifiers.id_SHA1.getId())) {
            return "SHA-1";
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha224.getId())) {
            return "SHA-224";
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha256.getId())) {
            return "SHA-256";
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha384.getId())) {
            return "SHA-384";
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha512.getId())) {
            return "SHA-512";
        }
        if (oid.equals(X9_SHA1_WITH_ECDSA_OID)) {
            return "SHA1withECDSA";
        }
        if (oid.equals(X9_SHA224_WITH_ECDSA_OID)) {
            return "SHA224withECDSA";
        }
        if (oid.equals(X9_SHA256_WITH_ECDSA_OID)) {
            return "SHA256withECDSA";
        }
        if (oid.equals(X9_SHA384_WITH_ECDSA_OID)) {
            return "SHA384withECDSA";
        }
        if (oid.equals(X9_SHA512_WITH_ECDSA_OID)) {
            return "SHA512withECDSA";
        }
        if (oid.equals(PKCS1_RSA_OID)) {
            return "RSA";
        }
        if (oid.equals(PKCS1_MD2_WITH_RSA_OID)) {
            return "MD2withRSA";
        }
        if (oid.equals(PKCS1_MD4_WITH_RSA_OID)) {
            return "MD4withRSA";
        }
        if (oid.equals(PKCS1_MD5_WITH_RSA_OID)) {
            return "MD5withRSA";
        }
        if (oid.equals(PKCS1_SHA1_WITH_RSA_OID)) {
            return "SHA1withRSA";
        }
        if (oid.equals(PKCS1_SHA256_WITH_RSA_OID)) {
            return "SHA256withRSA";
        }
        if (oid.equals(PKCS1_SHA384_WITH_RSA_OID)) {
            return "SHA384withRSA";
        }
        if (oid.equals(PKCS1_SHA512_WITH_RSA_OID)) {
            return "SHA512withRSA";
        }
        if (oid.equals(PKCS1_SHA224_WITH_RSA_OID)) {
            return "SHA224withRSA";
        }
        if (oid.equals(IEEE_P1363_SHA1_OID)) {
            return "SHA-1";
        }
        if (oid.equals(PKCS1_RSASSA_PSS_OID)) {
            return "SSAwithRSA/PSS";
        }
        if (oid.equals(PKCS1_MGF1)) {
            return "MGF1";
        }
        throw new NoSuchAlgorithmException("Unknown OID " + oid);
    }

    public static String lookupOIDByMnemonic(String name) throws NoSuchAlgorithmException {
        if ("O".equals(name)) {
            return X509ObjectIdentifiers.organization.getId();
        }
        if ("OU".equals(name)) {
            return X509ObjectIdentifiers.organizationalUnitName.getId();
        }
        if ("CN".equals(name)) {
            return X509ObjectIdentifiers.commonName.getId();
        }
        if ("C".equals(name)) {
            return X509ObjectIdentifiers.countryName.getId();
        }
        if ("ST".equals(name)) {
            return X509ObjectIdentifiers.stateOrProvinceName.getId();
        }
        if ("L".equals(name)) {
            return X509ObjectIdentifiers.localityName.getId();
        }
        if ("SHA-1".equalsIgnoreCase(name) || "SHA1".equalsIgnoreCase(name)) {
            return X509ObjectIdentifiers.id_SHA1.getId();
        }
        if ("SHA-224".equalsIgnoreCase(name) || "SHA224".equalsIgnoreCase(name)) {
            return NISTObjectIdentifiers.id_sha224.getId();
        }
        if ("SHA-256".equalsIgnoreCase(name) || "SHA256".equalsIgnoreCase(name)) {
            return NISTObjectIdentifiers.id_sha256.getId();
        }
        if ("SHA-384".equalsIgnoreCase(name) || "SHA384".equalsIgnoreCase(name)) {
            return NISTObjectIdentifiers.id_sha384.getId();
        }
        if ("SHA-512".equalsIgnoreCase(name) || "SHA512".equalsIgnoreCase(name)) {
            return NISTObjectIdentifiers.id_sha512.getId();
        }
        if ("RSA".equalsIgnoreCase(name)) {
            return PKCS1_RSA_OID;
        }
        if ("MD2withRSA".equalsIgnoreCase(name)) {
            return PKCS1_MD2_WITH_RSA_OID;
        }
        if ("MD4withRSA".equalsIgnoreCase(name)) {
            return PKCS1_MD4_WITH_RSA_OID;
        }
        if ("MD5withRSA".equalsIgnoreCase(name)) {
            return PKCS1_MD5_WITH_RSA_OID;
        }
        if ("SHA1withRSA".equalsIgnoreCase(name)) {
            return PKCS1_SHA1_WITH_RSA_OID;
        }
        if ("SHA256withRSA".equalsIgnoreCase(name)) {
            return PKCS1_SHA256_WITH_RSA_OID;
        }
        if ("SHA384withRSA".equalsIgnoreCase(name)) {
            return PKCS1_SHA384_WITH_RSA_OID;
        }
        if ("SHA512withRSA".equalsIgnoreCase(name)) {
            return PKCS1_SHA512_WITH_RSA_OID;
        }
        if ("SHA224withRSA".equalsIgnoreCase(name)) {
            return PKCS1_SHA224_WITH_RSA_OID;
        }
        if ("SHA1withECDSA".equalsIgnoreCase(name)) {
            return X9_SHA1_WITH_ECDSA_OID;
        }
        if ("SHA224withECDSA".equalsIgnoreCase(name)) {
            return X9_SHA224_WITH_ECDSA_OID;
        }
        if ("SHA256withECDSA".equalsIgnoreCase(name)) {
            return X9_SHA256_WITH_ECDSA_OID;
        }
        if ("SHA384withECDSA".equalsIgnoreCase(name)) {
            return X9_SHA384_WITH_ECDSA_OID;
        }
        if ("SHA512withECDSA".equalsIgnoreCase(name)) {
            return X9_SHA512_WITH_ECDSA_OID;
        }
        if ("SAwithRSA/PSS".equalsIgnoreCase(name)) {
            return PKCS1_RSASSA_PSS_OID;
        }
        if ("SSAwithRSA/PSS".equalsIgnoreCase(name)) {
            return PKCS1_RSASSA_PSS_OID;
        }
        if ("RSASSA-PSS".equalsIgnoreCase(name)) {
            return PKCS1_RSASSA_PSS_OID;
        }
        if ("MGF1".equalsIgnoreCase(name)) {
            return PKCS1_MGF1;
        }
        if ("SHA256withRSAandMGF1".equalsIgnoreCase(name)) {
            return PKCS1_MGF1;
        }
        if ("SHA512withRSAandMGF1".equalsIgnoreCase(name)) {
            return PKCS1_MGF1;
        }
        throw new NoSuchAlgorithmException("Unknown name " + name);
    }

    private static void checkEContent(Collection<Attribute> attributes, String digAlg, byte[] contentBytes) throws NoSuchAlgorithmException, SignatureException {
        for (Attribute attribute : attributes) {
            MessageDigest dig;
            byte[] computedDigestedContent;
            byte[] storedDigestedContent;
            if (!RFC_3369_MESSAGE_DIGEST_OID.equals(attribute.getAttrType().getId())) continue;
            ASN1Set attrValuesSet = attribute.getAttrValues();
            if (attrValuesSet.size() != 1) {
                LOGGER.warning("Expected only one attribute value in signedAttribute message digest in eContent!");
            }
            if ((storedDigestedContent = ((DEROctetString)attrValuesSet.getObjectAt(0)).getOctets()) == null) {
                LOGGER.warning("Error extracting signedAttribute message digest in eContent!");
            }
            if (Arrays.equals(storedDigestedContent, computedDigestedContent = (dig = MessageDigest.getInstance(digAlg)).digest(contentBytes))) continue;
            throw new SignatureException("Error checking signedAttribute message digest in eContent!");
        }
    }

    private static List<Attribute> getAttributes(ASN1Set signedAttributesSet) {
        ArrayList<ASN1Sequence> attributeObjects = Collections.list(signedAttributesSet.getObjects());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributeObjects.size());
        for (ASN1Sequence attributeObject : attributeObjects) {
            Attribute attribute = Attribute.getInstance((Object)attributeObject);
            attributes.add(attribute);
        }
        return attributes;
    }

    private static AlgorithmParameterSpec toAlgorithmParameterSpec(RSASSAPSSparams rsaSSAParams) throws NoSuchAlgorithmException {
        String hashAlgorithmOID = rsaSSAParams.getHashAlgorithm().getAlgorithm().getId();
        AlgorithmIdentifier maskGenAlgorithm = rsaSSAParams.getMaskGenAlgorithm();
        String maskGenAlgorithmOID = maskGenAlgorithm.getAlgorithm().getId();
        String hashAlgorithmName = SignedDataUtil.lookupMnemonicByOID(hashAlgorithmOID);
        String maskGenAlgorithmName = SignedDataUtil.lookupMnemonicByOID(maskGenAlgorithmOID);
        int saltLength = rsaSSAParams.getSaltLength().intValue();
        int trailerField = rsaSSAParams.getTrailerField().intValue();
        return new PSSParameterSpec(hashAlgorithmName, maskGenAlgorithmName, SignedDataUtil.toMaskGenAlgorithmParameterSpec(maskGenAlgorithm), saltLength, trailerField);
    }

    private static AlgorithmParameterSpec toMaskGenAlgorithmParameterSpec(AlgorithmIdentifier maskGenAlgorithm) {
        try {
            ASN1Encodable maskGenParams = maskGenAlgorithm.getParameters();
            if (maskGenParams != null) {
                AlgorithmIdentifier hashIdentifier = AlgorithmIdentifier.getInstance((Object)maskGenParams);
                String hashOID = hashIdentifier.getAlgorithm().getId();
                String hashName = SignedDataUtil.lookupMnemonicByOID(hashOID);
                return new MGF1ParameterSpec(hashName);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
        }
        return new MGF1ParameterSpec("SHA-1");
    }

    private static SignerInfo getSignerInfo(SignedData signedData) {
        ASN1Set signerInfos = signedData.getSignerInfos();
        if (signerInfos == null || signerInfos.size() <= 0) {
            throw new IllegalArgumentException("No signer info in signed data");
        }
        if (signerInfos.size() > 1) {
            LOGGER.warning("Found " + signerInfos.size() + " signerInfos");
        }
        return SignerInfo.getInstance((Object)signerInfos.getObjectAt(0));
    }

    private static ASN1Set createSingletonSet(ASN1Object e) {
        return new DLSet(new ASN1Encodable[]{e});
    }
}

