/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds;

import nashid.verify.sdk.utils.id_card.jmrtd.lds.SecurityInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;

public class TerminalAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 6220506985707094044L;
    public static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private final String oid;
    private final int version;
    private final transient ASN1Sequence efCVCA;

    TerminalAuthenticationInfo(String oid, int version, ASN1Sequence efCVCA) {
        this.oid = oid;
        this.version = version;
        this.efCVCA = efCVCA;
        this.checkFields();
    }

    TerminalAuthenticationInfo(String identifier, int version) {
        this(identifier, version, null);
    }

    public TerminalAuthenticationInfo() {
        this(ID_TA, 1);
    }

    public TerminalAuthenticationInfo(short fileId, byte shortFileId) {
        this(ID_TA, 1, TerminalAuthenticationInfo.constructEFCVCA(fileId, shortFileId));
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.oid));
        v.add((ASN1Encodable)new ASN1Integer((long)this.version));
        if (this.efCVCA != null) {
            v.add((ASN1Encodable)this.efCVCA);
        }
        return new DLSequence(v);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return this.toProtocolOIDString(this.oid);
    }

    public int getFileId() {
        return TerminalAuthenticationInfo.getFID(this.efCVCA);
    }

    public byte getShortFileId() {
        return TerminalAuthenticationInfo.getSFI(this.efCVCA);
    }

    public String toString() {
        return "TerminalAuthenticationInfo [protocol: " + this.toProtocolOIDString(this.oid) + ", version: " + this.version + ", fileID: " + this.getFileId() + ", shortFileID: " + this.getShortFileId() + "]";
    }

    public int hashCode() {
        return 123 + 7 * (this.oid == null ? 0 : this.oid.hashCode()) + 5 * this.version + 3 * (this.efCVCA == null ? 1 : this.efCVCA.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!TerminalAuthenticationInfo.class.equals(other.getClass())) {
            return false;
        }
        TerminalAuthenticationInfo otherTerminalAuthenticationInfo = (TerminalAuthenticationInfo)other;
        if (this.efCVCA == null && otherTerminalAuthenticationInfo.efCVCA != null) {
            return false;
        }
        if (this.efCVCA != null && otherTerminalAuthenticationInfo.efCVCA == null) {
            return false;
        }
        return this.getDERObject().equals(otherTerminalAuthenticationInfo.getDERObject());
    }

    static boolean checkRequiredIdentifier(String id2) {
        return ID_TA.equals(id2);
    }

    private void checkFields() {
        try {
            if (!TerminalAuthenticationInfo.checkRequiredIdentifier(this.oid)) {
                throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            }
            if (this.version != 1 && this.version != 2) {
                throw new IllegalArgumentException("Wrong version. Was expecting 1 or 2, found " + this.version);
            }
            if (this.efCVCA != null) {
                DEROctetString sfi;
                DEROctetString fid = (DEROctetString)this.efCVCA.getObjectAt(0);
                if (fid.getOctets().length != 2) {
                    throw new IllegalArgumentException("Malformed FID.");
                }
                if (this.efCVCA.size() == 2 && (sfi = (DEROctetString)this.efCVCA.getObjectAt(1)).getOctets().length != 1) {
                    throw new IllegalArgumentException("Malformed SFI.");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed TerminalAuthenticationInfo", e);
        }
    }

    private static ASN1Sequence constructEFCVCA(short fid, byte sfi) {
        if (sfi != -1) {
            return new DLSequence(new ASN1Encodable[]{new DEROctetString(new byte[]{(byte)((fid & 0xFF00) >> 8), (byte)(fid & 0xFF)}), new DEROctetString(new byte[]{(byte)(sfi & 0xFF)})});
        }
        return new DLSequence(new ASN1Encodable[]{new DEROctetString(new byte[]{(byte)((fid & 0xFF00) >> 8), (byte)(fid & 0xFF)})});
    }

    private static short getFID(ASN1Sequence efCVCA) {
        if (efCVCA == null) {
            return -1;
        }
        ASN1Sequence s = efCVCA;
        DEROctetString fid = (DEROctetString)s.getObjectAt(0);
        byte[] bytes = fid.getOctets();
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    private static byte getSFI(ASN1Sequence efCVCA) {
        if (efCVCA == null) {
            return -1;
        }
        if (efCVCA.size() != 2) {
            return -1;
        }
        return ((DEROctetString)efCVCA.getObjectAt(1)).getOctets()[0];
    }

    private String toProtocolOIDString(String oid) {
        if (ID_TA.equals(oid)) {
            return "id-TA";
        }
        if (ID_TA_RSA.equals(oid)) {
            return "id-TA-RSA";
        }
        if (ID_TA_RSA_V1_5_SHA_1.equals(oid)) {
            return "id-TA-RSA-v1-5-SHA-1";
        }
        if (ID_TA_RSA_V1_5_SHA_256.equals(oid)) {
            return "id-TA-RSA-v1-5-SHA-256";
        }
        if (ID_TA_RSA_PSS_SHA_1.equals(oid)) {
            return "id-TA-RSA-PSS-SHA-1";
        }
        if (ID_TA_RSA_PSS_SHA_256.equals(oid)) {
            return "id-TA-RSA-PSS-SHA-256";
        }
        if (ID_TA_ECDSA.equals(oid)) {
            return "id-TA-ECDSA";
        }
        if (ID_TA_ECDSA_SHA_1.equals(oid)) {
            return "id-TA-ECDSA-SHA-1";
        }
        if (ID_TA_ECDSA_SHA_224.equals(oid)) {
            return "id-TA-ECDSA-SHA-224";
        }
        if (ID_TA_ECDSA_SHA_256.equals(oid)) {
            return "id-TA-ECDSA-SHA-256";
        }
        return oid;
    }
}

