/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.ActiveAuthenticationInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.ChipAuthenticationInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.DataGroup;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.SecurityInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.TerminalAuthenticationInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DLSet;

public class DG14File
extends DataGroup {
    private static final long serialVersionUID = -3536507558193769953L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private Set<SecurityInfo> securityInfos;

    public DG14File(Collection<SecurityInfo> securityInfos) {
        super(110);
        if (securityInfos == null) {
            throw new IllegalArgumentException("Null securityInfos");
        }
        this.securityInfos = new HashSet<SecurityInfo>(securityInfos);
    }

    public DG14File(InputStream inputStream) throws IOException {
        super(110, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        this.securityInfos = new HashSet<SecurityInfo>();
        ASN1InputStream asn1In = new ASN1InputStream(inputStream);
        ASN1Set set = (ASN1Set)asn1In.readObject();
        for (int i = 0; i < set.size(); ++i) {
            ASN1Primitive object = set.getObjectAt(i).toASN1Primitive();
            try {
                SecurityInfo securityInfo = SecurityInfo.getInstance(object);
                if (securityInfo == null) {
                    LOGGER.warning("Skipping this unsupported SecurityInfo");
                    continue;
                }
                this.securityInfos.add(securityInfo);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Skipping Security Info", e);
            }
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (SecurityInfo securityInfo : this.securityInfos) {
            ASN1Primitive derObject = securityInfo.getDERObject();
            vector.add((ASN1Encodable)derObject);
        }
        DLSet derSet = new DLSet(vector);
        outputStream.write(derSet.getEncoded("DER"));
    }

    @Deprecated
    public List<TerminalAuthenticationInfo> getTerminalAuthenticationInfos() {
        ArrayList<TerminalAuthenticationInfo> terminalAuthenticationInfos = new ArrayList<TerminalAuthenticationInfo>();
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof TerminalAuthenticationInfo)) continue;
            terminalAuthenticationInfos.add((TerminalAuthenticationInfo)securityInfo);
        }
        return terminalAuthenticationInfos;
    }

    @Deprecated
    public List<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList<ChipAuthenticationInfo> map = new ArrayList<ChipAuthenticationInfo>();
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            map.add((ChipAuthenticationInfo)securityInfo);
            if (((ChipAuthenticationInfo)securityInfo).getKeyId() != null) continue;
            return map;
        }
        return map;
    }

    @Deprecated
    public List<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList<ChipAuthenticationPublicKeyInfo> publicKeys = new ArrayList<ChipAuthenticationPublicKeyInfo>();
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            publicKeys.add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return publicKeys;
    }

    @Deprecated
    public List<ActiveAuthenticationInfo> getActiveAuthenticationInfos() {
        ArrayList<ActiveAuthenticationInfo> resultList = new ArrayList<ActiveAuthenticationInfo>();
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof ActiveAuthenticationInfo)) continue;
            resultList.add((ActiveAuthenticationInfo)securityInfo);
        }
        return resultList;
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return this.securityInfos;
    }

    @Override
    public String toString() {
        return "DG14File [" + this.securityInfos.toString() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        DG14File other = (DG14File)obj;
        if (this.securityInfos == null) {
            return other.securityInfos == null;
        }
        if (other.securityInfos == null) {
            return this.securityInfos == null;
        }
        return this.securityInfos.equals(other.securityInfos);
    }

    public int hashCode() {
        return 5 * this.securityInfos.hashCode() + 41;
    }
}

