/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockDecoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlockEncoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.CBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ComplexCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Decoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.ISO781611Encoder;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.SimpleCBEFFInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.StandardBiometricHeader;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.CBEFFDataGroup;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794.FaceInfo;

public class DG2File
extends CBEFFDataGroup<FaceInfo> {
    private static final long serialVersionUID = 414300652684010416L;
    private static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<FaceInfo>(){

        @Override
        public FaceInfo decode(InputStream inputStream, StandardBiometricHeader sbh, int index, int length) throws IOException {
            return new FaceInfo(sbh, inputStream);
        }
    });
    private static final ISO781611Encoder<FaceInfo> ENCODER = new ISO781611Encoder<FaceInfo>(new BiometricDataBlockEncoder<FaceInfo>(){

        @Override
        public void encode(FaceInfo info, OutputStream outputStream) throws IOException {
            info.writeObject(outputStream);
        }
    });

    public DG2File(List<FaceInfo> faceInfos) {
        super(117, faceInfos);
    }

    public DG2File(InputStream inputStream) throws IOException {
        super(117, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        ComplexCBEFFInfo complexCBEFFInfo = DECODER.decode(inputStream);
        List<CBEFFInfo> records = complexCBEFFInfo.getSubRecords();
        for (CBEFFInfo cbeffInfo : records) {
            if (!(cbeffInfo instanceof SimpleCBEFFInfo)) {
                throw new IOException("Was expecting a SimpleCBEFFInfo, found " + cbeffInfo.getClass().getSimpleName());
            }
            Object bdb = ((SimpleCBEFFInfo)cbeffInfo).getBiometricDataBlock();
            if (!(bdb instanceof FaceInfo)) {
                throw new IOException("Was expecting a FaceInfo, found " + bdb.getClass().getSimpleName());
            }
            this.add((FaceInfo)bdb);
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        ComplexCBEFFInfo cbeffInfo = new ComplexCBEFFInfo();
        List faceInfos = this.getSubRecords();
        for (FaceInfo faceInfo : faceInfos) {
            SimpleCBEFFInfo<FaceInfo> simpleCBEFFInfo = new SimpleCBEFFInfo<FaceInfo>(faceInfo);
            cbeffInfo.add(simpleCBEFFInfo);
        }
        ENCODER.encode(cbeffInfo, outputStream);
    }

    @Override
    public String toString() {
        return "DG2File [" + super.toString() + "]";
    }

    public List<FaceInfo> getFaceInfos() {
        return this.getSubRecords();
    }

    public void addFaceInfo(FaceInfo faceInfo) {
        this.add(faceInfo);
    }

    public void removeFaceInfo(int index) {
        this.remove(index);
    }
}

