/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractImageInfo;
import net.sf.scuba.data.Gender;

public class FaceImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = -1751069410327594067L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int EYE_COLOR_UNSPECIFIED = 0;
    public static final int EYE_COLOR_BLACK = 1;
    public static final int EYE_COLOR_BLUE = 2;
    public static final int EYE_COLOR_BROWN = 3;
    public static final int EYE_COLOR_GRAY = 4;
    public static final int EYE_COLOR_GREEN = 5;
    public static final int EYE_COLOR_MULTI_COLORED = 6;
    public static final int EYE_COLOR_PINK = 7;
    public static final int EYE_COLOR_UNKNOWN = 255;
    public static final int HAIR_COLOR_UNSPECIFIED = 0;
    public static final int HAIR_COLOR_BALD = 1;
    public static final int HAIR_COLOR_BLACK = 2;
    public static final int HAIR_COLOR_BLONDE = 3;
    public static final int HAIR_COLOR_BROWN = 4;
    public static final int HAIR_COLOR_GRAY = 5;
    public static final int HAIR_COLOR_WHITE = 6;
    public static final int HAIR_COLOR_RED = 7;
    public static final int HAIR_COLOR_GREEN = 8;
    public static final int HAIR_COLOR_BLUE = 9;
    public static final int HAIR_COLOR_UNKNOWN = 255;
    private static final int FEATURE_FEATURES_ARE_SPECIFIED_FLAG = 1;
    private static final int FEATURE_GLASSES_FLAG = 2;
    private static final int FEATURE_MOUSTACHE_FLAG = 4;
    private static final int FEATURE_BEARD_FLAG = 8;
    private static final int FEATURE_TEETH_VISIBLE_FLAG = 16;
    private static final int FEATURE_BLINK_FLAG = 32;
    private static final int FEATURE_MOUTH_OPEN_FLAG = 64;
    private static final int FEATURE_LEFT_EYE_PATCH_FLAG = 128;
    private static final int FEATURE_RIGHT_EYE_PATCH = 256;
    private static final int FEATURE_DARK_GLASSES = 512;
    private static final int FEATURE_DISTORTING_MEDICAL_CONDITION = 1024;
    public static final short EXPRESSION_UNSPECIFIED = 0;
    public static final short EXPRESSION_NEUTRAL = 1;
    public static final short EXPRESSION_SMILE_CLOSED = 2;
    public static final short EXPRESSION_SMILE_OPEN = 3;
    public static final short EXPRESSION_RAISED_EYEBROWS = 4;
    public static final short EXPRESSION_EYES_LOOKING_AWAY = 5;
    public static final short EXPRESSION_SQUINTING = 6;
    public static final short EXPRESSION_FROWNING = 7;
    public static final int FACE_IMAGE_TYPE_BASIC = 0;
    public static final int FACE_IMAGE_TYPE_FULL_FRONTAL = 1;
    public static final int FACE_IMAGE_TYPE_TOKEN_FRONTAL = 2;
    public static final int IMAGE_DATA_TYPE_JPEG = 0;
    public static final int IMAGE_DATA_TYPE_JPEG2000 = 1;
    public static final int IMAGE_COLOR_SPACE_UNSPECIFIED = 0;
    public static final int IMAGE_COLOR_SPACE_RGB24 = 1;
    public static final int IMAGE_COLOR_SPACE_YUV422 = 2;
    public static final int IMAGE_COLOR_SPACE_GRAY8 = 3;
    public static final int IMAGE_COLOR_SPACE_OTHER = 4;
    public static final int SOURCE_TYPE_UNSPECIFIED = 0;
    public static final int SOURCE_TYPE_STATIC_PHOTO_UNKNOWN_SOURCE = 1;
    public static final int SOURCE_TYPE_STATIC_PHOTO_DIGITAL_CAM = 2;
    public static final int SOURCE_TYPE_STATIC_PHOTO_SCANNER = 3;
    public static final int SOURCE_TYPE_VIDEO_FRAME_UNKNOWN_SOURCE = 4;
    public static final int SOURCE_TYPE_VIDEO_FRAME_ANALOG_CAM = 5;
    public static final int SOURCE_TYPE_VIDEO_FRAME_DIGITAL_CAM = 6;
    public static final int SOURCE_TYPE_UNKNOWN = 7;
    private static final int YAW = 0;
    private static final int PITCH = 1;
    private static final int ROLL = 2;
    private long recordLength;
    private Gender gender;
    private EyeColor eyeColor;
    private int hairColor;
    private int featureMask;
    private int expression;
    private int[] poseAngle;
    private int[] poseAngleUncertainty;
    private FeaturePoint[] featurePoints;
    private int faceImageType;
    private int imageDataType;
    private int colorSpace;
    private int sourceType;
    private int deviceType;
    private int quality;

    public FaceImageInfo(Gender gender, EyeColor eyeColor, int featureMask, int hairColor, int expression, int[] poseAngle, int[] poseAngleUncertainty, int faceImageType, int colorSpace, int sourceType, int deviceType, int quality, FeaturePoint[] featurePoints, int width, int height, InputStream imageInputStream, int imageLength, int imageDataType) throws IOException {
        super(0, width, height, imageInputStream, imageLength, FaceImageInfo.toMimeType(imageDataType));
        if (imageInputStream == null) {
            throw new IllegalArgumentException("Null image");
        }
        this.gender = gender == null ? Gender.UNSPECIFIED : gender;
        this.eyeColor = eyeColor == null ? EyeColor.UNSPECIFIED : eyeColor;
        this.featureMask = featureMask;
        this.hairColor = hairColor;
        this.expression = expression;
        this.colorSpace = colorSpace;
        this.sourceType = sourceType;
        this.deviceType = deviceType;
        int featurePointCount = featurePoints == null ? 0 : featurePoints.length;
        this.featurePoints = new FeaturePoint[featurePointCount];
        if (featurePointCount > 0) {
            System.arraycopy(featurePoints, 0, this.featurePoints, 0, featurePointCount);
        }
        this.poseAngle = new int[3];
        System.arraycopy(poseAngle, 0, this.poseAngle, 0, 3);
        this.poseAngleUncertainty = new int[3];
        System.arraycopy(poseAngleUncertainty, 0, this.poseAngleUncertainty, 0, 3);
        this.imageDataType = imageDataType;
        this.recordLength = 20L + 8L * (long)featurePointCount + 12L + (long)imageLength;
        this.faceImageType = faceImageType;
        this.colorSpace = colorSpace;
        this.sourceType = sourceType;
        this.deviceType = deviceType;
        this.quality = quality;
    }

    public FaceImageInfo(InputStream inputStream) throws IOException {
        super(0);
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        int br;
        int bp;
        int by;
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.recordLength = (long)dataIn.readInt() & 0xFFFFFFFFL;
        int featurePointCount = dataIn.readUnsignedShort();
        this.gender = Gender.getInstance((int)dataIn.readUnsignedByte());
        this.eyeColor = EyeColor.toEyeColor(dataIn.readUnsignedByte());
        this.hairColor = dataIn.readUnsignedByte();
        this.featureMask = dataIn.readUnsignedByte();
        this.featureMask = this.featureMask << 16 | dataIn.readUnsignedShort();
        this.expression = dataIn.readShort();
        this.poseAngle = new int[3];
        this.poseAngle[0] = by = dataIn.readUnsignedByte();
        this.poseAngle[1] = bp = dataIn.readUnsignedByte();
        this.poseAngle[2] = br = dataIn.readUnsignedByte();
        this.poseAngleUncertainty = new int[3];
        this.poseAngleUncertainty[0] = dataIn.readUnsignedByte();
        this.poseAngleUncertainty[1] = dataIn.readUnsignedByte();
        this.poseAngleUncertainty[2] = dataIn.readUnsignedByte();
        this.featurePoints = new FeaturePoint[featurePointCount];
        for (int i = 0; i < featurePointCount; ++i) {
            int featureType = dataIn.readUnsignedByte();
            byte featurePoint = dataIn.readByte();
            int x = dataIn.readUnsignedShort();
            int y = dataIn.readUnsignedShort();
            for (long skippedBytes = 0L; skippedBytes < 2L; skippedBytes += dataIn.skip(2L)) {
            }
            this.featurePoints[i] = new FeaturePoint(featureType, featurePoint, x, y);
        }
        this.faceImageType = dataIn.readUnsignedByte();
        this.imageDataType = dataIn.readUnsignedByte();
        this.setWidth(dataIn.readUnsignedShort());
        this.setHeight(dataIn.readUnsignedShort());
        this.colorSpace = dataIn.readUnsignedByte();
        this.sourceType = dataIn.readUnsignedByte();
        this.deviceType = dataIn.readUnsignedShort();
        this.quality = dataIn.readUnsignedShort();
        if (this.getWidth() <= 0) {
            this.setWidth(800);
        }
        if (this.getHeight() <= 0) {
            this.setHeight(600);
        }
        this.setMimeType(FaceImageInfo.toMimeType(this.imageDataType));
        long imageLength = this.recordLength - 20L - 8L * (long)featurePointCount - 12L;
        this.readImage(inputStream, imageLength);
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream recordOut = new ByteArrayOutputStream();
        this.writeFacialRecordData(recordOut);
        byte[] facialRecordData = recordOut.toByteArray();
        long faceImageBlockLength = (long)facialRecordData.length + 4L;
        DataOutputStream dataOut = new DataOutputStream(outputStream);
        dataOut.writeInt((int)faceImageBlockLength);
        dataOut.write(facialRecordData);
        dataOut.flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public FeaturePoint[] getFeaturePoints() {
        return this.featurePoints;
    }

    public int getExpression() {
        return this.expression;
    }

    public EyeColor getEyeColor() {
        return this.eyeColor;
    }

    public Gender getGender() {
        return this.gender;
    }

    public int getHairColor() {
        return this.hairColor;
    }

    public int getFaceImageType() {
        return this.faceImageType;
    }

    public int getFeatureMask() {
        return this.featureMask;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getImageDataType() {
        return this.imageDataType;
    }

    public int getColorSpace() {
        return this.colorSpace;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int[] getPoseAngle() {
        int[] result2 = new int[3];
        System.arraycopy(this.poseAngle, 0, result2, 0, result2.length);
        return result2;
    }

    public int[] getPoseAngleUncertainty() {
        int[] result2 = new int[3];
        System.arraycopy(this.poseAngleUncertainty, 0, result2, 0, result2.length);
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("FaceImageInfo [");
        out.append("Image size: ").append(this.getWidth()).append(" x ").append(this.getHeight()).append(", ");
        out.append("Gender: ").append(this.gender == null ? Gender.UNSPECIFIED : this.gender).append(", ");
        out.append("Eye color: ").append((Object)(this.eyeColor == null ? EyeColor.UNSPECIFIED : this.eyeColor)).append(", ");
        out.append("Hair color: ").append(this.hairColorToString()).append(", ");
        out.append("Feature mask: ").append(this.featureMaskToString()).append(", ");
        out.append("Expression: ").append(this.expressionToString()).append(", ");
        out.append("Pose angle: ").append(this.poseAngleToString()).append(", ");
        out.append("Face image type: ").append(this.faceImageTypeToString()).append(", ");
        out.append("Source type: ").append(this.sourceTypeToString()).append(", ");
        out.append("FeaturePoints [");
        if (this.featurePoints != null && this.featurePoints.length > 0) {
            boolean isFirstFeaturePoint = true;
            for (FeaturePoint featurePoint : this.featurePoints) {
                if (isFirstFeaturePoint) {
                    isFirstFeaturePoint = false;
                } else {
                    out.append(", ");
                }
                out.append(featurePoint.toString());
            }
        }
        out.append("]");
        out.append("]");
        return out.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.colorSpace;
        result2 = 31 * result2 + this.deviceType;
        result2 = 31 * result2 + this.expression;
        result2 = 31 * result2 + (this.eyeColor == null ? 0 : this.eyeColor.hashCode());
        result2 = 31 * result2 + this.faceImageType;
        result2 = 31 * result2 + this.featureMask;
        result2 = 31 * result2 + Arrays.hashCode(this.featurePoints);
        result2 = 31 * result2 + (this.gender == null ? 0 : this.gender.hashCode());
        result2 = 31 * result2 + this.hairColor;
        result2 = 31 * result2 + this.imageDataType;
        result2 = 31 * result2 + Arrays.hashCode(this.poseAngle);
        result2 = 31 * result2 + Arrays.hashCode(this.poseAngleUncertainty);
        result2 = 31 * result2 + this.quality;
        result2 = 31 * result2 + (int)(this.recordLength ^ this.recordLength >>> 32);
        result2 = 31 * result2 + this.sourceType;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaceImageInfo other = (FaceImageInfo)obj;
        return this.colorSpace == other.colorSpace && this.deviceType == other.deviceType && this.expression == other.expression && this.eyeColor == other.eyeColor && this.faceImageType == other.faceImageType && this.featureMask == other.featureMask && Arrays.equals(this.featurePoints, other.featurePoints) && this.gender == other.gender && this.hairColor == other.hairColor && this.imageDataType == other.imageDataType && Arrays.equals(this.poseAngle, other.poseAngle) && Arrays.equals(this.poseAngleUncertainty, other.poseAngleUncertainty) && this.quality == other.quality && this.recordLength == other.recordLength && this.sourceType == other.sourceType;
    }

    private void writeFacialRecordData(OutputStream outputStream) throws IOException {
        int i;
        DataOutputStream dataOut = new DataOutputStream(outputStream);
        dataOut.writeShort(this.featurePoints.length);
        dataOut.writeByte(this.gender == null ? Gender.UNSPECIFIED.toInt() : this.gender.toInt());
        dataOut.writeByte(this.eyeColor == null ? EyeColor.UNSPECIFIED.toInt() : this.eyeColor.toInt());
        dataOut.writeByte(this.hairColor);
        dataOut.writeByte((byte)(((long)this.featureMask & 0xFF0000L) >> 16));
        dataOut.writeByte((byte)(((long)this.featureMask & 0xFF00L) >> 8));
        dataOut.writeByte((byte)((long)this.featureMask & 0xFFL));
        dataOut.writeShort(this.expression);
        for (i = 0; i < 3; ++i) {
            int b = this.poseAngle[i];
            dataOut.writeByte(b);
        }
        for (i = 0; i < 3; ++i) {
            dataOut.writeByte(this.poseAngleUncertainty[i]);
        }
        for (FeaturePoint fp : this.featurePoints) {
            dataOut.writeByte(fp.getType());
            dataOut.writeByte(fp.getMajorCode() << 4 | fp.getMinorCode());
            dataOut.writeShort(fp.getX());
            dataOut.writeShort(fp.getY());
            dataOut.writeShort(0);
        }
        dataOut.writeByte(this.faceImageType);
        dataOut.writeByte(this.imageDataType);
        dataOut.writeShort(this.getWidth());
        dataOut.writeShort(this.getHeight());
        dataOut.writeByte(this.colorSpace);
        dataOut.writeByte(this.sourceType);
        dataOut.writeShort(this.deviceType);
        dataOut.writeShort(this.quality);
        this.writeImage(dataOut);
        dataOut.flush();
        dataOut.close();
    }

    private String hairColorToString() {
        switch (this.hairColor) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "bald";
            }
            case 2: {
                return "black";
            }
            case 3: {
                return "blonde";
            }
            case 4: {
                return "brown";
            }
            case 5: {
                return "gray";
            }
            case 6: {
                return "white";
            }
            case 7: {
                return "red";
            }
            case 8: {
                return "green";
            }
            case 9: {
                return "blue";
            }
        }
        return "unknown";
    }

    private String featureMaskToString() {
        if ((this.featureMask & 1) == 0) {
            return "";
        }
        ArrayList<String> features = new ArrayList<String>();
        if ((this.featureMask & 2) != 0) {
            features.add("glasses");
        }
        if ((this.featureMask & 4) != 0) {
            features.add("moustache");
        }
        if ((this.featureMask & 8) != 0) {
            features.add("beard");
        }
        if ((this.featureMask & 0x10) != 0) {
            features.add("teeth visible");
        }
        if ((this.featureMask & 0x20) != 0) {
            features.add("blink");
        }
        if ((this.featureMask & 0x40) != 0) {
            features.add("mouth open");
        }
        if ((this.featureMask & 0x80) != 0) {
            features.add("left eye patch");
        }
        if ((this.featureMask & 0x100) != 0) {
            features.add("right eye patch");
        }
        if ((this.featureMask & 0x200) != 0) {
            features.add("dark glasses");
        }
        if ((this.featureMask & 0x400) != 0) {
            features.add("distorting medical condition (which could impact feature point detection)");
        }
        StringBuilder out = new StringBuilder();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            out.append((String)it.next());
            if (!it.hasNext()) continue;
            out.append(", ");
        }
        return out.toString();
    }

    private String expressionToString() {
        switch (this.expression) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "neutral (non-smiling) with both eyes open and mouth closed";
            }
            case 2: {
                return "a smile where the inside of the mouth and/or teeth is not exposed (closed jaw)";
            }
            case 3: {
                return "a smile where the inside of the mouth and/or teeth is exposed";
            }
            case 4: {
                return "raised eyebrows";
            }
            case 5: {
                return "eyes looking away from the camera";
            }
            case 6: {
                return "squinting";
            }
            case 7: {
                return "frowning";
            }
        }
        return "unknown";
    }

    private String poseAngleToString() {
        StringBuilder out = new StringBuilder();
        out.append("(");
        out.append("y: ").append(this.poseAngle[0]);
        if (this.poseAngleUncertainty[0] != 0) {
            out.append(" (").append(this.poseAngleUncertainty[0]).append(")");
        }
        out.append(", ");
        out.append("p:").append(this.poseAngle[1]);
        if (this.poseAngleUncertainty[1] != 0) {
            out.append(" (").append(this.poseAngleUncertainty[1]).append(")");
        }
        out.append(", ");
        out.append("r: ").append(this.poseAngle[2]);
        if (this.poseAngleUncertainty[2] != 0) {
            out.append(" (").append(this.poseAngleUncertainty[2]).append(")");
        }
        out.append(")");
        return out.toString();
    }

    private String faceImageTypeToString() {
        switch (this.faceImageType) {
            case 0: {
                return "basic";
            }
            case 1: {
                return "full frontal";
            }
            case 2: {
                return "token frontal";
            }
        }
        return "unknown";
    }

    private String sourceTypeToString() {
        switch (this.sourceType) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "static photograph from an unknown source";
            }
            case 2: {
                return "static photograph from a digital still-image camera";
            }
            case 3: {
                return "static photograph from a scanner";
            }
            case 4: {
                return "single video frame from an unknown source";
            }
            case 5: {
                return "single video frame from an analogue camera";
            }
            case 6: {
                return "single video frame from a digital camera";
            }
        }
        return "unknown";
    }

    private static String toMimeType(int compressionAlg) {
        switch (compressionAlg) {
            case 0: {
                return "image/jpeg";
            }
            case 1: {
                return "image/jp2";
            }
        }
        LOGGER.warning("Unknown image type: " + compressionAlg);
        return null;
    }

    public static enum EyeColor {
        UNSPECIFIED(0),
        BLACK(1),
        BLUE(2),
        BROWN(3),
        GRAY(4),
        GREEN(5),
        MULTI_COLORED(6),
        PINK(7),
        UNKNOWN(255);

        private final int code;

        private EyeColor(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }

        static EyeColor toEyeColor(int i) {
            for (EyeColor c : EyeColor.values()) {
                if (c.toInt() != i) continue;
                return c;
            }
            return UNKNOWN;
        }
    }

    public static class FeaturePoint
    implements Serializable {
        private static final long serialVersionUID = -4209679423938065215L;
        private final int type;
        private final int majorCode;
        private final int minorCode;
        private final int x;
        private final int y;

        public FeaturePoint(int type, int majorCode, int minorCode, int x, int y) {
            this.type = type;
            this.majorCode = majorCode;
            this.minorCode = minorCode;
            this.x = x;
            this.y = y;
        }

        FeaturePoint(int type, byte code, int x, int y) {
            this(type, (code & 0xF0) >> 4, code & 0xF, x, y);
        }

        public int getMajorCode() {
            return this.majorCode;
        }

        public int getMinorCode() {
            return this.minorCode;
        }

        public int getType() {
            return this.type;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "( point: " + this.getMajorCode() + "." + this.getMinorCode() + ", type: " + Integer.toHexString(this.type) + ", (" + this.x + ", " + this.y + "))";
        }
    }

    public static enum SourceType {
        UNSPECIFIED,
        STATIC_PHOTO_UNKNOWN_SOURCE,
        STATIC_PHOTO_DIGITAL_CAM,
        STATIC_PHOTO_SCANNER,
        VIDEO_FRAME_UNKNOWN_SOURCE,
        VIDEO_FRAME_ANALOG_CAM,
        VIDEO_FRAME_DIGITAL_CAM,
        UNKNOWN;

    }

    public static enum ImageColorSpace {
        UNSPECIFIED,
        RGB24,
        YUV422,
        GRAY8,
        OTHER;

    }

    public static enum ImageDataType {
        TYPE_JPEG,
        TYPE_JPEG2000;

    }

    public static enum FaceImageType {
        BASIC,
        FULL_FRONTAL,
        TOKEN_FRONTAL;

    }

    public static enum Expression {
        UNSPECIFIED,
        NEUTRAL,
        SMILE_CLOSED,
        SMILE_OPEN,
        RAISED_EYEBROWS,
        EYES_LOOKING_AWAY,
        SQUINTING,
        FROWNING;

    }

    public static enum Features {
        FEATURES_ARE_SPECIFIED,
        GLASSES,
        MOUSTACHE,
        BEARD,
        TEETH_VISIBLE,
        BLINK,
        MOUTH_OPEN,
        LEFT_EYE_PATCH,
        RIGHT_EYE_PATCH,
        DARK_GLASSES,
        DISTORTING_MEDICAL_CONDITION;

    }

    public static enum HairColor {
        UNSPECIFIED(0),
        BALD(1),
        BLACK(2),
        BLONDE(3),
        BROWN(4),
        GRAY(5),
        WHITE(6),
        RED(7),
        GREEN(8),
        BLUE(9),
        UNKNOWN(255);

        private final int code;

        private HairColor(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }

        static HairColor toHairColor(int i) {
            for (HairColor c : HairColor.values()) {
                if (c.toInt() != i) continue;
                return c;
            }
            return UNKNOWN;
        }
    }
}

