/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.BiometricDataBlock;
import nashid.verify.sdk.utils.id_card.jmrtd.cbeff.StandardBiometricHeader;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.AbstractListInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.iso19794.FingerImageInfo;

public class FingerInfo
extends AbstractListInfo<FingerImageInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = 5808625058034008176L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final int FORMAT_IDENTIFIER = 1179210240;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 7;
    public static final int SCALE_UNITS_PPI = 1;
    public static final int SCALE_UNITS_PPCM = 2;
    public static final int COMPRESSION_UNCOMPRESSED_NO_BIT_PACKING = 0;
    public static final int COMPRESSION_UNCOMPRESSED_BIT_PACKED = 1;
    public static final int COMPRESSION_WSQ = 2;
    public static final int COMPRESSION_JPEG = 3;
    public static final int COMPRESSION_JPEG2000 = 4;
    public static final int COMPRESSION_PNG = 5;
    private int captureDeviceId;
    private int acquisitionLevel;
    private int scaleUnits;
    private int scanResolutionHorizontal;
    private int scanResolutionVertical;
    private int imageResolutionHorizontal;
    private int imageResolutionVertical;
    private int depth;
    private int compressionAlgorithm;
    private StandardBiometricHeader sbh;

    public FingerInfo(int captureDeviceId, int acquisitionLevel, int scaleUnits, int scanResolutionHorizontal, int scanResolutionVertical, int imageResolutionHorizontal, int imageResolutionVertical, int depth, int compressionAlgorithm, List<FingerImageInfo> fingerImageInfos) {
        this(null, captureDeviceId, acquisitionLevel, scaleUnits, scanResolutionHorizontal, scanResolutionVertical, imageResolutionHorizontal, imageResolutionVertical, depth, compressionAlgorithm, fingerImageInfos);
    }

    public FingerInfo(StandardBiometricHeader sbh, int captureDeviceId, int acquisitionLevel, int scaleUnits, int scanResolutionHorizontal, int scanResolutionVertical, int imageResolutionHorizontal, int imageResolutionVertical, int depth, int compressionAlgorithm, List<FingerImageInfo> fingerImageInfos) {
        this.sbh = sbh;
        this.captureDeviceId = captureDeviceId;
        this.acquisitionLevel = acquisitionLevel;
        this.scaleUnits = scaleUnits;
        this.scanResolutionHorizontal = scanResolutionHorizontal;
        this.scanResolutionVertical = scanResolutionVertical;
        this.imageResolutionHorizontal = imageResolutionHorizontal;
        this.imageResolutionVertical = imageResolutionVertical;
        this.depth = depth;
        this.compressionAlgorithm = compressionAlgorithm;
        this.addAll(fingerImageInfos);
    }

    public FingerInfo(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    public FingerInfo(StandardBiometricHeader sbh, InputStream inputStream) throws IOException {
        this.sbh = sbh;
        this.readObject(inputStream);
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getAcquisitionLevel() {
        return this.acquisitionLevel;
    }

    public int getScaleUnits() {
        return this.scaleUnits;
    }

    public int getHorizontalScanningResolution() {
        return this.scanResolutionHorizontal;
    }

    public int getVerticalScanningResolution() {
        return this.scanResolutionVertical;
    }

    public int getHorizontalImageResolution() {
        return this.imageResolutionHorizontal;
    }

    public int getVerticalImageResolution() {
        return this.imageResolutionVertical;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int fir0 = dataIn.readInt();
        if (fir0 != 1179210240) {
            throw new IllegalArgumentException("'FIR' marker expected! Found " + Integer.toHexString(fir0));
        }
        int version = dataIn.readInt();
        if (version != 0x30313000) {
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(version));
        }
        long recordLength = FingerInfo.readUnsignedLong(dataIn, 6);
        this.captureDeviceId = dataIn.readUnsignedShort();
        this.acquisitionLevel = dataIn.readUnsignedShort();
        int count = dataIn.readUnsignedByte();
        this.scaleUnits = dataIn.readUnsignedByte();
        this.scanResolutionHorizontal = dataIn.readUnsignedShort();
        this.scanResolutionVertical = dataIn.readUnsignedShort();
        this.imageResolutionHorizontal = dataIn.readUnsignedShort();
        this.imageResolutionVertical = dataIn.readUnsignedShort();
        this.depth = dataIn.readUnsignedByte();
        this.compressionAlgorithm = dataIn.readUnsignedByte();
        dataIn.readUnsignedShort();
        long headerLength = 32L;
        long dataLength = recordLength - headerLength;
        long constructedDataLength = 0L;
        for (int i = 0; i < count; ++i) {
            FingerImageInfo imageInfo = new FingerImageInfo(inputStream, this.compressionAlgorithm);
            constructedDataLength += imageInfo.getRecordLength();
            this.add(imageInfo);
        }
        if (dataLength != constructedDataLength) {
            LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + dataLength + ", constructedDataLength = " + constructedDataLength);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        long headerLength = 32L;
        long dataLength = 0L;
        List fingerImageInfos = this.getSubRecords();
        for (FingerImageInfo fingerImageInfo : fingerImageInfos) {
            dataLength += fingerImageInfo.getRecordLength();
        }
        long recordLength = headerLength + dataLength;
        DataOutputStream dataOut = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOut.writeInt(1179210240);
        dataOut.writeInt(0x30313000);
        FingerInfo.writeLong(recordLength, dataOut, 6);
        dataOut.writeShort(this.captureDeviceId);
        dataOut.writeShort(this.acquisitionLevel);
        dataOut.writeByte(fingerImageInfos.size());
        dataOut.writeByte(this.scaleUnits);
        dataOut.writeShort(this.scanResolutionHorizontal);
        dataOut.writeShort(this.scanResolutionVertical);
        dataOut.writeShort(this.imageResolutionHorizontal);
        dataOut.writeShort(this.imageResolutionVertical);
        dataOut.writeByte(this.depth);
        dataOut.writeByte(this.compressionAlgorithm);
        dataOut.writeShort(0);
        for (FingerImageInfo fingerImageInfo : fingerImageInfos) {
            fingerImageInfo.writeObject(dataOut);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.acquisitionLevel;
        result2 = 31 * result2 + this.captureDeviceId;
        result2 = 31 * result2 + this.compressionAlgorithm;
        result2 = 31 * result2 + this.depth;
        result2 = 31 * result2 + this.imageResolutionHorizontal;
        result2 = 31 * result2 + this.imageResolutionVertical;
        result2 = 31 * result2 + (this.sbh == null ? 0 : this.sbh.hashCode());
        result2 = 31 * result2 + this.scaleUnits;
        result2 = 31 * result2 + this.scanResolutionHorizontal;
        result2 = 31 * result2 + this.scanResolutionVertical;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FingerInfo other = (FingerInfo)obj;
        return this.acquisitionLevel == other.acquisitionLevel && this.captureDeviceId == other.captureDeviceId && this.compressionAlgorithm == other.compressionAlgorithm && this.depth == other.depth && this.imageResolutionHorizontal == other.imageResolutionHorizontal && this.imageResolutionVertical == other.imageResolutionVertical && this.scaleUnits == other.scaleUnits && this.scanResolutionHorizontal == other.scanResolutionHorizontal && this.scanResolutionVertical == other.scanResolutionVertical;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("FingerInfo [");
        List records = this.getSubRecords();
        for (FingerImageInfo record : records) {
            result2.append(record.toString());
        }
        result2.append("]");
        return result2.toString();
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            byte[] biometricType = new byte[]{8};
            byte[] biometricSubtype = new byte[]{(byte)this.getBiometricSubtype()};
            byte[] formatOwner = new byte[]{1, 1};
            byte[] formatType = new byte[]{0, 7};
            TreeMap<Integer, byte[]> elements = new TreeMap<Integer, byte[]>();
            elements.put(129, biometricType);
            elements.put(130, biometricSubtype);
            elements.put(135, formatOwner);
            elements.put(136, formatType);
            this.sbh = new StandardBiometricHeader(elements);
        }
        return this.sbh;
    }

    public List<FingerImageInfo> getFingerImageInfos() {
        return this.getSubRecords();
    }

    public void addFingerImageInfo(FingerImageInfo fingerImageInfo) {
        this.add(fingerImageInfo);
    }

    public void removeFingerImageInfo(int index) {
        this.remove(index);
    }

    private static long readUnsignedLong(InputStream inputStream, int byteCount) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        byte[] buf = new byte[byteCount];
        dataIn.readFully(buf);
        long result2 = 0L;
        for (int i = 0; i < byteCount; ++i) {
            result2 <<= 8;
            result2 += (long)(buf[i] & 0xFF);
        }
        return result2;
    }

    private static void writeLong(long value, OutputStream outputStream, int byteCount) throws IOException {
        int i;
        if (byteCount <= 0) {
            return;
        }
        for (i = 0; i < byteCount - 8; ++i) {
            outputStream.write(0);
        }
        if (byteCount > 8) {
            byteCount = 8;
        }
        for (i = byteCount - 1; i >= 0; --i) {
            long mask = 255L << i * 8;
            byte b = (byte)((value & mask) >> i * 8);
            outputStream.write(b);
        }
    }

    static String toMimeType(int imageDataType) {
        switch (imageDataType) {
            case 0: {
                return "image/raw";
            }
            case 1: {
                return "image/raw";
            }
            case 2: {
                return "image/x-wsq";
            }
            case 3: {
                return "image/jpeg";
            }
            case 4: {
                return "image/jpeg2000";
            }
            case 5: {
                return "image/png";
            }
        }
        return null;
    }

    static int fromMimeType(String mimeType) {
        if ("image/x-wsq".equals(mimeType)) {
            return 2;
        }
        if ("image/jpeg".equals(mimeType)) {
            return 3;
        }
        if ("image/jpeg2000".equals(mimeType)) {
            return 4;
        }
        if ("images/png".equals(mimeType)) {
            return 5;
        }
        throw new IllegalArgumentException("Did not recognize mimeType");
    }

    private int getBiometricSubtype() {
        int result2 = 0;
        boolean isFirst = true;
        List fingerImageInfos = this.getSubRecords();
        for (FingerImageInfo fingerImageInfo : fingerImageInfos) {
            int fingerImageInfoSubType = fingerImageInfo.getBiometricSubtype();
            if (isFirst) {
                result2 = fingerImageInfoSubType;
                isFirst = false;
                continue;
            }
            result2 &= fingerImageInfoSubType;
        }
        return result2;
    }
}

