/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.protocol;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import nashid.verify.sdk.utils.id_card.jmrtd.AccessKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.PACEInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.util.Hex;

public class PACECAMResult
extends PACEResult {
    private static final long serialVersionUID = -4288710920347109329L;
    private byte[] encryptedChipAuthenticationData = null;
    private byte[] chipAuthenticationData;

    public PACECAMResult(AccessKeySpec paceKey, String agreementAlg, String cipherAlg, String digestAlg, int keyLength, PACEMappingResult mappingResult, KeyPair pcdKeyPair, PublicKey piccPublicKey, byte[] encryptedChipAuthenticationData, byte[] chipAuthenticationData, SecureMessagingWrapper wrapper) {
        super(paceKey, PACEInfo.MappingType.CAM, agreementAlg, cipherAlg, digestAlg, keyLength, mappingResult, pcdKeyPair, piccPublicKey, wrapper);
        if (encryptedChipAuthenticationData != null) {
            this.encryptedChipAuthenticationData = new byte[encryptedChipAuthenticationData.length];
            System.arraycopy(encryptedChipAuthenticationData, 0, this.encryptedChipAuthenticationData, 0, encryptedChipAuthenticationData.length);
        }
        this.chipAuthenticationData = null;
        if (chipAuthenticationData != null) {
            this.chipAuthenticationData = new byte[chipAuthenticationData.length];
            System.arraycopy(chipAuthenticationData, 0, this.chipAuthenticationData, 0, chipAuthenticationData.length);
        }
    }

    public byte[] getEncryptedChipAuthenticationData() {
        if (this.encryptedChipAuthenticationData == null) {
            return null;
        }
        byte[] result2 = new byte[this.encryptedChipAuthenticationData.length];
        System.arraycopy(this.encryptedChipAuthenticationData, 0, result2, 0, this.encryptedChipAuthenticationData.length);
        return result2;
    }

    public byte[] getChipAuthenticationData() {
        if (this.chipAuthenticationData == null) {
            return null;
        }
        byte[] result2 = new byte[this.chipAuthenticationData.length];
        System.arraycopy(this.chipAuthenticationData, 0, result2, 0, this.chipAuthenticationData.length);
        return result2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.chipAuthenticationData);
        result2 = 31 * result2 + Arrays.hashCode(this.encryptedChipAuthenticationData);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PACECAMResult other = (PACECAMResult)obj;
        return Arrays.equals(this.chipAuthenticationData, other.chipAuthenticationData) && Arrays.equals(this.encryptedChipAuthenticationData, other.encryptedChipAuthenticationData);
    }

    @Override
    public String toString() {
        return "PACECAMResult [paceKey: " + this.getPACEKey() + ", mappingType: " + (Object)((Object)this.getMappingType()) + ", agreementAlg: " + this.getAgreementAlg() + ", cipherAlg: " + this.getCipherAlg() + ", digestAlg: " + this.getDigestAlg() + ", keyLength: " + this.getKeyLength() + ", mappingResult: " + this.getMappingResult() + ", pcdKeyPair: " + this.getPCDKeyPair() + ", piccPublicKey: " + this.getPICCPublicKey() + ", encryptedChipAuthenticationData: " + Hex.bytesToHexString((byte[])this.encryptedChipAuthenticationData) + ", wrapper: " + this.getWrapper() + ", chipAuthenticationData: " + Hex.bytesToHexString((byte[])this.chipAuthenticationData) + "]";
    }
}

