/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.jmrtd.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.APDULevelPACECapable;
import nashid.verify.sdk.utils.id_card.jmrtd.AccessKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.BACKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.PACEException;
import nashid.verify.sdk.utils.id_card.jmrtd.PACEKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.PACESecretKeySpec;
import nashid.verify.sdk.utils.id_card.jmrtd.Util;
import nashid.verify.sdk.utils.id_card.jmrtd.lds.PACEInfo;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.AESSecureMessagingWrapper;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.DESedeSecureMessagingWrapper;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACECAMResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEGMMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEGMWithDHMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEGMWithECDHAgreement;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEGMWithECDHMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEIMMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEMappingResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.PACEResult;
import nashid.verify.sdk.utils.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class PACEProtocol {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private static final byte[] IV_FOR_PACE_CAM_DECRYPTION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] C0_LENGTH_128 = new byte[]{-90, 104, -119, 42, 124, 65, -29, -54, 115, -97, 64, -80, 87, -40, 89, 4};
    private static final byte[] C1_LENGTH_128 = new byte[]{-92, -31, 54, -84, 114, 95, 115, -117, 1, -63, -10, 2, 23, -63, -120, -83};
    private static final byte[] C0_LENGTH_256 = new byte[]{-44, 99, -42, 82, 52, 18, 78, -9, -119, 112, 84, -104, 109, -54, 10, 23, 78, 40, -33, 117, -116, -70, -96, 63, 36, 6, 22, 65, 77, 90, 22, 118};
    private static final byte[] C1_LENGTH_256 = new byte[]{84, -67, 114, 85, -16, -86, -8, 49, -66, -61, 66, 63, -49, 57, -42, -101, 108, -65, 6, 102, 119, -48, -6, -82, 90, -83, -39, -99, -8, -27, 53, 23};
    private final APDULevelPACECapable service;
    private SecureMessagingWrapper wrapper;
    private final int maxTranceiveLength;
    private final boolean shouldCheckMAC;
    private final Random random;

    public PACEProtocol(APDULevelPACECapable service, SecureMessagingWrapper wrapper, int maxTranceiveLength, boolean shouldCheckMAC) {
        this.service = service;
        this.wrapper = wrapper;
        this.maxTranceiveLength = maxTranceiveLength;
        this.shouldCheckMAC = shouldCheckMAC;
        this.random = new SecureRandom();
    }

    public PACEResult doPACE(AccessKeySpec accessKey, String oid, AlgorithmParameterSpec params) throws CardServiceException {
        try {
            return this.doPACE(accessKey, PACEProtocol.deriveStaticPACEKey(accessKey, oid), oid, params);
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side error in key derivation step", gse);
        }
    }

    private PACEResult doPACE(AccessKeySpec accessKey, SecretKey staticPACEKey, String oid, AlgorithmParameterSpec staticParameters) throws CardServiceException {
        PACEInfo.MappingType mappingType = PACEInfo.toMappingType(oid);
        String agreementAlg = PACEInfo.toKeyAgreementAlgorithm(oid);
        String cipherAlg = PACEInfo.toCipherAlgorithm(oid);
        String digestAlg = PACEInfo.toDigestAlgorithm(oid);
        int keyLength = PACEInfo.toKeyLength(oid);
        this.checkConsistency(agreementAlg, cipherAlg, digestAlg, keyLength, staticParameters);
        Cipher staticPACECipher = null;
        try {
            staticPACECipher = Cipher.getInstance(cipherAlg + "/CBC/NoPadding");
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side error in static cipher construction during key derivation step", gse);
        }
        try {
            byte[] referencePrivateKeyOrForComputingSessionKey = null;
            byte paceKeyReference = 1;
            if (staticPACEKey instanceof PACESecretKeySpec) {
                paceKeyReference = ((PACESecretKeySpec)staticPACEKey).getKeyReference();
            }
            this.service.sendMSESetATMutualAuth(this.wrapper, oid, paceKeyReference, referencePrivateKeyOrForComputingSessionKey);
        }
        catch (CardServiceException cse) {
            throw new PACEException("PICC side error in static PACE key derivation step", cse, cse.getSW());
        }
        byte[] piccNonce = this.doPACEStep1(staticPACEKey, staticPACECipher);
        PACEMappingResult mappingResult = this.doPACEStep2(mappingType, agreementAlg, staticParameters, piccNonce, staticPACECipher);
        AlgorithmParameterSpec ephemeralParams = mappingResult.getEphemeralParameters();
        KeyPair ephemeralPCDKeyPair = this.doPACEStep3GenerateKeyPair(agreementAlg, ephemeralParams);
        PublicKey ephemeralPICCPublicKey = this.doPACEStep3ExchangePublicKeys(ephemeralPCDKeyPair.getPublic(), ephemeralParams);
        byte[] sharedSecretBytes = this.doPACEStep3KeyAgreement(agreementAlg, ephemeralPCDKeyPair.getPrivate(), ephemeralPICCPublicKey);
        SecretKey encKey = null;
        SecretKey macKey = null;
        try {
            encKey = Util.deriveKey(sharedSecretBytes, cipherAlg, keyLength, 1);
            macKey = Util.deriveKey(sharedSecretBytes, cipherAlg, keyLength, 2);
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("Security exception during secure messaging key derivation", gse);
        }
        byte[] encryptedChipAuthenticationData = this.doPACEStep4(oid, mappingType, ephemeralPCDKeyPair, ephemeralPICCPublicKey, macKey);
        byte[] chipAuthenticationData = null;
        try {
            long ssc;
            long l = ssc = this.wrapper == null ? 0L : this.wrapper.getSendSequenceCounter();
            if (cipherAlg.startsWith("DESede")) {
                this.wrapper = new DESedeSecureMessagingWrapper(encKey, macKey, this.maxTranceiveLength, this.shouldCheckMAC, 0L);
            } else if (cipherAlg.startsWith("AES")) {
                this.wrapper = new AESSecureMessagingWrapper(encKey, macKey, this.maxTranceiveLength, this.shouldCheckMAC, ssc);
            } else {
                LOGGER.warning("Unsupported cipher algorithm " + cipherAlg);
            }
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Security exception in secure messaging establishment", gse);
        }
        if (PACEInfo.MappingType.CAM.equals((Object)mappingType)) {
            if (encryptedChipAuthenticationData == null) {
                LOGGER.warning("Encrypted Chip Authentication data is null");
            }
            try {
                Cipher decryptCipher = Cipher.getInstance("AES/GCM/NoPadding");
                decryptCipher.init(2, (Key)encKey, new IvParameterSpec(IV_FOR_PACE_CAM_DECRYPTION));
                byte[] paddedChipAuthenticationData = decryptCipher.doFinal(encryptedChipAuthenticationData);
                chipAuthenticationData = Util.unpad(paddedChipAuthenticationData);
            }
            catch (GeneralSecurityException gse) {
                LOGGER.log(Level.WARNING, "Could not decrypt Chip Authentication data", gse);
            }
            return new PACECAMResult(accessKey, agreementAlg, cipherAlg, digestAlg, keyLength, mappingResult, ephemeralPCDKeyPair, ephemeralPICCPublicKey, encryptedChipAuthenticationData, chipAuthenticationData, this.wrapper);
        }
        return new PACEResult(accessKey, mappingType, agreementAlg, cipherAlg, digestAlg, keyLength, mappingResult, ephemeralPCDKeyPair, ephemeralPICCPublicKey, this.wrapper);
    }

    public byte[] doPACEStep1(SecretKey staticPACEKey, Cipher staticPACECipher) throws PACEException {
        byte[] piccNonce = null;
        try {
            byte[] step1Data = new byte[]{};
            byte[] step1Response = this.service.sendGeneralAuthenticate(this.wrapper, step1Data, false);
            byte[] step1EncryptedNonce = TLVUtil.unwrapDO((int)128, (byte[])step1Response);
            staticPACECipher.init(2, (Key)staticPACEKey, new IvParameterSpec(new byte[staticPACECipher.getBlockSize()]));
            piccNonce = staticPACECipher.doFinal(step1EncryptedNonce);
            return piccNonce;
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side exception in tranceiving nonce step", gse);
        }
        catch (CardServiceException cse) {
            throw new PACEException("PICC side exception in tranceiving nonce step", cse);
        }
    }

    public PACEMappingResult doPACEStep2(PACEInfo.MappingType mappingType, String agreementAlg, AlgorithmParameterSpec params, byte[] piccNonce, Cipher staticPACECipher) throws PACEException {
        switch (mappingType) {
            case CAM: 
            case GM: {
                return this.doPACEStep2GM(agreementAlg, params, piccNonce);
            }
            case IM: {
                return this.doPACEStep2IM(agreementAlg, params, piccNonce, staticPACECipher);
            }
        }
        throw new PACEException("Unsupported mapping type " + (Object)((Object)mappingType));
    }

    public PACEGMMappingResult doPACEStep2GM(String agreementAlg, AlgorithmParameterSpec params, byte[] piccNonce) throws PACEException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(agreementAlg, BC_PROVIDER);
            keyPairGenerator.initialize(params);
            KeyPair pcdMappingKeyPair = keyPairGenerator.generateKeyPair();
            PublicKey pcdMappingPublicKey = pcdMappingKeyPair.getPublic();
            PrivateKey pcdMappingPrivateKey = pcdMappingKeyPair.getPrivate();
            byte[] pcdMappingEncodedPublicKey = PACEProtocol.encodePublicKeyForSmartCard(pcdMappingPublicKey);
            byte[] step2Data = TLVUtil.wrapDO((int)129, (byte[])pcdMappingEncodedPublicKey);
            byte[] step2Response = this.service.sendGeneralAuthenticate(this.wrapper, step2Data, false);
            byte[] piccMappingEncodedPublicKey = TLVUtil.unwrapDO((int)130, (byte[])step2Response);
            PublicKey piccMappingPublicKey = PACEProtocol.decodePublicKeyFromSmartCard(piccMappingEncodedPublicKey, params);
            if ("ECDH".equals(agreementAlg)) {
                PACEGMWithECDHAgreement mappingAgreement = new PACEGMWithECDHAgreement();
                mappingAgreement.init(pcdMappingPrivateKey);
                ECPoint mappingSharedSecretPoint = mappingAgreement.doPhase(piccMappingPublicKey);
                ECParameterSpec ephemeralParameters = PACEProtocol.mapNonceGMWithECDH(piccNonce, mappingSharedSecretPoint, (ECParameterSpec)params);
                return new PACEGMWithECDHMappingResult(params, piccNonce, piccMappingPublicKey, pcdMappingKeyPair, mappingSharedSecretPoint, ephemeralParameters);
            }
            if ("DH".equals(agreementAlg)) {
                KeyAgreement mappingAgreement = KeyAgreement.getInstance(agreementAlg);
                mappingAgreement.init(pcdMappingPrivateKey);
                mappingAgreement.doPhase(piccMappingPublicKey, true);
                byte[] mappingSharedSecretBytes = mappingAgreement.generateSecret();
                DHParameterSpec ephemeralParameters = PACEProtocol.mapNonceGMWithDH(piccNonce, Util.os2i(mappingSharedSecretBytes), (DHParameterSpec)params);
                return new PACEGMWithDHMappingResult(params, piccNonce, piccMappingPublicKey, pcdMappingKeyPair, mappingSharedSecretBytes, ephemeralParameters);
            }
            throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + agreementAlg + "\" /" + params.getClass().getCanonicalName());
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side error in mapping nonce step", gse);
        }
        catch (CardServiceException cse) {
            throw new PACEException("PICC side exception in mapping nonce step", cse);
        }
    }

    public PACEIMMappingResult doPACEStep2IM(String agreementAlg, AlgorithmParameterSpec params, byte[] piccNonce, Cipher staticPACECipher) throws PACEException {
        try {
            byte[] pcdNonce = new byte[piccNonce.length];
            this.random.nextBytes(pcdNonce);
            byte[] step2Data = TLVUtil.wrapDO((int)129, (byte[])pcdNonce);
            this.service.sendGeneralAuthenticate(this.wrapper, step2Data, false);
            if ("ECDH".equals(agreementAlg)) {
                AlgorithmParameterSpec ephemeralParameters = PACEProtocol.mapNonceIMWithECDH(piccNonce, pcdNonce, staticPACECipher.getAlgorithm(), (ECParameterSpec)params);
                return new PACEIMMappingResult(params, piccNonce, pcdNonce, ephemeralParameters);
            }
            if ("DH".equals(agreementAlg)) {
                AlgorithmParameterSpec ephemeralParameters = PACEProtocol.mapNonceIMWithDH(piccNonce, pcdNonce, staticPACECipher.getAlgorithm(), (DHParameterSpec)params);
                return new PACEIMMappingResult(params, piccNonce, pcdNonce, ephemeralParameters);
            }
            throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + agreementAlg + "\" /" + params.getClass().getCanonicalName());
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side error in mapping nonce step", gse);
        }
        catch (CardServiceException cse) {
            throw new PACEException("PICC side exception in mapping nonce step", cse, cse.getSW());
        }
    }

    public KeyPair doPACEStep3GenerateKeyPair(String agreementAlg, AlgorithmParameterSpec ephemeralParams) throws PACEException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(agreementAlg, BC_PROVIDER);
            keyPairGenerator.initialize(ephemeralParams);
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side error during generation of PCD key pair", gse);
        }
    }

    public PublicKey doPACEStep3ExchangePublicKeys(PublicKey pcdPublicKey, AlgorithmParameterSpec ephemeralParams) throws PACEException {
        try {
            byte[] pcdEncodedPublicKey = PACEProtocol.encodePublicKeyForSmartCard(pcdPublicKey);
            byte[] step3Data = TLVUtil.wrapDO((int)131, (byte[])pcdEncodedPublicKey);
            byte[] step3Response = this.service.sendGeneralAuthenticate(this.wrapper, step3Data, false);
            byte[] piccEncodedPublicKey = TLVUtil.unwrapDO((int)132, (byte[])step3Response);
            PublicKey piccPublicKey = PACEProtocol.decodePublicKeyFromSmartCard(piccEncodedPublicKey, ephemeralParams);
            if (pcdPublicKey.equals(piccPublicKey)) {
                throw new PACEException("PCD's public key and PICC's public key are the same in key agreement step!");
            }
            return piccPublicKey;
        }
        catch (IllegalStateException ise) {
            throw new PACEException("PCD side exception in key agreement step", ise);
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side exception in key agreement step", gse);
        }
        catch (CardServiceException cse) {
            throw new PACEException("PICC side exception in key agreement step", cse, cse.getSW());
        }
    }

    public byte[] doPACEStep3KeyAgreement(String agreementAlg, PrivateKey pcdPrivateKey, PublicKey piccPublicKey) throws PACEException {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(agreementAlg, BC_PROVIDER);
            keyAgreement.init(pcdPrivateKey);
            keyAgreement.doPhase(PACEProtocol.updateParameterSpec(piccPublicKey, pcdPrivateKey), true);
            return keyAgreement.generateSecret();
        }
        catch (GeneralSecurityException gse) {
            LOGGER.log(Level.WARNING, "PCD side error during key agreement", gse);
            throw new PACEException("PCD side error during key agreement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] doPACEStep4(String oid, PACEInfo.MappingType mappingType, KeyPair pcdKeyPair, PublicKey piccPublicKey, SecretKey macKey) throws CardServiceException {
        try {
            byte[] pcdToken = PACEProtocol.generateAuthenticationToken(oid, macKey, piccPublicKey);
            byte[] step4Data = TLVUtil.wrapDO((int)133, (byte[])pcdToken);
            byte[] step4Response = this.service.sendGeneralAuthenticate(this.wrapper, step4Data, true);
            TLVInputStream step4ResponseInputStream = new TLVInputStream((InputStream)new ByteArrayInputStream(step4Response));
            try {
                int tag86 = step4ResponseInputStream.readTag();
                if (tag86 != 134) {
                    LOGGER.warning("Was expecting tag 0x86, found: " + Integer.toHexString(tag86));
                }
                step4ResponseInputStream.readLength();
                byte[] piccToken = step4ResponseInputStream.readValue();
                byte[] expectedPICCToken = PACEProtocol.generateAuthenticationToken(oid, macKey, pcdKeyPair.getPublic());
                if (!Arrays.equals(expectedPICCToken, piccToken)) {
                    throw new GeneralSecurityException("PICC authentication token mismatch, expectedPICCToken = " + Hex.bytesToHexString((byte[])expectedPICCToken) + ", piccToken = " + Hex.bytesToHexString((byte[])piccToken));
                }
                if (mappingType != PACEInfo.MappingType.CAM) return null;
                int tag8A = step4ResponseInputStream.readTag();
                if (tag8A != 138) {
                    LOGGER.warning("Was expecting tag 0x8A, found: " + Integer.toHexString(tag8A));
                }
                step4ResponseInputStream.readLength();
                byte[] byArray = step4ResponseInputStream.readValue();
                return byArray;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Could not parse step 4 response", ioe);
                return null;
            }
            finally {
                try {
                    step4ResponseInputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, "Exception closing stream", ioe);
                }
            }
        }
        catch (GeneralSecurityException gse) {
            throw new PACEException("PCD side exception in authentication token generation step", gse);
        }
    }

    public static SecretKey deriveStaticPACEKey(AccessKeySpec accessKey, String oid) throws GeneralSecurityException {
        String cipherAlg = PACEInfo.toCipherAlgorithm(oid);
        int keyLength = PACEInfo.toKeyLength(oid);
        byte[] keySeed = PACEProtocol.computeKeySeedForPACE(accessKey);
        byte paceKeyReference = 0;
        if (accessKey instanceof PACEKeySpec) {
            paceKeyReference = ((PACEKeySpec)accessKey).getKeyReference();
        }
        return Util.deriveKey(keySeed, cipherAlg, keyLength, null, 3, paceKeyReference);
    }

    public static byte[] computeKeySeedForPACE(AccessKeySpec accessKey) throws GeneralSecurityException {
        if (accessKey == null) {
            throw new IllegalArgumentException("Access key cannot be null");
        }
        if (accessKey instanceof BACKeySpec) {
            String documentNumber = ((BACKeySpec)accessKey).getDocumentNumber();
            String dateOfBirth = ((BACKeySpec)accessKey).getDateOfBirth();
            String dateOfExpiry = ((BACKeySpec)accessKey).getDateOfExpiry();
            if (dateOfBirth == null || dateOfBirth.length() != 6) {
                throw new IllegalArgumentException("Wrong date format used for date of birth. Expected yyMMdd, found " + dateOfBirth);
            }
            if (dateOfExpiry == null || dateOfExpiry.length() != 6) {
                throw new IllegalArgumentException("Wrong date format used for date of expiry. Expected yyMMdd, found " + dateOfExpiry);
            }
            if (documentNumber == null) {
                throw new IllegalArgumentException("Wrong document number. Found " + documentNumber);
            }
            documentNumber = PACEProtocol.fixDocumentNumber(documentNumber);
            return PACEProtocol.computeKeySeedForPACE(documentNumber, dateOfBirth, dateOfExpiry);
        }
        if (accessKey instanceof PACEKeySpec) {
            return accessKey.getKey();
        }
        LOGGER.warning("JMRTD doesn't recognize this type of access key, best effort key derivation!");
        return accessKey.getKey();
    }

    public static ECParameterSpec mapNonceGMWithECDH(byte[] nonceS, ECPoint sharedSecretPointH, ECParameterSpec staticParameters) {
        ECPoint generator = staticParameters.getGenerator();
        EllipticCurve curve = staticParameters.getCurve();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        ECFieldFp field = (ECFieldFp)curve.getField();
        BigInteger p = field.getP();
        BigInteger order = staticParameters.getOrder();
        int cofactor = staticParameters.getCofactor();
        ECPoint ephemeralGenerator = Util.add(Util.multiply(Util.os2i(nonceS), generator, staticParameters), sharedSecretPointH, staticParameters);
        if (!Util.toBouncyCastleECPoint(ephemeralGenerator, staticParameters).isValid()) {
            LOGGER.info("ephemeralGenerator is not a valid point");
        }
        return new ECParameterSpec(new EllipticCurve(new ECFieldFp(p), a, b), ephemeralGenerator, order, cofactor);
    }

    public static DHParameterSpec mapNonceGMWithDH(byte[] nonceS, BigInteger sharedSecretH, DHParameterSpec staticParameters) {
        BigInteger p = staticParameters.getP();
        BigInteger generator = staticParameters.getG();
        BigInteger mappedGenerator = generator.modPow(Util.os2i(nonceS), p).multiply(sharedSecretH).mod(p);
        return new DHParameterSpec(p, mappedGenerator, staticParameters.getL());
    }

    public static AlgorithmParameterSpec mapNonceIMWithECDH(byte[] nonceS, byte[] nonceT, String cipherAlgorithm, ECParameterSpec params) throws GeneralSecurityException {
        BigInteger p = Util.getPrime(params);
        BigInteger order = params.getOrder();
        int cofactor = params.getCofactor();
        BigInteger a = params.getCurve().getA();
        BigInteger b = params.getCurve().getB();
        BigInteger t = Util.os2i(PACEProtocol.pseudoRandomFunction(nonceS, nonceT, p, cipherAlgorithm));
        ECPoint mappedGenerator = PACEProtocol.icartPointEncode(t, params);
        return new ECParameterSpec(new EllipticCurve(new ECFieldFp(p), a, b), mappedGenerator, order, cofactor);
    }

    public static AlgorithmParameterSpec mapNonceIMWithDH(byte[] nonceS, byte[] nonceT, String cipherAlgorithm, DHParameterSpec params) throws GeneralSecurityException {
        BigInteger g = params.getG();
        if (g == null || g.equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("Invalid generator: " + g);
        }
        BigInteger p = params.getP();
        BigInteger q = params instanceof PACEInfo.DHCParameterSpec ? ((PACEInfo.DHCParameterSpec)params).getQ() : BigInteger.ONE;
        BigInteger x = Util.os2i(PACEProtocol.pseudoRandomFunction(nonceS, nonceT, p, cipherAlgorithm));
        BigInteger a = p.subtract(BigInteger.ONE).divide(q);
        BigInteger mappedGenerator = x.modPow(a, p);
        return new DHParameterSpec(p, mappedGenerator, params.getL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pseudoRandomFunction(byte[] s, byte[] t, BigInteger p, String algorithm) throws GeneralSecurityException {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Null nonce");
        }
        int l = s.length * 8;
        int k = t.length * 8;
        byte[] c0 = null;
        byte[] c1 = null;
        switch (l) {
            case 128: {
                c0 = C0_LENGTH_128;
                c1 = C1_LENGTH_128;
                break;
            }
            case 192: 
            case 256: {
                c0 = C0_LENGTH_256;
                c1 = C1_LENGTH_256;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown length " + l + ", was expecting 128, 192, or 256");
            }
        }
        Cipher cipher = Cipher.getInstance(algorithm + (algorithm.endsWith("/CBC/NoPadding") ? "" : "/CBC/NoPadding"));
        int blockSize = cipher.getBlockSize();
        IvParameterSpec zeroIV = new IvParameterSpec(new byte[blockSize]);
        cipher.init(1, (Key)new SecretKeySpec(t, algorithm), zeroIV);
        byte[] key = cipher.doFinal(s);
        ByteArrayOutputStream x = new ByteArrayOutputStream();
        try {
            int n = 0;
            while (n * l < p.bitLength() + 64) {
                cipher.init(1, (Key)new SecretKeySpec(key, 0, k / 8, algorithm), zeroIV);
                key = cipher.doFinal(c0);
                x.write(cipher.doFinal(c1));
                ++n;
            }
            byte[] xBytes = x.toByteArray();
            byte[] byArray = Util.i2os(Util.os2i(xBytes).mod(p));
            return byArray;
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, "Could not write to stream", ioe);
            byte[] byArray = Util.i2os(Util.os2i(x.toByteArray()).mod(p));
            return byArray;
        }
        finally {
            try {
                x.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Could not close stream", ioe);
            }
        }
    }

    public static ECPoint icartPointEncode(BigInteger t, ECParameterSpec params) {
        ECPoint xy;
        BigInteger p = Util.getPrime(params);
        int cofactor = params.getCofactor();
        BigInteger a = params.getCurve().getA();
        BigInteger b = params.getCurve().getB();
        BigInteger alpha = t.modPow(BigInteger.valueOf(2L), p).negate().mod(p);
        BigInteger alphaSq = alpha.modPow(BigInteger.valueOf(2L), p);
        BigInteger alphaPlusAlphaSq = alpha.add(alphaSq).mod(p);
        BigInteger onePlusAlphaPlusAlphaSq = BigInteger.ONE.add(alphaPlusAlphaSq);
        BigInteger pMinus2 = p.subtract(BigInteger.ONE).subtract(BigInteger.ONE);
        BigInteger x2 = b.negate().multiply(onePlusAlphaPlusAlphaSq).multiply(a.multiply(alphaPlusAlphaSq).modPow(pMinus2, p)).mod(p);
        BigInteger x3 = alpha.multiply(x2).mod(p);
        BigInteger h2 = x2.modPow(BigInteger.valueOf(3L), p).add(a.multiply(x2)).add(b).mod(p);
        BigInteger u = t.modPow(BigInteger.valueOf(3L), p).multiply(h2).mod(p);
        BigInteger pPlusOneOverFour = p.add(BigInteger.ONE).multiply(BigInteger.valueOf(4L).modInverse(p)).mod(p);
        BigInteger pMinusOneMinusPPlusOneOverFour = p.subtract(BigInteger.ONE).subtract(pPlusOneOverFour);
        BigInteger aa = h2.modPow(pMinusOneMinusPPlusOneOverFour, p);
        BigInteger aaSqTimesH2 = aa.modPow(BigInteger.valueOf(2L), p).multiply(h2).mod(p);
        ECPoint eCPoint = xy = aaSqTimesH2.equals(BigInteger.ONE) ? new ECPoint(x2, aa.multiply(h2).mod(p)) : new ECPoint(x3, aa.multiply(u).mod(p));
        if (cofactor == 1) {
            return Util.normalize(xy, params);
        }
        org.bouncycastle.math.ec.ECPoint bcPoint = Util.toBouncyCastleECPoint(xy, params);
        bcPoint.multiply(BigInteger.valueOf(cofactor));
        return Util.fromBouncyCastleECPoint(bcPoint);
    }

    public static PublicKey updateParameterSpec(PublicKey publicKey, PrivateKey privateKey) throws GeneralSecurityException {
        String publicKeyAlgorithm = publicKey.getAlgorithm();
        String privateKeyAlgorithm = privateKey.getAlgorithm();
        if ("EC".equals(publicKeyAlgorithm) || "ECDH".equals(publicKeyAlgorithm)) {
            if (!"EC".equals(privateKeyAlgorithm) && !"ECDH".equals(privateKeyAlgorithm)) {
                throw new NoSuchAlgorithmException("Unsupported key type public: " + publicKeyAlgorithm + ", private: " + privateKeyAlgorithm);
            }
            KeyFactory keyFactory = KeyFactory.getInstance("EC", BC_PROVIDER);
            ECPublicKeySpec keySpec = new ECPublicKeySpec(((ECPublicKey)publicKey).getW(), ((ECPrivateKey)privateKey).getParams());
            return keyFactory.generatePublic(keySpec);
        }
        if ("DH".equals(publicKeyAlgorithm)) {
            if (!"DH".equals(privateKeyAlgorithm)) {
                throw new NoSuchAlgorithmException("Unsupported key type public: " + publicKeyAlgorithm + ", private: " + privateKeyAlgorithm);
            }
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            DHPublicKey dhPublicKey = (DHPublicKey)publicKey;
            DHPrivateKey dhPrivateKey = (DHPrivateKey)privateKey;
            DHParameterSpec privateKeyParams = dhPrivateKey.getParams();
            DHPublicKeySpec keySpec = new DHPublicKeySpec(dhPublicKey.getY(), privateKeyParams.getP(), privateKeyParams.getG());
            return keyFactory.generatePublic(keySpec);
        }
        throw new NoSuchAlgorithmException("Unsupported key type public: " + publicKeyAlgorithm + ", private: " + privateKeyAlgorithm);
    }

    public static byte[] generateAuthenticationToken(String oid, SecretKey macKey, PublicKey publicKey) throws GeneralSecurityException {
        String cipherAlg = PACEInfo.toCipherAlgorithm(oid);
        String macAlg = PACEProtocol.inferMACAlgorithmFromCipherAlgorithm(cipherAlg);
        Mac mac = Util.getMac(macAlg, macKey);
        return PACEProtocol.generateAuthenticationToken(oid, mac, publicKey);
    }

    public static byte[] computeKeySeedForPACE(String cardAccessNumber) throws GeneralSecurityException {
        return Util.computeKeySeed(cardAccessNumber, "SHA-1", false);
    }

    public static byte[] encodePublicKeyDataObject(String oid, PublicKey publicKey) throws InvalidKeyException {
        return PACEProtocol.encodePublicKeyDataObject(oid, publicKey, true);
    }

    public static byte[] encodePublicKeyDataObject(String oid, PublicKey publicKey, boolean isContextKnown) throws InvalidKeyException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TLVOutputStream tlvOutputStream = new TLVOutputStream((OutputStream)byteArrayOutputStream);
        try {
            tlvOutputStream.writeTag(32585);
            if (publicKey instanceof DHPublicKey) {
                params = ((DHPublicKey)publicKey).getParams();
                BigInteger p = ((DHParameterSpec)params).getP();
                int l = ((DHParameterSpec)params).getL();
                BigInteger generator = ((DHParameterSpec)params).getG();
                BigInteger y = ((DHPublicKey)publicKey).getY();
                tlvOutputStream.write(new ASN1ObjectIdentifier(oid).getEncoded());
                if (!isContextKnown) {
                    tlvOutputStream.writeTag(129);
                    tlvOutputStream.writeValue(Util.i2os(p));
                    tlvOutputStream.writeTag(130);
                    tlvOutputStream.writeValue(Util.i2os(BigInteger.valueOf(l)));
                    tlvOutputStream.writeTag(131);
                    tlvOutputStream.writeValue(Util.i2os(generator));
                }
                tlvOutputStream.writeTag(132);
                tlvOutputStream.writeValue(Util.i2os(y));
            } else if (publicKey instanceof ECPublicKey) {
                params = ((ECPublicKey)publicKey).getParams();
                BigInteger p = Util.getPrime(params);
                EllipticCurve curve = ((ECParameterSpec)params).getCurve();
                BigInteger a = curve.getA();
                BigInteger b = curve.getB();
                ECPoint generator = ((ECParameterSpec)params).getGenerator();
                BigInteger order = ((ECParameterSpec)params).getOrder();
                int coFactor = ((ECParameterSpec)params).getCofactor();
                ECPoint publicPoint = ((ECPublicKey)publicKey).getW();
                tlvOutputStream.write(new ASN1ObjectIdentifier(oid).getEncoded());
                if (!isContextKnown) {
                    tlvOutputStream.writeTag(129);
                    tlvOutputStream.writeValue(Util.i2os(p));
                    tlvOutputStream.writeTag(130);
                    tlvOutputStream.writeValue(Util.i2os(a));
                    tlvOutputStream.writeTag(131);
                    tlvOutputStream.writeValue(Util.i2os(b));
                    BigInteger affineX = generator.getAffineX();
                    BigInteger affineY = generator.getAffineY();
                    tlvOutputStream.writeTag(132);
                    tlvOutputStream.write(Util.i2os(affineX));
                    tlvOutputStream.write(Util.i2os(affineY));
                    tlvOutputStream.writeValueEnd();
                    tlvOutputStream.writeTag(133);
                    tlvOutputStream.writeValue(Util.i2os(order));
                }
                tlvOutputStream.writeTag(134);
                tlvOutputStream.writeValue(Util.ecPoint2OS(publicPoint));
                if (!isContextKnown) {
                    tlvOutputStream.writeTag(135);
                    tlvOutputStream.writeValue(Util.i2os(BigInteger.valueOf(coFactor)));
                }
            } else {
                throw new InvalidKeyException("Unsupported public key: " + publicKey.getClass().getCanonicalName());
            }
            tlvOutputStream.writeValueEnd();
            tlvOutputStream.flush();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception", ioe);
            throw new IllegalStateException("Error in encoding public key");
        }
        finally {
            try {
                tlvOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] encodePublicKeyForSmartCard(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot encode null public key");
        }
        if (publicKey instanceof ECPublicKey) {
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                bOut.write(Util.ecPoint2OS(((ECPublicKey)publicKey).getW()));
                byte[] encodedPublicKey = bOut.toByteArray();
                bOut.close();
                return encodedPublicKey;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Internal error writing to memory", ioe);
            }
        }
        if (publicKey instanceof DHPublicKey) {
            return Util.i2os(((DHPublicKey)publicKey).getY());
        }
        throw new InvalidKeyException("Unsupported public key: " + publicKey.getClass().getCanonicalName());
    }

    public static PublicKey decodePublicKeyFromSmartCard(byte[] encodedPublicKey, AlgorithmParameterSpec params) {
        if (params == null) {
            throw new IllegalArgumentException("Params cannot be null");
        }
        try {
            if (params instanceof ECParameterSpec) {
                ECPoint w = Util.os2ECPoint(encodedPublicKey);
                return Util.getPublicKey("EC", new ECPublicKeySpec(w, (ECParameterSpec)params));
            }
            if (params instanceof DHParameterSpec) {
                BigInteger y = Util.os2i(encodedPublicKey);
                return Util.getPublicKey("DH", new DHPublicKeySpec(y, ((DHParameterSpec)params).getP(), ((DHParameterSpec)params).getG()));
            }
            throw new IllegalArgumentException("Expected ECParameterSpec or DHParameterSpec, found " + params.getClass().getCanonicalName());
        }
        catch (GeneralSecurityException gse) {
            LOGGER.log(Level.WARNING, "Exception", gse);
            throw new IllegalArgumentException(gse);
        }
    }

    private static byte[] generateAuthenticationToken(String oid, Mac mac, PublicKey publicKey) throws GeneralSecurityException {
        byte[] encodedPublicKeyDataObject = PACEProtocol.encodePublicKeyDataObject(oid, publicKey);
        byte[] maccedPublicKeyDataObject = mac.doFinal(encodedPublicKeyDataObject);
        byte[] authenticationToken = new byte[8];
        System.arraycopy(maccedPublicKeyDataObject, 0, authenticationToken, 0, authenticationToken.length);
        return authenticationToken;
    }

    private static String fixDocumentNumber(String documentNumber) {
        String minDocumentNumber = documentNumber.replace('<', ' ').trim().replace(' ', '<');
        StringBuilder result2 = new StringBuilder(minDocumentNumber);
        while (result2.length() < 9) {
            result2.append('<');
        }
        return result2.toString();
    }

    private static byte[] computeKeySeedForPACE(String documentNumber, String dateOfBirth, String dateOfExpiry) throws GeneralSecurityException {
        return Util.computeKeySeed(documentNumber, dateOfBirth, dateOfExpiry, "SHA-1", false);
    }

    private void checkConsistency(String agreementAlg, String cipherAlg, String digestAlg, int keyLength, AlgorithmParameterSpec params) {
        if (agreementAlg == null) {
            throw new IllegalArgumentException("Unknown agreement algorithm");
        }
        if (!"ECDH".equalsIgnoreCase(agreementAlg) && !"DH".equalsIgnoreCase(agreementAlg)) {
            throw new IllegalArgumentException("Unsupported agreement algorithm, expected ECDH or DH, found \"" + agreementAlg + "\"");
        }
        if (cipherAlg == null) {
            throw new IllegalArgumentException("Unknown cipher algorithm");
        }
        if (!"DESede".equalsIgnoreCase(cipherAlg) && !"AES".equalsIgnoreCase(cipherAlg)) {
            throw new IllegalArgumentException("Unsupported cipher algorithm, expected DESede or AES, found \"" + cipherAlg + "\"");
        }
        if (!("SHA-1".equalsIgnoreCase(digestAlg) || "SHA1".equalsIgnoreCase(digestAlg) || "SHA-256".equalsIgnoreCase(digestAlg) || "SHA256".equalsIgnoreCase(digestAlg))) {
            throw new IllegalArgumentException("Unsupported cipher algorithm, expected DESede or AES, found \"" + digestAlg + "\"");
        }
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalArgumentException("Unsupported key length, expected 128, 192, or 256, found " + keyLength);
        }
        if ("ECDH".equalsIgnoreCase(agreementAlg) && !(params instanceof ECParameterSpec)) {
            throw new IllegalArgumentException("Expected ECParameterSpec for agreement algorithm \"" + agreementAlg + "\", found " + params.getClass().getCanonicalName());
        }
        if ("DH".equalsIgnoreCase(agreementAlg) && !(params instanceof DHParameterSpec)) {
            throw new IllegalArgumentException("Expected DHParameterSpec for agreement algorithm \"" + agreementAlg + "\", found " + params.getClass().getCanonicalName());
        }
    }

    private static String inferMACAlgorithmFromCipherAlgorithm(String cipherAlg) throws InvalidAlgorithmParameterException {
        if (cipherAlg == null) {
            throw new IllegalArgumentException("Cannot infer MAC algorithm from cipher algorithm null");
        }
        if (cipherAlg.startsWith("DESede")) {
            return "ISO9797ALG3WITHISO7816-4PADDING";
        }
        if (cipherAlg.startsWith("AES")) {
            return "AESCMAC";
        }
        throw new InvalidAlgorithmParameterException("Cannot infer MAC algorithm from cipher algorithm \"" + cipherAlg + "\"");
    }
}

