/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDataInputStream;

public class OmanCardDG11File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_COMPANY_NAME_ARABIC = 43811;
    public static final int TAG_COMPANY_NAME_ENGLISH = 60196;
    public static final int TAG_COMPANY_ADDRESS_ARABIC = 43813;
    String companyNameArabic;
    String companyNameEnglish;
    String companyAddressArabic;

    public OmanCardDG11File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.companyNameArabic = new String(omanCardDataInputStream.getTagValue(43811), charset);
        this.companyNameEnglish = new String(omanCardDataInputStream.getTagValue(60196), charset);
        this.companyAddressArabic = new String(omanCardDataInputStream.getTagValue(43813), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 43811: {
                return this.companyNameArabic;
            }
            case 60196: {
                return this.companyNameEnglish;
            }
            case 43813: {
                return this.companyAddressArabic;
            }
        }
        return null;
    }

    public String toString() {
        return "OmanCardDG11File{43811='" + this.companyNameArabic + '\'' + ", " + 60196 + "='" + this.companyNameEnglish + '\'' + ", " + 43813 + "='" + this.companyAddressArabic + '\'' + '}';
    }

    public String getCompanyNameArabic() {
        return this.companyNameArabic;
    }

    public void setCompanyNameArabic(String companyNameArabic) {
        this.companyNameArabic = companyNameArabic;
    }

    public String getCompanyNameEnglish() {
        return this.companyNameEnglish;
    }

    public void setCompanyNameEnglish(String companyNameEnglish) {
        this.companyNameEnglish = companyNameEnglish;
    }

    public String getCompanyAddressArabic() {
        return this.companyAddressArabic;
    }

    public void setCompanyAddressArabic(String companyAddressArabic) {
        this.companyAddressArabic = companyAddressArabic;
    }
}

