/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.utils.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nashid.verify.sdk.utils.id_card.omn.OmanCardDataInputStream;
import net.sf.scuba.util.Hex;

public class OmanCardDG13File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_SPONSOR_RELATIONSHIP = 44333;
    public static final int TAG_SPONSOR_NUMBER = 11566;
    public static final int TAG_SPONSOR_ISSUE_DATE = 19759;
    public static final int TAG_SPONSOR_EXPIRY_DATE = 19760;
    String sponsorRelationship;
    String sponsorNumber;
    String sponsorIssueDate;
    String sponsorExpiryDate;

    public OmanCardDG13File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.sponsorRelationship = new String(omanCardDataInputStream.getTagValue(44333), charset);
        this.sponsorNumber = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(11566));
        this.sponsorIssueDate = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(19759));
        this.sponsorExpiryDate = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(19760));
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 44333: {
                return this.sponsorRelationship;
            }
            case 11566: {
                return this.sponsorNumber;
            }
            case 19759: {
                return this.sponsorIssueDate;
            }
            case 19760: {
                return this.sponsorExpiryDate;
            }
        }
        return null;
    }

    public String toString() {
        return "OmanCardDG13File{44333='" + this.sponsorRelationship + '\'' + ", " + 11566 + "='" + this.sponsorNumber + '\'' + ", " + 19759 + "='" + this.sponsorIssueDate + '\'' + ", " + 19760 + "='" + this.sponsorExpiryDate + '\'' + '}';
    }

    public String getSponsorRelationship() {
        return this.sponsorRelationship;
    }

    public void setSponsorRelationship(String sponsorRelationship) {
        this.sponsorRelationship = sponsorRelationship;
    }

    public String getSponsorNumber() {
        return this.sponsorNumber;
    }

    public void setSponsorNumber(String sponsorNumber) {
        this.sponsorNumber = sponsorNumber;
    }

    public String getSponsorIssueDate() {
        return this.sponsorIssueDate;
    }

    public void setSponsorIssueDate(String sponsorIssueDate) {
        this.sponsorIssueDate = sponsorIssueDate;
    }

    public String getSponsorExpiryDate() {
        return this.sponsorExpiryDate;
    }

    public void setSponsorExpiryDate(String sponsorExpiryDate) {
        this.sponsorExpiryDate = sponsorExpiryDate;
    }
}

